/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.IrElementBuilder;
import org.jetbrains.kotlin.ir.builders.IrElementBuilderKt;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrMutableAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JvmStandardClassIds;

@PhaseDescription(name="JvmOverloadsAnnotation")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u0012\u001a\u00020\u000e*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\"\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOverloadsAnnotationLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "generateWrappers", "target", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "generateWrapper", "numDefaultParametersToExpect", "", "generateWrapperHeader", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "oldFunction", "generateNewValueParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nJvmOverloadsAnnotationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmOverloadsAnnotationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmOverloadsAnnotationLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n*L\n1#1,184:1\n808#2,11:185\n774#2:196\n865#2,2:197\n1869#2,2:199\n1788#2,4:201\n284#3,4:205\n238#3,4:209\n*S KotlinDebug\n*F\n+ 1 JvmOverloadsAnnotationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmOverloadsAnnotationLowering\n*L\n37#1:185,11\n37#1:196\n37#1:197,2\n41#1:199,2\n47#1:201,4\n126#1:205,4\n135#1:209,4\n*E\n"})
public final class JvmOverloadsAnnotationLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public JvmOverloadsAnnotationLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    public void lower(@NotNull IrClass irClass) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Iterable $this$filterIsInstance$iv = irClass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrFunction it = (IrFunction)element$iv$iv;
            boolean bl = false;
            if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)((IrAnnotationContainer)it), (FqName)JvmStandardClassIds.INSTANCE.getJVM_OVERLOADS_FQ_NAME())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List functions = (List)destination$iv$iv;
        Iterable $this$forEach$iv = functions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrFunction it = (IrFunction)element$iv;
            boolean bl = false;
            this.generateWrappers(it, irClass);
        }
    }

    private final void generateWrappers(IrFunction target, IrClass irClass) {
        int n;
        Iterable $this$count$iv = target.getValueParameters();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                IrValueParameter it = (IrValueParameter)element$iv;
                boolean bl = false;
                if (!(it.getDefaultValue() != null) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int numDefaultParameters = n;
        for (int i = numDefaultParameters - 1; -1 < i; --i) {
            IrFunction wrapper = this.generateWrapper(target, i);
            IrDeclarationsKt.addMember((IrClass)irClass, (IrDeclaration)((IrDeclaration)wrapper));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final IrFunction generateWrapper(IrFunction target, int numDefaultParametersToExpect) {
        IrBody irBody;
        IrGetValueImpl irGetValueImpl;
        IrGetValueImpl irGetValueImpl2;
        IrValueParameter dispatchReceiver;
        IrFunctionAccessExpression irFunctionAccessExpression;
        Object object;
        IrFunctionAccessExpression irFunctionAccessExpression2;
        IrFunction wrapperIrFunction = this.generateWrapperHeader(this.context.getIrFactory(), target, numDefaultParametersToExpect);
        IrFunction irFunction = target;
        if (irFunction instanceof IrConstructor) {
            irFunctionAccessExpression2 = (IrFunctionAccessExpression)BuildersKt.fromSymbolOwner$default((IrDelegatingConstructorCallImpl.Companion)IrDelegatingConstructorCallImpl.Companion, (int)-1, (int)-1, (IrType)this.context.getIrBuiltIns().getUnitType(), (IrConstructorSymbol)((IrConstructor)target).getSymbol(), (int)0, (int)16, null);
        } else if (irFunction instanceof IrSimpleFunction) {
            irFunctionAccessExpression2 = (IrFunctionAccessExpression)BuildersKt.fromSymbolOwner$default((IrCallImpl.Companion)IrCallImpl.Companion, (int)-1, (int)-1, (IrType)target.getReturnType(), (IrSimpleFunctionSymbol)((IrSimpleFunction)target).getSymbol(), null, null, (int)48, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        IrFunctionAccessExpression call = irFunctionAccessExpression2;
        for (IrTypeParameter arg : IrUtilsKt.getAllTypeParameters((IrFunction)wrapperIrFunction)) {
            call.getTypeArguments().set(arg.getIndex(), IrTypesKt.getDefaultType((IrTypeParameter)arg));
        }
        IrFunctionAccessExpression irFunctionAccessExpression3 = call;
        IrValueParameter irValueParameter = wrapperIrFunction.getDispatchReceiverParameter();
        if (irValueParameter != null) {
            object = irValueParameter;
            irFunctionAccessExpression = irFunctionAccessExpression3;
            boolean bl = false;
            irGetValueImpl2 = BuildersKt.IrGetValueImpl$default((int)-1, (int)-1, (IrValueSymbol)((IrValueSymbol)dispatchReceiver.getSymbol()), null, (int)8, null);
            irFunctionAccessExpression3 = irFunctionAccessExpression;
        } else {
            irGetValueImpl2 = null;
        }
        irFunctionAccessExpression3.setDispatchReceiver((IrExpression)irGetValueImpl2);
        IrFunctionAccessExpression irFunctionAccessExpression4 = call;
        IrValueParameter irValueParameter2 = wrapperIrFunction.getExtensionReceiverParameter();
        if (irValueParameter2 != null) {
            void extensionReceiver;
            dispatchReceiver = irValueParameter2;
            irFunctionAccessExpression = irFunctionAccessExpression4;
            boolean bl = false;
            irGetValueImpl = BuildersKt.IrGetValueImpl$default((int)-1, (int)-1, (IrValueSymbol)((IrValueSymbol)extensionReceiver.getSymbol()), null, (int)8, null);
            irFunctionAccessExpression4 = irFunctionAccessExpression;
        } else {
            irGetValueImpl = null;
        }
        irFunctionAccessExpression4.setExtensionReceiver((IrExpression)irGetValueImpl);
        int parametersCopied = 0;
        int defaultParametersCopied = 0;
        object = ((Iterable)target.getValueParameters()).iterator();
        int n = 0;
        while (object.hasNext()) {
            int i = n++;
            IrValueParameter valueParameter = (IrValueParameter)object.next();
            if (valueParameter.getDefaultValue() != null) {
                if (defaultParametersCopied < numDefaultParametersToExpect) {
                    ++defaultParametersCopied;
                    call.putValueArgument(i, (IrExpression)BuildersKt.IrGetValueImpl$default((int)-1, (int)-1, (IrValueSymbol)((IrValueSymbol)((IrValueParameter)wrapperIrFunction.getValueParameters().get(parametersCopied++)).getSymbol()), null, (int)8, null));
                    continue;
                }
                call.putValueArgument(i, null);
                continue;
            }
            call.putValueArgument(i, (IrExpression)BuildersKt.IrGetValueImpl$default((int)-1, (int)-1, (IrValueSymbol)((IrValueSymbol)((IrValueParameter)wrapperIrFunction.getValueParameters().get(parametersCopied++)).getSymbol()), null, (int)8, null));
        }
        object = target;
        if (object instanceof IrConstructor) {
            irBody = (IrBody)IrFactoryHelpersKt.createBlockBody((IrFactory)this.context.getIrFactory(), (int)-1, (int)-1, (List)CollectionsKt.listOf((Object)call));
        } else if (object instanceof IrSimpleFunction) {
            irBody = (IrBody)this.context.getIrFactory().createExpressionBody(-1, -1, (IrExpression)call);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        wrapperIrFunction.setBody(irBody);
        return wrapperIrFunction;
    }

    private final IrFunction generateWrapperHeader(IrFactory $this$generateWrapperHeader, IrFunction oldFunction, int numDefaultParametersToExpect) {
        IrFunction irFunction;
        IrFunction irFunction2 = oldFunction;
        if (irFunction2 instanceof IrConstructor) {
            IrFactory $this$buildConstructor$iv = $this$generateWrapperHeader;
            boolean $i$f$buildConstructor = false;
            IrFunctionBuilder $this$buildConstructor_u24lambda_u2424$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$generateWrapperHeader_u24lambda_u245 = $this$buildConstructor_u24lambda_u2424$iv;
            boolean bl2 = false;
            IrElementBuilderKt.setSourceRange((IrElementBuilder)((IrElementBuilder)$this$generateWrapperHeader_u24lambda_u245), (IrElement)((IrElement)oldFunction));
            $this$generateWrapperHeader_u24lambda_u245.setOrigin((IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getJVM_OVERLOADS_WRAPPER());
            $this$generateWrapperHeader_u24lambda_u245.setName(oldFunction.getName());
            $this$generateWrapperHeader_u24lambda_u245.setVisibility(oldFunction.getVisibility());
            $this$generateWrapperHeader_u24lambda_u245.setReturnType(oldFunction.getReturnType());
            $this$generateWrapperHeader_u24lambda_u245.setInline(oldFunction.isInline());
            irFunction = (IrFunction)DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv, (IrFunctionBuilder)$this$buildConstructor_u24lambda_u2424$iv);
        } else if (irFunction2 instanceof IrSimpleFunction) {
            IrFactory $this$buildFun$iv = $this$generateWrapperHeader;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$generateWrapperHeader_u24lambda_u246 = $this$buildFun_u24lambda_u2420$iv;
            boolean bl3 = false;
            IrElementBuilderKt.setSourceRange((IrElementBuilder)((IrElementBuilder)$this$generateWrapperHeader_u24lambda_u246), (IrElement)((IrElement)oldFunction));
            $this$generateWrapperHeader_u24lambda_u246.setOrigin((IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getJVM_OVERLOADS_WRAPPER());
            $this$generateWrapperHeader_u24lambda_u246.setName(oldFunction.getName());
            $this$generateWrapperHeader_u24lambda_u246.setVisibility(oldFunction.getVisibility());
            $this$generateWrapperHeader_u24lambda_u246.setModality(this.context.getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.GenerateJvmOverloadsAsFinal) ? Modality.FINAL : ((IrSimpleFunction)oldFunction).getModality());
            $this$generateWrapperHeader_u24lambda_u246.setReturnType(oldFunction.getReturnType());
            $this$generateWrapperHeader_u24lambda_u246.setInline(oldFunction.isInline());
            $this$generateWrapperHeader_u24lambda_u246.setSuspend(((IrSimpleFunction)oldFunction).isSuspend());
            irFunction = (IrFunction)DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u2420$iv);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        IrFunction res2 = irFunction;
        res2.setParent(oldFunction.getParent());
        IrUtilsKt.copyAnnotationsFrom((IrMutableAnnotationContainer)((IrMutableAnnotationContainer)res2), (IrAnnotationContainer)((IrAnnotationContainer)oldFunction));
        IrUtilsKt.copyTypeParametersFrom$default((IrTypeParametersContainer)((IrTypeParametersContainer)res2), (IrTypeParametersContainer)((IrTypeParametersContainer)oldFunction), null, null, (int)6, null);
        IrValueParameter irValueParameter = oldFunction.getDispatchReceiverParameter();
        res2.setDispatchReceiverParameter(irValueParameter != null ? IrUtilsKt.copyTo$default((IrValueParameter)irValueParameter, (IrFunction)res2, null, (int)0, (int)0, null, null, null, null, null, (boolean)false, (boolean)false, (boolean)false, null, (int)8190, null) : null);
        IrValueParameter irValueParameter2 = oldFunction.getExtensionReceiverParameter();
        res2.setExtensionReceiverParameter(irValueParameter2 != null ? IrUtilsKt.copyTo$default((IrValueParameter)irValueParameter2, (IrFunction)res2, null, (int)0, (int)0, null, null, null, null, null, (boolean)false, (boolean)false, (boolean)false, null, (int)8190, null) : null);
        res2.setValueParameters(CollectionsKt.plus((Collection)res2.getValueParameters(), (Iterable)this.generateNewValueParameters(res2, oldFunction, numDefaultParametersToExpect)));
        return res2;
    }

    private final List<IrValueParameter> generateNewValueParameters(IrFunction $this$generateNewValueParameters, IrFunction oldFunction, int numDefaultParametersToExpect) {
        int defaultParametersCopied = 0;
        List result = new ArrayList();
        for (IrValueParameter oldValueParameter : oldFunction.getValueParameters()) {
            if (oldValueParameter.getDefaultValue() != null && defaultParametersCopied < numDefaultParametersToExpect) {
                ++defaultParametersCopied;
                result.add(IrUtilsKt.copyTo$default((IrValueParameter)oldValueParameter, (IrFunction)$this$generateNewValueParameters, null, (int)0, (int)0, null, null, null, null, null, (boolean)oldValueParameter.isCrossinline(), (boolean)oldValueParameter.isNoinline(), (boolean)false, null, (int)6398, null));
                continue;
            }
            if (oldValueParameter.getDefaultValue() != null) continue;
            result.add(IrUtilsKt.copyTo$default((IrValueParameter)oldValueParameter, (IrFunction)$this$generateNewValueParameters, null, (int)0, (int)0, null, null, null, null, null, (boolean)false, (boolean)false, (boolean)false, null, (int)8190, null));
        }
        return result;
    }
}

