/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ir.SharedVariablesManager;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrVariableSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmSharedVariablesManager;", "Lorg/jetbrains/kotlin/backend/common/ir/SharedVariablesManager;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "declareSharedVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "originalDeclaration", "defineSharedValue", "sharedVariableDeclaration", "getSharedValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "sharedVariableSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "originalGet", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "setSharedValue", "originalSet", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nWasmSharedVariablesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmSharedVariablesManager.kt\norg/jetbrains/kotlin/backend/wasm/lower/WasmSharedVariablesManager\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,129:1\n36#2,2:130\n36#2,2:132\n*S KotlinDebug\n*F\n+ 1 WasmSharedVariablesManager.kt\norg/jetbrains/kotlin/backend/wasm/lower/WasmSharedVariablesManager\n*L\n69#1:130,2\n103#1:132,2\n*E\n"})
public final class WasmSharedVariablesManager
implements SharedVariablesManager {
    @NotNull
    private final WasmBackendContext context;

    public WasmSharedVariablesManager(@NotNull WasmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public IrVariable declareSharedVariable(@NotNull IrVariable originalDeclaration) {
        IrConstructorCallImpl irConstructorCallImpl;
        Intrinsics.checkNotNullParameter((Object)originalDeclaration, (String)"originalDeclaration");
        IrExpression irExpression = originalDeclaration.getInitializer();
        if (irExpression == null) {
            irExpression = (IrExpression)IrUtilsKt.defaultValueForType((IrConstImpl.Companion)IrConstImpl.Companion, (int)originalDeclaration.getStartOffset(), (int)originalDeclaration.getEndOffset(), (IrType)originalDeclaration.getType());
        }
        IrExpression initializer = irExpression;
        IrClassSymbol boxClass = this.context.getWasmSymbols().findClosureBoxClass(originalDeclaration.getType());
        IrConstructorSymbol constructorSymbol = (IrConstructorSymbol)SequencesKt.first((Sequence)IrUtilsKt.getConstructors((IrClassSymbol)boxClass));
        IrConstructorCallImpl $this$declareSharedVariable_u24lambda_u240 = irConstructorCallImpl = org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrConstructorCallImpl$default((int)initializer.getStartOffset(), (int)initializer.getEndOffset(), (IrType)IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)boxClass)), (IrConstructorSymbol)constructorSymbol, (int)((IrClass)boxClass.getOwner()).getTypeParameters().size(), (int)((IrConstructor)constructorSymbol.getOwner()).getTypeParameters().size(), null, null, (int)192, null);
        boolean bl = false;
        $this$declareSharedVariable_u24lambda_u240.getArguments().set(0, (Object)initializer);
        IrConstructorCallImpl irCall = irConstructorCallImpl;
        IrConstructorCallImpl it = irConstructorCallImpl = BuildersKt.IrVariableImpl((int)originalDeclaration.getStartOffset(), (int)originalDeclaration.getEndOffset(), (IrDeclarationOrigin)originalDeclaration.getOrigin(), (IrVariableSymbol)((IrVariableSymbol)new IrVariableSymbolImpl(null, 1, null)), (Name)originalDeclaration.getName(), (IrType)irCall.getType(), (boolean)false, (boolean)false, (boolean)false);
        boolean bl2 = false;
        it.setParent(originalDeclaration.getParent());
        it.setInitializer((IrExpression)irCall);
        return (IrVariable)irConstructorCallImpl;
    }

    @NotNull
    public IrVariable defineSharedValue(@NotNull IrVariable originalDeclaration, @NotNull IrVariable sharedVariableDeclaration) {
        Intrinsics.checkNotNullParameter((Object)originalDeclaration, (String)"originalDeclaration");
        Intrinsics.checkNotNullParameter((Object)sharedVariableDeclaration, (String)"sharedVariableDeclaration");
        return sharedVariableDeclaration;
    }

    @NotNull
    public IrExpression getSharedValue(@NotNull IrValueSymbol sharedVariableSymbol, @NotNull IrGetValue originalGet) {
        Object element$iv;
        IrCallImpl irCallImpl;
        IrClass boxClass;
        block2: {
            Intrinsics.checkNotNullParameter((Object)sharedVariableSymbol, (String)"sharedVariableSymbol");
            Intrinsics.checkNotNullParameter((Object)originalGet, (String)"originalGet");
            boxClass = (IrClass)IrTypesKt.getClassOrFail((IrType)sharedVariableSymbol.getOwner().getType()).getOwner();
            Iterable $this$firstIsInstance$iv = boxClass.getDeclarations();
            boolean $i$f$firstIsInstance = false;
            irCallImpl = $this$firstIsInstance$iv.iterator();
            while (irCallImpl.hasNext()) {
                element$iv = irCallImpl.next();
                if (!(element$iv instanceof IrProperty)) continue;
                break block2;
            }
            throw new NoSuchElementException("No element of given type found");
        }
        IrProperty valueProperty = (IrProperty)element$iv;
        if (!Intrinsics.areEqual((Object)valueProperty.getName().asString(), (Object)"value")) {
            throw new IllegalStateException("Check failed.");
        }
        IrSimpleFunction irSimpleFunction = valueProperty.getGetter();
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        IrSimpleFunction propertyGetter = irSimpleFunction;
        IrCallImpl it = irCallImpl = org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrCallImpl$default((int)originalGet.getStartOffset(), (int)originalGet.getEndOffset(), (IrType)propertyGetter.getReturnType(), (IrSimpleFunctionSymbol)propertyGetter.getSymbol(), (int)0, (IrStatementOrigin)originalGet.getOrigin(), null, (int)64, null);
        boolean bl = false;
        it.setDispatchReceiver((IrExpression)org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrGetValueImpl((int)originalGet.getStartOffset(), (int)originalGet.getEndOffset(), (IrType)((IrType)IrUtilsKt.getDefaultType((IrClass)boxClass)), (IrValueSymbol)sharedVariableSymbol, (IrStatementOrigin)originalGet.getOrigin()));
        IrCallImpl propertyGet = irCallImpl;
        return (IrExpression)org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrTypeOperatorCallImpl((int)originalGet.getStartOffset(), (int)originalGet.getEndOffset(), (IrType)originalGet.getType(), (IrTypeOperator)IrTypeOperator.IMPLICIT_CAST, (IrType)originalGet.getType(), (IrExpression)((IrExpression)propertyGet));
    }

    @NotNull
    public IrExpression setSharedValue(@NotNull IrValueSymbol sharedVariableSymbol, @NotNull IrSetValue originalSet) {
        Object element$iv;
        IrCallImpl irCallImpl;
        IrClass boxClass;
        block2: {
            Intrinsics.checkNotNullParameter((Object)sharedVariableSymbol, (String)"sharedVariableSymbol");
            Intrinsics.checkNotNullParameter((Object)originalSet, (String)"originalSet");
            boxClass = (IrClass)IrTypesKt.getClassOrFail((IrType)sharedVariableSymbol.getOwner().getType()).getOwner();
            Iterable $this$firstIsInstance$iv = boxClass.getDeclarations();
            boolean $i$f$firstIsInstance = false;
            irCallImpl = $this$firstIsInstance$iv.iterator();
            while (irCallImpl.hasNext()) {
                element$iv = irCallImpl.next();
                if (!(element$iv instanceof IrProperty)) continue;
                break block2;
            }
            throw new NoSuchElementException("No element of given type found");
        }
        IrProperty valueProperty = (IrProperty)element$iv;
        if (!Intrinsics.areEqual((Object)valueProperty.getName().asString(), (Object)"value")) {
            throw new IllegalStateException("Check failed.");
        }
        IrSimpleFunction irSimpleFunction = valueProperty.getSetter();
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        IrSimpleFunction propertySetter = irSimpleFunction;
        IrCallImpl it = irCallImpl = org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrCallImpl$default((int)originalSet.getStartOffset(), (int)originalSet.getEndOffset(), (IrType)propertySetter.getReturnType(), (IrSimpleFunctionSymbol)propertySetter.getSymbol(), (int)0, (IrStatementOrigin)originalSet.getOrigin(), null, (int)64, null);
        boolean bl = false;
        it.setDispatchReceiver((IrExpression)org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrGetValueImpl((int)originalSet.getStartOffset(), (int)originalSet.getEndOffset(), (IrType)((IrType)IrUtilsKt.getDefaultType((IrClass)boxClass)), (IrValueSymbol)sharedVariableSymbol, (IrStatementOrigin)originalSet.getOrigin()));
        it.getArguments().set(1, (Object)originalSet.getValue());
        IrCallImpl propertySet = irCallImpl;
        return (IrExpression)propertySet;
    }
}

