/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.shellcheck;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.ex.ExternalAnnotatorBatchInspection;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.sh.shellcheck.ShellcheckOptionsPanel;
import com.intellij.sh.utils.ProjectUtil;
import com.intellij.ui.EditorNotifications;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShShellcheckInspection
extends LocalInspectionTool
implements ExternalAnnotatorBatchInspection {
    @NonNls
    public static final String SHORT_NAME = "ShellCheck";
    @NonNls
    private static final String SHELLCHECK_SETTINGS_TAG = "shellcheck_settings";
    private static final String DELIMITER = ",";
    private final Set<@NlsSafe String> myDisabledInspections = new TreeSet<String>();
    private JComponent myOptionsPanel;

    public SuppressQuickFix @NotNull [] getBatchSuppressActions(@Nullable PsiElement element) {
        if (SuppressQuickFix.EMPTY_ARRAY == null) {
            ShShellcheckInspection.$$$reportNull$$$0(0);
        }
        return SuppressQuickFix.EMPTY_ARRAY;
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    public void readSettings(@NotNull Element node) {
        String inspectionSettings;
        if (node == null) {
            ShShellcheckInspection.$$$reportNull$$$0(1);
        }
        if (StringUtil.isNotEmpty((String)(inspectionSettings = JDOMExternalizerUtil.readCustomField((Element)node, (String)SHELLCHECK_SETTINGS_TAG)))) {
            this.myDisabledInspections.addAll(StringUtil.split((String)inspectionSettings, (String)DELIMITER));
        }
    }

    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            ShShellcheckInspection.$$$reportNull$$$0(2);
        }
        if (!this.myDisabledInspections.isEmpty()) {
            String joinedString = StringUtil.join(this.myDisabledInspections, (String)DELIMITER);
            JDOMExternalizerUtil.writeCustomField((Element)node, (String)SHELLCHECK_SETTINGS_TAG, (String)joinedString);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            Project project = ProjectUtil.getProject(this.myOptionsPanel);
            EditorNotifications editorNotifications = EditorNotifications.getInstance((Project)project);
            editorNotifications.updateAllNotifications();
        }
    }

    @Nullable
    public JComponent createOptionsPanel() {
        this.myOptionsPanel = new ShellcheckOptionsPanel(this.getDisabledInspections(), this::onInspectionChange).getPanel();
        return this.myOptionsPanel;
    }

    @NotNull Set<@NlsSafe String> getDisabledInspections() {
        return new HashSet<String>(this.myDisabledInspections);
    }

    public void disableInspection(String inspectionCode) {
        if (StringUtil.isNotEmpty((String)inspectionCode)) {
            this.myDisabledInspections.add(inspectionCode);
        }
    }

    private void onInspectionChange(@NotNull String inspectionCode, boolean selected) {
        if (inspectionCode == null) {
            ShShellcheckInspection.$$$reportNull$$$0(3);
        }
        if (selected) {
            this.myDisabledInspections.add(inspectionCode);
        } else {
            this.myDisabledInspections.remove(inspectionCode);
        }
    }

    @NotNull
    static ShShellcheckInspection findShShellcheckInspection(@NotNull PsiElement element) {
        InspectionProfileImpl profile;
        ShShellcheckInspection tool;
        if (element == null) {
            ShShellcheckInspection.$$$reportNull$$$0(4);
        }
        ShShellcheckInspection shShellcheckInspection = (tool = (ShShellcheckInspection)(profile = InspectionProjectProfileManager.getInstance((Project)element.getProject()).getCurrentProfile()).getUnwrappedTool(SHORT_NAME, element)) == null ? new ShShellcheckInspection() : tool;
        if (shShellcheckInspection == null) {
            ShShellcheckInspection.$$$reportNull$$$0(5);
        }
        return shShellcheckInspection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/shellcheck/ShShellcheckInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionCode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBatchSuppressActions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/shellcheck/ShShellcheckInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findShShellcheckInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onInspectionChange";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findShShellcheckInspection";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

