/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.util.jcommander;

import com.android.tools.smali.util.jcommander.Command;
import com.android.tools.smali.util.jcommander.ExtendedParameter;
import com.android.tools.smali.util.jcommander.ExtendedParameters;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.Parameterized;
import com.beust.jcommander.Parameters;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExtendedCommands {
    @Nonnull
    private static ExtendedParameters getExtendedParameters(Object command) {
        ExtendedParameters anno = command.getClass().getAnnotation(ExtendedParameters.class);
        if (anno == null) {
            throw new IllegalStateException("All extended commands should have an ExtendedParameters annotation: " + command.getClass().getCanonicalName());
        }
        return anno;
    }

    @Nonnull
    public static String commandName(JCommander jc) {
        return ExtendedCommands.getExtendedParameters(jc.getObjects().get(0)).commandName();
    }

    @Nonnull
    public static String commandName(Object command) {
        return ExtendedCommands.getExtendedParameters(command).commandName();
    }

    @Nonnull
    public static String[] commandAliases(JCommander jc) {
        return ExtendedCommands.commandAliases(jc.getObjects().get(0));
    }

    @Nonnull
    public static String[] commandAliases(Object command) {
        return ExtendedCommands.getExtendedParameters(command).commandAliases();
    }

    public static boolean includeParametersInUsage(JCommander jc) {
        return ExtendedCommands.includeParametersInUsage(jc.getObjects().get(0));
    }

    public static boolean includeParametersInUsage(Object command) {
        return ExtendedCommands.getExtendedParameters(command).includeParametersInUsage();
    }

    @Nonnull
    public static String postfixDescription(JCommander jc) {
        return ExtendedCommands.postfixDescription(jc.getObjects().get(0));
    }

    @Nonnull
    public static String postfixDescription(Object command) {
        return ExtendedCommands.getExtendedParameters(command).postfixDescription();
    }

    public static void addExtendedCommand(JCommander jc, Command command) {
        jc.addCommand(ExtendedCommands.commandName(command), (Object)command, ExtendedCommands.commandAliases(command));
        command.setupCommand(command.getJCommander());
    }

    @Nonnull
    public static String[] parameterArgumentNames(ParameterDescription parameterDescription) {
        Parameterized parameterized = parameterDescription.getParameterized();
        Field field = null;
        for (Class<?> cls = parameterDescription.getObject().getClass(); cls != Object.class; cls = cls.getSuperclass()) {
            try {
                field = cls.getDeclaredField(parameterized.getName());
                break;
            }
            catch (NoSuchFieldException ex) {
                continue;
            }
        }
        assert (field != null);
        ExtendedParameter extendedParameter = field.getAnnotation(ExtendedParameter.class);
        if (extendedParameter != null) {
            return extendedParameter.argumentNames();
        }
        return new String[0];
    }

    @Nullable
    public static JCommander getSubcommand(JCommander jc, String commandName) {
        if (jc.getCommands().containsKey(commandName)) {
            return (JCommander)jc.getCommands().get(commandName);
        }
        for (JCommander command : jc.getCommands().values()) {
            for (String alias : ExtendedCommands.commandAliases(command)) {
                if (!commandName.equals(alias)) continue;
                return command;
            }
        }
        return null;
    }

    @Nullable
    public static String getCommandDescription(@Nonnull JCommander jc) {
        Parameters parameters = jc.getObjects().get(0).getClass().getAnnotation(Parameters.class);
        if (parameters == null) {
            return null;
        }
        return parameters.commandDescription();
    }
}

