/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.android;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gct.testing.CloudConfigurationHelper;
import com.google.gct.testing.android.CloudConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudProjectSelector
extends ComboBox<String> {
    private static final String LOADING_CLOUD_PROJECTS_STRING = "Loading cloud projects...";
    private static final List<String> LOADING_CLOUD_PROJECTS_LIST = ImmutableList.of((Object)"Loading cloud projects...");
    private static volatile List<String> myCloudProjects;
    private final CloudConfiguration.Kind myConfigurationKind;
    private int myCurrentConfigurationId = -1;
    private Module myCurrentModule;
    private static final Map<CloudConfiguration.Kind, String> myLastChosenProjectIdPerKind;
    private static final Map<Integer, Map<Pair<CloudConfiguration.Kind, Module>, String>> myProjectByConfigurationIdAndModuleCache;

    public CloudProjectSelector(@NotNull CloudConfiguration.Kind configurationKind) {
        this.myConfigurationKind = configurationKind;
        this.setRenderer((ListCellRenderer)((Object)new CloudProjectRenderer()));
        this.addActionListener(e -> {
            Object selectedItem = this.getSelectedItem();
            if (selectedItem != null && !LOADING_CLOUD_PROJECTS_STRING.equals(selectedItem)) {
                this.rememberChosenProjectId((String)selectedItem);
            }
        });
        if (myCloudProjects == null || myCloudProjects.isEmpty()) {
            this.setDefaultPreferredSize();
        }
        if (myCloudProjects != null) {
            this.setModel((ComboBoxModel)new CollectionComboBoxModel(myCloudProjects));
        }
    }

    public void refreshCloudProjects() {
        this.setModel((ComboBoxModel)new CollectionComboBoxModel(LOADING_CLOUD_PROJECTS_LIST));
        boolean wasEnabled = this.isEnabled();
        this.setEnabled(false);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            myCloudProjects = CloudConfigurationHelper.getCloudProjects();
            SwingUtilities.invokeLater(() -> {
                if (!myCloudProjects.isEmpty()) {
                    this.setPreferredSize(null);
                } else {
                    this.setDefaultPreferredSize();
                }
                this.setModel((ComboBoxModel)new CollectionComboBoxModel(myCloudProjects));
                this.restoreChosenProjectId();
                this.setEnabled(wasEnabled);
                for (ItemListener itemListener : this.getItemListeners()) {
                    itemListener.itemStateChanged(new ItemEvent((ItemSelectable)((Object)this), 701, (Object)this, 1));
                }
            });
        });
    }

    private void setDefaultPreferredSize() {
        this.setPreferredSize(new Dimension(JBUI.scale((int)200), this.getMinimumSize().height));
    }

    @NotNull
    public String getProjectId() {
        Object selectedItem = this.getSelectedItem();
        if (LOADING_CLOUD_PROJECTS_STRING.equals(selectedItem)) {
            selectedItem = this.getStoredChosenProjectId();
        }
        return selectedItem == null ? "" : (String)selectedItem;
    }

    public void updateCloudProjectId(@NotNull String cloudProjectId) {
        this.setSelectedItem(cloudProjectId);
        if (!cloudProjectId.equals(this.getSelectedItem()) && this.getItemCount() > 0) {
            this.setSelectedIndex(0);
        }
        this.rememberChosenProjectId(cloudProjectId);
    }

    public void setFacet(@Nullable AndroidFacet facet) {
        if (facet == null) {
            return;
        }
        this.myCurrentModule = facet.getModule();
        if (myCloudProjects == null) {
            this.refreshCloudProjects();
        } else {
            this.restoreChosenProjectId();
        }
    }

    public void setRunConfigurationId(int configurationId) {
        this.myCurrentConfigurationId = configurationId;
    }

    private void rememberChosenProjectId(@NotNull String cloudProjectId) {
        myLastChosenProjectIdPerKind.put(this.myConfigurationKind, cloudProjectId);
        if (this.myCurrentConfigurationId == -1 || this.myCurrentModule == null) {
            return;
        }
        Map projectByModuleCache = myProjectByConfigurationIdAndModuleCache.computeIfAbsent(this.myCurrentConfigurationId, k -> Maps.newHashMapWithExpectedSize((int)5));
        projectByModuleCache.put(Pair.create((Object)((Object)this.myConfigurationKind), (Object)this.myCurrentModule), cloudProjectId);
    }

    private void restoreChosenProjectId() {
        String storedChosenProjectId = this.getStoredChosenProjectId();
        if (storedChosenProjectId != null) {
            this.setSelectedItem(storedChosenProjectId);
        }
    }

    @Nullable
    private String getStoredChosenProjectId() {
        if (this.myCurrentConfigurationId == -1 || this.myCurrentModule == null) {
            return myLastChosenProjectIdPerKind.get((Object)this.myConfigurationKind);
        }
        Map<Pair<CloudConfiguration.Kind, Module>, String> projectByModuleCache = myProjectByConfigurationIdAndModuleCache.get(this.myCurrentConfigurationId);
        if (projectByModuleCache != null) {
            return projectByModuleCache.get(Pair.create((Object)((Object)this.myConfigurationKind), (Object)this.myCurrentModule));
        }
        return null;
    }

    static {
        myLastChosenProjectIdPerKind = Maps.newHashMapWithExpectedSize((int)5);
        myProjectByConfigurationIdAndModuleCache = Maps.newHashMapWithExpectedSize((int)5);
    }

    private static class CloudProjectRenderer
    extends ColoredListCellRenderer<String> {
        private CloudProjectRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList<? extends String> list, String value, int index, boolean selected, boolean hasFocus) {
            if (value == null) {
                this.append("[none]", SimpleTextAttributes.ERROR_ATTRIBUTES);
            } else {
                this.append(value);
            }
        }
    }
}

