/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.dimension;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.gct.testing.CloudConfigurationImpl;
import com.google.gct.testing.dimension.CloudTestingType;
import com.google.gct.testing.dimension.CloudTestingTypeGroup;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public abstract class CloudConfigurationDimension {
    private static final long DISCOVERY_TEST_API_REFRESH_TIMEOUT = 300000L;
    private static final Map<String, Long> lastDiscoveryTestApiUpdateTimestampMap = new HashMap<String, Long>();
    private final List<CloudTestingType> enabledTypes = new LinkedList<CloudTestingType>();
    private final CloudConfigurationImpl myCloudConfiguration;

    public CloudConfigurationDimension(CloudConfigurationImpl cloudConfiguration) {
        this.myCloudConfiguration = cloudConfiguration;
    }

    static boolean shouldPollDiscoveryTestApi(String dimension) {
        Long lastTimestamp = lastDiscoveryTestApiUpdateTimestampMap.get(dimension);
        if (lastTimestamp == null) {
            return true;
        }
        return System.currentTimeMillis() - lastTimestamp > 300000L;
    }

    static void resetDiscoveryTestApiUpdateTimestamp(String dimension) {
        lastDiscoveryTestApiUpdateTimestampMap.put(dimension, System.currentTimeMillis());
    }

    public abstract List<? extends CloudTestingType> getAppSupportedDomain();

    public List<? extends CloudTestingTypeGroup> getSupportedGroups() {
        LinkedList<CloudTestingTypeGroup> result = new LinkedList<CloudTestingTypeGroup>();
        for (CloudTestingType cloudTestingType : this.getSupportedDomain()) {
            CloudTestingTypeGroup groupToAddTo = null;
            for (CloudTestingTypeGroup group : result) {
                if (!cloudTestingType.getGroupName().equals(group.getName())) continue;
                groupToAddTo = group;
                break;
            }
            if (groupToAddTo == null) {
                groupToAddTo = new CloudTestingTypeGroup(cloudTestingType.getGroupName(), cloudTestingType.getGroupDescription());
                result.add(groupToAddTo);
            }
            groupToAddTo.addType(cloudTestingType);
        }
        return result;
    }

    public List<? extends CloudTestingType> getSupportedDomain() {
        return this.getAppSupportedDomain();
    }

    public void enable(CloudTestingType ... types) {
        this.checkIsEditable();
        for (CloudTestingType type : types) {
            if (!this.getSupportedDomain().contains(type)) continue;
            this.enableType(type);
        }
    }

    public void enable(List<? extends CloudTestingType> types, Iterable<String> ids) {
        this.checkIsEditable();
        HashSet idsSet = Sets.newHashSet(ids);
        for (CloudTestingType cloudTestingType : types) {
            if (!this.getSupportedDomain().contains(cloudTestingType) || !idsSet.contains(cloudTestingType.getId())) continue;
            this.enableType(cloudTestingType);
        }
    }

    public void enableTopN(List<? extends CloudTestingType> types, int numberOfTypesToEnable) {
        this.checkIsEditable();
        int enabledTypesCount = 0;
        for (CloudTestingType cloudTestingType : types) {
            if (enabledTypesCount == numberOfTypesToEnable) {
                return;
            }
            if (!this.getSupportedDomain().contains(cloudTestingType)) continue;
            this.enableType(cloudTestingType);
            ++enabledTypesCount;
        }
    }

    public void disable(CloudTestingType ... types) {
        this.checkIsEditable();
        this.enabledTypes.removeAll(Arrays.asList(types));
    }

    public void setEnabled(CloudTestingType type, boolean isEnabled) {
        if (!this.getSupportedDomain().contains(type)) {
            return;
        }
        this.checkIsEditable();
        if (isEnabled) {
            this.enableType(type);
        } else {
            this.enabledTypes.remove(type);
        }
    }

    private void enableType(CloudTestingType type) {
        if (!this.enabledTypes.contains(type)) {
            this.enabledTypes.add(type);
        }
    }

    public void enableAll() {
        this.checkIsEditable();
        for (CloudTestingType cloudTestingType : this.getSupportedDomain()) {
            this.enable(cloudTestingType);
        }
    }

    public void disableAll() {
        this.checkIsEditable();
        for (CloudTestingType cloudTestingType : this.getSupportedDomain()) {
            this.disable(cloudTestingType);
        }
    }

    public ImmutableList<CloudTestingType> getEnabledTypes() {
        return ImmutableList.copyOf(this.enabledTypes);
    }

    public boolean isEditable() {
        return this.myCloudConfiguration.isEditable();
    }

    public void dimensionChanged() {
        this.myCloudConfiguration.dimensionChanged(this);
    }

    private void checkIsEditable() {
        Preconditions.checkState((boolean)this.isEditable(), (Object)"Cannot change a non-editable dimension!");
    }

    public boolean shouldBeAlwaysGrouped() {
        return false;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public abstract String getDisplayName();

    public abstract String getId();

    public abstract Icon getIcon();

    public void enableAll(Iterable<? extends CloudTestingType> enabledTypes) {
        for (CloudTestingType cloudTestingType : enabledTypes) {
            this.enable(cloudTestingType);
        }
    }
}

