/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.OS;

public class ImageList {
    int[] pixbufs;
    int width = -1;
    int height = -1;
    Image[] images = new Image[4];

    public ImageList() {
        this.pixbufs = new int[4];
    }

    public static int convertSurface(Image image) {
        int n = image.surface;
        int n2 = Cairo.cairo_surface_get_type(n);
        if (n2 != 0) {
            int n3;
            Rectangle rectangle = image.getBounds();
            int n4 = Cairo.cairo_surface_get_content(n) == 4096 ? 1 : 0;
            if ((n = Cairo.cairo_image_surface_create(n4, rectangle.width, rectangle.height)) == 0) {
                SWT.error(2);
            }
            if ((n3 = Cairo.cairo_create(n)) == 0) {
                SWT.error(2);
            }
            Cairo.cairo_set_operator(n3, 1);
            Cairo.cairo_set_source_surface(n3, image.surface, 0.0, 0.0);
            Cairo.cairo_paint(n3);
            Cairo.cairo_destroy(n3);
        } else {
            Cairo.cairo_surface_reference(n);
        }
        return n;
    }

    public static int createPixbuf(Image image) {
        int n;
        if (OS.USE_CAIRO) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8 = ImageList.convertSurface(image);
            int n9 = Cairo.cairo_image_surface_get_format(n8);
            boolean bl = n9 == 0;
            n = OS.gdk_pixbuf_new(0, bl, 8, n7 = Cairo.cairo_image_surface_get_width(n8), n6 = Cairo.cairo_image_surface_get_height(n8));
            if (n == 0) {
                SWT.error(2);
            }
            int n10 = OS.gdk_pixbuf_get_rowstride(n);
            int n11 = OS.gdk_pixbuf_get_pixels(n);
            if (OS.BIG_ENDIAN) {
                n5 = 0;
                n4 = 1;
                n3 = 2;
                n2 = 3;
            } else {
                n5 = 3;
                n4 = 2;
                n3 = 1;
                n2 = 0;
            }
            byte[] byArray = new byte[n10];
            int n12 = Cairo.cairo_image_surface_get_data(n8);
            if (bl) {
                int n13 = 0;
                while (n13 < n6) {
                    OS.memmove(byArray, n12 + n13 * n10, n10);
                    int n14 = 0;
                    int n15 = 0;
                    while (n14 < n7) {
                        int n16 = byArray[n15 + n5] & 0xFF;
                        int n17 = byArray[n15 + n4] & 0xFF;
                        int n18 = byArray[n15 + n3] & 0xFF;
                        int n19 = byArray[n15 + n2] & 0xFF;
                        byArray[n15 + 3] = (byte)n16;
                        if (n16 != 0) {
                            byArray[n15 + 0] = (byte)((n17 * 255 + n16 / 2) / n16);
                            byArray[n15 + 1] = (byte)((n18 * 255 + n16 / 2) / n16);
                            byArray[n15 + 2] = (byte)((n19 * 255 + n16 / 2) / n16);
                        }
                        ++n14;
                        n15 += 4;
                    }
                    OS.memmove(n11 + n13 * n10, byArray, n10);
                    ++n13;
                }
            } else {
                int n20 = Cairo.cairo_image_surface_get_stride(n8);
                byte[] byArray2 = new byte[n20];
                int n21 = 0;
                while (n21 < n6) {
                    OS.memmove(byArray2, n12 + n21 * n20, n20);
                    int n22 = 0;
                    int n23 = 0;
                    int n24 = 0;
                    while (n22 < n7) {
                        byte by = byArray2[n24 + n4];
                        byte by2 = byArray2[n24 + n3];
                        byte by3 = byArray2[n24 + n2];
                        byArray[n23 + 0] = by;
                        byArray[n23 + 1] = by2;
                        byArray[n23 + 2] = by3;
                        ++n22;
                        n23 += 3;
                        n24 += 4;
                    }
                    OS.memmove(n11 + n21 * n10, byArray, n10);
                    ++n21;
                }
            }
            Cairo.cairo_surface_destroy(n8);
        } else {
            boolean bl;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gdk_drawable_get_size(image.pixmap, nArray, nArray2);
            int n25 = OS.gdk_colormap_get_system();
            boolean bl2 = bl = image.mask != 0 && OS.gdk_drawable_get_depth(image.mask) == 1;
            if (bl) {
                n = OS.gdk_pixbuf_new(0, true, 8, nArray[0], nArray2[0]);
                if (n == 0) {
                    SWT.error(2);
                }
                OS.gdk_pixbuf_get_from_drawable(n, image.pixmap, n25, 0, 0, 0, 0, nArray[0], nArray2[0]);
                int n26 = OS.gdk_pixbuf_new(0, false, 8, nArray[0], nArray2[0]);
                if (n26 == 0) {
                    SWT.error(2);
                }
                OS.gdk_pixbuf_get_from_drawable(n26, image.mask, 0, 0, 0, 0, 0, nArray[0], nArray2[0]);
                int n27 = OS.gdk_pixbuf_get_rowstride(n);
                int n28 = OS.gdk_pixbuf_get_pixels(n);
                byte[] byArray = new byte[n27];
                int n29 = OS.gdk_pixbuf_get_rowstride(n26);
                int n30 = OS.gdk_pixbuf_get_pixels(n26);
                byte[] byArray3 = new byte[n29];
                int n31 = 0;
                while (n31 < nArray2[0]) {
                    int n32 = n28 + n31 * n27;
                    OS.memmove(byArray, n32, n27);
                    int n33 = n30 + n31 * n29;
                    OS.memmove(byArray3, n33, n29);
                    int n34 = 0;
                    while (n34 < nArray[0]) {
                        if (byArray3[n34 * 3] == 0) {
                            byArray[n34 * 4 + 3] = 0;
                        }
                        ++n34;
                    }
                    OS.memmove(n32, byArray, n27);
                    ++n31;
                }
                OS.g_object_unref(n26);
            } else {
                ImageData imageData = image.getImageData();
                boolean bl3 = imageData.getTransparencyType() == 1;
                n = OS.gdk_pixbuf_new(0, bl3, 8, nArray[0], nArray2[0]);
                if (n == 0) {
                    SWT.error(2);
                }
                OS.gdk_pixbuf_get_from_drawable(n, image.pixmap, n25, 0, 0, 0, 0, nArray[0], nArray2[0]);
                if (bl3) {
                    byte[] byArray = imageData.alphaData;
                    int n35 = OS.gdk_pixbuf_get_rowstride(n);
                    int n36 = OS.gdk_pixbuf_get_pixels(n);
                    byte[] byArray4 = new byte[n35];
                    int n37 = 0;
                    while (n37 < nArray2[0]) {
                        int n38 = n36 + n37 * n35;
                        OS.memmove(byArray4, n38, n35);
                        int n39 = 0;
                        while (n39 < nArray[0]) {
                            byArray4[n39 * 4 + 3] = byArray[n37 * nArray[0] + n39];
                            ++n39;
                        }
                        OS.memmove(n38, byArray4, n35);
                        ++n37;
                    }
                }
            }
        }
        return n;
    }

    public int add(Image image) {
        int n = 0;
        while (n < this.images.length) {
            if (this.images[n] != null && this.images[n].isDisposed()) {
                OS.g_object_unref(this.pixbufs[n]);
                this.images[n] = null;
                this.pixbufs[n] = 0;
            }
            if (this.images[n] == null) break;
            ++n;
        }
        if (n == this.images.length) {
            Image[] imageArray = new Image[this.images.length + 4];
            System.arraycopy(this.images, 0, imageArray, 0, this.images.length);
            this.images = imageArray;
            int[] nArray = new int[this.pixbufs.length + 4];
            System.arraycopy(this.pixbufs, 0, nArray, 0, this.pixbufs.length);
            this.pixbufs = nArray;
        }
        this.set(n, image);
        return n;
    }

    public void dispose() {
        if (this.pixbufs == null) {
            return;
        }
        int n = 0;
        while (n < this.pixbufs.length) {
            if (this.pixbufs[n] != 0) {
                OS.g_object_unref(this.pixbufs[n]);
            }
            ++n;
        }
        this.images = null;
        this.pixbufs = null;
    }

    public Image get(int n) {
        return this.images[n];
    }

    public int getPixbuf(int n) {
        return this.pixbufs[n];
    }

    public int indexOf(Image image) {
        if (image == null) {
            return -1;
        }
        int n = 0;
        while (n < this.images.length) {
            if (image == this.images[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOf(int n) {
        if (n == 0) {
            return -1;
        }
        int n2 = 0;
        while (n2 < this.images.length) {
            if (n == this.pixbufs[n2]) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public boolean isDisposed() {
        return this.images == null;
    }

    public void put(int n, Image image) {
        int n2 = this.images.length;
        if (n < 0 || n >= n2) {
            return;
        }
        if (image != null) {
            this.set(n, image);
        } else {
            this.images[n] = null;
            if (this.pixbufs[n] != 0) {
                OS.g_object_unref(this.pixbufs[n]);
            }
            this.pixbufs[n] = 0;
        }
    }

    public void remove(Image image) {
        if (image == null) {
            return;
        }
        int n = 0;
        while (n < this.images.length) {
            if (image == this.images[n]) {
                OS.g_object_unref(this.pixbufs[n]);
                this.images[n] = null;
                this.pixbufs[n] = 0;
            }
            ++n;
        }
    }

    void set(int n, Image image) {
        int n2;
        int n3 = ImageList.createPixbuf(image);
        int n4 = OS.gdk_pixbuf_get_width(n3);
        int n5 = OS.gdk_pixbuf_get_height(n3);
        if (this.width == -1 || this.height == -1) {
            this.width = n4;
            this.height = n5;
        }
        if (n4 != this.width || n5 != this.height) {
            n2 = OS.gdk_pixbuf_scale_simple(n3, this.width, this.height, 2);
            OS.g_object_unref(n3);
            n3 = n2;
        }
        if ((n2 = this.pixbufs[n]) != 0) {
            if (this.images[n] == image) {
                OS.gdk_pixbuf_copy_area(n3, 0, 0, this.width, this.height, n2, 0, 0);
                OS.g_object_unref(n3);
                n3 = n2;
            } else {
                OS.g_object_unref(n2);
            }
        }
        this.pixbufs[n] = n3;
        this.images[n] = image;
    }

    public int size() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.images.length) {
            if (this.images[n2] != null) {
                if (this.images[n2].isDisposed()) {
                    OS.g_object_unref(this.pixbufs[n2]);
                    this.images[n2] = null;
                    this.pixbufs[n2] = 0;
                }
                if (this.images[n2] != null) {
                    ++n;
                }
            }
            ++n2;
        }
        return n;
    }
}

