/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.action.internal;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.ActiveOnboardingProvider;
import com.android.studio.ml.SmlBundle;
import com.android.studio.ml.bot.ui.onboarding.OnboardingState;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/android/studio/ml/bot/action/internal/ToggleOnboardingCompletionAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nToggleOnboardingCompletionAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToggleOnboardingCompletionAction.kt\ncom/android/studio/ml/bot/action/internal/ToggleOnboardingCompletionAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,91:1\n25#2:92\n25#2:95\n25#2:98\n31#3,2:93\n31#3,2:96\n31#3,2:99\n*S KotlinDebug\n*F\n+ 1 ToggleOnboardingCompletionAction.kt\ncom/android/studio/ml/bot/action/internal/ToggleOnboardingCompletionAction\n*L\n38#1:92\n57#1:95\n63#1:98\n43#1:93,2\n61#1:96,2\n67#1:99,2\n*E\n"})
public final class ToggleOnboardingCompletionAction
extends DumbAwareAction {
    public static final int $stable = 8;

    public ToggleOnboardingCompletionAction() {
        super(SmlBundle.message("sml.studiobot.internal.resetOnboarding.text.generic", new Object[0]));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        e.getPresentation().setEnabledAndVisible(project2 != null);
        if (project2 == null) {
            ToggleOnboardingCompletionAction $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ToggleOnboardingCompletionAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Can't get project from action event, can't check onboarding completion");
            return;
        }
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<ActiveOnboardingProvider> serviceClass$iv = ActiveOnboardingProvider.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        StateFlow<OnboardingState.State> stateFlow = (StateFlow<OnboardingState.State>)((ActiveOnboardingProvider)object).getOnboardingState().getValue();
        boolean onboardingCompleted = (stateFlow != null && (stateFlow = stateFlow.getCurrentState()) != null ? (OnboardingState.State)((Object)stateFlow.getValue()) : null) == OnboardingState.State.ONBOARDED;
        e.getPresentation().setText(onboardingCompleted ? SmlBundle.message("sml.studiobot.internal.resetOnboarding.text.toNotCompleted", new Object[0]) : SmlBundle.message("sml.studiobot.internal.resetOnboarding.text.toCompleted", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            ToggleOnboardingCompletionAction $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ToggleOnboardingCompletionAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Can't get project from action event, can't toggle onboarding completion");
            return;
        }
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<ActiveOnboardingProvider> serviceClass$iv = ActiveOnboardingProvider.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        OnboardingState onboardingState2 = (OnboardingState)((ActiveOnboardingProvider)object).getOnboardingState().getValue();
        if (onboardingState2 == null) {
            ToggleOnboardingCompletionAction $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ToggleOnboardingCompletionAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("No onboarding provider currently active.");
            return;
        }
        ComponentManager $this$service$iv2 = (ComponentManager)project2;
        boolean $i$f$service2 = false;
        Class<ActiveOnboardingProvider> serviceClass$iv2 = ActiveOnboardingProvider.class;
        Object object2 = $this$service$iv2.getService(serviceClass$iv2);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv2, serviceClass$iv2);
        }
        StateFlow<OnboardingState.State> stateFlow = (StateFlow<OnboardingState.State>)((ActiveOnboardingProvider)object2).getOnboardingState().getValue();
        boolean onboardingCompleted = (stateFlow != null && (stateFlow = stateFlow.getCurrentState()) != null ? (OnboardingState.State)((Object)stateFlow.getValue()) : null) == OnboardingState.State.ONBOARDED;
        MessageDialogBuilder.YesNo dialogBuilder2 = MessageDialogBuilder.Companion.yesNo(SmlBundle.message("sml.studiobot.internal.resetOnboarding.dialogTitle", new Object[0]), onboardingCompleted ? SmlBundle.message("sml.studiobot.internal.resetOnboarding.dialogMessage.toNotCompleted", new Object[0]) : SmlBundle.message("sml.studiobot.internal.resetOnboarding.dialogMessage.toCompleted", new Object[0]));
        if (dialogBuilder2.ask(e.getProject())) {
            if (onboardingCompleted) {
                onboardingState2.setUserHasNotCompletedOnboarding();
                onboardingState2.clearOnboardingRelatedSettings(project2);
            } else {
                onboardingState2.setUserHasCompletedOnboarding();
            }
        }
    }
}

