/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.diff;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.ModelProvider;
import com.android.studio.ml.TransformServiceKt;
import com.android.studio.ml.bot.diff.ActiveDiffRequestHolder;
import com.android.studio.ml.bot.diff.TransformSession;
import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.Collection;
import java.util.List;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0003J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0003J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0015J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0015J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0019H\u0015J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0019H\u0015J\b\u0010\u001e\u001a\u00020\u0019H\u0015J\b\u0010\u001f\u001a\u00020\u0015H\u0015J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0003J\u001a\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u00192\b\u0010%\u001a\u0004\u0018\u00010&H\u0017R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/studio/ml/bot/diff/TransformSessionViewer;", "Lcom/intellij/diff/impl/DiffRequestProcessor;", "Lcom/android/studio/ml/bot/diff/ActiveDiffRequestHolder;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/android/studio/ml/bot/diff/TransformSession;", "(Lcom/intellij/openapi/project/Project;Lcom/android/studio/ml/bot/diff/TransformSession;)V", "diffRequestChain", "Lcom/intellij/diff/chains/DiffRequestChain;", "getDiffRequestChain", "()Lcom/intellij/diff/chains/DiffRequestChain;", "fileIndex", "", "lastDisplayedFileName", "", "createGoToChangeAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getCurrentRequest", "Lcom/intellij/diff/requests/DiffRequest;", "goToChange", "", "index", "goToNextChange", "fromDifferences", "", "goToPrevChange", "hasNextChange", "fromUpdate", "hasPrevChange", "isNavigationEnabled", "onDispose", "onSessionUpdate", "updateType", "Lcom/android/studio/ml/bot/diff/TransformSession$UpdateListener$UpdateType;", "updateRequest", "force", "scrollToChangePolicy", "Lcom/intellij/diff/util/DiffUserDataKeysEx$ScrollToPolicy;", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nTransformSessionViewer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransformSessionViewer.kt\ncom/android/studio/ml/bot/diff/TransformSessionViewer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n360#2,7:117\n*S KotlinDebug\n*F\n+ 1 TransformSessionViewer.kt\ncom/android/studio/ml/bot/diff/TransformSessionViewer\n*L\n72#1:117,7\n*E\n"})
public final class TransformSessionViewer
extends DiffRequestProcessor
implements ActiveDiffRequestHolder {
    @NotNull
    private final TransformSession session;
    @Nullable
    private String lastDisplayedFileName;
    private int fileIndex;
    public static final int $stable = 8;

    public TransformSessionViewer(@NotNull Project project2, @NotNull TransformSession session2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
        super(project2, (UserDataHolder)session2);
        this.session = session2;
        if (this.session.isEmpty()) {
            Disposer.dispose((Disposable)((Disposable)this));
            throw new IllegalArgumentException("Cannot create viewer for empty session!");
        }
        this.session.addListener(new TransformSession.UpdateListener(){

            @Override
            public final void onUpdate(TransformSession.UpdateListener.UpdateType p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                this.onSessionUpdate(p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, (Object)this, TransformSessionViewer.class, "onSessionUpdate", "onSessionUpdate(Lcom/android/studio/ml/bot/diff/TransformSession$UpdateListener$UpdateType;)V", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof TransformSession.UpdateListener ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        }, (Disposable)this);
        this.session.addTransformResultEvent(TransformServiceKt.toDisplayEvent(this.session.getCurrentEntry().getTransformResult()));
        this.fileIndex = this.getDiffRequestChain().getIndex();
    }

    private final DiffRequestChain getDiffRequestChain() {
        return this.session.getCurrentEntry().getDiffRequestChain();
    }

    @RequiresEdt
    public void updateRequest(boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        this.lastDisplayedFileName = ((DiffRequestProducer)this.getDiffRequestChain().getRequests().get(this.fileIndex)).getName();
        this.applyRequest(this.getCurrentRequest(), force, scrollToChangePolicy);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private final void onSessionUpdate(TransformSession.UpdateListener.UpdateType updateType) {
        if (updateType == TransformSession.UpdateListener.UpdateType.CONTENTS_CHANGED || updateType == TransformSession.UpdateListener.UpdateType.POSITION_UPDATED) {
            int n;
            block3: {
                void $this$indexOfFirst$iv;
                List list = this.getDiffRequestChain().getRequests();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRequests(...)");
                List list2 = list;
                TransformSessionViewer transformSessionViewer = this;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    DiffRequestProducer it = (DiffRequestProducer)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getName(), (Object)this.lastDisplayedFileName)) {
                        n = index$iv;
                        break block3;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int n2 = n;
            transformSessionViewer.fileIndex = RangesKt.coerceAtLeast((int)n2, (int)0);
            this.session.addTransformResultEvent(TransformServiceKt.toDisplayEvent(this.session.getCurrentEntry().getTransformResult()));
            this.updateRequest(true, DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE);
        }
    }

    @RequiresEdt
    private final DiffRequest getCurrentRequest() {
        DiffRequest diffRequest = ((DiffRequestProducer)this.getDiffRequestChain().getRequests().get(this.fileIndex)).process((UserDataHolder)this.getContext(), (ProgressIndicator)new EmptyProgressIndicator());
        Intrinsics.checkNotNullExpressionValue((Object)diffRequest, (String)"process(...)");
        return diffRequest;
    }

    @RequiresEdt
    protected boolean hasNextChange(boolean fromUpdate) {
        return this.fileIndex < this.getDiffRequestChain().getRequests().size() - 1;
    }

    @RequiresEdt
    protected boolean hasPrevChange(boolean fromUpdate) {
        return this.fileIndex > 0;
    }

    @RequiresEdt
    protected void goToNextChange(boolean fromDifferences) {
        this.goToNextChangeImpl(fromDifferences, () -> TransformSessionViewer.goToNextChange$lambda$1(this));
    }

    @RequiresEdt
    protected void goToPrevChange(boolean fromDifferences) {
        this.goToPrevChangeImpl(fromDifferences, () -> TransformSessionViewer.goToPrevChange$lambda$2(this));
    }

    @RequiresEdt
    protected boolean isNavigationEnabled() {
        return this.getDiffRequestChain().getRequests().size() > 1;
    }

    @RequiresEdt
    private final void goToChange(int index) {
        block4: {
            block3: {
                if (index == this.fileIndex) break block3;
                if (0 <= index ? index < ((Collection)this.getDiffRequestChain().getRequests()).size() : false) break block4;
            }
            return;
        }
        this.fileIndex = index;
        this.updateRequest(true, DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE);
    }

    @NotNull
    protected AnAction createGoToChangeAction() {
        AnAction anAction = GoToChangePopupBuilder.create((DiffRequestChain)this.getDiffRequestChain(), arg_0 -> TransformSessionViewer.createGoToChangeAction$lambda$3((Function1)new Function1<Integer, Unit>((Object)this){

            public final void invoke(int p0) {
                TransformSessionViewer.access$goToChange((TransformSessionViewer)this.receiver, p0);
            }
        }, arg_0), (int)this.fileIndex);
        Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"create(...)");
        return anAction;
    }

    @RequiresEdt
    protected void onDispose() {
        this.session.updateListeners(TransformSession.UpdateListener.UpdateType.DIFF_CLOSED);
        ModelProvider.Companion.activeModelProvider().getTransformService().reportSession(this.session.buildReport());
    }

    private static final void goToNextChange$lambda$1(TransformSessionViewer this$0) {
        ++this$0.fileIndex;
    }

    private static final void goToPrevChange$lambda$2(TransformSessionViewer this$0) {
        --this$0.fileIndex;
    }

    private static final void createGoToChangeAction$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$goToChange(TransformSessionViewer $this, int index) {
        $this.goToChange(index);
    }
}

