/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.ui.compose.onboarding;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.ActiveOnboardingProvider;
import com.android.studio.ml.Authenticator;
import com.android.studio.ml.bot.ui.compose.onboarding.ComposeOnboardingController;
import com.android.studio.ml.bot.ui.compose.onboarding.StatefulOnboardingPage;
import com.android.studio.ml.bot.ui.onboarding.OnboardingProvider;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001:\u0001)B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u001c\u001a\u00020\u0010H\u0016J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u0010H\u0016J\b\u0010!\u001a\u00020\u0010H\u0016J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$H\u0002J\u0012\u0010%\u001a\u00020\u00102\b\u0010&\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010'\u001a\u00020\u0010H\u0016J\b\u0010(\u001a\u00020\u0010H\u0016R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006*"}, d2={"Lcom/android/studio/ml/bot/ui/compose/onboarding/ComposeOnboardingControllerImpl;", "Lcom/android/studio/ml/bot/ui/compose/onboarding/ComposeOnboardingController;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "onboardingProviderFlow", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/android/studio/ml/bot/ui/onboarding/OnboardingProvider;", "authenticator", "Lcom/android/studio/ml/Authenticator;", "defaultDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "edtDispatcher", "Lkotlin/coroutines/CoroutineContext;", "onResetListener", "Lkotlin/Function0;", "", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/flow/StateFlow;Lcom/android/studio/ml/Authenticator;Lkotlinx/coroutines/CoroutineDispatcher;Lkotlin/coroutines/CoroutineContext;Lkotlin/jvm/functions/Function0;)V", "_state", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/android/studio/ml/bot/ui/compose/onboarding/ComposeOnboardingControllerImpl$ComposeOnboardingState;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "state", "getState", "()Lkotlinx/coroutines/flow/StateFlow;", "dispose", "disposePage", "currentState", "Lcom/android/studio/ml/bot/ui/compose/onboarding/ComposeOnboardingControllerImpl$ComposeOnboardingState$Available;", "goBack", "goForward", "goToPage", "newPage", "", "onNewOnboardingProvider", "provider", "resetComposePages", "resetToStart", "ComposeOnboardingState", "aiplugin.core.aicore"})
@VisibleForTesting
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nComposeOnboardingController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeOnboardingController.kt\ncom/android/studio/ml/bot/ui/compose/onboarding/ComposeOnboardingControllerImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,240:1\n25#2:241\n31#3,2:242\n226#4,5:244\n226#4,5:249\n*S KotlinDebug\n*F\n+ 1 ComposeOnboardingController.kt\ncom/android/studio/ml/bot/ui/compose/onboarding/ComposeOnboardingControllerImpl\n*L\n66#1:241\n79#1:242,2\n111#1:244,5\n172#1:249,5\n*E\n"})
public final class ComposeOnboardingControllerImpl
implements ComposeOnboardingController {
    @NotNull
    private final Project project;
    @NotNull
    private final StateFlow<OnboardingProvider> onboardingProviderFlow;
    @NotNull
    private final Authenticator authenticator;
    @NotNull
    private final CoroutineContext edtDispatcher;
    @VisibleForTesting
    @NotNull
    private final Function0<Unit> onResetListener;
    @NotNull
    private final Logger logger;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final MutableStateFlow<ComposeOnboardingState> _state;
    @NotNull
    private final StateFlow<ComposeOnboardingState> state;
    public static final int $stable = 8;

    public ComposeOnboardingControllerImpl(@NotNull Project project2, @NotNull StateFlow<? extends OnboardingProvider> onboardingProviderFlow, @NotNull Authenticator authenticator, @NotNull CoroutineDispatcher defaultDispatcher, @NotNull CoroutineContext edtDispatcher, @NotNull Function0<Unit> onResetListener) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(onboardingProviderFlow, (String)"onboardingProviderFlow");
        Intrinsics.checkNotNullParameter((Object)authenticator, (String)"authenticator");
        Intrinsics.checkNotNullParameter((Object)defaultDispatcher, (String)"defaultDispatcher");
        Intrinsics.checkNotNullParameter((Object)edtDispatcher, (String)"edtDispatcher");
        Intrinsics.checkNotNullParameter(onResetListener, (String)"onResetListener");
        this.project = project2;
        this.onboardingProviderFlow = onboardingProviderFlow;
        this.authenticator = authenticator;
        this.edtDispatcher = edtDispatcher;
        this.onResetListener = onResetListener;
        ComposeOnboardingControllerImpl $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(ComposeOnboardingControllerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        CoroutineContext coroutineContext = defaultDispatcher.plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null));
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)coroutineContext.plus((CoroutineContext)new CoroutineName(string)));
        this._state = StateFlowKt.MutableStateFlow((Object)ComposeOnboardingState.Unavailable.INSTANCE);
        this.state = (StateFlow)this._state;
        FlowKt.launchIn((Flow)FlowKt.flowOn((Flow)FlowKt.onEach((Flow)((Flow)this.onboardingProviderFlow), (Function2)((Function2)new Function2<OnboardingProvider, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ ComposeOnboardingControllerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        OnboardingProvider provider = (OnboardingProvider)this.L$0;
                        this.this$0.onNewOnboardingProvider(provider);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(OnboardingProvider p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineContext)((CoroutineContext)defaultDispatcher)), (CoroutineScope)this.scope);
        FlowKt.launchIn((Flow)FlowKt.flowOn((Flow)FlowKt.onEach((Flow)((Flow)this.authenticator.getAuthenticationState()), (Function2)((Function2)new Function2<Authenticator.AuthState, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ ComposeOnboardingControllerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Authenticator.AuthState authState = (Authenticator.AuthState)this.L$0;
                        if (!(authState instanceof Authenticator.AuthState.Authorized)) {
                            this.this$0.logger.info("Auth state (" + authState + ") changes require onboarding restart");
                            this.this$0.resetToStart();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Authenticator.AuthState p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineContext)((CoroutineContext)defaultDispatcher)), (CoroutineScope)this.scope);
    }

    public /* synthetic */ ComposeOnboardingControllerImpl(Project project2, StateFlow stateFlow, Authenticator authenticator, CoroutineDispatcher coroutineDispatcher, CoroutineContext coroutineContext, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            function0 = 1.INSTANCE;
        }
        this(project2, (StateFlow<? extends OnboardingProvider>)stateFlow, authenticator, coroutineDispatcher, coroutineContext, (Function0<Unit>)function0);
    }

    @Override
    @NotNull
    public StateFlow<ComposeOnboardingState> getState() {
        return this.state;
    }

    public ComposeOnboardingControllerImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<ActiveOnboardingProvider> serviceClass$iv = ActiveOnboardingProvider.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this(project2, ((ActiveOnboardingProvider)object).getOnboardingProvider(), Authenticator.Companion.current(), Dispatchers.getDefault(), CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, 32, null);
    }

    private final void onNewOnboardingProvider(OnboardingProvider provider) {
        List list;
        if (provider == null) {
            this.logger.debug("Onboarding provider no longer available");
            return;
        }
        this.logger.debug("Onboarding provider has changed: " + provider);
        int newPageCount = provider.getPageCount();
        if (newPageCount == 0) {
            ComposeOnboardingState nextValue$iv;
            Object prevValue$iv;
            MutableStateFlow<ComposeOnboardingState> $this$update$iv = this._state;
            boolean $i$f$update = false;
            do {
                prevValue$iv = $this$update$iv.getValue();
                ComposeOnboardingState it = (ComposeOnboardingState)prevValue$iv;
                boolean bl = false;
            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (ComposeOnboardingState)ComposeOnboardingState.Unavailable.INSTANCE)));
            return;
        }
        List $this$onNewOnboardingProvider_u24lambda_u241 = list = CollectionsKt.createListBuilder((int)newPageCount);
        boolean bl = false;
        for (int i2 = 0; i2 < newPageCount; ++i2) {
            $this$onNewOnboardingProvider_u24lambda_u241.add(provider.createPage(i2, this.project));
        }
        List newPages = CollectionsKt.build((List)list);
        BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)this.edtDispatcher, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, newPageCount, (List<? extends OnboardingProvider.OnboardingPage>)newPages, null){
            int label;
            final /* synthetic */ ComposeOnboardingControllerImpl this$0;
            final /* synthetic */ int $newPageCount;
            final /* synthetic */ List<OnboardingProvider.OnboardingPage> $newPages;
            {
                this.this$0 = $receiver;
                this.$newPageCount = $newPageCount;
                this.$newPages = $newPages;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        ComposeOnboardingControllerImpl.access$getLogger$p(this.this$0).info("New onboarding has " + this.$newPageCount + " page(s):\n" + this.$newPages);
                        this.label = 1;
                        v0 = ComposeOnboardingControllerImpl.access$get_state$p(this.this$0).emit((Object)new ComposeOnboardingState.Available(this.$newPageCount, this.$newPages, 0), (Continuation)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        this.this$0.resetToStart();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @Override
    public void goForward() {
        ComposeOnboardingState currentState2 = (ComposeOnboardingState)this.getState().getValue();
        if (!(currentState2 instanceof ComposeOnboardingState.Available)) {
            this.logger.warn("Asked to go forward but the onboarding is not available");
            return;
        }
        int currentPageIndex = ((ComposeOnboardingState.Available)currentState2).getCurrentPage();
        if (currentPageIndex == CollectionsKt.getLastIndex(((ComposeOnboardingState.Available)currentState2).getPages())) {
            this.logger.info("User moved past the last page, disposing current page and setting onboarding completed");
            this.disposePage((ComposeOnboardingState.Available)currentState2);
            Object object = (OnboardingProvider)this.onboardingProviderFlow.getValue();
            if (object != null && (object = object.getOnboardingState()) != null) {
                object.setUserHasCompletedOnboarding();
            }
        } else {
            int newPage = currentPageIndex + 1;
            this.logger.info("Going forward one page to " + newPage);
            this.goToPage(newPage);
        }
    }

    @Override
    public void goBack() {
        ComposeOnboardingState currentState2 = (ComposeOnboardingState)this.getState().getValue();
        if (!(currentState2 instanceof ComposeOnboardingState.Available)) {
            this.logger.warn("Asked to go back but the onboarding is not available");
            return;
        }
        int newPage = ((ComposeOnboardingState.Available)currentState2).getCurrentPage() - 1;
        this.logger.info("Going back one page to " + newPage);
        this.goToPage(newPage);
    }

    @Override
    public void resetToStart() {
        this.logger.info("Resetting onboarding to the first page");
        this.goToPage(0);
        this.onResetListener.invoke();
    }

    private final void goToPage(int newPage) {
        int index;
        ComposeOnboardingState currentState2;
        ComposeOnboardingState nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<ComposeOnboardingState> $this$update$iv = this._state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            currentState2 = (ComposeOnboardingState)prevValue$iv;
            boolean bl = false;
            if (!(currentState2 instanceof ComposeOnboardingState.Available)) {
                this.logger.warn("Trying to go to page " + newPage + ", but the onboarding is unavailable");
                return;
            }
            int pagesCount = ((ComposeOnboardingState.Available)currentState2).getPageCount();
            if (newPage < 0) {
                this.logger.warn("Trying to go to a negative onboarding page: " + newPage + ", forcing to 0");
                v0 = 0;
            } else if (newPage > CollectionsKt.getLastIndex(((ComposeOnboardingState.Available)currentState2).getPages())) {
                this.logger.warn("Trying to go past the last onboarding page: " + newPage + ", forcing to " + (pagesCount - 1));
                v0 = pagesCount - 1;
            } else {
                v0 = index = newPage;
            }
            if (index == ((ComposeOnboardingState.Available)currentState2).getCurrentPage()) continue;
            this.disposePage((ComposeOnboardingState.Available)currentState2);
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (ComposeOnboardingState)ComposeOnboardingState.Available.copy$default((ComposeOnboardingState.Available)currentState2, 0, null, index, 3, null))));
    }

    private final void disposePage(ComposeOnboardingState.Available currentState2) {
        if (currentState2.getPageCount() <= 0 || currentState2.getCurrentPage() > CollectionsKt.getLastIndex(currentState2.getPages())) {
            return;
        }
        currentState2.getPages().get(currentState2.getCurrentPage()).onNavigateAway();
    }

    @Override
    public void resetComposePages() {
        ComposeOnboardingState currentState2 = (ComposeOnboardingState)this.getState().getValue();
        if (!(currentState2 instanceof ComposeOnboardingState.Available)) {
            return;
        }
        if (((ComposeOnboardingState.Available)currentState2).getPageCount() <= 0 || ((ComposeOnboardingState.Available)currentState2).getCurrentPage() > CollectionsKt.getLastIndex(((ComposeOnboardingState.Available)currentState2).getPages())) {
            return;
        }
        this.logger.info("Resetting Compose pages state (if any)");
        for (OnboardingProvider.OnboardingPage page : ((ComposeOnboardingState.Available)currentState2).getPages()) {
            if (!(page instanceof StatefulOnboardingPage)) continue;
            this.logger.info("Resetting state for page " + page.getClass().getSimpleName() + "...");
            ((StatefulOnboardingPage)((Object)page)).reset();
        }
    }

    public void dispose() {
        CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, (String)"Disposing", null, (int)2, null);
    }

    public static final /* synthetic */ MutableStateFlow access$get_state$p(ComposeOnboardingControllerImpl $this) {
        return $this._state;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/android/studio/ml/bot/ui/compose/onboarding/ComposeOnboardingControllerImpl$ComposeOnboardingState;", "", "Available", "Unavailable", "Lcom/android/studio/ml/bot/ui/compose/onboarding/ComposeOnboardingControllerImpl$ComposeOnboardingState$Available;", "Lcom/android/studio/ml/bot/ui/compose/onboarding/ComposeOnboardingControllerImpl$ComposeOnboardingState$Unavailable;", "aiplugin.core.aicore"})
    public static interface ComposeOnboardingState {

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J-\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/android/studio/ml/bot/ui/compose/onboarding/ComposeOnboardingControllerImpl$ComposeOnboardingState$Available;", "Lcom/android/studio/ml/bot/ui/compose/onboarding/ComposeOnboardingControllerImpl$ComposeOnboardingState;", "pageCount", "", "pages", "", "Lcom/android/studio/ml/bot/ui/onboarding/OnboardingProvider$OnboardingPage;", "currentPage", "(ILjava/util/List;I)V", "getCurrentPage", "()I", "getPageCount", "getPages", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "", "aiplugin.core.aicore"})
        @StabilityInferred(parameters=0)
        public static final class Available
        implements ComposeOnboardingState {
            private final int pageCount;
            @NotNull
            private final List<OnboardingProvider.OnboardingPage> pages;
            private final int currentPage;
            public static final int $stable = 8;

            public Available(int pageCount, @NotNull List<? extends OnboardingProvider.OnboardingPage> pages, int currentPage) {
                Intrinsics.checkNotNullParameter(pages, (String)"pages");
                this.pageCount = pageCount;
                this.pages = pages;
                this.currentPage = currentPage;
            }

            public final int getPageCount() {
                return this.pageCount;
            }

            @NotNull
            public final List<OnboardingProvider.OnboardingPage> getPages() {
                return this.pages;
            }

            public final int getCurrentPage() {
                return this.currentPage;
            }

            public final int component1() {
                return this.pageCount;
            }

            @NotNull
            public final List<OnboardingProvider.OnboardingPage> component2() {
                return this.pages;
            }

            public final int component3() {
                return this.currentPage;
            }

            @NotNull
            public final Available copy(int pageCount, @NotNull List<? extends OnboardingProvider.OnboardingPage> pages, int currentPage) {
                Intrinsics.checkNotNullParameter(pages, (String)"pages");
                return new Available(pageCount, pages, currentPage);
            }

            public static /* synthetic */ Available copy$default(Available available, int n, List list, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = available.pageCount;
                }
                if ((n3 & 2) != 0) {
                    list = available.pages;
                }
                if ((n3 & 4) != 0) {
                    n2 = available.currentPage;
                }
                return available.copy(n, list, n2);
            }

            @NotNull
            public String toString() {
                return "Available(pageCount=" + this.pageCount + ", pages=" + this.pages + ", currentPage=" + this.currentPage + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.pageCount);
                result2 = result2 * 31 + ((Object)this.pages).hashCode();
                result2 = result2 * 31 + Integer.hashCode(this.currentPage);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Available)) {
                    return false;
                }
                Available available = (Available)other;
                if (this.pageCount != available.pageCount) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.pages, available.pages)) {
                    return false;
                }
                return this.currentPage == available.currentPage;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/android/studio/ml/bot/ui/compose/onboarding/ComposeOnboardingControllerImpl$ComposeOnboardingState$Unavailable;", "Lcom/android/studio/ml/bot/ui/compose/onboarding/ComposeOnboardingControllerImpl$ComposeOnboardingState;", "()V", "aiplugin.core.aicore"})
        @StabilityInferred(parameters=1)
        public static final class Unavailable
        implements ComposeOnboardingState {
            @NotNull
            public static final Unavailable INSTANCE = new Unavailable();
            public static final int $stable;

            private Unavailable() {
            }
        }
    }
}

