/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.designer.compose.preview;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.flags.Flag;
import com.android.flags.FlagsUtilKt;
import com.android.studio.ml.ActiveModelProvider;
import com.android.studio.ml.ModelProvider;
import com.android.studio.ml.TransformService;
import com.android.studio.ml.designer.compose.preview.agents.actions.AlignUiToTargetImageAction;
import com.android.studio.ml.designer.compose.preview.agents.actions.ComposePreviewAgentsDropdownAction;
import com.android.studio.ml.designer.compose.preview.agents.actions.FixRenderIssuesAction;
import com.android.studio.ml.designer.compose.preview.agents.actions.FixVisualLintIssuesAction;
import com.android.studio.ml.designer.compose.preview.agents.actions.TransformPreviewAction;
import com.android.studio.ml.designer.compose.preview.transform.GenerateComposePreviewsForFileAction;
import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.compose.preview.ComposeStudioBotActionFactory;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.openapi.actionSystem.AnAction;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u0016J\u0018\u0010\b\u001a\u0004\u0018\u00010\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/android/studio/ml/designer/compose/preview/GeminiStudioBotActionFactory;", "Lcom/android/tools/idea/compose/preview/ComposeStudioBotActionFactory;", "<init>", "()V", "createPreviewGenerator", "Lcom/intellij/openapi/actionSystem/AnAction;", "transformPreviewAction", "fixVisualLintIssuesAction", "fixComposeRenderIssueAction", "issues", "", "Lcom/android/tools/idea/common/error/Issue;", "alignUiToTargetImageAction", "previewAgentsDropDownAction", "isFeatureSupported", "", "feature", "Lcom/android/studio/ml/TransformService$Feature;", "aiplugin.android"})
@StabilityInferred(parameters=1)
public final class GeminiStudioBotActionFactory
implements ComposeStudioBotActionFactory {
    public static final int $stable;

    @Nullable
    public AnAction createPreviewGenerator() {
        if (((Boolean)StudioFlags.COMPOSE_PREVIEW_GENERATE_PREVIEW_AGENTIC.get()).booleanValue()) {
            return new com.android.studio.ml.designer.compose.preview.agents.actions.GenerateComposePreviewsForFileAction();
        }
        if (this.isFeatureSupported(TransformService.Feature.GENERATE_COMPOSE_PREVIEW)) {
            return new GenerateComposePreviewsForFileAction();
        }
        return null;
    }

    @Nullable
    public AnAction transformPreviewAction() {
        if (((Boolean)StudioFlags.COMPOSE_PREVIEW_TRANSFORM_UI_WITH_AI_AGENTIC.get()).booleanValue()) {
            return new TransformPreviewAction();
        }
        if (this.isFeatureSupported(TransformService.Feature.MULTIMODAL_PREVIEW_TRANSFORM)) {
            return new com.android.studio.ml.designer.compose.preview.transform.TransformPreviewAction(null, 1, null);
        }
        return null;
    }

    @Nullable
    public AnAction fixVisualLintIssuesAction() {
        Flag flag = StudioFlags.COMPOSE_UI_CHECK_FIX_WITH_AI;
        Intrinsics.checkNotNullExpressionValue((Object)flag, (String)"COMPOSE_UI_CHECK_FIX_WITH_AI");
        return (AnAction)FlagsUtilKt.ifEnabled((Flag)flag, GeminiStudioBotActionFactory::fixVisualLintIssuesAction$lambda$0);
    }

    @Nullable
    public AnAction fixComposeRenderIssueAction(@NotNull List<? extends Issue> issues) {
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        Flag flag = StudioFlags.COMPOSE_RENDER_ERROR_FIX_WITH_AI;
        Intrinsics.checkNotNullExpressionValue((Object)flag, (String)"COMPOSE_RENDER_ERROR_FIX_WITH_AI");
        return (AnAction)FlagsUtilKt.ifEnabled((Flag)flag, () -> GeminiStudioBotActionFactory.fixComposeRenderIssueAction$lambda$1(issues));
    }

    @NotNull
    public AnAction alignUiToTargetImageAction() {
        return new AlignUiToTargetImageAction(null, 1, null);
    }

    @NotNull
    public AnAction previewAgentsDropDownAction() {
        return (AnAction)new ComposePreviewAgentsDropdownAction();
    }

    private final boolean isFeatureSupported(TransformService.Feature feature) {
        TransformService transformService;
        ModelProvider modelProvider = (ModelProvider)ActiveModelProvider.Companion.getInstance().getModelProvider().getValue();
        return modelProvider != null && (transformService = modelProvider.getTransformService()) != null ? transformService.supportsFeature(feature) : false;
    }

    private static final FixVisualLintIssuesAction fixVisualLintIssuesAction$lambda$0() {
        return new FixVisualLintIssuesAction();
    }

    private static final FixRenderIssuesAction fixComposeRenderIssueAction$lambda$1(List $issues) {
        return new FixRenderIssuesAction($issues);
    }
}

