/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.designer.compose.preview.agents.actions;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.StudioGeminiBundle;
import com.android.studio.ml.bot.BotToolWindowService;
import com.android.studio.ml.bot.ResponseMode;
import com.android.studio.ml.designer.compose.preview.BaseComposePreviewAction;
import com.android.studio.ml.designer.compose.preview.ComposePreviewActionContext;
import com.android.studio.ml.designer.compose.preview.UtilsKt;
import com.android.studio.ml.designer.compose.preview.agents.AlignUiToTargetImageAgent;
import com.android.studio.ml.designer.compose.preview.utils.ShowErrorNotificationKt;
import com.android.studio.ml.util.Blob;
import com.android.tools.idea.studiobot.AiExcludeService;
import com.android.tools.idea.studiobot.StudioBot;
import com.google.aiplugin.agents.ToolsProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import icons.SmlIcons;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0004H\u0002R\u001c\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/studio/ml/designer/compose/preview/agents/actions/AlignUiToTargetImageAction;", "Lcom/android/studio/ml/designer/compose/preview/BaseComposePreviewAction;", "pickImage", "Lkotlin/Function1;", "Lcom/intellij/openapi/project/Project;", "Lcom/android/studio/ml/util/Blob;", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "performAiAction", "runAlignUiToTargetImageAgent", "renderedImage", "sourceCode", "Lcom/intellij/openapi/vfs/VirtualFile;", "targetImage", "project", "aiplugin.android"})
@StabilityInferred(parameters=0)
public final class AlignUiToTargetImageAction
extends BaseComposePreviewAction {
    @NotNull
    private final Function1<Project, Blob> pickImage;
    @NotNull
    private final Logger logger;
    public static final int $stable = 8;

    public AlignUiToTargetImageAction(@NotNull Function1<? super Project, Blob> pickImage) {
        Intrinsics.checkNotNullParameter(pickImage, (String)"pickImage");
        super(StudioGeminiBundle.Companion.message("designer.action.align.ui.to.image", new Object[0]), null, SmlIcons.Logo);
        this.pickImage = pickImage;
        Logger logger = Logger.getInstance(AlignUiToTargetImageAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    public /* synthetic */ AlignUiToTargetImageAction(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = 1.INSTANCE;
        }
        this((Function1<? super Project, Blob>)function1);
    }

    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        if (!e.getPresentation().isEnabledAndVisible()) {
            return;
        }
        Project project2 = e.getProject();
        e.getPresentation().setEnabled(project2 != null && StudioBot.Companion.getInstance().chat(project2).isReadyToReceiveQuery(ResponseMode.Agent));
    }

    @Override
    public void performAiAction(@NotNull AnActionEvent e) {
        block3: {
            Blob targetImage;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project2 = e.getProject();
            if (project2 == null) {
                throw new IllegalStateException("Project is null.".toString());
            }
            Project project3 = project2;
            if (!this.checkIfPreviewAttachingAllowed(project3)) {
                this.logger.info("Preview attachment is not allowed");
                return;
            }
            Object object = this.getComposePreviewActionContext-IoAF18A(e);
            ResultKt.throwOnFailure((Object)object);
            ComposePreviewActionContext context2 = (ComposePreviewActionContext)object;
            VirtualFile sourceCode = context2.getFilePointer().getVirtualFile();
            AiExcludeService aiExcludeService2 = StudioBot.Companion.getInstance().aiExcludeService(project3);
            Intrinsics.checkNotNull((Object)sourceCode);
            if (aiExcludeService2.isFileExcluded(sourceCode)) {
                ShowErrorNotificationKt.showErrorNotification$default(StudioGeminiBundle.Companion.message("designer.action.align.ui.to.image.file.excluded.error", new Object[0]), project3, null, 4, null);
                return;
            }
            Blob blob = targetImage = (Blob)this.pickImage.invoke((Object)project3);
            if (blob == null) break block3;
            Blob it = blob;
            boolean bl = false;
            this.runAlignUiToTargetImageAgent(UtilsKt.toBlob(context2.getImage()), sourceCode, it, project3);
        }
    }

    private final void runAlignUiToTargetImageAgent(Blob renderedImage, VirtualFile sourceCode, Blob targetImage, Project project2) {
        AlignUiToTargetImageAgent agent2 = new AlignUiToTargetImageAgent(renderedImage, sourceCode, targetImage, ToolsProvider.Companion.getTools(project2));
        BotToolWindowService.Companion.getInstance(project2).runAgent(agent2, "Aligning UI to target image...", CollectionsKt.listOf((Object)targetImage));
    }

    public AlignUiToTargetImageAction() {
        this(null, 1, null);
    }
}

