/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.designer.compose.preview.agents.actions;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.StudioGeminiBundle;
import com.android.studio.ml.bot.BotToolWindowService;
import com.android.studio.ml.bot.ResponseMode;
import com.android.studio.ml.designer.compose.preview.BaseComposePreviewAction;
import com.android.studio.ml.designer.compose.preview.agents.FixRenderIssueAgent;
import com.android.studio.ml.designer.compose.preview.agents.actions.FixWithAIButton;
import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.studiobot.StudioBot;
import com.google.aiplugin.agents.ToolsProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import icons.SmlIcons;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/studio/ml/designer/compose/preview/agents/actions/FixRenderIssuesAction;", "Lcom/android/studio/ml/designer/compose/preview/BaseComposePreviewAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "issues", "", "Lcom/android/tools/idea/common/error/Issue;", "<init>", "(Ljava/util/List;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isVirtualFileRequired", "", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "performAiAction", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "updateCustomComponent", "component", "aiplugin.android"})
@StabilityInferred(parameters=0)
public final class FixRenderIssuesAction
extends BaseComposePreviewAction
implements CustomComponentAction {
    @NotNull
    private final List<Issue> issues;
    public static final int $stable = 8;

    public FixRenderIssuesAction(@NotNull List<? extends Issue> issues) {
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        super(StudioGeminiBundle.Companion.message("designer.action.fix.render.issues.agent.title", new Object[0]), null, SmlIcons.Logo);
        this.issues = issues;
    }

    public /* synthetic */ FixRenderIssuesAction(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(list);
    }

    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Override
    protected boolean isVirtualFileRequired() {
        return false;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        if (!e.getPresentation().isEnabledAndVisible()) {
            return;
        }
        Project project2 = e.getProject();
        e.getPresentation().setEnabled(project2 != null && StudioBot.Companion.getInstance().chat(project2).isReadyToReceiveQuery(ResponseMode.Agent));
    }

    @Override
    public void performAiAction(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        FixRenderIssueAgent agent2 = new FixRenderIssueAgent(project3, this.issues, ToolsProvider.Companion.getTools(project3));
        String summaryIssues = CollectionsKt.joinToString$default((Iterable)this.issues, (CharSequence)"\n", null, null, (int)0, null, FixRenderIssuesAction::performAiAction$lambda$0, (int)30, null);
        ApplicationManager.getApplication().invokeLater(() -> FixRenderIssuesAction.performAiAction$lambda$1(project3, agent2, summaryIssues));
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        FixWithAIButton fixWithAIButton;
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        FixWithAIButton button = fixWithAIButton = new FixWithAIButton(presentation, this);
        boolean bl = false;
        this.updateCustomComponent(button, presentation);
        return fixWithAIButton;
    }

    public void updateCustomComponent(@NotNull JComponent component2, @NotNull Presentation presentation) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        FixWithAIButton fixWithAIButton = component2 instanceof FixWithAIButton ? (FixWithAIButton)component2 : null;
        if (fixWithAIButton == null) {
            return;
        }
        FixWithAIButton button = fixWithAIButton;
        button.updateComponent(presentation);
    }

    private static final CharSequence performAiAction$lambda$0(Issue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\t- " + it.getSummary();
    }

    private static final void performAiAction$lambda$1(Project $project, FixRenderIssueAgent $agent, String $summaryIssues) {
        Object[] objectArray = new Object[]{$summaryIssues};
        BotToolWindowService.runAgentOnPinnedSession$default(BotToolWindowService.Companion.getInstance($project), $agent, StudioGeminiBundle.Companion.message("designer.action.fix.render.agent.text", objectArray), StudioGeminiBundle.Companion.message("designer.action.fix.render.issues.agent.title", new Object[0]), null, 8, null);
    }

    public FixRenderIssuesAction() {
        this(null, 1, null);
    }
}

