/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.devmode;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.FileContext;
import com.android.studio.ml.ModelProvider;
import com.android.studio.ml.ModifiedFile;
import com.android.studio.ml.SmlCodeCompletionRequest;
import com.android.studio.ml.SmlCodeCompletionResponse;
import com.android.studio.ml.SmlCodeCompletionSample;
import com.android.studio.ml.SmlMetadata;
import com.android.studio.ml.TransformRequest;
import com.android.studio.ml.TransformResult;
import com.android.studio.ml.devmode.DevModeCache;
import com.android.studio.ml.devmode.DevModeDataType;
import com.android.studio.ml.devmode.DevModeModelProvider;
import com.android.studio.ml.devmode.DevModePlayback;
import com.android.tools.idea.studiobot.Citation;
import com.android.tools.idea.studiobot.CitationAction;
import com.android.tools.idea.studiobot.Content;
import com.android.tools.idea.studiobot.prompts.FileWithSelection;
import com.android.tools.idea.studiobot.prompts.Prompt;
import com.google.aiplugin.agents.Tool;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010%\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\b\b\u0000\u0018\u0000 A2\u00020\u0001:\u0005@ABCDB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\fH\u0002J\u0006\u0010'\u001a\u00020$J\u0010\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020\u0006H\u0002J\u000e\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020\u0006J\u0006\u0010+\u001a\u00020$J\u0018\u0010,\u001a\u0004\u0018\u00010\f2\u0006\u0010(\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u000bJ\u0006\u0010-\u001a\u00020$J\u000e\u0010-\u001a\u00020.2\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010/\u001a\u00020.2\u0006\u0010\u0002\u001a\u00020\u0003J\u0018\u00100\u001a\u0004\u0018\u00010\f2\u000e\u00101\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005J\u000e\u00102\u001a\u00020.2\u0006\u0010\u0002\u001a\u00020\u0003JF\u00103\u001a\u00020\f2\u0006\u0010(\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u000b2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b042\u0006\u00105\u001a\u0002062\b\b\u0002\u00107\u001a\u00020\u000b2\b\b\u0002\u00108\u001a\u00020\u000bJ\u0010\u00109\u001a\u0004\u0018\u00010\f2\u0006\u0010%\u001a\u00020\u000bJ\"\u0010:\u001a\u00020$2\u0010\b\u0002\u00101\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\b\b\u0002\u0010+\u001a\u00020\u000eJ2\u0010;\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020\u00032\u0018\u0010<\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0=2\u0006\u0010>\u001a\u00020\u000eH\u0002J\u000e\u0010?\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020\u0003R \u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0010\"\u0004\b\u001d\u0010\u0012R\u001a\u0010\u001e\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0010\"\u0004\b \u0010\u0012R \u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/android/studio/ml/devmode/DevModeCache;", "", "file", "Ljava/io/File;", "autoSave", "", "Lcom/android/studio/ml/devmode/DevModeDataType;", "(Ljava/io/File;Ljava/util/Set;)V", "accessed", "", "Lkotlin/Pair;", "", "Lcom/android/studio/ml/devmode/DevModeCache$Entry;", "autoFlush", "", "getAutoFlush", "()Z", "setAutoFlush", "(Z)V", "getAutoSave", "()Ljava/util/Set;", "setAutoSave", "(Ljava/util/Set;)V", "data", "", "getFile", "()Ljava/io/File;", "logModelId", "getLogModelId", "setLogModelId", "logTime", "getLogTime", "setLogTime", "pendingSave", "pendingWrite", "accessedEntry", "", "key", "entry", "discardPendingSaves", "type", "discardPendingUnlessSaving", "dataType", "flush", "get", "load", "", "loadFrom", "peekPending", "types", "prune", "put", "", "delay", "", "model", "timeStamp", "remove", "savePending", "write", "entries", "", "appendOnly", "writeTo", "ChatCache", "Companion", "CompletionCache", "Entry", "TransformCache", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDevModeCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevModeCache.kt\ncom/android/studio/ml/devmode/DevModeCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,880:1\n1557#2:881\n1628#2,3:882\n1202#2,2:885\n1230#2,4:887\n2632#2,3:891\n295#2,2:894\n295#2,2:896\n1734#2,3:898\n1755#2,3:901\n2632#2,3:904\n*S KotlinDebug\n*F\n+ 1 DevModeCache.kt\ncom/android/studio/ml/devmode/DevModeCache\n*L\n85#1:881\n85#1:882,3\n130#1:885,2\n130#1:887,4\n203#1:891,3\n210#1:894,2\n230#1:896,2\n234#1:898,3\n270#1:901,3\n271#1:904,3\n*E\n"})
public final class DevModeCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File file;
    @NotNull
    private Set<? extends DevModeDataType> autoSave;
    private boolean logTime;
    private boolean logModelId;
    private boolean autoFlush;
    @NotNull
    private final Map<String, Entry> data;
    @NotNull
    private final List<Pair<String, Entry>> pendingSave;
    @NotNull
    private final List<Pair<String, Entry>> pendingWrite;
    @NotNull
    private final List<Pair<String, Entry>> accessed;
    public static final int $stable = 8;
    private static final int MAX_LENGTH = 400;
    @NotNull
    private static final String ATTR_KEY = "key";
    @NotNull
    private static final String ATTR_TYPE = "type";
    @NotNull
    private static final String ATTR_TEXT = "text";
    @NotNull
    private static final String ATTR_COUNT = "count";
    @NotNull
    private static final String ATTR_CONFIDENCE = "confidence";
    @NotNull
    private static final String ATTR_PATH = "path";
    @NotNull
    private static final String ATTR_NEXT = "next";
    @NotNull
    private static final String ATTR_MODEL_ID = "modelId";
    @NotNull
    private static final String ATTR_DELAY = "delay";
    @NotNull
    private static final String ATTR_TIMESTAMP = "timeStamp";
    @NotNull
    private static final String ATTR_VERIFIED = "verified";
    @NotNull
    private static final String ATTR_CITATIONS = "citations";
    @NotNull
    private static final String ATTR_NAME = "name";
    @NotNull
    private static final String ATTR_ARG_PREFIX = "arg_";
    @NotNull
    private static final String ATTR_RESPONSE = "response";
    @NotNull
    private static final String ATTR_TOOL = "tool";
    @Nullable
    private static DevModeCache storage;

    public DevModeCache(@NotNull File file, @NotNull Set<? extends DevModeDataType> autoSave) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(autoSave, (String)"autoSave");
        this.file = file;
        this.autoSave = autoSave;
        this.logTime = true;
        this.logModelId = true;
        this.autoFlush = true;
        this.data = new LinkedHashMap();
        this.pendingSave = new ArrayList();
        this.pendingWrite = new ArrayList();
        this.accessed = new ArrayList();
        this.load();
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final Set<DevModeDataType> getAutoSave() {
        return this.autoSave;
    }

    public final void setAutoSave(@NotNull Set<? extends DevModeDataType> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.autoSave = set;
    }

    public final boolean getLogTime() {
        return this.logTime;
    }

    public final void setLogTime(boolean bl) {
        this.logTime = bl;
    }

    public final boolean getLogModelId() {
        return this.logModelId;
    }

    public final void setLogModelId(boolean bl) {
        this.logModelId = bl;
    }

    public final boolean getAutoFlush() {
        return this.autoFlush;
    }

    public final void setAutoFlush(boolean bl) {
        this.autoFlush = bl;
    }

    public final void load() {
        this.loadFrom(this.file);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeTo(@NotNull File file) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Iterable iterable = this.data.entrySet();
        File file2 = file;
        DevModeCache devModeCache = this;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void entry;
            Map.Entry entry2 = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair(entry.getKey(), entry.getValue()));
        }
        collection = (List)destination$iv$iv;
        devModeCache.write(file2, CollectionsKt.toList((Iterable)collection), false);
    }

    private final void write(File file, List<Pair<String, Entry>> entries, boolean appendOnly) {
        StringBuilder sb = new StringBuilder();
        for (Pair<String, Entry> pair : entries) {
            String key = (String)pair.component1();
            Entry entry = (Entry)pair.component2();
            Map map2 = new LinkedHashMap();
            map2.put(ATTR_TYPE, entry.getType().getName());
            map2.put(ATTR_KEY, key);
            map2.putAll(entry.getMap());
            map2.put(ATTR_DELAY, String.valueOf(entry.getDelay()));
            if (this.logTime) {
                map2.put(ATTR_TIMESTAMP, entry.getTimeStamp());
            }
            if (this.logModelId) {
                map2.put(ATTR_MODEL_ID, entry.getModelId());
            }
            sb.append(new Gson().toJson((Object)map2)).append('\n');
        }
        if (!file.isFile()) {
            File file2 = file.getParentFile();
            if (file2 != null) {
                file2.mkdirs();
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String json = string;
        if (appendOnly) {
            FilesKt.appendText$default((File)file, (String)json, null, (int)2, null);
        } else {
            FilesKt.writeText$default((File)file, (String)json, null, (int)2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int loadFrom(@NotNull File file) {
        block22: {
            Charset $this$associateByTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.data.clear();
            this.pendingSave.clear();
            this.pendingWrite.clear();
            if (!file.exists() || file.length() <= 0L) break block22;
            Iterable $this$associateBy$iv = (Iterable)DevModeDataType.getEntries();
            boolean $i$f$associateBy = false;
            int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv22 = new LinkedHashMap(capacity$iv22);
            boolean $i$f$associateByTo22 = false;
            Iterator iterator = $this$associateByTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object element$iv$iv = iterator.next();
                DevModeDataType devModeDataType = (DevModeDataType)((Object)element$iv$iv);
                Map map2 = destination$iv$iv22;
                boolean bl = false;
                map2.put(it.getName(), element$iv$iv);
            }
            Map typeMap = destination$iv$iv22;
            Gson gson = new Gson();
            File capacity$iv22 = file;
            $this$associateByTo$iv$iv = Charsets.UTF_8;
            int destination$iv$iv22 = 8192;
            Object $i$f$associateByTo22 = capacity$iv22;
            JsonReader reader = new JsonReader((Reader)(($i$f$associateByTo22 = (Reader)new InputStreamReader((InputStream)new FileInputStream((File)$i$f$associateByTo22), $this$associateByTo$iv$iv)) instanceof BufferedReader ? (BufferedReader)$i$f$associateByTo22 : new BufferedReader((Reader)$i$f$associateByTo22, destination$iv$iv22)));
            reader.setLenient(true);
            while (reader.hasNext()) {
                Map m = (Map)gson.fromJson(reader, (Type)((Object)Map.class));
                String key = "";
                DevModeDataType type2 = DevModeDataType.CHAT;
                long delay = 0L;
                String timeStamp = "";
                String modelId = "";
                Map map3 = new LinkedHashMap();
                Intrinsics.checkNotNull((Object)m);
                block16: for (Map.Entry entry : m.entrySet()) {
                    String k = (String)entry.getKey();
                    String v = (String)entry.getValue();
                    switch (k) {
                        case "type": {
                            if ((DevModeDataType)((Object)typeMap.get(v)) != null) continue block16;
                            throw new IllegalStateException(("Unknown data type " + type2).toString());
                        }
                        case "key": {
                            key = v;
                            continue block16;
                        }
                        case "delay": {
                            delay = Long.parseLong(v);
                            continue block16;
                        }
                        case "timeStamp": {
                            timeStamp = v;
                            continue block16;
                        }
                        case "modelId": {
                            modelId = v;
                            continue block16;
                        }
                    }
                    map3.put(k, v);
                }
                this.data.put(key, new Entry(type2, map3, delay, timeStamp, modelId));
            }
            return this.data.size();
        }
        return 0;
    }

    public final int prune(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.write(file, this.accessed, false);
        return this.accessed.size();
    }

    @NotNull
    public final Entry put(@NotNull DevModeDataType type2, @NotNull String key, @NotNull Map<String, String> data2, long delay, @NotNull String model2, @NotNull String timeStamp) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)ATTR_TYPE);
        Intrinsics.checkNotNullParameter((Object)key, (String)ATTR_KEY);
        Intrinsics.checkNotNullParameter(data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)timeStamp, (String)ATTR_TIMESTAMP);
        Entry entry = new Entry(type2, data2, delay, timeStamp, model2);
        this.pendingSave.add((Pair<String, Entry>)new Pair((Object)key, (Object)entry));
        if (this.autoSave.contains((Object)type2)) {
            DevModeCache.savePending$default(this, SetsKt.setOf((Object)((Object)type2)), false, 2, null);
        }
        return entry;
    }

    public static /* synthetic */ Entry put$default(DevModeCache devModeCache, DevModeDataType devModeDataType, String string, Map map2, long l2, String string2, String string3, int n, Object object) {
        if ((n & 0x10) != 0) {
            String string4 = string2 = devModeCache.logModelId ? Companion.getCurrentModelId() : "";
        }
        if ((n & 0x20) != 0) {
            string3 = devModeCache.logTime ? Companion.getCurrentTimestamp() : "";
        }
        return devModeCache.put(devModeDataType, string, map2, l2, string2, string3);
    }

    @Nullable
    public final Entry get(@NotNull DevModeDataType type2, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)ATTR_TYPE);
        Intrinsics.checkNotNullParameter((Object)key, (String)ATTR_KEY);
        Entry entry = this.data.get(key);
        if (entry == null) {
            return null;
        }
        Entry entry2 = entry;
        if (entry2.getType() != type2) {
            return null;
        }
        this.accessedEntry(key, entry2);
        return entry2;
    }

    private final void accessedEntry(String key, Entry entry) {
        boolean bl;
        block4: {
            Iterable $this$none$iv = this.accessed;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getFirst(), (Object)key)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            this.accessed.add((Pair<String, Entry>)TuplesKt.to((Object)key, (Object)entry));
        }
    }

    @Nullable
    public final Entry remove(@NotNull String key) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)key, (String)ATTR_KEY);
            Iterable $this$firstOrNull$iv = this.pendingSave;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getFirst(), (Object)key)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Pair pending = v0;
        if (pending != null) {
            this.pendingSave.remove(pending);
            return (Entry)pending.getSecond();
        }
        return this.data.remove(key);
    }

    public final void flush() {
        if (this.pendingWrite.isEmpty()) {
            return;
        }
        this.write(this.file, this.pendingWrite, true);
        this.pendingWrite.clear();
    }

    @Nullable
    public final Entry peekPending(@Nullable Set<? extends DevModeDataType> types) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.pendingSave;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                Collection collection = types;
                if (!(collection == null || collection.isEmpty() || types.contains((Object)((Entry)it.getSecond()).getType()))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Pair pair = v0;
        return pair != null ? (Entry)pair.getSecond() : null;
    }

    /*
     * Unable to fully structure code
     */
    public final void savePending(@Nullable Set<? extends DevModeDataType> types, boolean flush) {
        block8: {
            var4_3 = types;
            if (var4_3 == null || var4_3.isEmpty() != false) ** GOTO lbl-1000
            $this$all$iv = this.pendingSave;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v0 = true;
            } else {
                for (T element$iv : $this$all$iv) {
                    it = (Pair)element$iv;
                    $i$a$-all-DevModeCache$savePending$allMatch$1 = false;
                    if (types.contains((Object)((Entry)it.getSecond()).getType())) continue;
                    v0 = false;
                    break block8;
                }
                v0 = true;
            }
        }
        if (v0) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        allMatch = v1;
        listIterator = this.pendingSave.listIterator();
        while (listIterator.hasNext()) {
            pair = listIterator.next();
            key = (String)pair.component1();
            entry = (Entry)pair.component2();
            var8_8 = types;
            if (!(var8_8 == null || var8_8.isEmpty() != false) && !types.contains((Object)entry.getType())) continue;
            this.data.put(key, entry);
            this.pendingWrite.add(pair);
            if (allMatch) continue;
            listIterator.remove();
        }
        if (allMatch) {
            this.pendingSave.clear();
        }
        if (this.autoFlush || flush) {
            this.flush();
        }
    }

    public static /* synthetic */ void savePending$default(DevModeCache devModeCache, Set set, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            set = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        devModeCache.savePending(set, bl);
    }

    public final void discardPendingUnlessSaving(@NotNull DevModeDataType dataType) {
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        if (!this.autoSave.contains((Object)dataType)) {
            this.discardPendingSaves(dataType);
        }
    }

    public final void discardPendingSaves() {
        this.pendingSave.clear();
    }

    private final void discardPendingSaves(DevModeDataType type2) {
        Pair it;
        boolean bl;
        block9: {
            Iterable $this$any$iv = this.pendingSave;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (Pair)element$iv;
                    boolean bl2 = false;
                    if (!(((Entry)it.getSecond()).getType() == type2)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            boolean bl3;
            block10: {
                Iterable $this$none$iv = this.pendingSave;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        it = (Pair)element$iv;
                        boolean bl4 = false;
                        if (!(((Entry)it.getSecond()).getType() != type2)) continue;
                        bl3 = false;
                        break block10;
                    }
                    bl3 = true;
                }
            }
            if (bl3) {
                this.pendingSave.clear();
            } else {
                this.pendingSave.removeIf(arg_0 -> DevModeCache.discardPendingSaves$lambda$8((Function1)new Function1<Pair<? extends String, ? extends Entry>, Boolean>(type2){
                    final /* synthetic */ DevModeDataType $type;
                    {
                        this.$type = $type;
                        super(1);
                    }

                    public final Boolean invoke(Pair<String, Entry> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return ((Entry)it.getSecond()).getType() == this.$type;
                    }
                }, arg_0));
            }
        }
    }

    public final int load(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.loadFrom(file);
    }

    private static final boolean discardPendingSaves$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\"\u0010\u000e\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u000bJ\u0006\u0010\u0018\u001a\u00020\u000bJ\u001e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016J.\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016J\u001e\u0010!\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016J(\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010&\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rJ.\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00120(2\u0006\u0010)\u001a\u00020*2\u0018\u0010+\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000fJ\u0010\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020\bH\u0002J\f\u0010.\u001a\u00020\b*\u00020/H\u0002J\f\u0010.\u001a\u00020\b*\u000200H\u0002J\f\u0010.\u001a\u00020\b*\u000201H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00062"}, d2={"Lcom/android/studio/ml/devmode/DevModeCache$ChatCache;", "", "storage", "Lcom/android/studio/ml/devmode/DevModeCache;", "(Lcom/android/studio/ml/devmode/DevModeCache;)V", "getStorage", "()Lcom/android/studio/ml/devmode/DevModeCache;", "computeKeyString", "", "s", "deleteConversation", "", "prompt", "Lcom/android/tools/idea/studiobot/prompts/Prompt;", "get", "", "Lkotlin/Pair;", "", "Lcom/android/tools/idea/studiobot/Content;", "getPromptQuestion", "newKey", "prev", "Lcom/android/studio/ml/devmode/DevModeCache$Entry;", "onConversationFinished", "onNewConversation", "putAnswer", "content", "Lcom/android/tools/idea/studiobot/Content$TextContent;", "delay", "chunk", "verified", "", "citations", "putContent", "putFunctionCall", "call", "Lcom/android/tools/idea/studiobot/Content$FunctionCall;", "response", "putQuestion", "replay", "Lkotlinx/coroutines/flow/Flow;", "behavior", "Lcom/android/studio/ml/devmode/DevModePlayback;", "conversation", "stabilizeKey", "substring", "toKey", "Lcom/android/tools/idea/studiobot/prompts/Prompt$FunctionCallMessage;", "Lcom/android/tools/idea/studiobot/prompts/Prompt$FunctionResponseMessage;", "Lcom/android/tools/idea/studiobot/prompts/Prompt$Message;", "aiplugin.core.aicore"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nDevModeCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevModeCache.kt\ncom/android/studio/ml/devmode/DevModeCache$ChatCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,880:1\n827#2:881\n855#2,2:882\n543#2,6:884\n1557#2:890\n1628#2,3:891\n808#2,11:895\n25#3:894\n*S KotlinDebug\n*F\n+ 1 DevModeCache.kt\ncom/android/studio/ml/devmode/DevModeCache$ChatCache\n*L\n630#1:881\n630#1:882,2\n670#1:884,6\n700#1:890\n700#1:891,3\n808#1:895,11\n789#1:894\n*E\n"})
    public static final class ChatCache {
        @NotNull
        private final DevModeCache storage;
        public static final int $stable = 8;

        public ChatCache(@NotNull DevModeCache storage) {
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            this.storage = storage;
        }

        @NotNull
        public final DevModeCache getStorage() {
            return this.storage;
        }

        private final String computeKeyString(String s) {
            String s2 = this.stabilizeKey(s);
            StringBuilder sb = new StringBuilder(400);
            int it = StringsKt.indexOf$default((CharSequence)s2, (String)"\n\nContents of ", (int)0, (boolean)false, (int)6, null);
            boolean bl = false;
            int context2 = it == -1 ? StringsKt.indexOf$default((CharSequence)s2, (String)"\n\n----- File: ", (int)0, (boolean)false, (int)6, null) : it;
            boolean includeChecksum = context2 == -1;
            int length = 0;
            int n = ((CharSequence)s2).length();
            for (int i2 = 0; i2 < n; ++i2) {
                char c = s2.charAt(i2);
                if (!CharsKt.isWhitespace((char)c)) {
                    String string = String.valueOf(c);
                    Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type java.lang.String");
                    String string2 = string.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    sb.append(string2);
                    if (++length == 400) {
                        if (!includeChecksum) break;
                        MessageDigest md = MessageDigest.getInstance("MD5");
                        String string3 = s2.substring(i2);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        String string4 = string3;
                        byte[] byArray = string4.getBytes(Charsets.UTF_8);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                        byte[] digested = md.digest(byArray);
                        StringBuilder stringBuilder = sb.append("_");
                        Intrinsics.checkNotNull((Object)digested);
                        stringBuilder.append(ArraysKt.joinToString$default((byte[])digested, (CharSequence)"", null, null, (int)0, null, (Function1)computeKeyString.1.INSTANCE, (int)30, null));
                        break;
                    }
                }
                if (i2 != context2) continue;
                sb.append("@project");
                break;
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final String stabilizeKey(String substring) {
            void $this$filterNotTo$iv$iv;
            String home = System.getProperty("user.home");
            Iterable $this$filterNot$iv = StringsKt.lines((CharSequence)substring);
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (StringsKt.startsWith$default((String)it, (String)"BUILD FAILED in ", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"BUILD SUCCESSFUL in ", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"CONFIGURE FAILED in ", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"Gradle Daemon started in ", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)it, (CharSequence)" actionable tasks: ", (boolean)false, (int)2, null) && Character.isDigit(it.charAt(0)) || StringsKt.contains$default((CharSequence)it, (CharSequence)": Executing ':", (boolean)false, (int)2, null) && Character.isDigit(it.charAt(0))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(home){
                final /* synthetic */ String $home;
                {
                    this.$home = $home;
                    super(1);
                }

                public final CharSequence invoke(String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String string = this.$home;
                    Intrinsics.checkNotNull((Object)string);
                    return StringsKt.replace$default((String)it, (String)string, (String)"$USER_HOME", (boolean)false, (int)4, null);
                }
            }), (int)30, null);
        }

        private final String toKey(Prompt.FunctionResponseMessage $this$toKey) {
            return $this$toKey.getName() + ": " + $this$toKey.getResponse();
        }

        private final String toKey(Prompt.FunctionCallMessage $this$toKey) {
            return $this$toKey.getName() + "(" + CollectionsKt.joinToString$default((Iterable)$this$toKey.getArgs().entrySet(), (CharSequence)",", null, null, (int)0, null, (Function1)toKey.1.INSTANCE, (int)30, null) + ")";
        }

        private final String toKey(Prompt.Message $this$toKey) {
            return CollectionsKt.joinToString$default((Iterable)$this$toKey.getChunks(), (CharSequence)"\n", null, null, (int)0, null, (Function1)toKey.2.INSTANCE, (int)30, null);
        }

        @NotNull
        public final String getPromptQuestion(@NotNull Prompt prompt2) {
            Object lastUserMessage;
            Object object;
            Prompt.Message message;
            Prompt.Message last;
            List<Prompt.Message> messages;
            block5: {
                Intrinsics.checkNotNullParameter((Object)prompt2, (String)"prompt");
                messages = prompt2.getMessages();
                last = (Prompt.Message)CollectionsKt.last(messages);
                List<Prompt.Message> $this$lastOrNull$iv = prompt2.getMessages();
                boolean $i$f$lastOrNull = false;
                ListIterator<Prompt.Message> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Prompt.Message element$iv;
                    Prompt.Message it = element$iv = iterator$iv.previous();
                    boolean bl = false;
                    if (!(it instanceof Prompt.UserMessage)) continue;
                    message = element$iv;
                    break block5;
                }
                message = null;
            }
            if ((object = (Prompt.Message)message) == null || (object = this.toKey((Prompt.Message)object)) == null) {
                object = lastUserMessage = "";
            }
            if (last instanceof Prompt.FunctionResponseMessage) {
                Prompt.Message call = messages.get(messages.size() - 2);
                if (call instanceof Prompt.FunctionCallMessage) {
                    return (String)lastUserMessage + ": " + this.toKey((Prompt.FunctionCallMessage)call) + ":" + this.toKey((Prompt.FunctionResponseMessage)last);
                }
                return (String)lastUserMessage + ": " + this.toKey((Prompt.FunctionResponseMessage)last);
            }
            if (last instanceof Prompt.FunctionCallMessage) {
                return (String)lastUserMessage + ": " + this.toKey((Prompt.FunctionCallMessage)last);
            }
            return this.toKey(last);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final List<Pair<Long, Content>> get(@NotNull Prompt prompt2) {
            Intrinsics.checkNotNullParameter((Object)prompt2, (String)"prompt");
            String questionKey = this.computeKeyString(this.getPromptQuestion(prompt2));
            Entry entry = this.storage.get(DevModeDataType.CHAT, questionKey);
            if (entry == null) {
                return null;
            }
            Entry question = entry;
            List list = new ArrayList();
            String string = question.getMap().get(DevModeCache.ATTR_NEXT);
            if (string == null) {
                return null;
            }
            String key = string;
            while (this.storage.get(DevModeDataType.CHAT, key) != null) {
                Content content2;
                Entry entry2;
                Map<String, String> data2 = entry2.getMap();
                String text2 = data2.get(DevModeCache.ATTR_TEXT);
                if (text2 != null) {
                    List list2;
                    boolean verified = Intrinsics.areEqual((Object)data2.get(DevModeCache.ATTR_VERIFIED), (Object)"true");
                    if (data2.get(DevModeCache.ATTR_CITATIONS) != null) {
                        void $this$mapTo$iv$iv;
                        String it;
                        boolean bl = false;
                        String[] stringArray = new String[]{","};
                        Iterable $this$map$iv = StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            String url;
                            void s;
                            String string2 = (String)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl2 = false;
                            int index = StringsKt.indexOf$default((CharSequence)((CharSequence)s), (char)':', (int)0, (boolean)false, (int)6, null);
                            String string3 = s.substring(0, index);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                            CitationAction action = CitationAction.valueOf(string3);
                            Intrinsics.checkNotNullExpressionValue((Object)s.substring(index + 1), (String)"substring(...)");
                            TextRange textRange = TextRange.EMPTY_RANGE;
                            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
                            collection.add(new Citation.Web(action, url, textRange, null));
                        }
                        list2 = (List)destination$iv$iv;
                    } else {
                        list2 = CollectionsKt.emptyList();
                    }
                    List citations2 = list2;
                    Pair[] pairArray = new Pair[]{new Pair((Object)"SML_METADATA", (Object)SmlMetadata.NONE), new Pair((Object)"IS_VERIFIED_RESPONSE", (Object)verified)};
                    Map metadata = MapsKt.mapOf((Pair[])pairArray);
                    content2 = new Content.TextContent(text2, citations2, metadata, null, null, 24, null);
                } else {
                    String name;
                    Tool tool;
                    Intrinsics.checkNotNull((Object)data2.get(DevModeCache.ATTR_NAME));
                    Map args = new LinkedHashMap();
                    for (Map.Entry<String, String> entry3 : data2.entrySet()) {
                        String key2 = entry3.getKey();
                        String value = entry3.getValue();
                        if (!StringsKt.startsWith$default((String)key2, (String)DevModeCache.ATTR_ARG_PREFIX, (boolean)false, (int)2, null)) continue;
                        args.put(StringsKt.removePrefix((String)key2, (CharSequence)DevModeCache.ATTR_ARG_PREFIX), value);
                    }
                    String toolClass = data2.get(DevModeCache.ATTR_TOOL);
                    if (toolClass != null) {
                        Class<?> cls = Class.forName(toolClass);
                        Object obj = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type com.google.aiplugin.agents.Tool<*>");
                        tool = (Tool)obj;
                    } else {
                        tool = null;
                    }
                    Tool tool2 = tool;
                    Content.FunctionCall call = new Content.FunctionCall(name, args, tool2, null, null, 24, null);
                    String response2 = data2.get(DevModeCache.ATTR_RESPONSE);
                    content2 = response2 != null ? (Content)new Content.FunctionCallResponse(call, response2, null, 4, null) : (Content)call;
                }
                Content content3 = content2;
                list.add(new Pair((Object)entry2.getDelay(), (Object)content3));
                if (data2.get(DevModeCache.ATTR_NEXT) != null) continue;
                return list;
            }
            return list;
        }

        @NotNull
        public final Entry putQuestion(@NotNull Prompt prompt2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)prompt2, (String)"prompt");
            boolean bl2 = bl = !this.storage.getAutoFlush();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Map data2 = new LinkedHashMap();
            String question = this.getPromptQuestion(prompt2);
            String key = this.computeKeyString(question);
            data2.put(DevModeCache.ATTR_TEXT, question);
            return DevModeCache.put$default(this.storage, DevModeDataType.CHAT, key, data2, 0L, null, null, 48, null);
        }

        @NotNull
        public final Entry putContent(@NotNull Content content2, long delay, @NotNull Entry prev) {
            Entry entry;
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            Intrinsics.checkNotNullParameter((Object)prev, (String)"prev");
            Content content3 = content2;
            if (content3 instanceof Content.TextContent) {
                entry = this.putAnswer((Content.TextContent)content2, delay, prev);
            } else if (content3 instanceof Content.FunctionCall) {
                entry = this.putFunctionCall((Content.FunctionCall)content2, null, delay, prev);
            } else if (content3 instanceof Content.FunctionCallResponse) {
                entry = this.putFunctionCall(((Content.FunctionCallResponse)content2).getCall(), ((Content.FunctionCallResponse)content2).getResponse(), delay, prev);
            } else if (content3 instanceof Content.Thought ? true : content3 instanceof Content.ThoughtSignature) {
                entry = prev;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return entry;
        }

        @NotNull
        public final Entry putFunctionCall(@NotNull Content.FunctionCall call, @Nullable String response2, long delay, @NotNull Entry prev) {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)prev, (String)"prev");
            String newKey = this.newKey(prev);
            Map data2 = new LinkedHashMap();
            data2.put(DevModeCache.ATTR_NAME, call.getName());
            List args = MapsKt.toList(call.getArgs());
            for (Object object : args) {
                String key = (String)object.component1();
                Object value = object.component2();
                if (!(value instanceof String)) {
                    ChatCache $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(ChatCache.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    Object object2 = value;
                    logger.warn("WARNING: value is not a string; type=" + (object2 != null ? object2.getClass() : null) + " and str=" + value);
                }
                data2.put(DevModeCache.ATTR_ARG_PREFIX + key, String.valueOf(value));
            }
            if (response2 != null) {
                data2.put(DevModeCache.ATTR_RESPONSE, response2);
            }
            if (call.getTool() != null) {
                Object object;
                Map map2 = data2;
                object = DevModeCache.ATTR_TOOL;
                Object object3 = call.getTool();
                Intrinsics.checkNotNull((Object)object3);
                String string = object3.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = string;
                map2.put(object, string2);
            }
            return DevModeCache.put$default(this.storage, DevModeDataType.CHAT, newKey, data2, delay, null, null, 48, null);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Entry putAnswer(@NotNull Content.TextContent content2, long delay, @NotNull Entry prev) {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            Intrinsics.checkNotNullParameter((Object)prev, (String)"prev");
            Object object = content2.getMetadata().get("IS_VERIFIED_RESPONSE");
            Boolean bl = object instanceof Boolean ? (Boolean)object : null;
            boolean isVerified = bl != null ? bl : false;
            Iterable $this$filterIsInstance$iv = content2.getCitations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Citation.Web)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            String citations2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, (Function1)putAnswer.citations.1.INSTANCE, (int)30, null);
            return this.putAnswer(content2.getText(), isVerified, citations2, delay, prev);
        }

        @NotNull
        public final Entry putAnswer(@NotNull String chunk, boolean verified, @NotNull String citations2, long delay, @NotNull Entry prev) {
            Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
            Intrinsics.checkNotNullParameter((Object)citations2, (String)DevModeCache.ATTR_CITATIONS);
            Intrinsics.checkNotNullParameter((Object)prev, (String)"prev");
            String newKey = this.newKey(prev);
            Map data2 = new LinkedHashMap();
            data2.put(DevModeCache.ATTR_TEXT, chunk);
            if (verified) {
                data2.put(DevModeCache.ATTR_VERIFIED, "true");
            }
            if (!StringsKt.isBlank((CharSequence)citations2)) {
                data2.put(DevModeCache.ATTR_CITATIONS, citations2);
            }
            return DevModeCache.put$default(this.storage, DevModeDataType.CHAT, newKey, data2, delay, null, null, 48, null);
        }

        private final String newKey(Entry prev) {
            Object object = new String[]{prev.getMap().toString()};
            String newKey = Companion.createKey("continued", (String[])object);
            Map<String, String> map2 = prev.getMap();
            Intrinsics.checkNotNull(map2, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.String>");
            object = TypeIntrinsics.asMutableMap(map2);
            object.put(DevModeCache.ATTR_NEXT, newKey);
            return newKey;
        }

        public final void deleteConversation(@NotNull Prompt prompt2) {
            Intrinsics.checkNotNullParameter((Object)prompt2, (String)"prompt");
            String question = this.getPromptQuestion(prompt2);
            Entry prev = this.storage.remove(question);
            while (prev != null) {
                String string = prev.getMap().get(DevModeCache.ATTR_NEXT);
                if (string == null) break;
                prev = this.storage.remove(string);
            }
            this.storage.writeTo(this.storage.getFile());
        }

        @NotNull
        public final Flow<Content> replay(@NotNull DevModePlayback behavior2, @NotNull List<? extends Pair<Long, ? extends Content>> conversation) {
            Intrinsics.checkNotNullParameter((Object)((Object)behavior2), (String)"behavior");
            Intrinsics.checkNotNullParameter(conversation, (String)"conversation");
            return FlowKt.flow((Function2)((Function2)new Function2<FlowCollector<? super Content>, Continuation<? super Unit>, Object>(conversation, behavior2, null){
                Object L$1;
                Object L$2;
                Object L$3;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ List<Pair<Long, Content>> $conversation;
                final /* synthetic */ DevModePlayback $behavior;
                {
                    this.$conversation = $conversation;
                    this.$behavior = $behavior;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$flow = (FlowCollector)this.L$0;
                            var3_4 = this.$conversation;
                            var4_5 = this.$behavior;
                            $i$f$forEach = false;
                            var6_7 = $this$forEach$iv.iterator();
lbl10:
                            // 3 sources

                            while (var6_7.hasNext()) {
                                element$iv = var6_7.next();
                                var8_9 = (Pair)element$iv;
                                $i$a$-forEach-DevModeCache$ChatCache$replay$1$1 = false;
                                chunkDelay = ((Number)var8_9.component1()).longValue();
                                content = (Content)var8_9.component2();
                                this.L$0 = $this$flow;
                                this.L$1 = var4_5;
                                this.L$2 = var6_7;
                                this.L$3 = content;
                                this.label = 1;
                                v0 = var4_5.replaySuspend(chunkDelay, (Continuation<? super Unit>)this);
                                if (v0 == var13_2) {
                                    return var13_2;
                                }
                                ** GOTO lbl35
                            }
                            break;
                        }
                        case 1: {
                            $i$f$forEach = false;
                            $i$a$-forEach-DevModeCache$ChatCache$replay$1$1 = false;
                            content = (Content)this.L$3;
                            var6_7 = (Iterator)this.L$2;
                            var4_5 = (DevModePlayback)this.L$1;
                            $this$flow = (FlowCollector)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl35:
                            // 2 sources

                            this.L$0 = $this$flow;
                            this.L$1 = var4_5;
                            this.L$2 = var6_7;
                            this.L$3 = null;
                            this.label = 2;
                            v1 = $this$flow.emit((Object)content, (Continuation)this);
                            if (v1 != var13_2) ** GOTO lbl10
                            return var13_2;
                        }
                        case 2: {
                            $i$f$forEach = false;
                            $i$a$-forEach-DevModeCache$ChatCache$replay$1$1 = false;
                            var6_7 = (Iterator<T>)this.L$2;
                            var4_5 = (DevModePlayback)this.L$1;
                            $this$flow = (FlowCollector)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                            ** GOTO lbl10
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(FlowCollector<? super Content> p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        public final void onNewConversation() {
            this.storage.discardPendingUnlessSaving(DevModeDataType.CHAT);
        }

        public final void onConversationFinished() {
            if (this.storage.getAutoSave().contains((Object)DevModeDataType.CHAT)) {
                DevModeCache.savePending$default(this.storage, SetsKt.setOf((Object)((Object)DevModeDataType.CHAT)), false, 2, null);
                this.storage.flush();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001b\"\u00020\u0004\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\u0004J\u0006\u0010\"\u001a\u00020\u0004J\b\u0010#\u001a\u00020$H\u0002J\u0006\u0010%\u001a\u00020\u0017J\u0006\u0010&\u001a\u00020'J\u0018\u0010(\u001a\u0004\u0018\u00010\u00042\u000e\u0010)\u001a\n\u0012\u0004\u0012\u00020+\u0018\u00010*J\u000e\u0010,\u001a\u00020-2\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/android/studio/ml/devmode/DevModeCache$Companion;", "", "()V", "ATTR_ARG_PREFIX", "", "ATTR_CITATIONS", "ATTR_CONFIDENCE", "ATTR_COUNT", "ATTR_DELAY", "ATTR_KEY", "ATTR_MODEL_ID", "ATTR_NAME", "ATTR_NEXT", "ATTR_PATH", "ATTR_RESPONSE", "ATTR_TEXT", "ATTR_TIMESTAMP", "ATTR_TOOL", "ATTR_TYPE", "ATTR_VERIFIED", "MAX_LENGTH", "", "storage", "Lcom/android/studio/ml/devmode/DevModeCache;", "createKey", "prefix", "parts", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getChatCache", "Lcom/android/studio/ml/devmode/DevModeCache$ChatCache;", "getCompletionCache", "Lcom/android/studio/ml/devmode/DevModeCache$CompletionCache;", "getCurrentModelId", "getCurrentTimestamp", "getDefaultFile", "Ljava/io/File;", "getStorage", "getTransformCache", "Lcom/android/studio/ml/devmode/DevModeCache$TransformCache;", "saveLast", "types", "", "Lcom/android/studio/ml/devmode/DevModeDataType;", "setStorage", "", "aiplugin.core.aicore"})
    @SourceDebugExtension(value={"SMAP\nDevModeCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevModeCache.kt\ncom/android/studio/ml/devmode/DevModeCache$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,880:1\n1#2:881\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String saveLast(@Nullable Set<? extends DevModeDataType> types) {
            DevModeCache cache = this.getStorage();
            Object object = cache.peekPending(types);
            String result2 = object != null && (object = ((Entry)object).getMap()) != null ? (String)object.get(DevModeCache.ATTR_TEXT) : null;
            DevModeCache.savePending$default(cache, types, false, 2, null);
            cache.flush();
            return result2;
        }

        @NotNull
        public final String getCurrentModelId() {
            ModelProvider modelProvider = ModelProvider.Companion.activeModelProvider();
            return modelProvider instanceof DevModeModelProvider ? ((DevModeModelProvider)modelProvider).getModelProvider$aiplugin_core_aicore().displayName() : modelProvider.displayName();
        }

        @NotNull
        public final String getCurrentTimestamp() {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
            String string = LocalDateTime.now().format(formatter);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }

        @NotNull
        public final String createKey(@NotNull String prefix, String ... parts) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)parts, (String)"parts");
            Hasher hasher = Hashing.murmur3_32_fixed().newHasher();
            hasher.putString((CharSequence)prefix, Charsets.UTF_8);
            for (String part : parts) {
                hasher.putString((CharSequence)part, Charsets.UTF_8);
            }
            return prefix + "_" + hasher.hash();
        }

        private final File getDefaultFile() {
            String root = System.getProperty("user.home");
            return new File(root, ".dev-cache.jsonl");
        }

        @NotNull
        public final DevModeCache getStorage() {
            DevModeCache devModeCache = storage;
            if (devModeCache == null) {
                DevModeCache devModeCache2;
                DevModeCache it = devModeCache2 = new DevModeCache(this.getDefaultFile(), DevModeDataType.Companion.getAutoSave());
                boolean bl = false;
                storage = it;
                devModeCache = devModeCache2;
            }
            return devModeCache;
        }

        @NotNull
        public final CompletionCache getCompletionCache() {
            return new CompletionCache(this.getStorage());
        }

        @NotNull
        public final ChatCache getChatCache() {
            return new ChatCache(this.getStorage());
        }

        @NotNull
        public final TransformCache getTransformCache() {
            return new TransformCache(this.getStorage());
        }

        public final void setStorage(@NotNull DevModeCache storage) {
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            storage = storage;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/android/studio/ml/devmode/DevModeCache$CompletionCache;", "", "storage", "Lcom/android/studio/ml/devmode/DevModeCache;", "(Lcom/android/studio/ml/devmode/DevModeCache;)V", "getStorage", "()Lcom/android/studio/ml/devmode/DevModeCache;", "createKey", "", "req", "Lcom/android/studio/ml/SmlCodeCompletionRequest;", "get", "Lkotlin/Pair;", "Lcom/android/studio/ml/devmode/DevModeCache$Entry;", "Lcom/android/studio/ml/SmlCodeCompletionResponse;", "onNewCompletion", "", "put", "response", "delay", "", "aiplugin.core.aicore"})
    @StabilityInferred(parameters=0)
    public static final class CompletionCache {
        @NotNull
        private final DevModeCache storage;
        public static final int $stable = 8;

        public CompletionCache(@NotNull DevModeCache storage) {
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            this.storage = storage;
        }

        @NotNull
        public final DevModeCache getStorage() {
            return this.storage;
        }

        private final String createKey(SmlCodeCompletionRequest req) {
            String prefix = req.getPrefix();
            String suffix = req.getSuffix();
            String window = StringsKt.replace$default((String)(StringsKt.takeLast((String)prefix, (int)12) + "|" + StringsKt.take((String)suffix, (int)12)), (String)"\n", (String)"\\n", (boolean)false, (int)4, null) + ":";
            return window + Hashing.murmur3_32_fixed().newHasher().putString((CharSequence)prefix, Charsets.UTF_8).putChar('|').putString((CharSequence)suffix, Charsets.UTF_8).hash();
        }

        @Nullable
        public final Pair<Entry, SmlCodeCompletionResponse> get(@NotNull SmlCodeCompletionRequest req) {
            Intrinsics.checkNotNullParameter((Object)req, (String)"req");
            String key = this.createKey(req);
            Entry entry = this.storage.get(DevModeDataType.COMPLETION, key);
            if (entry == null) {
                return null;
            }
            Entry entry2 = entry;
            Map<String, String> data2 = entry2.getMap();
            String string = data2.get(DevModeCache.ATTR_COUNT);
            Intrinsics.checkNotNull((Object)string);
            int count = Integer.parseInt(string);
            ArrayList<SmlCodeCompletionSample> samples = new ArrayList<SmlCodeCompletionSample>(count);
            for (int i2 = 0; i2 < count; ++i2) {
                String suggestion;
                int attrSuffix = i2 + 1;
                Intrinsics.checkNotNull((Object)data2.get(DevModeCache.ATTR_TEXT + attrSuffix));
                String string2 = data2.get(DevModeCache.ATTR_CONFIDENCE + attrSuffix);
                float confidence = string2 != null ? Float.parseFloat(string2) : 1.0f;
                samples.add(new SmlCodeCompletionSample(suggestion, confidence, CollectionsKt.emptyList(), i2));
            }
            return new Pair((Object)entry2, (Object)new SmlCodeCompletionResponse((List<SmlCodeCompletionSample>)samples, null));
        }

        public final void put(@NotNull SmlCodeCompletionRequest req, @NotNull SmlCodeCompletionResponse response2, long delay) {
            Intrinsics.checkNotNullParameter((Object)req, (String)"req");
            Intrinsics.checkNotNullParameter((Object)response2, (String)DevModeCache.ATTR_RESPONSE);
            List<SmlCodeCompletionSample> suggestions = response2.getSuggestions();
            if (suggestions.isEmpty() && this.storage.getAutoSave().contains((Object)DevModeDataType.COMPLETION)) {
                return;
            }
            Map data2 = new LinkedHashMap();
            data2.put(DevModeCache.ATTR_PATH, req.getFilePath());
            int count = suggestions.size();
            data2.put(DevModeCache.ATTR_COUNT, String.valueOf(count));
            for (int i2 = 0; i2 < count; ++i2) {
                SmlCodeCompletionSample suggestion = suggestions.get(i2);
                int attrSuffix = i2 + 1;
                data2.put(DevModeCache.ATTR_TEXT + attrSuffix, suggestion.getCompletion());
                data2.put(DevModeCache.ATTR_CONFIDENCE + attrSuffix, String.valueOf(suggestion.getScore()));
            }
            DevModeCache.put$default(this.storage, DevModeDataType.COMPLETION, this.createKey(req), data2, delay, null, null, 48, null);
        }

        public final void onNewCompletion() {
            this.storage.discardPendingUnlessSaving(DevModeDataType.COMPLETION);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\r\b\u0007\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/android/studio/ml/devmode/DevModeCache$Entry;", "", "type", "Lcom/android/studio/ml/devmode/DevModeDataType;", "map", "", "", "delay", "", "timeStamp", "modelId", "(Lcom/android/studio/ml/devmode/DevModeDataType;Ljava/util/Map;JLjava/lang/String;Ljava/lang/String;)V", "getDelay", "()J", "getMap", "()Ljava/util/Map;", "getModelId", "()Ljava/lang/String;", "getTimeStamp", "getType", "()Lcom/android/studio/ml/devmode/DevModeDataType;", "aiplugin.core.aicore"})
    @StabilityInferred(parameters=0)
    public static final class Entry {
        @NotNull
        private final DevModeDataType type;
        @NotNull
        private final Map<String, String> map;
        private final long delay;
        @NotNull
        private final String timeStamp;
        @NotNull
        private final String modelId;
        public static final int $stable = 8;

        public Entry(@NotNull DevModeDataType type2, @NotNull Map<String, String> map2, long delay, @NotNull String timeStamp, @NotNull String modelId) {
            Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)DevModeCache.ATTR_TYPE);
            Intrinsics.checkNotNullParameter(map2, (String)"map");
            Intrinsics.checkNotNullParameter((Object)timeStamp, (String)DevModeCache.ATTR_TIMESTAMP);
            Intrinsics.checkNotNullParameter((Object)modelId, (String)DevModeCache.ATTR_MODEL_ID);
            this.type = type2;
            this.map = map2;
            this.delay = delay;
            this.timeStamp = timeStamp;
            this.modelId = modelId;
        }

        @NotNull
        public final DevModeDataType getType() {
            return this.type;
        }

        @NotNull
        public final Map<String, String> getMap() {
            return this.map;
        }

        public final long getDelay() {
            return this.delay;
        }

        @NotNull
        public final String getTimeStamp() {
            return this.timeStamp;
        }

        @NotNull
        public final String getModelId() {
            return this.modelId;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J&\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\bJ6\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015\u0018\u00010\u00122\u0006\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0006\u0010\u0017\u001a\u00020\u0018J&\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dJ8\u0010\u0019\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u001c\u001a\u00020\u001dJ\f\u0010\u001f\u001a\u00020\b*\u00020 H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006!"}, d2={"Lcom/android/studio/ml/devmode/DevModeCache$TransformCache;", "", "storage", "Lcom/android/studio/ml/devmode/DevModeCache;", "(Lcom/android/studio/ml/devmode/DevModeCache;)V", "getStorage", "()Lcom/android/studio/ml/devmode/DevModeCache;", "createKey", "", "request", "Lcom/android/studio/ml/TransformRequest;", "refinement", "userQuery", "fileContext", "Lcom/android/tools/idea/studiobot/prompts/FileWithSelection;", "history", "Lcom/android/tools/idea/studiobot/prompts/Prompt;", "get", "Lkotlin/Pair;", "Lcom/android/studio/ml/devmode/DevModeCache$Entry;", "Lcom/android/studio/ml/TransformResult;", "", "Lcom/android/tools/idea/studiobot/Content$TextContent;", "onNewTransform", "", "put", "req", "response", "delay", "", "result", "describe", "Lcom/android/studio/ml/FileContext;", "aiplugin.core.aicore"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nDevModeCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevModeCache.kt\ncom/android/studio/ml/devmode/DevModeCache$TransformCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,880:1\n1557#2:881\n1628#2,3:882\n295#2,2:889\n37#3:885\n36#3,3:886\n*S KotlinDebug\n*F\n+ 1 DevModeCache.kt\ncom/android/studio/ml/devmode/DevModeCache$TransformCache\n*L\n465#1:881\n465#1:882,3\n495#1:889,2\n465#1:885\n465#1:886,3\n*E\n"})
    public static final class TransformCache {
        @NotNull
        private final DevModeCache storage;
        public static final int $stable = 8;

        public TransformCache(@NotNull DevModeCache storage) {
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            this.storage = storage;
        }

        @NotNull
        public final DevModeCache getStorage() {
            return this.storage;
        }

        private final String describe(FileContext $this$describe) {
            String doc = $this$describe.content();
            StringBuilder sb = new StringBuilder();
            if (!((Collection)$this$describe.getCaretInfos()).isEmpty()) {
                for (FileContext.CaretInfo info2 : $this$describe.getCaretInfos()) {
                    int offset2 = info2.getOffset();
                    TextRange sel = info2.getSelectionRange();
                    if (!Intrinsics.areEqual((Object)sel, (Object)TextRange.EMPTY_RANGE)) {
                        String string = doc.substring(sel.getStartOffset(), sel.getEndOffset());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        sb.append(string);
                        continue;
                    }
                    if (offset2 >= 0) {
                        String string = doc.substring(0, offset2);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        sb.append(string);
                        sb.append('|');
                        if (offset2 >= doc.length()) continue;
                        String string2 = doc.substring(offset2 + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        sb.append(string2);
                        continue;
                    }
                    return doc;
                }
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final String createKey(TransformRequest request2, String refinement) {
            String string;
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = request2.getFileContexts();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FileContext fileContext = (FileContext)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.describe((FileContext)it));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] fileContexts = thisCollection$iv.toArray(new String[0]);
            TransformRequest transformRequest = request2;
            if (transformRequest instanceof TransformRequest.CustomTransform) {
                String string2 = ((TransformRequest.CustomTransform)request2).getQuery();
                SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                spreadBuilder.add((Object)refinement);
                spreadBuilder.addSpread((Object)fileContexts);
                string = Companion.createKey(string2, (String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
            } else if (transformRequest instanceof TransformRequest.DocumentElement) {
                SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                spreadBuilder.add((Object)refinement);
                spreadBuilder.addSpread((Object)fileContexts);
                string = Companion.createKey("document", (String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
            } else if (transformRequest instanceof TransformRequest.GenerateComposePreviewTransform) {
                SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                spreadBuilder.add((Object)refinement);
                spreadBuilder.addSpread((Object)fileContexts);
                string = Companion.createKey("generatecomposepreview", (String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
            } else if (transformRequest instanceof TransformRequest.MultimodalPreviewTransform) {
                SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                spreadBuilder.add((Object)refinement);
                spreadBuilder.addSpread((Object)fileContexts);
                string = Companion.createKey("multimodalpreview", (String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
            } else {
                if (transformRequest instanceof TransformRequest.IntegrateCodeBlock) {
                    throw new IllegalStateException("Code Integration not supported");
                }
                if (transformRequest instanceof TransformRequest.SuggestedFixTransform) {
                    SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                    spreadBuilder.add((Object)refinement);
                    spreadBuilder.addSpread((Object)fileContexts);
                    string = Companion.createKey("generatesuggestedfix", (String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        @Nullable
        public final Pair<Entry, TransformResult> get(@NotNull TransformRequest request2, @NotNull String refinement) {
            ModifiedFile modifiedFile;
            Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
            Intrinsics.checkNotNullParameter((Object)refinement, (String)"refinement");
            String key = this.createKey(request2, refinement);
            Entry entry = this.storage.get(DevModeDataType.TRANSFORM, key);
            if (entry == null) {
                return null;
            }
            Entry entry2 = entry;
            Map<String, String> data2 = entry2.getMap();
            String string = data2.get("displayQuery");
            Intrinsics.checkNotNull((Object)string);
            String displayQuery2 = string;
            String string2 = data2.get("newContent");
            Intrinsics.checkNotNull((Object)string2);
            String newContent2 = string2;
            String path2 = data2.get(DevModeCache.ATTR_PATH);
            String edited = data2.get("edited");
            String deleted = data2.get("edited");
            if (path2 != null) {
                modifiedFile = new ModifiedFile.NewFile(path2, newContent2, CollectionsKt.emptyList());
            } else {
                FileContext fileContext;
                Object v6;
                block6: {
                    String string3 = edited;
                    if (string3 == null) {
                        String string4 = deleted;
                        string3 = string4;
                        Intrinsics.checkNotNull((Object)string4);
                    }
                    String virtualPath = string3;
                    Iterable $this$firstOrNull$iv = request2.getFileContexts();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        FileContext it = (FileContext)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getFile().getPath(), (Object)virtualPath)) continue;
                        v6 = element$iv;
                        break block6;
                    }
                    v6 = null;
                }
                if ((fileContext = (FileContext)v6) == null || (fileContext = fileContext.getFile()) == null) {
                    return null;
                }
                FileContext virtualFile2 = fileContext;
                modifiedFile = edited != null ? (ModifiedFile)new ModifiedFile.EditedFile((VirtualFile)virtualFile2, newContent2, CollectionsKt.emptyList()) : (ModifiedFile)new ModifiedFile.DeletedFile((VirtualFile)virtualFile2);
            }
            ModifiedFile modifiedFile2 = modifiedFile;
            List modifiedFiles = CollectionsKt.listOf((Object)modifiedFile2);
            TransformResult result2 = new TransformResult(request2, displayQuery2, modifiedFiles, null, 0, null, null, 120, null);
            return new Pair((Object)entry2, (Object)result2);
        }

        public static /* synthetic */ Pair get$default(TransformCache transformCache, TransformRequest transformRequest, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            return transformCache.get(transformRequest, string);
        }

        public final void put(@NotNull TransformRequest req, @NotNull String refinement, @NotNull TransformResult response2, long delay) {
            Intrinsics.checkNotNullParameter((Object)req, (String)"req");
            Intrinsics.checkNotNullParameter((Object)refinement, (String)"refinement");
            Intrinsics.checkNotNullParameter((Object)((Object)response2), (String)DevModeCache.ATTR_RESPONSE);
            List<ModifiedFile> modifiedFiles = response2.getModifiedFiles();
            if (modifiedFiles.size() != 1) {
                return;
            }
            ModifiedFile modifiedFile = (ModifiedFile)CollectionsKt.firstOrNull(modifiedFiles);
            if (modifiedFile == null) {
                return;
            }
            ModifiedFile firstFile = modifiedFile;
            Map data2 = new LinkedHashMap();
            data2.put("displayQuery", response2.getDisplayQuery());
            ModifiedFile modifiedFile2 = firstFile;
            if (modifiedFile2 instanceof ModifiedFile.NewFile) {
                data2.put(DevModeCache.ATTR_PATH, ((ModifiedFile.NewFile)firstFile).getPath());
            } else if (modifiedFile2 instanceof ModifiedFile.EditedFile) {
                Map map2 = data2;
                String string = "edited";
                String string2 = ((ModifiedFile.EditedFile)firstFile).getVirtualFile().getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                String string3 = string2;
                map2.put(string, string3);
            } else if (modifiedFile2 instanceof ModifiedFile.DeletedFile) {
                Map map3 = data2;
                String string = "deleted";
                String string4 = ((ModifiedFile.DeletedFile)firstFile).getVirtualFile().getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
                String string5 = string4;
                map3.put(string, string5);
            }
            data2.put("newContent", firstFile.getNewContent());
            DevModeCache.put$default(this.storage, DevModeDataType.TRANSFORM, this.createKey(req, refinement), data2, delay, null, null, 48, null);
        }

        @Nullable
        public final Pair<Entry, List<Content.TextContent>> get(@NotNull String userQuery, @Nullable FileWithSelection fileContext, @Nullable Prompt history2) {
            Intrinsics.checkNotNullParameter((Object)userQuery, (String)"userQuery");
            String key = this.createKey(userQuery, fileContext, history2);
            Entry entry = this.storage.get(DevModeDataType.TRANSFORM, key);
            if (entry == null) {
                return null;
            }
            Entry entry2 = entry;
            Map<String, String> data2 = entry2.getMap();
            String string = data2.get(DevModeCache.ATTR_TEXT);
            Intrinsics.checkNotNull((Object)string);
            String content2 = string;
            List result2 = CollectionsKt.listOf((Object)new Content.TextContent(content2, null, null, null, null, 30, null));
            return new Pair((Object)entry2, (Object)result2);
        }

        public final void put(@NotNull String userQuery, @Nullable FileWithSelection fileContext, @Nullable Prompt history2, @NotNull List<Content.TextContent> result2, long delay) {
            Intrinsics.checkNotNullParameter((Object)userQuery, (String)"userQuery");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            Content.TextContent first = (Content.TextContent)CollectionsKt.first(result2);
            if (result2.size() != 1) {
                new Content.TextContent(CollectionsKt.joinToString$default((Iterable)result2, (CharSequence)"\n", null, null, (int)0, null, (Function1)put.content.1.INSTANCE, (int)30, null), null, null, null, null, 30, null);
                return;
            }
            Content.TextContent content2 = first;
            Map data2 = new LinkedHashMap();
            data2.put(DevModeCache.ATTR_TEXT, content2.getText());
            String key = this.createKey(userQuery, fileContext, history2);
            DevModeCache.put$default(this.storage, DevModeDataType.TRANSFORM, key, data2, delay, null, null, 48, null);
        }

        private final String createKey(String userQuery, FileWithSelection fileContext, Prompt history2) {
            Prompt prompt2 = history2;
            Intrinsics.checkNotNull((Object)prompt2);
            String currentPromptHistory2 = CollectionsKt.joinToString$default((Iterable)prompt2.getMessages(), (CharSequence)"\n", null, null, (int)0, null, (Function1)createKey.currentPromptHistory.1.INSTANCE, (int)30, null);
            Object[] objectArray = new String[3];
            objectArray[0] = currentPromptHistory2;
            objectArray[1] = userQuery;
            FileWithSelection fileWithSelection = fileContext;
            String string = fileWithSelection != null ? fileWithSelection.getSelected() : null;
            if (string == null) {
                string = "";
            }
            objectArray[2] = string;
            String currentPrompt = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            objectArray = new String[]{currentPrompt};
            return Companion.createKey(userQuery, (String[])objectArray);
        }

        public final void onNewTransform() {
            this.storage.discardPendingUnlessSaving(DevModeDataType.TRANSFORM);
        }
    }
}

