/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.gradle.buildsystem;

import com.android.studio.ml.gradle.buildsystem.ArtifactCoordinate;
import com.android.studio.ml.gradle.buildsystem.GetTopLevelSubProjectsKt;
import com.android.studio.ml.gradle.buildsystem.GradleToolsUtilsKt;
import com.android.studio.ml.gradle.buildsystem.ProjectData;
import com.android.studio.ml.gradle.buildsystem.SourceSetModuleData;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.gradle.LinkedAndroidModuleGroupUtilsKt;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KParameter;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ToolDescription(summary="Returns the top-level artifacts consuming the given artifact", instructions="The arguments are generally obtained via get_gradle_artifact_from_file.", examples={})
@ToolResult(description="Returns a JSON array of objects, each representing an artifact and containing the following information:\n- subproject_path: the path of the Gradle sub-project containing the file\n- variant_name: the name of the variant containing the file, 'null' for java projects\n- artifact_type: the name of the artifact containing the file\nReturns an empty array ([]) if no artifacts are found.")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u000e\u000fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/android/studio/ml/gradle/buildsystem/GetArtifactConsumers;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/android/studio/ml/gradle/buildsystem/ArtifactCoordinate;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "Companion", "Handler", "aiplugin.android.gradle"})
public final class GetArtifactConsumers
implements Tool<ArtifactCoordinate> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "get_artifact_consumers";

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull ArtifactCoordinate args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new Handler(context2, args);
    }

    @Override
    @NotNull
    public String getDisplayText(@NotNull ArtifactCoordinate args) {
        return Tool.super.getDisplayText(args);
    }

    @Override
    @Nullable
    public String getStatusMessage() {
        return Tool.super.getStatusMessage();
    }

    @Override
    @Nullable
    public Map<KParameter, ToolArgument> getToolArguments() {
        return Tool.super.getToolArguments();
    }

    @Override
    @NotNull
    public ToolDescription getToolDescription() {
        return Tool.super.getToolDescription();
    }

    @Override
    @Nullable
    public ToolResult getToolResult() {
        return Tool.super.getToolResult();
    }

    @Override
    @Nullable
    public ToolHandler restoreHandler(@NotNull Project project2, @NotNull ArtifactCoordinate args, @NotNull Response response2) {
        return Tool.super.restoreHandler(project2, args, response2);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tool.super.getDescription();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/studio/ml/gradle/buildsystem/GetArtifactConsumers$Companion;", "", "<init>", "()V", "NAME", "", "aiplugin.android.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/studio/ml/gradle/buildsystem/GetArtifactConsumers$Handler;", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "Lcom/android/studio/ml/gradle/buildsystem/ArtifactCoordinate;", "<init>", "(Lcom/google/aiplugin/agents/tools/ToolContext;Lcom/android/studio/ml/gradle/buildsystem/ArtifactCoordinate;)V", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "aiplugin.android.gradle"})
    @SourceDebugExtension(value={"SMAP\nGetArtifactConsumers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GetArtifactConsumers.kt\ncom/android/studio/ml/gradle/buildsystem/GetArtifactConsumers$Handler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,163:1\n295#2,2:164\n1368#2:166\n1454#2,2:167\n1557#2:169\n1628#2,3:170\n1456#2,3:173\n1317#3,2:176\n*S KotlinDebug\n*F\n+ 1 GetArtifactConsumers.kt\ncom/android/studio/ml/gradle/buildsystem/GetArtifactConsumers$Handler\n*L\n116#1:164,2\n127#1:166\n127#1:167,2\n128#1:169\n128#1:170,3\n127#1:173,3\n141#1:176,2\n*E\n"})
    private static final class Handler
    implements ToolHandler {
        @NotNull
        private final ToolContext context;
        @NotNull
        private final ArtifactCoordinate args;

        public Handler(@NotNull ToolContext context2, @NotNull ArtifactCoordinate args) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.context = context2;
            this.args = args;
        }

        @Override
        @Nullable
        public Object handle(@NotNull Continuation<? super Response> $completion) {
            if (Intrinsics.areEqual((Object)this.args.getArtifact_type(), (Object)"unit_test_artifact") || Intrinsics.areEqual((Object)this.args.getArtifact_type(), (Object)"android_test_artifact")) {
                return new Response("[]", null, null, 6, null);
            }
            return CoroutinesKt.readAction(() -> Handler.handle$lambda$5(this), $completion);
        }

        private static final boolean handle$lambda$5$lambda$4(Set $allDependentModules, SourceSetModuleData it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return $allDependentModules.contains(it.getModule());
        }

        /*
         * WARNING - void declaration
         */
        private static final Response handle$lambda$5(Handler this$0) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Module requestedModule;
            Iterable $this$firstOrNull$iv;
            Map<String, ProjectData> modulesByGradlePath;
            Project project2;
            block28: {
                Object v2;
                Object object;
                block25: {
                    ProjectData projectData;
                    block26: {
                        project2 = this$0.context.getProject();
                        AndroidProjectSystem projectSystem = ProjectSystemUtil.getProjectSystem((Project)project2);
                        if (!projectSystem.isAndroidProject()) {
                            return GradleToolsUtilsKt.errorNotAndroid();
                        }
                        modulesByGradlePath = GradleToolsUtilsKt.buildModulesMap(project2);
                        if (modulesByGradlePath.isEmpty()) {
                            return GradleToolsUtilsKt.errorNoModules();
                        }
                        ProjectData projectData2 = modulesByGradlePath.get(this$0.args.getSubproject_path());
                        if (projectData2 == null) {
                            return GradleToolsUtilsKt.errorModuleNotFound(this$0.args.getSubproject_path());
                        }
                        projectData = projectData2;
                        Module holderModule = projectData.getRootModule().getModule();
                        if (!LinkedAndroidModuleGroupUtilsKt.isLinkedAndroidModule((Module)holderModule)) break block26;
                        switch (this$0.args.getArtifact_type()) {
                            case "main_artifact": {
                                object = LinkedAndroidModuleGroupUtilsKt.getMainModule((Module)holderModule);
                                break;
                            }
                            case "unit_test_artifact": {
                                object = LinkedAndroidModuleGroupUtilsKt.getUnitTestModule((Module)holderModule);
                                break;
                            }
                            case "android_test_artifact": {
                                object = LinkedAndroidModuleGroupUtilsKt.getAndroidTestModule((Module)holderModule);
                                break;
                            }
                            case "test_fixtures_artifact": {
                                object = LinkedAndroidModuleGroupUtilsKt.getTestFixturesModule((Module)holderModule);
                                break;
                            }
                            default: {
                                object = null;
                                break;
                            }
                        }
                        break block28;
                    }
                    $this$firstOrNull$iv = projectData.getSourcesetModules();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        SourceSetModuleData it = (SourceSetModuleData)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getType(), (Object)this$0.args.getArtifact_type())) continue;
                        v2 = element$iv;
                        break block25;
                    }
                    v2 = null;
                }
                SourceSetModuleData sourceSetModuleData = v2;
                object = requestedModule = sourceSetModuleData != null ? sourceSetModuleData.getModule() : null;
            }
            if (requestedModule == null) {
                return GradleToolsUtilsKt.errorArtifactTypeNotFoundInProject(this$0.args.getArtifact_type(), this$0.args.getSubproject_path());
            }
            $this$firstOrNull$iv = modulesByGradlePath.values();
            boolean $i$f$flatMap = false;
            Iterator iterator = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo22 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                ProjectData projectData = (ProjectData)element$iv$iv;
                boolean bl = false;
                Iterable $this$map$iv = projectData.getSourcesetModules();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SourceSetModuleData sourceSetModuleData = (SourceSetModuleData)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(TuplesKt.to((Object)it.getModule(), (Object)projectData));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Map moduleToProjectData = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            ModuleManager moduleManager = ModuleManager.Companion.getInstance(project2);
            Graph moduleGraph = moduleManager.moduleGraph(true);
            Set allDependentModules = new LinkedHashSet();
            Object[] $i$f$flatMapTo22 = new Module[]{requestedModule};
            Set modulesSeen = SetsKt.mutableSetOf((Object[])$i$f$flatMapTo22);
            ArrayDeque queue = new ArrayDeque((Collection)modulesSeen);
            while (!((Collection)queue).isEmpty()) {
                Module current2 = (Module)queue.removeFirst();
                Iterator iterator2 = moduleGraph.getOut((Object)current2);
                Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"getOut(...)");
                Sequence $this$forEach$iv = SequencesKt.asSequence((Iterator)iterator2);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Module it = (Module)element$iv;
                    boolean bl = false;
                    if (modulesSeen.contains(it)) continue;
                    Intrinsics.checkNotNull((Object)it);
                    queue.add((Object)it);
                    modulesSeen.add(it);
                }
                allDependentModules.add(current2);
            }
            allDependentModules.remove(requestedModule);
            List<String> matchingArtifacts = GetTopLevelSubProjectsKt.topLevelArtifacts(project2, modulesByGradlePath, (Function1<? super SourceSetModuleData, Boolean>)((Function1)arg_0 -> Handler.handle$lambda$5$lambda$4(allDependentModules, arg_0)));
            return new Response(CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)matchingArtifacts), (CharSequence)",\n", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null), null, null, 6, null);
        }
    }
}

