/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.journeys;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.SmlBundle;
import com.android.studio.ml.bot.StudioBotFlags;
import com.android.tools.idea.studiobot.StudioBot;
import com.android.tools.idea.studiobot.ads.GeminiAdvertiser;
import com.android.tools.idea.studiobot.ads.GeminiFeature;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0007J\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/studio/ml/journeys/JourneyUtils;", "", "<init>", "()V", "ROOT_TAG_NAME", "", "isJourneyFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "xmlFile", "Lcom/intellij/psi/xml/XmlFile;", "checkIfUserIsLoggedIntoGeminiPlugin", "aiplugin.android.journeys"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nJourneyUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JourneyUtils.kt\ncom/android/studio/ml/journeys/JourneyUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public final class JourneyUtils {
    @NotNull
    public static final JourneyUtils INSTANCE = new JourneyUtils();
    @NotNull
    public static final String ROOT_TAG_NAME = "journey";
    public static final int $stable;

    private JourneyUtils() {
    }

    @RequiresReadLock
    public final boolean isJourneyFile(@NotNull VirtualFile file, @NotNull Project project2) {
        boolean bl;
        XmlFile xmlFile2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (!Intrinsics.areEqual((Object)file.getExtension(), (Object)"xml")) {
            return false;
        }
        PsiFile psiFile2 = PsiManager.getInstance((Project)project2).findFile(file);
        XmlFile xmlFile3 = xmlFile2 = psiFile2 instanceof XmlFile ? (XmlFile)psiFile2 : null;
        if (xmlFile3 != null) {
            XmlFile it = xmlFile3;
            boolean bl2 = false;
            bl = INSTANCE.isJourneyFile(xmlFile2);
        } else {
            bl = false;
        }
        return bl;
    }

    @RequiresReadLock
    public final boolean isJourneyFile(@NotNull XmlFile xmlFile2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)xmlFile2, (String)"xmlFile");
        XmlTag xmlTag = xmlFile2.getRootTag();
        if (xmlTag != null) {
            XmlTag it = xmlTag;
            boolean bl2 = false;
            bl = Intrinsics.areEqual((Object)it.getName(), (Object)ROOT_TAG_NAME);
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean checkIfUserIsLoggedIntoGeminiPlugin(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (StudioBot.Companion.getInstance().isAvailable()) {
            return true;
        }
        if (!StudioBotFlags.Companion.getInstance().isAdvertiserEnabled()) {
            ApplicationManager.getApplication().invokeLater(() -> JourneyUtils.checkIfUserIsLoggedIntoGeminiPlugin$lambda$2(project2));
        } else {
            GeminiAdvertiser.DialogInfo dialogInfo = new GeminiAdvertiser.DialogInfo(SmlBundle.INSTANCE.getMessage("sml.studiobot.advertiser.description.journeys", new Object[0]), null, null, 6, null);
            GeminiAdvertiser.Companion.advertiseAndSignIn(project2, GeminiFeature.JOURNEYS, dialogInfo);
        }
        return false;
    }

    private static final void checkIfUserIsLoggedIntoGeminiPlugin$lambda$2(Project $project) {
        ToolWindow toolWindow;
        String[] stringArray = new String[]{Messages.getCancelButton(), "Enable Gemini"};
        String[] options = stringArray;
        Icon icon2 = AllIcons.General.Warning;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Warning");
        Icon icon3 = icon2;
        int result2 = Messages.showIdeaMessageDialog(null, (String)"To use Journeys with Gemini, you must enable Gemini in Android Studio by following the prompts in the Gemini tool window.", (String)"Enable Gemini", (String[])options, (int)1, (Icon)icon3, null);
        if (result2 == 1 && (toolWindow = ToolWindowManager.Companion.getInstance($project).getToolWindow("StudioBot")) != null) {
            toolWindow.show();
        }
    }
}

