/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.journeys.gradle;

import com.android.studio.ml.journeys.gradle.JourneysRunConfigurationKt;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.login.GoogleLoginCredentialProvider;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.project.Project;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManagerExtension;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010\u000f\u001a\u00020\u0007H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/android/studio/ml/journeys/gradle/JourneysGradleTaskManager;", "Lorg/jetbrains/plugins/gradle/service/task/GradleTaskManagerExtension;", "<init>", "()V", "configureTasks", "", "projectPath", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "settings", "Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "getCredential", "createExtraRepositoryBlock", "aiplugin.android.journeys.gradle"})
@SourceDebugExtension(value={"SMAP\nJourneysGradleTaskManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JourneysGradleTaskManager.kt\ncom/android/studio/ml/journeys/gradle/JourneysGradleTaskManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,209:1\n1#2:210\n*E\n"})
public final class JourneysGradleTaskManager
implements GradleTaskManagerExtension {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureTasks(@NotNull String projectPath, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings, @Nullable GradleVersion gradleVersion) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            if (!(((Boolean)StudioFlags.JOURNEYS_WITH_GEMINI_AUTO_GRADLE_CONFIGURATION.get()).booleanValue() && ((Boolean)StudioFlags.JOURNEYS_WITH_GEMINI_EXECUTION.get()).booleanValue() && Intrinsics.areEqual((Object)settings.getUserData(JourneysRunConfigurationKt.getJOURNEYS_RUN_CONFIG_USER_KEY()), (Object)true))) {
                return;
            }
            try {
                String string = this.getCredential();
                if (string == null) break block13;
                String credential = string;
                boolean bl = false;
                File dir = new File(System.getProperty("user.home"), ".AndroidStudioJourneysGradleTaskManager");
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                Object object = new FileAttribute[]{};
                File accessTokenFile = Files.createTempFile(dir.toPath(), "access_token", ".json", Arrays.copyOf(object, ((FileAttribute[])object).length)).toFile();
                Intrinsics.checkNotNull((Object)accessTokenFile);
                object = accessTokenFile;
                Object object2 = Charsets.UTF_8;
                object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), (Charset)object2);
                object2 = null;
                try {
                    OutputStreamWriter fw = (OutputStreamWriter)object;
                    boolean bl2 = false;
                    Writer writer = fw.append(credential);
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                }
                accessTokenFile.deleteOnExit();
                settings.withArgument("-PJourneysTestEngineInput.Proxy.accessTokenPath=" + accessTokenFile.getAbsolutePath());
            }
            catch (IOException e) {
                Notification notification;
                Project project2 = id.findProject();
                if (project2 == null) {
                    return;
                }
                Project project3 = project2;
                NotificationGroup notificationGroup = NotificationGroup.Companion.findRegisteredGroup("Gemini");
                if (notificationGroup != null && (notification = notificationGroup.createNotification("Journeys with Gemini", "Failed to retrieve authentication credentials. Please ensure you are logged in and have a stable network connection.", NotificationType.ERROR)) != null) {
                    notification.notify(project3);
                }
                Logger.getInstance(JourneysGradleTaskManager.class).error((Throwable)e);
            }
        }
        String engineClassPath = (String)StudioFlags.JOURNEYS_WITH_GEMINI_AUTO_GRADLE_CONFIGURATION_DEP.get();
        String extraRepositoryBlock = this.createExtraRepositoryBlock();
        if (((Boolean)StudioFlags.JOURNEYS_WITH_GEMINI_AUTO_GRADLE_CONFIGURATION_INIT_SCRIPT_V2.get()).booleanValue()) {
            settings.addInitScript("applyJourneysPlugin", StringsKt.trimIndent((String)("\n        settingsEvaluated { settings ->\n            settings.dependencyResolutionManagement {\n                repositoriesMode = RepositoriesMode.FAIL_ON_PROJECT_REPOS\n                repositories {\n                    " + extraRepositoryBlock + "\n                }\n            }\n        }\n        allprojects {\n            buildscript {\n                repositories {\n                    " + extraRepositoryBlock + "\n                }\n            }\n\n            def journeysPluginConfig = configurations.detachedConfiguration(\n                dependencies.create(\"" + engineClassPath + "\")\n            )\n\n            plugins.withId('com.android.application') { appPlugin ->\n                if (!plugins.hasPlugin('com.android.tools.journeys')) {\n                    var classLoader = (URLClassLoader) appPlugin.class.classLoader\n                    journeysPluginConfig.resolve().forEach {\n                        classLoader.addURL(it.toURI().toURL())\n                    }\n                    var journeysPluginClass = classLoader.loadClass('com.android.tools.journeys.JourneysGradlePlugin')\n                    pluginManager.apply(journeysPluginClass)\n                }\n            }\n        }\n        ")));
        } else {
            settings.addInitScript("applyJourneysPlugin", StringsKt.trimIndent((String)("\n        settingsEvaluated { settings ->\n            settings.dependencyResolutionManagement {\n                repositoriesMode = RepositoriesMode.FAIL_ON_PROJECT_REPOS\n                repositories {\n                    google {\n                        content {\n                            includeGroupByRegex(\"com\\\\.android.*\")\n                            includeGroupByRegex(\"com\\\\.google.*\")\n                            includeGroupByRegex(\"androidx.*\")\n                        }\n                    }\n                    mavenCentral()\n                    " + extraRepositoryBlock + "\n                }\n            }\n        }\n        allprojects {\n            buildscript {\n                repositories {\n                    google {\n                        content {\n                            includeGroupByRegex(\"com\\\\.android.*\")\n                            includeGroupByRegex(\"com\\\\.google.*\")\n                            includeGroupByRegex(\"androidx.*\")\n                        }\n                    }\n                    mavenCentral()\n                    " + extraRepositoryBlock + "\n                }\n                dependencies {\n                    classpath \"" + engineClassPath + "\"\n                }\n            }\n            plugins.withId('com.android.application') {\n                if (!plugins.hasPlugin('com.android.tools.journeys')) {\n                    // Note: Cannot apply plugin by id from init script.\n                    // https://github.com/gradle/gradle/issues/1322\n                    var journeysPluginClass = buildscript.classLoader.loadClass('com.android.tools.journeys.JourneysGradlePlugin')\n                    pluginManager.apply(journeysPluginClass)\n                }\n            }\n        }\n        ")));
        }
    }

    private final String getCredential() {
        return GoogleLoginCredentialProvider.Companion.getGeminiAccessTokenAsJson();
    }

    private final String createExtraRepositoryBlock() {
        String extraRepository = (String)StudioFlags.JOURNEYS_WITH_GEMINI_AUTO_GRADLE_CONFIGURATION_EXTRA_REPOSITORY_URL.get();
        Intrinsics.checkNotNull((Object)extraRepository);
        if (((CharSequence)extraRepository).length() == 0) {
            return "";
        }
        return StringsKt.startsWith$default((String)extraRepository, (String)"http:", (boolean)false, (int)2, null) ? StringsKt.trimIndent((String)("\n        maven {\n            url = uri(\"" + extraRepository + "\")\n            allowInsecureProtocol = true\n        }\n      ")) : StringsKt.trimIndent((String)("\n        maven {\n            url = uri(\"" + extraRepository + "\")\n        }\n      "));
    }
}

