/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.journeys.gradle;

import com.android.studio.ml.journeys.gradle.JourneysRunConfiguration;
import com.android.studio.ml.journeys.gradle.JourneysRunConfigurationType;
import com.android.tools.idea.execution.common.DeployableToDevice;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.testartifacts.testsuite.GradleRunConfigurationExtension;
import com.android.utils.StringHelper;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/android/studio/ml/journeys/gradle/JourneysRunConfigurationHelper;", "", "<init>", "()V", "Companion", "aiplugin.android.journeys.gradle"})
public final class JourneysRunConfigurationHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String RUN_ALL_JOURNEYS_CONFIGURATION_NAME = "All journeys";
    @NotNull
    public static final String JOURNEY_PLUGIN_FILTER_PARAM = "journeysFilter";

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013J.\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005J\u001e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005J(\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u001dJ \u0010\"\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0018\u0010#\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0002J\"\u0010%\u001a\u0004\u0018\u00010\u001d2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J(\u0010(\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/android/studio/ml/journeys/gradle/JourneysRunConfigurationHelper$Companion;", "", "<init>", "()V", "RUN_ALL_JOURNEYS_CONFIGURATION_NAME", "", "JOURNEY_PLUGIN_FILTER_PARAM", "isRunConfigurationForAllJourneys", "", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "module", "Lcom/intellij/openapi/module/Module;", "isRunConfigurationForJourneyFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isJourneySourceDirectory", "getJourneysTestTaskName", "gradleAndroidModel", "Lcom/android/tools/idea/gradle/project/model/GradleAndroidModel;", "applySingleJourneyConfiguration", "", "Lcom/android/studio/ml/journeys/gradle/JourneysRunConfiguration;", "journeyName", "fileName", "externalProjectPath", "journeysTestTaskName", "applyAllJourneysConfiguration", "getJourneyRunnerAndConfigurationSettings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "project", "Lcom/intellij/openapi/project/Project;", "executeJourneyRunConfiguration", "runnerAndConfigurationSettings", "applyBaseConfiguration", "createConfigurationNameFromJourneyName", "journeyFileName", "getExistingRunConfigurationSettings", "runManager", "Lcom/intellij/execution/RunManager;", "createNewRunConfigurationSettings", "getFileNameFromFilterParam", "aiplugin.android.journeys.gradle"})
    @SourceDebugExtension(value={"SMAP\nJourneysRunConfigurationHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JourneysRunConfigurationHelper.kt\ncom/android/studio/ml/journeys/gradle/JourneysRunConfigurationHelper$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 runConfigurationType.kt\ncom/intellij/execution/configurations/RunConfigurationTypeKt\n*L\n1#1,244:1\n1#2:245\n295#3,2:246\n26#4:248\n*S KotlinDebug\n*F\n+ 1 JourneysRunConfigurationHelper.kt\ncom/android/studio/ml/journeys/gradle/JourneysRunConfigurationHelper$Companion\n*L\n192#1:246,2\n204#1:248\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isRunConfigurationForAllJourneys(@NotNull RunConfiguration configuration, @NotNull Module module2) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            if (!(configuration instanceof JourneysRunConfiguration)) {
                return false;
            }
            String string = ExternalSystemApiUtil.getExternalProjectPath((Module)module2);
            if (string == null) {
                return false;
            }
            String externalProjectPath = string;
            if (!Intrinsics.areEqual((Object)((JourneysRunConfiguration)configuration).getSettings().getExternalProjectPath(), (Object)externalProjectPath)) {
                return false;
            }
            return Intrinsics.areEqual((Object)((JourneysRunConfiguration)configuration).getName(), (Object)JourneysRunConfigurationHelper.RUN_ALL_JOURNEYS_CONFIGURATION_NAME);
        }

        public final boolean isRunConfigurationForJourneyFile(@NotNull RunConfiguration configuration, @NotNull VirtualFile file, @NotNull Module module2) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            if (!(configuration instanceof JourneysRunConfiguration)) {
                return false;
            }
            VirtualFile virtualFile2 = file.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getParent(...)");
            if (!this.isJourneySourceDirectory(virtualFile2)) {
                return false;
            }
            String string = ExternalSystemApiUtil.getExternalProjectPath((Module)module2);
            if (string == null) {
                return false;
            }
            String externalProjectPathForFile = string;
            if (!Intrinsics.areEqual((Object)((JourneysRunConfiguration)configuration).getSettings().getExternalProjectPath(), (Object)externalProjectPathForFile)) {
                return false;
            }
            String string2 = this.getFileNameFromFilterParam((JourneysRunConfiguration)configuration);
            if (string2 == null) {
                return false;
            }
            String fileNameFromFilterParam = string2;
            String string3 = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            String fileNameFromContext = string3;
            return Intrinsics.areEqual((Object)fileNameFromFilterParam, (Object)fileNameFromContext);
        }

        public final boolean isJourneySourceDirectory(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return file.isDirectory() && Intrinsics.areEqual((Object)file.getName(), (Object)"journeysTest");
        }

        @NotNull
        public final String getJourneysTestTaskName(@NotNull GradleAndroidModel gradleAndroidModel) {
            Intrinsics.checkNotNullParameter((Object)gradleAndroidModel, (String)"gradleAndroidModel");
            String selectedVariant = gradleAndroidModel.getSelectedVariantName();
            return "validate" + StringHelper.usLocaleCapitalize((String)selectedVariant) + "JourneysTest";
        }

        public final void applySingleJourneyConfiguration(@NotNull JourneysRunConfiguration configuration, @NotNull String journeyName, @NotNull String fileName, @NotNull String externalProjectPath, @NotNull String journeysTestTaskName) {
            Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)journeyName, (String)"journeyName");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
            Intrinsics.checkNotNullParameter((Object)journeysTestTaskName, (String)"journeysTestTaskName");
            this.applyBaseConfiguration(configuration, externalProjectPath, journeysTestTaskName);
            configuration.setName(this.createConfigurationNameFromJourneyName(journeyName, fileName));
            String filterParam = "-PjourneysFilter=" + fileName;
            CharSequence charSequence = configuration.getSettings().getScriptParameters();
            configuration.getSettings().setScriptParameters(charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? filterParam : configuration.getSettings().getScriptParameters() + " " + filterParam);
        }

        public final void applyAllJourneysConfiguration(@NotNull JourneysRunConfiguration configuration, @NotNull String externalProjectPath, @NotNull String journeysTestTaskName) {
            Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
            Intrinsics.checkNotNullParameter((Object)journeysTestTaskName, (String)"journeysTestTaskName");
            this.applyBaseConfiguration(configuration, externalProjectPath, journeysTestTaskName);
            configuration.setName(JourneysRunConfigurationHelper.RUN_ALL_JOURNEYS_CONFIGURATION_NAME);
        }

        @Nullable
        public final RunnerAndConfigurationSettings getJourneyRunnerAndConfigurationSettings(@NotNull String journeyName, @NotNull VirtualFile file, @NotNull Project project2, @NotNull Module module2) {
            Intrinsics.checkNotNullParameter((Object)journeyName, (String)"journeyName");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            if (!((Boolean)StudioFlags.JOURNEYS_WITH_GEMINI_EXECUTION.get()).booleanValue()) {
                return null;
            }
            RunManager runManager = RunManager.Companion.getInstance(project2);
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.getExistingRunConfigurationSettings(runManager, file, module2);
            if (runnerAndConfigurationSettings == null) {
                runnerAndConfigurationSettings = this.createNewRunConfigurationSettings(runManager, file, module2, journeyName);
            }
            RunnerAndConfigurationSettings runnerAndConfigurationSettings2 = runnerAndConfigurationSettings;
            runManager.setSelectedConfiguration(runnerAndConfigurationSettings2);
            return runnerAndConfigurationSettings2;
        }

        public final void executeJourneyRunConfiguration(@NotNull RunnerAndConfigurationSettings runnerAndConfigurationSettings) {
            Intrinsics.checkNotNullParameter((Object)runnerAndConfigurationSettings, (String)"runnerAndConfigurationSettings");
            if (!((Boolean)StudioFlags.JOURNEYS_WITH_GEMINI_EXECUTION.get()).booleanValue()) {
                return;
            }
            Executor executor = DefaultRunExecutor.getRunExecutorInstance();
            ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)runnerAndConfigurationSettings, (Executor)executor);
        }

        private final void applyBaseConfiguration(JourneysRunConfiguration configuration, String externalProjectPath, String journeysTestTaskName) {
            configuration.getSettings().setTaskNames(CollectionsKt.listOf((Object)journeysTestTaskName));
            configuration.getSettings().setExternalProjectPath(externalProjectPath);
            configuration.setRunAsTest(true);
            configuration.putUserData(DeployableToDevice.getKEY(), true);
            configuration.putUserData(GradleRunConfigurationExtension.BooleanOptions.SHOW_TEST_RESULT_IN_ANDROID_TEST_SUITE_VIEW.getUserDataKey(), true);
        }

        private final String createConfigurationNameFromJourneyName(String journeyName, String journeyFileName) {
            String string;
            int ellipsisThreshold = 100;
            String it = string = journeyName;
            boolean bl = false;
            Object object = it.length() <= ellipsisThreshold ? string : null;
            if (object == null) {
                String string2 = journeyName.substring(0, ellipsisThreshold);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                object = string2 + "...";
            }
            String formattedJourneyName = object;
            return journeyFileName + " (" + formattedJourneyName + ")";
        }

        private final RunnerAndConfigurationSettings getExistingRunConfigurationSettings(RunManager runManager, VirtualFile file, Module module2) {
            Object v1;
            block1: {
                Iterable $this$firstOrNull$iv = runManager.getAllSettings();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
                    boolean bl = false;
                    RunConfiguration runConfiguration = it.getConfiguration();
                    Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
                    if (!Companion.isRunConfigurationForJourneyFile(runConfiguration, file, module2)) continue;
                    v1 = element$iv;
                    break block1;
                }
                v1 = null;
            }
            return v1;
        }

        private final RunnerAndConfigurationSettings createNewRunConfigurationSettings(RunManager runManager, VirtualFile file, Module module2, String journeyName) {
            boolean $i$f$runConfigurationType = false;
            ConfigurationFactory configurationFactory = ((JourneysRunConfigurationType)ConfigurationTypeUtil.findConfigurationType(JourneysRunConfigurationType.class)).getConfigurationFactories()[0];
            RunnerAndConfigurationSettings configuration = runManager.createConfiguration("", configurationFactory);
            String string = ExternalSystemApiUtil.getExternalProjectPath((Module)module2);
            if (string == null) {
                throw new IllegalStateException("Failed to retrieve the external project path for module '" + module2.getName() + "'.");
            }
            String externalProjectPath = string;
            RunConfiguration runConfiguration = configuration.getConfiguration();
            JourneysRunConfiguration journeysRunConfiguration = runConfiguration instanceof JourneysRunConfiguration ? (JourneysRunConfiguration)runConfiguration : null;
            if (journeysRunConfiguration == null) {
                throw new IllegalStateException("Expected configuration to be an instance of JourneysRunConfiguration, but found type " + Reflection.getOrCreateKotlinClass(configuration.getConfiguration().getClass()).getQualifiedName() + ".");
            }
            JourneysRunConfiguration runConfiguration2 = journeysRunConfiguration;
            GradleAndroidModel gradleAndroidModel = GradleAndroidModel.Companion.get(module2);
            if (gradleAndroidModel == null) {
                throw new IllegalStateException("No Gradle Android model found. Ensure the Journey file is located in an Android module.");
            }
            GradleAndroidModel androidModel = gradleAndroidModel;
            String string2 = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            this.applySingleJourneyConfiguration(runConfiguration2, journeyName, string2, externalProjectPath, this.getJourneysTestTaskName(androidModel));
            runManager.setTemporaryConfiguration(configuration);
            return configuration;
        }

        private final String getFileNameFromFilterParam(JourneysRunConfiguration configuration) {
            String string = configuration.getSettings().getScriptParameters();
            if (string == null) {
                return null;
            }
            Regex regex = new Regex("^.*-PjourneysFilter=(.*.xml).*$");
            String scriptParameters = string;
            MatchResult matches = Regex.find$default((Regex)regex, (CharSequence)scriptParameters, (int)0, (int)2, null);
            MatchResult matchResult = matches;
            return matchResult != null && (matchResult = matchResult.getGroups()) != null && (matchResult = matchResult.get(1)) != null ? matchResult.getValue() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

