/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.journeys.metrics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.annotations.concurrency.AnyThread;
import com.android.studio.ml.journeys.metrics.JourneyEngineErrorParser;
import com.android.studio.ml.journeys.metrics.JourneysTracker;
import com.android.studio.ml.journeys.run.JourneysRunToken;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.Token;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResultListener;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDevice;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCase;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestStep;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestSuite;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/android/studio/ml/journeys/metrics/JourneysTestResultMetricsListener;", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResultListener;", "journeysTracker", "Lcom/android/studio/ml/journeys/metrics/JourneysTracker;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/android/studio/ml/journeys/metrics/JourneysTracker;Lcom/intellij/openapi/project/Project;)V", "journeysRunToken", "Lcom/android/studio/ml/journeys/run/JourneysRunToken;", "Lcom/android/tools/idea/projectsystem/AndroidProjectSystem;", "getJourneysRunToken", "()Lcom/android/studio/ml/journeys/run/JourneysRunToken;", "journeysRunToken$delegate", "Lkotlin/Lazy;", "onTestCaseFinished", "", "device", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDevice;", "testSuite", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestSuite;", "testCase", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestCase;", "onTestSuiteFinished", "isJourneyTestSuite", "", "aiplugin.android.journeys"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nJourneysTestResultMetricsListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JourneysTestResultMetricsListener.kt\ncom/android/studio/ml/journeys/metrics/JourneysTestResultMetricsListener\n+ 2 Token.kt\ncom/android/tools/idea/projectsystem/TokenKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n47#2:81\n669#3,11:82\n*S KotlinDebug\n*F\n+ 1 JourneysTestResultMetricsListener.kt\ncom/android/studio/ml/journeys/metrics/JourneysTestResultMetricsListener\n*L\n45#1:81\n45#1:82,11\n*E\n"})
public final class JourneysTestResultMetricsListener
implements AndroidTestResultListener {
    @NotNull
    private final JourneysTracker journeysTracker;
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy journeysRunToken$delegate;
    public static final int $stable = 8;

    public JourneysTestResultMetricsListener(@NotNull JourneysTracker journeysTracker, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)journeysTracker, (String)"journeysTracker");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.journeysTracker = journeysTracker;
        this.project = project2;
        this.journeysRunToken$delegate = LazyKt.lazy(() -> JourneysTestResultMetricsListener.journeysRunToken_delegate$lambda$0(this));
    }

    private final JourneysRunToken<AndroidProjectSystem> getJourneysRunToken() {
        Lazy lazy = this.journeysRunToken$delegate;
        return (JourneysRunToken)lazy.getValue();
    }

    public void onTestCaseFinished(@NotNull AndroidDevice device, @NotNull AndroidTestSuite testSuite, @NotNull AndroidTestCase testCase) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)testSuite, (String)"testSuite");
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        if (!this.isJourneyTestSuite(testSuite)) {
            return;
        }
        String errorStackTrace = testCase.getErrorStackTrace();
        if (((CharSequence)errorStackTrace).length() == 0) {
            return;
        }
        String string = JourneyEngineErrorParser.Companion.tryToParseReasonFromEngineException(errorStackTrace);
        if (string == null) {
            return;
        }
        String reason = string;
        this.journeysTracker.trackJourneyError(reason);
    }

    public void onTestSuiteFinished(@NotNull AndroidDevice device, @NotNull AndroidTestSuite testSuite) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)testSuite, (String)"testSuite");
        if (!this.isJourneyTestSuite(testSuite)) {
            return;
        }
        this.journeysTracker.trackJourneyFinished(testSuite.getResult());
    }

    private final boolean isJourneyTestSuite(AndroidTestSuite testSuite) {
        RunConfiguration runConfiguration = testSuite.getRunConfiguration();
        if (runConfiguration == null) {
            return false;
        }
        RunConfiguration runConfiguration2 = runConfiguration;
        JourneysRunToken<AndroidProjectSystem> journeysRunToken = this.getJourneysRunToken();
        return journeysRunToken != null ? journeysRunToken.isRunConfigurationForJourney(runConfiguration2) : false;
    }

    @AnyThread
    public void onRerunScheduled(@NotNull AndroidDevice device) {
        super.onRerunScheduled(device);
    }

    @AnyThread
    public void onTestCaseStarted(@NotNull AndroidDevice device, @NotNull AndroidTestSuite testSuite, @NotNull AndroidTestCase testCase) {
        super.onTestCaseStarted(device, testSuite, testCase);
    }

    @AnyThread
    public void onTestStepFinished(@NotNull AndroidDevice device, @NotNull AndroidTestCase testCase, @NotNull AndroidTestStep testStep) {
        super.onTestStepFinished(device, testCase, testStep);
    }

    @AnyThread
    public void onTestStepStarted(@NotNull AndroidDevice device, @NotNull AndroidTestCase testCase, @NotNull AndroidTestStep testStep) {
        super.onTestStepStarted(device, testCase, testStep);
    }

    @AnyThread
    public void onTestSuiteScheduled(@NotNull AndroidDevice device) {
        super.onTestSuiteScheduled(device);
    }

    @AnyThread
    public void onTestSuiteStarted(@NotNull AndroidDevice device, @NotNull AndroidTestSuite testSuite) {
        super.onTestSuiteStarted(device, testSuite);
    }

    /*
     * WARNING - void declaration
     */
    private static final JourneysRunToken journeysRunToken_delegate$lambda$0(JourneysTestResultMetricsListener this$0) {
        Object v0;
        block2: {
            AndroidProjectSystem projectSystem;
            AndroidProjectSystem androidProjectSystem = projectSystem = ProjectSystemUtil.getProjectSystem((Project)this$0.project);
            ExtensionPointName<JourneysRunToken<AndroidProjectSystem>> extensionPointName$iv = JourneysRunToken.Companion.getEP_NAME();
            boolean $i$f$getTokenOrNull = false;
            Iterable $this$singleOrNull$iv$iv = extensionPointName$iv.getExtensionList();
            boolean $i$f$singleOrNull = false;
            Object single$iv$iv = null;
            boolean found$iv$iv = false;
            for (Object element$iv$iv : $this$singleOrNull$iv$iv) {
                void $this$getTokenOrNull$iv;
                Token it$iv = (Token)element$iv$iv;
                boolean bl = false;
                if (!it$iv.isApplicable((AndroidProjectSystem)$this$getTokenOrNull$iv)) continue;
                if (found$iv$iv) {
                    v0 = null;
                    break block2;
                }
                single$iv$iv = element$iv$iv;
                found$iv$iv = true;
            }
            v0 = !found$iv$iv ? null : single$iv$iv;
        }
        return (JourneysRunToken)((Token)v0);
    }
}

