/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.journeys.metrics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestSuiteResult;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.JourneyEngineErrorEvent;
import com.google.wireless.android.sdk.stats.JourneyFinishedEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\f\u0010\u000b\u001a\u00020\f*\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/android/studio/ml/journeys/metrics/JourneysTracker;", "", "<init>", "()V", "trackJourneyFinished", "", "testSuiteResult", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestSuiteResult;", "trackJourneyError", "reason", "", "mapToMetricsType", "Lcom/google/wireless/android/sdk/stats/JourneyFinishedEvent$TestResult;", "mapErrorType", "Lcom/google/wireless/android/sdk/stats/JourneyEngineErrorEvent$ErrorType;", "aiplugin.android.journeys"})
@StabilityInferred(parameters=1)
public final class JourneysTracker {
    public static final int $stable;

    public final void trackJourneyFinished(@Nullable AndroidTestSuiteResult testSuiteResult) {
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.JOURNEY_FINISHED_EVENT);
        JourneyFinishedEvent.Builder builder2 = builder.getJourneyFinishedEventBuilder();
        AndroidTestSuiteResult androidTestSuiteResult = testSuiteResult;
        if (androidTestSuiteResult == null || (androidTestSuiteResult = this.mapToMetricsType(androidTestSuiteResult)) == null) {
            androidTestSuiteResult = JourneyFinishedEvent.TestResult.UNKNOWN;
        }
        builder2.setTestResult((JourneyFinishedEvent.TestResult)androidTestSuiteResult);
        Intrinsics.checkNotNull((Object)builder);
        UsageTracker.log((AndroidStudioEvent.Builder)builder);
    }

    public final void trackJourneyError(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.JOURNEY_ENGINE_ERROR_EVENT);
        builder.getJourneyEngineErrorEventBuilder().setErrorType(this.mapErrorType(reason));
        Intrinsics.checkNotNull((Object)builder);
        UsageTracker.log((AndroidStudioEvent.Builder)builder);
    }

    private final JourneyFinishedEvent.TestResult mapToMetricsType(AndroidTestSuiteResult $this$mapToMetricsType) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$mapToMetricsType.ordinal()]) {
            case 1 -> JourneyFinishedEvent.TestResult.PASSED;
            case 2 -> JourneyFinishedEvent.TestResult.FAILED;
            case 3 -> JourneyFinishedEvent.TestResult.CANCELED;
            case 4 -> JourneyFinishedEvent.TestResult.ABORTED;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final JourneyEngineErrorEvent.ErrorType mapErrorType(String reason) {
        return switch (reason) {
            case "ADB_INSTALL_FAILED" -> JourneyEngineErrorEvent.ErrorType.ADB_INSTALL_FAILED;
            case "ADB_FORWARDING_FAILED" -> JourneyEngineErrorEvent.ErrorType.ADB_FORWARDING_FAILED;
            case "ROBO_PORT_EXTRACTION_FAILED" -> JourneyEngineErrorEvent.ErrorType.ROBO_PORT_EXTRACTION_FAILED;
            case "INSTRUMENTATION_FAILED" -> JourneyEngineErrorEvent.ErrorType.INSTRUMENTATION_FAILED;
            case "JOURNEY_READ_FAILED" -> JourneyEngineErrorEvent.ErrorType.JOURNEY_READ_FAILED;
            case "AUTHENTICATION_FAILED" -> JourneyEngineErrorEvent.ErrorType.AUTHENTICATION_FAILED;
            case "UNKNOWN_FAILURE" -> JourneyEngineErrorEvent.ErrorType.UNKNOWN_ERROR;
            default -> JourneyEngineErrorEvent.ErrorType.UNKNOWN_ERROR;
        };
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AndroidTestSuiteResult.values().length];
            try {
                nArray[AndroidTestSuiteResult.PASSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidTestSuiteResult.FAILED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidTestSuiteResult.CANCELLED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidTestSuiteResult.ABORTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

