/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.prompting;

import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.ui.graphics.painter.Painter;
import androidx.compose.ui.text.TextRange;
import com.android.studio.ml.SmlConversation;
import com.android.studio.ml.bot.ui.compose.LoadablePainter;
import com.android.studio.ml.bot.ui.compose.timeline.Attachment;
import com.android.studio.ml.bot.ui.compose.timeline.AttachmentKt;
import com.android.studio.ml.bot.ui.compose.timeline.ContextDrawerAttachment;
import com.android.studio.ml.bot.ui.compose.timeline.ImageAttachment;
import com.android.studio.ml.bot.ui.compose.timeline.LocalFileAttachment;
import com.android.tools.idea.studiobot.mimetype.MimeTypeUtilsKt;
import com.android.tools.idea.studiobot.prompts.Prompt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a2\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b*\u00020\u0015\u001a\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000b*\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005\u001a\n\u0010\u0018\u001a\u00020\u0015*\u00020\u0012\u001a\u000e\u0010\u0019\u001a\u0004\u0018\u00010\t*\u00020\u001aH\u0007\u001a\n\u0010\u0019\u001a\u00020\t*\u00020\u0015\u001a\f\u0010\u001b\u001a\u0004\u0018\u00010\u0015*\u00020\u0012\u001a\f\u0010\u001c\u001a\u0004\u0018\u00010\u0015*\u00020\u0012\u001a\u0012\u0010\u001d\u001a\u00020\u0017*\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u001e*\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u0005\u001a\f\u0010 \u001a\u0004\u0018\u00010!*\u00020\u0017\u00a8\u0006\""}, d2={"getSelectionOrNull", "Lcom/intellij/openapi/util/TextRange;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "makeSmlConversationRequest", "Lcom/android/studio/ml/SmlConversation$Request;", "displayText", "", "attachments", "", "Lcom/android/studio/ml/bot/ui/compose/timeline/Attachment;", "inlineReferenceRanges", "Landroidx/compose/ui/text/TextRange;", "isMarkdown", "", "extractAttachments", "Lcom/android/tools/idea/studiobot/prompts/Prompt;", "extractBlobAttachments", "Lcom/android/studio/ml/bot/ui/compose/timeline/Attachment$InMemoryImage;", "Lcom/android/tools/idea/studiobot/prompts/Prompt$Message;", "extractFileAttachments", "Lcom/android/studio/ml/bot/ui/compose/timeline/ContextDrawerAttachment;", "lastMessage", "queryString", "Lcom/android/tools/idea/studiobot/prompts/Prompt$Chunk;", "ruleMessage", "systemMessage", "toContextDrawerAttachment", "Lcom/android/tools/idea/studiobot/prompts/Prompt$ContextFile;", "toContextFileOrNull", "toRemoteContextOrNull", "Lcom/android/tools/idea/studiobot/prompts/Prompt$RemoteContext;", "aiplugin.core.aicore"})
@SourceDebugExtension(value={"SMAP\nPromptUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PromptUtils.kt\ncom/android/studio/ml/prompting/PromptUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,189:1\n669#2,11:190\n669#2,11:201\n1611#2,9:212\n1863#2:221\n1864#2:223\n1620#2:224\n808#2,11:225\n1368#2:236\n1454#2,2:237\n1557#2:239\n1628#2,3:240\n1456#2,3:243\n808#2,11:246\n1611#2,9:257\n1863#2:266\n1864#2:268\n1620#2:269\n1#3:222\n1#3:267\n1#3:270\n*S KotlinDebug\n*F\n+ 1 PromptUtils.kt\ncom/android/studio/ml/prompting/PromptUtilsKt\n*L\n46#1:190,11\n52#1:201,11\n60#1:212,9\n60#1:221\n60#1:223\n60#1:224\n67#1:225,11\n67#1:236\n67#1:237,2\n68#1:239\n68#1:240,3\n67#1:243,3\n73#1:246,11\n73#1:257,9\n73#1:266\n73#1:268\n73#1:269\n60#1:222\n73#1:267\n*E\n"})
public final class PromptUtilsKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Prompt.Message systemMessage(@NotNull Prompt $this$systemMessage) {
        Object object;
        block2: {
            void var3_3;
            Intrinsics.checkNotNullParameter((Object)$this$systemMessage, (String)"<this>");
            Iterable $this$singleOrNull$iv = $this$systemMessage.getMessages();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                Prompt.Message it = (Prompt.Message)element$iv;
                boolean bl = false;
                if (!(it instanceof Prompt.SystemMessage)) continue;
                if (found$iv) {
                    object = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            object = !found$iv ? null : var3_3;
        }
        return (Prompt.Message)object;
    }

    @NotNull
    public static final Prompt.Message lastMessage(@NotNull Prompt $this$lastMessage) {
        Intrinsics.checkNotNullParameter((Object)$this$lastMessage, (String)"<this>");
        return (Prompt.Message)CollectionsKt.last($this$lastMessage.getMessages());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Prompt.Message ruleMessage(@NotNull Prompt $this$ruleMessage) {
        Object object;
        block2: {
            void var3_3;
            Intrinsics.checkNotNullParameter((Object)$this$ruleMessage, (String)"<this>");
            Iterable $this$singleOrNull$iv = $this$ruleMessage.getMessages();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                Prompt.Message it = (Prompt.Message)element$iv;
                boolean bl = false;
                if (!(it instanceof Prompt.RuleMessage)) continue;
                if (found$iv) {
                    object = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            object = !found$iv ? null : var3_3;
        }
        return (Prompt.Message)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String queryString(@NotNull Prompt.Message $this$queryString) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$queryString, (String)"<this>");
        Iterable $this$mapNotNull$iv = $this$queryString.getChunks();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Prompt.Chunk it = (Prompt.Chunk)element$iv$iv;
            boolean bl2 = false;
            if (PromptUtilsKt.queryString(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public static final List<Attachment> extractAttachments(@NotNull Prompt $this$extractAttachments, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)$this$extractAttachments, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return CollectionsKt.plus((Collection)PromptUtilsKt.extractBlobAttachments(PromptUtilsKt.lastMessage($this$extractAttachments)), (Iterable)PromptUtilsKt.extractFileAttachments($this$extractAttachments, project2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ContextDrawerAttachment> extractFileAttachments(@NotNull Prompt $this$extractFileAttachments, @NotNull Project project2) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$extractFileAttachments, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Iterable $this$filterIsInstance$iv = $this$extractFileAttachments.getMessages();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Prompt.ContextMessage)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            Prompt.ContextMessage it = (Prompt.ContextMessage)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = it.getFiles();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void file;
                Prompt.ContextFile contextFile = (Prompt.ContextFile)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(PromptUtilsKt.toContextDrawerAttachment((Prompt.ContextFile)file, project2));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Attachment.InMemoryImage> extractBlobAttachments(@NotNull Prompt.Message $this$extractBlobAttachments) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$extractBlobAttachments, (String)"<this>");
        Iterable $this$filterIsInstance$iv = $this$extractBlobAttachments.getChunks();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Prompt.BlobChunk)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Attachment.InMemoryImage inMemoryImage;
            Path path2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Prompt.BlobChunk chunk = (Prompt.BlobChunk)element$iv$iv;
            boolean bl2 = false;
            Map<String, Object> map2 = chunk.getExtraData();
            Object object = map2 != null ? map2.get("AttachmentId") : null;
            String id = object instanceof String ? (String)object : null;
            Map<String, Object> map3 = chunk.getExtraData();
            Object object2 = map3 != null ? map3.get("AttachmentPath") : null;
            Path path3 = path2 = object2 instanceof Path ? (Path)object2 : null;
            if (id == null || path2 == null) {
                inMemoryImage = null;
            } else if (ImageAttachment.SupportedImageTypes.INSTANCE.isSupportedImageMimeType-qru2Y28(chunk.getMimeType-i_3W7CY())) {
                Map<String, Object> map4 = chunk.getExtraData();
                Object object3 = map4 != null ? map4.get("AttachmentPainter") : null;
                if ((object3 instanceof Painter ? (Painter)object3 : null) == null) {
                    inMemoryImage = null;
                } else {
                    Painter painter2;
                    painter2 = painter2;
                    inMemoryImage = new Attachment.InMemoryImage(id, path2, chunk.getMimeType-i_3W7CY(), (State)SnapshotStateKt.mutableStateOf$default((Object)new LoadablePainter.Loaded(painter2, chunk.getData()), null, (int)2, null), null);
                }
            } else {
                inMemoryImage = null;
            }
            if (inMemoryImage == null) continue;
            Attachment.InMemoryImage it$iv$iv = inMemoryImage;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Language(value="Markdown")
    @Nullable
    public static final String queryString(@NotNull Prompt.Chunk $this$queryString) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$queryString, (String)"<this>");
        Prompt.Chunk chunk = $this$queryString;
        if (chunk instanceof Prompt.TextChunk) {
            string = ((Prompt.TextChunk)$this$queryString).getText();
        } else if (chunk instanceof Prompt.CodeChunk) {
            String string2 = ((Prompt.CodeChunk)$this$queryString).getLanguage-_TXXkdE();
            if (string2 == null || (string2 = MimeTypeUtilsKt.markdownLanguageName-qru2Y28(string2)) == null) {
                string2 = "";
            }
            string = StringsKt.trimMargin$default((String)("\n      |```" + string2 + "\n      |" + ((Prompt.CodeChunk)$this$queryString).getText() + "\n      |```\n      "), null, (int)1, null);
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public static final SmlConversation.Request makeSmlConversationRequest(@NotNull String displayText, @NotNull List<? extends Attachment> attachments, @NotNull List<TextRange> inlineReferenceRanges, boolean isMarkdown) {
        Intrinsics.checkNotNullParameter((Object)displayText, (String)"displayText");
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        Intrinsics.checkNotNullParameter(inlineReferenceRanges, (String)"inlineReferenceRanges");
        return new SmlConversation.Request(displayText, null, attachments, inlineReferenceRanges, isMarkdown, 2, null);
    }

    private static final com.intellij.openapi.util.TextRange getSelectionOrNull(VirtualFile virtualFile2, Project project2) {
        return (com.intellij.openapi.util.TextRange)ActionsKt.runReadAction((Function0)((Function0)new Function0<com.intellij.openapi.util.TextRange>(project2, virtualFile2){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $virtualFile;
            {
                this.$project = $project;
                this.$virtualFile = $virtualFile;
                super(0);
            }

            public final com.intellij.openapi.util.TextRange invoke() {
                Editor currentEditor;
                Editor editor = currentEditor = FileEditorManager.getInstance((Project)this.$project).getSelectedTextEditor();
                if (!Intrinsics.areEqual((Object)(editor != null ? editor.getVirtualFile() : null), (Object)this.$virtualFile)) {
                    return null;
                }
                SelectionModel selectionModel = currentEditor.getSelectionModel();
                Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
                SelectionModel selectionModel2 = selectionModel;
                return new com.intellij.openapi.util.TextRange(selectionModel2.getSelectionStart(), selectionModel2.getSelectionEnd());
            }
        }));
    }

    @Nullable
    public static final Prompt.ContextFile toContextFileOrNull(@NotNull ContextDrawerAttachment $this$toContextFileOrNull, @NotNull Project project2) {
        Prompt.ContextFile contextFile;
        Intrinsics.checkNotNullParameter((Object)$this$toContextFileOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (!($this$toContextFileOrNull instanceof LocalFileAttachment)) {
            return null;
        }
        VirtualFile virtualFile2 = VirtualFileManager.getInstance().findFileByNioPath(((LocalFileAttachment)((Object)$this$toContextFileOrNull)).getPath());
        if (virtualFile2 != null) {
            VirtualFile virtualFile3 = virtualFile2;
            boolean bl = false;
            ContextDrawerAttachment contextDrawerAttachment = $this$toContextFileOrNull;
            if (contextDrawerAttachment instanceof Attachment.TextFile) {
                com.intellij.openapi.util.TextRange selection = ((Attachment.TextFile)$this$toContextFileOrNull).isCurrentFile() ? PromptUtilsKt.getSelectionOrNull(virtualFile3, project2) : null;
                Object object = ActionsKt.runReadAction((Function0)((Function0)new Function0<String>(virtualFile3){
                    final /* synthetic */ VirtualFile $virtualFile;
                    {
                        this.$virtualFile = $virtualFile;
                        super(0);
                    }

                    public final String invoke() {
                        VirtualFile virtualFile2 = this.$virtualFile;
                        Intrinsics.checkNotNull((Object)virtualFile2);
                        Object object = VirtualFileUtil.findDocument((VirtualFile)virtualFile2);
                        if (object == null || (object = object.getText()) == null) {
                            VirtualFile virtualFile3 = this.$virtualFile;
                            Intrinsics.checkNotNull((Object)virtualFile3);
                            object = VirtualFileUtil.readText((VirtualFile)virtualFile3);
                        }
                        return object;
                    }
                }));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
                String fileText2 = (String)object;
                boolean bl2 = $this$toContextFileOrNull.getAttachedByUser();
                boolean bl3 = ((Attachment.TextFile)$this$toContextFileOrNull).isCurrentFile();
                contextFile = new Prompt.ContextFile(virtualFile3, fileText2, bl3, selection, bl2);
            } else {
                contextFile = contextDrawerAttachment instanceof Attachment.Folder ? new Prompt.ContextFile(virtualFile3, null, false, null, $this$toContextFileOrNull.getAttachedByUser(), 12, null) : null;
            }
        } else {
            contextFile = null;
        }
        return contextFile;
    }

    @Nullable
    public static final Prompt.RemoteContext toRemoteContextOrNull(@NotNull ContextDrawerAttachment $this$toRemoteContextOrNull) {
        Prompt.RemoteContext remoteContext;
        Intrinsics.checkNotNullParameter((Object)$this$toRemoteContextOrNull, (String)"<this>");
        Attachment.RemoteContextAttachment remoteContextAttachment = $this$toRemoteContextOrNull instanceof Attachment.RemoteContextAttachment ? (Attachment.RemoteContextAttachment)$this$toRemoteContextOrNull : null;
        if (remoteContextAttachment != null) {
            Attachment.RemoteContextAttachment it = remoteContextAttachment;
            boolean bl = false;
            remoteContext = new Prompt.RemoteContext(it.getId(), it.getMetadata());
        } else {
            remoteContext = null;
        }
        return remoteContext;
    }

    @NotNull
    public static final ContextDrawerAttachment toContextDrawerAttachment(@NotNull Prompt.ContextFile $this$toContextDrawerAttachment, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)$this$toContextDrawerAttachment, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return AttachmentKt.toContextDrawerAttachment($this$toContextDrawerAttachment.getVirtualFile(), project2, null, $this$toContextDrawerAttachment.getAttachedByUser());
    }
}

