/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.releasenotes;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.ide.common.repository.IdeNetworkCacheUtils;
import com.android.ide.common.repository.NetworkCache;
import com.android.studio.ml.releasenotes.ReleaseNotesContentProvider;
import com.intellij.openapi.application.PathManager;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0002\u000b\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/studio/ml/releasenotes/ReleaseNotesContentProviderImpl;", "Lcom/android/studio/ml/releasenotes/ReleaseNotesContentProvider;", "cache", "Lcom/android/ide/common/repository/NetworkCache;", "<init>", "(Lcom/android/ide/common/repository/NetworkCache;)V", "()V", "getReleaseNotes", "Lcom/android/studio/ml/releasenotes/ReleaseNotesContentProvider$ReleaseNotesContent;", "url", "Ljava/net/URL;", "ReleaseNotesCache", "Companion", "aiplugin.android"})
@StabilityInferred(parameters=0)
public final class ReleaseNotesContentProviderImpl
implements ReleaseNotesContentProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NetworkCache cache;
    public static final int $stable = 8;
    @NotNull
    private static final String RELEASE_NOTES_CACHE_PATH = "agent-rel-notes";

    public ReleaseNotesContentProviderImpl(@NotNull NetworkCache cache) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this.cache = cache;
    }

    public ReleaseNotesContentProviderImpl() {
        this(new ReleaseNotesCache(null, 1, null));
    }

    @Override
    @Nullable
    public ReleaseNotesContentProvider.ReleaseNotesContent getReleaseNotes(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = url.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        InputStream result2 = this.cache.findData(string, false);
        if (result2 != null) {
            String content2 = new String(ByteStreamsKt.readBytes((InputStream)result2), Charsets.UTF_8);
            return new ReleaseNotesContentProvider.ReleaseNotesContent(content2, ReleaseNotesContentProvider.ContentFormat.HTML);
        }
        return null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/studio/ml/releasenotes/ReleaseNotesContentProviderImpl$Companion;", "", "<init>", "()V", "RELEASE_NOTES_CACHE_PATH", "", "aiplugin.android"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0014J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/android/studio/ml/releasenotes/ReleaseNotesContentProviderImpl$ReleaseNotesCache;", "Lcom/android/ide/common/repository/NetworkCache;", "baseUrl", "", "<init>", "(Ljava/lang/String;)V", "readUrlData", "Lcom/android/ide/common/repository/NetworkCache$ReadUrlDataResult;", "url", "timeout", "", "lastModified", "", "readDefaultData", "Ljava/io/InputStream;", "relative", "error", "", "throwable", "", "message", "aiplugin.android"})
    private static final class ReleaseNotesCache
    extends NetworkCache {
        public ReleaseNotesCache(@NotNull String baseUrl) {
            Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
            String[] stringArray = new String[]{ReleaseNotesContentProviderImpl.RELEASE_NOTES_CACHE_PATH};
            super(baseUrl, Paths.get(PathManager.getSystemPath(), stringArray), 0, (int)TimeUnit.DAYS.toHours(1L), true, 4, null);
        }

        public /* synthetic */ ReleaseNotesCache(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            this(string);
        }

        @NotNull
        protected NetworkCache.ReadUrlDataResult readUrlData(@NotNull String url, int timeout, long lastModified) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return IdeNetworkCacheUtils.Companion.readHttpUrlData$default((IdeNetworkCacheUtils.Companion)IdeNetworkCacheUtils.Companion, (String)url, (int)timeout, (long)lastModified, null, (int)8, null);
        }

        @Nullable
        protected InputStream readDefaultData(@NotNull String relative) {
            Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
            return null;
        }

        public void error(@NotNull Throwable throwable, @Nullable String message) {
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        }

        public ReleaseNotesCache() {
            this(null, 1, null);
        }
    }
}

