/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.releasenotes;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.releasenotes.ReleaseNotes;
import com.android.studio.ml.releasenotes.ReleaseNotesContentProvider;
import com.android.studio.ml.releasenotes.ReleaseNotesExtractor;
import com.android.studio.ml.releasenotes.ReleaseNotesFetcher;
import com.android.studio.ml.releasenotes.ReleaseNotesQuery;
import com.android.studio.ml.releasenotes.fetchers.AgpReleaseNotesFetcher;
import com.android.studio.ml.releasenotes.fetchers.FirebaseReleaseNotesFetcher;
import com.android.studio.ml.releasenotes.fetchers.GithubChangeLogFetcher;
import com.android.studio.ml.releasenotes.fetchers.JetpackReleaseNotesFetcher;
import com.intellij.openapi.project.Project;
import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000f\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/android/studio/ml/releasenotes/ReleaseNotesExtractorImpl;", "Lcom/android/studio/ml/releasenotes/ReleaseNotesExtractor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getReleaseNotesUrl", "Ljava/net/URL;", "query", "Lcom/android/studio/ml/releasenotes/ReleaseNotesQuery;", "getReleaseNotes", "", "Lcom/android/studio/ml/releasenotes/ReleaseNotes;", "request", "findFetcher", "Lcom/android/studio/ml/releasenotes/ReleaseNotesFetcher;", "Companion", "aiplugin.android"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nReleaseNotesExtractorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReleaseNotesExtractorImpl.kt\ncom/android/studio/ml/releasenotes/ReleaseNotesExtractorImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n295#2,2:76\n*S KotlinDebug\n*F\n+ 1 ReleaseNotesExtractorImpl.kt\ncom/android/studio/ml/releasenotes/ReleaseNotesExtractorImpl\n*L\n68#1:76,2\n*E\n"})
public final class ReleaseNotesExtractorImpl
implements ReleaseNotesExtractor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    public static final int $stable = 8;
    @NotNull
    public static final String GRADLE_WRAPPER_NAME = "Gradle Wrapper";

    public ReleaseNotesExtractorImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @Nullable
    public URL getReleaseNotesUrl(@NotNull ReleaseNotesQuery query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        ReleaseNotesFetcher releaseNotesFetcher = this.findFetcher(query);
        return releaseNotesFetcher != null ? releaseNotesFetcher.getReleaseNotesUrl(query) : null;
    }

    @Override
    @Nullable
    public List<ReleaseNotes> getReleaseNotes(@NotNull ReleaseNotesQuery request2) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
                ReleaseNotesContentProvider contentProvider = (ReleaseNotesContentProvider)this.project.getService(ReleaseNotesContentProvider.class);
                object = this.findFetcher(request2);
                if (object == null) break block2;
                Intrinsics.checkNotNull((Object)contentProvider);
                if ((object = object.fetch(request2, contentProvider)) != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final ReleaseNotesFetcher findFetcher(ReleaseNotesQuery request2) {
        Object v0;
        block5: {
            Object[] objectArray = new ReleaseNotesFetcher[]{new JetpackReleaseNotesFetcher(), new FirebaseReleaseNotesFetcher(), new AgpReleaseNotesFetcher(), new GithubChangeLogFetcher()};
            List specificFetchers = CollectionsKt.listOf((Object[])objectArray);
            if (StringsKt.endsWith$default((String)request2.getLibrary().getArtifact(), (String)"-bom", (boolean)false, (int)2, null)) {
                return null;
            }
            if (Intrinsics.areEqual((Object)request2.getLibrary().getArtifact(), (Object)GRADLE_WRAPPER_NAME)) {
                return null;
            }
            if (StringsKt.startsWith$default((String)request2.getLibrary().getGroup(), (String)"kotlin.", (boolean)false, (int)2, null)) {
                return null;
            }
            if (StringsKt.startsWith$default((String)request2.getLibrary().getGroup(), (String)"com.android.tools.build", (boolean)false, (int)2, null)) {
                return null;
            }
            Iterable $this$firstOrNull$iv = specificFetchers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ReleaseNotesFetcher it = (ReleaseNotesFetcher)element$iv;
                boolean bl = false;
                if (!it.canHandle(request2.getLibrary())) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        return v0;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/studio/ml/releasenotes/ReleaseNotesExtractorImpl$Companion;", "", "<init>", "()V", "GRADLE_WRAPPER_NAME", "", "aiplugin.android"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

