/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.releasenotes.fetchers;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.ide.common.gradle.Version;
import com.android.ide.common.repository.GoogleMavenRepository;
import com.android.ide.common.repository.IdeNetworkCacheUtils;
import com.android.ide.common.repository.NetworkCache;
import com.android.studio.ml.releasenotes.MavenLibrary;
import com.android.studio.ml.releasenotes.ReleaseNotes;
import com.android.studio.ml.releasenotes.ReleaseNotesContentProvider;
import com.android.studio.ml.releasenotes.ReleaseNotesFetcher;
import com.android.studio.ml.releasenotes.ReleaseNotesQuery;
import com.android.studio.ml.releasenotes.ReleaseNotesUtils;
import com.android.tools.lint.checks.GradleDetector;
import com.intellij.openapi.application.PathManager;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 $2\u00020\u0001:\u0001$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J2\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00050\u0019H\u0014J&\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J#\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0016H\u0001\u00a2\u0006\u0002\b\u001eJ\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0016H\u0002J\"\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006%"}, d2={"Lcom/android/studio/ml/releasenotes/fetchers/AgpReleaseNotesFetcher;", "Lcom/android/studio/ml/releasenotes/ReleaseNotesFetcher;", "<init>", "()V", "canHandle", "", "library", "Lcom/android/studio/ml/releasenotes/MavenLibrary;", "getReleaseNotesUrl", "Ljava/net/URL;", "query", "Lcom/android/studio/ml/releasenotes/ReleaseNotesQuery;", "fetch", "", "Lcom/android/studio/ml/releasenotes/ReleaseNotes;", "request", "contentProvider", "Lcom/android/studio/ml/releasenotes/ReleaseNotesContentProvider;", "getVersions", "", "Lcom/android/ide/common/gradle/Version;", "groupId", "", "artifactId", "predicate", "Lkotlin/Function1;", "getAgpReleaseNotes", "stableVersions", "version", "html", "getAgpReleaseNotes$aiplugin_android", "removeCodePre", "s", "getReleaseNotesHtmlPage", "Lcom/android/studio/ml/releasenotes/ReleaseNotesContentProvider$ReleaseNotesContent;", "isLastStable", "Companion", "aiplugin.android"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nAgpReleaseNotesFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgpReleaseNotesFetcher.kt\ncom/android/studio/ml/releasenotes/fetchers/AgpReleaseNotesFetcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,193:1\n774#2:194\n865#2,2:195\n1#3:197\n*S KotlinDebug\n*F\n+ 1 AgpReleaseNotesFetcher.kt\ncom/android/studio/ml/releasenotes/fetchers/AgpReleaseNotesFetcher\n*L\n90#1:194\n90#1:195,2\n*E\n"})
public class AgpReleaseNotesFetcher
implements ReleaseNotesFetcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;

    @Override
    public boolean canHandle(@NotNull MavenLibrary library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        return Companion.isAgpArtifact(library.getGroup() + ":" + library.getArtifact());
    }

    @Override
    @Nullable
    public URL getReleaseNotesUrl(@NotNull ReleaseNotesQuery query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return null;
    }

    @Override
    @Nullable
    public List<ReleaseNotes> fetch(@NotNull ReleaseNotesQuery request2, @NotNull ReleaseNotesContentProvider contentProvider) {
        Version oldVersion;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)contentProvider, (String)"contentProvider");
        String newVersion = request2.getTargetVersion();
        Version from = oldVersion = request2.getLibrary().getVersion();
        Version to = Version.Companion.parse(newVersion);
        Function1 stableVersionInRange = arg_0 -> AgpReleaseNotesFetcher.fetch$lambda$0(from, to, arg_0);
        Collection<Version> stableVersions = this.getVersions("com.android.tools.build", "gradle", (Function1<? super Version, Boolean>)stableVersionInRange);
        return this.getAgpReleaseNotes(stableVersions, contentProvider);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Collection<Version> getVersions(@NotNull String groupId, @NotNull String artifactId, @NotNull Function1<? super Version, Boolean> predicate) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        String[] stringArray = new String[]{"agent-agp-versions"};
        Path cacheFolder = Paths.get(PathManager.getSystemPath(), stringArray);
        File cacheDir = cacheFolder.toFile();
        cacheDir.mkdirs();
        GoogleMavenRepository repository2 = new GoogleMavenRepository(cacheFolder){

            public NetworkCache.ReadUrlDataResult readUrlData(String url, int timeout, long lastModified) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                return IdeNetworkCacheUtils.Companion.readHttpUrlData$default((IdeNetworkCacheUtils.Companion)IdeNetworkCacheUtils.Companion, (String)url, (int)timeout, (long)lastModified, null, (int)8, null);
            }

            public void error(Throwable throwable, String message) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            }
        };
        Set versions = repository2.getVersions(groupId, artifactId);
        Iterable $this$filter$iv = versions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)predicate.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<ReleaseNotes> getAgpReleaseNotes(Collection<Version> stableVersions, ReleaseNotesContentProvider contentProvider) {
        Version version = (Version)CollectionsKt.maxOrNull((Iterable)stableVersions);
        if (version == null) {
            return null;
        }
        Version lastStable = version;
        List releaseNotes = new ArrayList();
        for (Version version2 : stableVersions) {
            ReleaseNotesContentProvider.ReleaseNotesContent it;
            ReleaseNotesContentProvider.ReleaseNotesContent html = this.getReleaseNotesHtmlPage(Intrinsics.areEqual((Object)version2, (Object)lastStable), version2, contentProvider);
            if (html == null) continue;
            boolean bl = false;
            releaseNotes.addAll((Collection)this.getAgpReleaseNotes$aiplugin_android(version2, it.getContent()));
        }
        return releaseNotes;
    }

    @VisibleForTesting
    @NotNull
    public final List<ReleaseNotes> getAgpReleaseNotes$aiplugin_android(@NotNull Version version, @NotNull String html) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        int it = StringsKt.indexOf$default((CharSequence)html, (String)"<div class=\"devsite-article-body", (int)0, (boolean)false, (int)6, null);
        boolean bl = false;
        int start2 = it == -1 ? 0 : it;
        int it2 = StringsKt.indexOf$default((CharSequence)html, (String)"<devsite-content-footer", (int)0, (boolean)false, (int)6, null);
        boolean bl2 = false;
        int end = it2 == -1 ? html.length() : it2;
        String string = html.substring(start2, end);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String html2 = string;
        String cleanHtml = this.removeCodePre(html2);
        String text2 = ReleaseNotesUtils.INSTANCE.stripMarkdownJunk(ReleaseNotesUtils.INSTANCE.convertToMarkdown(cleanHtml));
        return !StringsKt.isBlank((CharSequence)text2) ? CollectionsKt.listOf((Object)new ReleaseNotes(version, text2)) : CollectionsKt.emptyList();
    }

    private final String removeCodePre(String s) {
        int preEnd;
        int start2;
        StringBuilder sb = new StringBuilder();
        int offset2 = 0;
        while ((start2 = StringsKt.indexOf$default((CharSequence)s, (String)"<pre", (int)offset2, (boolean)false, (int)4, null)) != -1 && (preEnd = StringsKt.indexOf$default((CharSequence)s, (char)'>', (int)start2, (boolean)false, (int)4, null)) != -1) {
            if (StringsKt.startsWith$default((String)s, (String)"><code", (int)preEnd, (boolean)false, (int)4, null)) {
                int codeEnd = StringsKt.indexOf$default((CharSequence)s, (char)'>', (int)(preEnd + 1), (boolean)false, (int)4, null);
                if (codeEnd == -1) break;
                String string = s.substring(offset2, preEnd + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                sb.append(string);
                int endTag = StringsKt.indexOf$default((CharSequence)s, (String)"</code></pre>", (int)codeEnd, (boolean)false, (int)4, null);
                offset2 = preEnd + 1;
                if (endTag == -1) break;
                String string2 = s.substring(codeEnd + 1, endTag);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                sb.append(string2);
                offset2 = StringsKt.indexOf$default((CharSequence)s, (String)"</pre", (int)endTag, (boolean)false, (int)4, null);
                continue;
            }
            offset2 = preEnd + 1;
        }
        String string = s.substring(offset2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        sb.append(string);
        String string3 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    private final ReleaseNotesContentProvider.ReleaseNotesContent getReleaseNotesHtmlPage(boolean isLastStable, Version version, ReleaseNotesContentProvider contentProvider) {
        if (isLastStable) {
            return contentProvider.getReleaseNotes(new URL("https://developer.android.com/build/releases/gradle-plugin"));
        }
        String url = "https://developer.android.com/build/releases/past-releases/agp-" + version.getMajor() + "-" + version.getMinor() + "-0-release-notes/index.html";
        return contentProvider.getReleaseNotes(new URL(url));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean fetch$lambda$0(Version $from, Version $to, Version version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (version.isPreview()) return false;
        if (version.isSnapshot()) return false;
        Integer n = version.getMicro();
        if (n == null) return false;
        if (n != 0) return false;
        if (version.compareTo($from) < 0) return false;
        if (version.compareTo($to) > 0) return false;
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/android/studio/ml/releasenotes/fetchers/AgpReleaseNotesFetcher$Companion;", "", "<init>", "()V", "isAgpArtifact", "", "artifactId", "", "aiplugin.android"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isAgpArtifact(@NotNull String artifactId) {
            Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
            if (StringsKt.endsWith$default((String)artifactId, (String)".gradle.plugin", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)artifactId, (CharSequence)":", (boolean)false, (int)2, null)) {
                return this.isAgpArtifact(StringsKt.substringBefore$default((String)artifactId, (String)":", null, (int)2, null));
            }
            if (GradleDetector.Companion.getALL_PLUGIN_IDS().contains(artifactId)) {
                return true;
            }
            String string = artifactId;
            switch (string.hashCode()) {
                case -1438949539: {
                    if (string.equals("android-library")) return true;
                    return false;
                }
                case -861391249: {
                    if (string.equals("android")) return true;
                    return false;
                }
                case 95303497: {
                    if (string.equals("com.android.instant-app")) return true;
                    return false;
                }
                case 65998450: {
                    if (string.equals("com.android.tools.build:gradle")) return true;
                    return false;
                }
                case 1921327114: {
                    if (!string.equals("com.android.feature")) return false;
                    return true;
                }
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

