/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.settings;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.ActiveOnboardingProvider;
import com.android.studio.ml.Authenticator;
import com.android.studio.ml.ConfigurableContributor;
import com.android.studio.ml.StudioGeminiBundle;
import com.android.studio.ml.bot.StudioBotFlags;
import com.android.studio.ml.bot.configuration.StudioBotAppSettings;
import com.android.studio.ml.bot.configuration.StudioBotAppSettingsKt;
import com.android.studio.ml.bot.ui.onboarding.OnboardingState;
import com.android.studio.ml.settings.EditorAiAppSettings;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\b\u0010\u001f\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000eR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/studio/ml/settings/EditorComponent;", "Lcom/android/studio/ml/ConfigurableContributor$SectionConfigurableContributorComponent;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "title", "", "getTitle", "()Ljava/lang/String;", "isCollapsible", "", "()Z", "isVisible", "editorSettings", "Lcom/android/studio/ml/settings/EditorAiAppSettings;", "botSettings", "Lcom/android/studio/ml/bot/configuration/StudioBotAppSettings;", "authenticator", "Lcom/android/studio/ml/Authenticator;", "onboardingState", "Lcom/android/studio/ml/bot/ui/onboarding/OnboardingState;", "row", "Lcom/intellij/ui/dsl/builder/Row;", "setupUi", "", "builder", "Lcom/intellij/ui/dsl/builder/Panel;", "update", "shouldEnable", "aiplugin.android"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nEditorConfigurableContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigurableContributor.kt\ncom/android/studio/ml/settings/EditorComponent\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,72:1\n40#2,3:73\n40#2,3:76\n31#3,2:79\n*S KotlinDebug\n*F\n+ 1 EditorConfigurableContributor.kt\ncom/android/studio/ml/settings/EditorComponent\n*L\n39#1:73,3\n41#1:76,3\n43#1:79,2\n*E\n"})
public final class EditorComponent
implements ConfigurableContributor.SectionConfigurableContributorComponent {
    @NotNull
    private final Project project;
    @NotNull
    private final String title;
    private final boolean isCollapsible;
    @NotNull
    private final EditorAiAppSettings editorSettings;
    @NotNull
    private final StudioBotAppSettings botSettings;
    @NotNull
    private final Authenticator authenticator;
    @NotNull
    private final OnboardingState onboardingState;
    private Row row;
    public static final int $stable = 8;

    public EditorComponent(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.title = StudioGeminiBundle.Companion.message("studio.gemini.settings.title", new Object[0]);
        boolean $i$f$service = false;
        Class serviceClass$iv = EditorAiAppSettings.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        this.editorSettings = (EditorAiAppSettings)object;
        $i$f$service = false;
        serviceClass$iv = StudioBotAppSettings.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object2 == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        this.botSettings = (StudioBotAppSettings)object2;
        this.authenticator = Authenticator.Companion.current();
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service2 = false;
        Class<ActiveOnboardingProvider> serviceClass$iv2 = ActiveOnboardingProvider.class;
        Object object3 = $this$service$iv.getService(serviceClass$iv2);
        if (object3 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv2);
        }
        this.onboardingState = (OnboardingState)((ActiveOnboardingProvider)object3).getOnboardingState().getValue();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean isCollapsible() {
        return this.isCollapsible;
    }

    @Override
    public boolean isVisible() {
        return StudioBotFlags.Companion.getInstance().isRenameActionEnabled();
    }

    @Override
    public void setupUi(@NotNull Panel builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Panel $this$setupUi_u24lambda_u243 = builder;
        boolean bl = false;
        this.row = Panel.row$default((Panel)$this$setupUi_u24lambda_u243, null, arg_0 -> EditorComponent.setupUi$lambda$3$lambda$2(this, arg_0), (int)1, null).visible(StudioBotFlags.Companion.getInstance().isRenameActionEnabled()).enabled(this.shouldEnable());
    }

    @Override
    public void update() {
        Row row = this.row;
        if (row == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"row");
            row = null;
        }
        row.enabled(this.shouldEnable());
    }

    private final boolean shouldEnable() {
        StateFlow<OnboardingState.State> stateFlow;
        return StudioBotAppSettingsKt.isContextSharingEnabled(this.botSettings, this.project) && this.authenticator.isAuthorized() && ((stateFlow = this.onboardingState) != null && (stateFlow = stateFlow.getCurrentState()) != null ? (OnboardingState.State)((Object)stateFlow.getValue()) : null) == OnboardingState.State.ONBOARDED;
    }

    private static final boolean setupUi$lambda$3$lambda$2$lambda$0(EditorComponent this$0) {
        return this$0.editorSettings.getEnableSmartSuggestion();
    }

    private static final Unit setupUi$lambda$3$lambda$2$lambda$1(EditorComponent this$0, boolean it) {
        this$0.editorSettings.setEnableSmartSuggestion(it);
        return Unit.INSTANCE;
    }

    private static final Unit setupUi$lambda$3$lambda$2(EditorComponent this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.bindSelected((Cell)Cell.comment$default((Cell)$this$row.checkBox(StudioGeminiBundle.Companion.message("studio.gemini.settings.rename.title", new Object[0])), (String)StudioGeminiBundle.Companion.message("studio.gemini.settings.rename.comment", new Object[0]), (int)0, null, (int)6, null), () -> EditorComponent.setupUi$lambda$3$lambda$2$lambda$0(this$0), arg_0 -> EditorComponent.setupUi$lambda$3$lambda$2$lambda$1(this$0, arg_0));
        return Unit.INSTANCE;
    }
}

