/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.suggestion.controls.viewmodel;

import com.android.studio.ml.suggestion.AnchoredDiffChunk;
import com.android.studio.ml.suggestion.controls.viewmodel.CodeDisplayKt;
import com.android.studio.ml.suggestion.controls.viewmodel.CodeDisplayRow;
import com.android.studio.ml.suggestion.controls.viewmodel.CodeDisplaySnippet;
import com.android.studio.ml.suggestion.controls.viewmodel.ConstructedDocument;
import com.android.studio.ml.suggestion.controls.viewmodel.DiffStyle;
import com.android.studio.ml.suggestion.grouping.GroupedChange;
import com.android.studio.ml.suggestion.grouping.LineLevelChange;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a?\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\b\fH\u0001\u001a(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a0\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00032\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a$\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00032\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a$\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00032\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a.\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u00032\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a \u0010'\u001a\u00020$2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$2\u0006\u0010(\u001a\u00020\u0011H\u0001\u001a\u0012\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\u001eH\u0002\u00a8\u0006*"}, d2={"buildDocumentFromChunks", "Lcom/android/studio/ml/suggestion/controls/viewmodel/ConstructedDocument;", "chunks", "", "Lcom/android/studio/ml/suggestion/AnchoredDiffChunk;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getChunkContent", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "createCodeDisplayRow", "Lcom/android/studio/ml/suggestion/controls/viewmodel/CodeDisplayRow;", "sourceChunk", "lineNumber", "", "constructedDocument", "diffStyle", "Lcom/android/studio/ml/suggestion/controls/viewmodel/DiffStyle;", "createCodeDisplayRowForModification", "originalConstructedDocument", "newConstructedDocument", "signature", "Lcom/android/studio/ml/suggestion/grouping/LineLevelChange$Signature;", "createHighlightedRowsForChunk", "chunk", "createHighlightedRowsForGroupedChange", "groupedChange", "Lcom/android/studio/ml/suggestion/grouping/GroupedChange;", "createHighlightedSnippetsForSingleLineChunk", "Lcom/android/studio/ml/suggestion/controls/viewmodel/CodeDisplaySnippet;", "getHighlightedSnippets", "content", "textRange", "Lcom/intellij/openapi/util/TextRange;", "highlighter", "Lcom/intellij/openapi/editor/highlighter/EditorHighlighter;", "getSubRangeForLine", "lineNumberInTextRange", "getOrderedDistinctChunks", "aiplugin.core.aicore"})
@SourceDebugExtension(value={"SMAP\nCodeDisplay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeDisplay.kt\ncom/android/studio/ml/suggestion/controls/viewmodel/CodeDisplayKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,370:1\n1557#2:371\n1628#2,3:372\n1557#2:375\n1628#2,3:376\n1#3:379\n*S KotlinDebug\n*F\n+ 1 CodeDisplay.kt\ncom/android/studio/ml/suggestion/controls/viewmodel/CodeDisplayKt\n*L\n61#1:371\n61#1:372,3\n228#1:375\n228#1:376,3\n*E\n"})
public final class CodeDisplayKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<CodeDisplayRow> createHighlightedRowsForGroupedChange(@NotNull GroupedChange groupedChange, @NotNull Project project2, @NotNull VirtualFile virtualFile2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)groupedChange, (String)"groupedChange");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        List<AnchoredDiffChunk> chunks = CodeDisplayKt.getOrderedDistinctChunks(groupedChange);
        ConstructedDocument originalConstructedDocument2 = CodeDisplayKt.buildDocumentFromChunks(chunks, project2, virtualFile2, (Function1<? super AnchoredDiffChunk, String>)((Function1)createHighlightedRowsForGroupedChange.originalConstructedDocument.1.INSTANCE));
        ConstructedDocument newConstructedDocument2 = CodeDisplayKt.buildDocumentFromChunks(chunks, project2, virtualFile2, (Function1<? super AnchoredDiffChunk, String>)((Function1)createHighlightedRowsForGroupedChange.newConstructedDocument.1.INSTANCE));
        Iterable $this$map$iv = groupedChange.getChanges();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CodeDisplayRow codeDisplayRow;
            void lineLevelChange;
            LineLevelChange lineLevelChange2 = (LineLevelChange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var15_15 = lineLevelChange;
            if (var15_15 instanceof LineLevelChange.Addition) {
                codeDisplayRow = CodeDisplayKt.createCodeDisplayRow(lineLevelChange.getSourceChunk(), lineLevelChange.getLineNumber(), newConstructedDocument2, DiffStyle.New);
            } else if (var15_15 instanceof LineLevelChange.Deletion) {
                codeDisplayRow = CodeDisplayKt.createCodeDisplayRow(lineLevelChange.getSourceChunk(), lineLevelChange.getLineNumber(), originalConstructedDocument2, DiffStyle.Original);
            } else if (var15_15 instanceof LineLevelChange.Modification) {
                codeDisplayRow = CodeDisplayKt.createCodeDisplayRowForModification(lineLevelChange.getSourceChunk(), lineLevelChange.getLineNumber(), originalConstructedDocument2, newConstructedDocument2, lineLevelChange.getSignature().toDisplaySignature());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(codeDisplayRow);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final List<CodeDisplayRow> createHighlightedRowsForChunk(@NotNull AnchoredDiffChunk chunk, @NotNull Project project2, @NotNull VirtualFile virtualFile2) {
        int index;
        List list;
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        List chunks = CollectionsKt.listOf((Object)chunk);
        ConstructedDocument originalConstructedDocument2 = CodeDisplayKt.buildDocumentFromChunks(chunks, project2, virtualFile2, (Function1<? super AnchoredDiffChunk, String>)((Function1)createHighlightedRowsForChunk.originalConstructedDocument.1.INSTANCE));
        ConstructedDocument newConstructedDocument2 = CodeDisplayKt.buildDocumentFromChunks(chunks, project2, virtualFile2, (Function1<? super AnchoredDiffChunk, String>)((Function1)createHighlightedRowsForChunk.newConstructedDocument.1.INSTANCE));
        List $this$createHighlightedRowsForChunk_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        int n = ((Collection)chunk.getOriginalContentLines()).size();
        for (index = 0; index < n; ++index) {
            $this$createHighlightedRowsForChunk_u24lambda_u241.add(CodeDisplayKt.createCodeDisplayRow(chunk, index, originalConstructedDocument2, DiffStyle.Original));
        }
        n = ((Collection)chunk.getNewContentLines()).size();
        for (index = 0; index < n; ++index) {
            $this$createHighlightedRowsForChunk_u24lambda_u241.add(CodeDisplayKt.createCodeDisplayRow(chunk, index, newConstructedDocument2, DiffStyle.New));
        }
        return CollectionsKt.build((List)list);
    }

    @NotNull
    public static final List<CodeDisplaySnippet> createHighlightedSnippetsForSingleLineChunk(@NotNull AnchoredDiffChunk chunk, @NotNull Project project2, @NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        List chunks = CollectionsKt.listOf((Object)chunk);
        ConstructedDocument originalConstructedDocument2 = CodeDisplayKt.buildDocumentFromChunks(chunks, project2, virtualFile2, (Function1<? super AnchoredDiffChunk, String>)((Function1)createHighlightedSnippetsForSingleLineChunk.originalConstructedDocument.1.INSTANCE));
        ConstructedDocument newConstructedDocument2 = CodeDisplayKt.buildDocumentFromChunks(chunks, project2, virtualFile2, (Function1<? super AnchoredDiffChunk, String>)((Function1)createHighlightedSnippetsForSingleLineChunk.newConstructedDocument.1.INSTANCE));
        TextRange textRange = originalConstructedDocument2.getChunkToRange().get(chunk);
        if (textRange == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        TextRange textRange2 = newConstructedDocument2.getChunkToRange().get(chunk);
        if (textRange2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return CollectionsKt.plus((Collection)CodeDisplayKt.getHighlightedSnippets(originalConstructedDocument2.getContent(), textRange, originalConstructedDocument2.getHighlighter(), DiffStyle.Original), (Iterable)CodeDisplayKt.getHighlightedSnippets(newConstructedDocument2.getContent(), textRange2, newConstructedDocument2.getHighlighter(), DiffStyle.New));
    }

    private static final CodeDisplayRow createCodeDisplayRow(AnchoredDiffChunk sourceChunk, int lineNumber, ConstructedDocument constructedDocument, DiffStyle diffStyle) {
        TextRange textRange = constructedDocument.getChunkToRange().get(sourceChunk);
        if (textRange == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return new CodeDisplayRow(CodeDisplayKt.getHighlightedSnippets(constructedDocument.getContent(), CodeDisplayKt.getSubRangeForLine(constructedDocument.getContent(), textRange, lineNumber), constructedDocument.getHighlighter(), diffStyle));
    }

    private static final CodeDisplayRow createCodeDisplayRowForModification(AnchoredDiffChunk sourceChunk, int lineNumber, ConstructedDocument originalConstructedDocument2, ConstructedDocument newConstructedDocument2, LineLevelChange.Signature signature2) {
        String originalContent = originalConstructedDocument2.component1();
        Map<AnchoredDiffChunk, TextRange> originalChunkToRange = originalConstructedDocument2.component2();
        EditorHighlighter originalHighlighter = originalConstructedDocument2.component3();
        String newContent2 = newConstructedDocument2.component1();
        Map<AnchoredDiffChunk, TextRange> newChunkToRange = newConstructedDocument2.component2();
        EditorHighlighter newHighlighter = newConstructedDocument2.component3();
        TextRange textRange = newChunkToRange.get(sourceChunk);
        if (textRange == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        TextRange subRangeInNew = CodeDisplayKt.getSubRangeForLine(newContent2, textRange, lineNumber);
        TextRange textRange2 = originalChunkToRange.get(sourceChunk);
        if (textRange2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        TextRange subRangeInOriginal = CodeDisplayKt.getSubRangeForLine(originalContent, textRange2, lineNumber);
        List<CodeDisplaySnippet> prefixSnippets = CodeDisplayKt.getHighlightedSnippets(originalContent, new TextRange(subRangeInOriginal.getStartOffset(), subRangeInOriginal.getStartOffset() + signature2.getCommonPrefix().length()), originalHighlighter, DiffStyle.None);
        int suffixStartOffset = subRangeInOriginal.getStartOffset() + signature2.getCommonPrefix().length() + signature2.getRemoved().length();
        int suffixEndOffset = RangesKt.coerceAtMost((int)(suffixStartOffset + signature2.getCommonSuffix().length()), (int)subRangeInOriginal.getEndOffset());
        List<CodeDisplaySnippet> suffixSnippets = CodeDisplayKt.getHighlightedSnippets(originalContent, new TextRange(suffixStartOffset, suffixEndOffset), originalHighlighter, DiffStyle.None);
        int removedStartOffset = subRangeInOriginal.getStartOffset() + signature2.getCommonPrefix().length();
        int removedEndOffset = removedStartOffset + signature2.getRemoved().length();
        List<CodeDisplaySnippet> removedSnippets = CodeDisplayKt.getHighlightedSnippets(originalContent, new TextRange(removedStartOffset, removedEndOffset), originalHighlighter, DiffStyle.Original);
        int addedStartOffset = subRangeInNew.getStartOffset() + signature2.getCommonPrefix().length();
        int addedEndOffset = addedStartOffset + signature2.getAdded().length();
        List<CodeDisplaySnippet> addedSnippets = CodeDisplayKt.getHighlightedSnippets(newContent2, new TextRange(addedStartOffset, addedEndOffset), newHighlighter, DiffStyle.New);
        return new CodeDisplayRow(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)prefixSnippets, (Iterable)removedSnippets), (Iterable)addedSnippets), (Iterable)suffixSnippets));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<AnchoredDiffChunk> getOrderedDistinctChunks(GroupedChange $this$getOrderedDistinctChunks) {
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$getOrderedDistinctChunks.getChanges();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            object = (LineLevelChange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getSourceChunk());
        }
        List distinctChunks = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        for (List list : CollectionsKt.windowed$default((Iterable)distinctChunks, (int)2, (int)0, (boolean)false, (int)6, null)) {
            AnchoredDiffChunk first = (AnchoredDiffChunk)list.get(0);
            AnchoredDiffChunk second = (AnchoredDiffChunk)list.get(1);
            RangeMarker firstRange = first.getRangeMarker();
            RangeMarker secondRange = second.getRangeMarker();
            if (!(secondRange.getTextRange().getStartOffset() >= firstRange.getTextRange().getEndOffset())) {
                object = "Failed requirement.";
                throw new IllegalArgumentException(object.toString());
            }
            if (Intrinsics.areEqual((Object)secondRange.getDocument(), (Object)firstRange.getDocument())) continue;
            object = "Failed requirement.";
            throw new IllegalArgumentException(object.toString());
        }
        return distinctChunks;
    }

    @VisibleForTesting
    @NotNull
    public static final ConstructedDocument buildDocumentFromChunks(@NotNull List<? extends AnchoredDiffChunk> chunks, @NotNull Project project2, @NotNull VirtualFile virtualFile2, @NotNull Function1<? super AnchoredDiffChunk, String> getChunkContent) {
        Intrinsics.checkNotNullParameter(chunks, (String)"chunks");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter(getChunkContent, (String)"getChunkContent");
        Document document = ((AnchoredDiffChunk)CollectionsKt.first(chunks)).getRangeMarker().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        String string = document2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String documentText = string;
        int startOffsetInDocument = 0;
        StringBuilder contentBuilder = new StringBuilder();
        Map chunkToRange = new LinkedHashMap();
        for (AnchoredDiffChunk anchoredDiffChunk : chunks) {
            TextRange chunkTextRangeInDocument;
            Intrinsics.checkNotNullExpressionValue((Object)anchoredDiffChunk.getRangeMarker().getTextRange(), (String)"getTextRange(...)");
            int chunkStartOffsetInDocument = chunkTextRangeInDocument.getStartOffset();
            if (chunkStartOffsetInDocument > startOffsetInDocument) {
                String string2 = documentText.substring(startOffsetInDocument, chunkStartOffsetInDocument);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                contentBuilder.append(string2);
            }
            String chunkContent = (String)getChunkContent.invoke((Object)anchoredDiffChunk);
            chunkToRange.put(anchoredDiffChunk, new TextRange(contentBuilder.length(), contentBuilder.length() + chunkContent.length()));
            contentBuilder.append(chunkContent);
            startOffsetInDocument = chunkTextRangeInDocument.getEndOffset();
        }
        if (startOffsetInDocument < documentText.length()) {
            String string3 = documentText.substring(startOffsetInDocument);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            contentBuilder.append(string3);
        }
        String string4 = contentBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        String content2 = string4;
        EditorHighlighter editorHighlighter2 = (EditorHighlighter)ActionsKt.runReadAction((Function0)((Function0)new Function0<EditorHighlighter>(project2, virtualFile2){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $virtualFile;
            {
                this.$project = $project;
                this.$virtualFile = $virtualFile;
                super(0);
            }

            public final EditorHighlighter invoke() {
                return EditorHighlighterFactory.Companion.getInstance().createEditorHighlighter(this.$project, this.$virtualFile);
            }
        }));
        editorHighlighter2.setText((CharSequence)content2);
        return new ConstructedDocument(content2, MapsKt.toMap((Map)chunkToRange), editorHighlighter2);
    }

    @VisibleForTesting
    @NotNull
    public static final TextRange getSubRangeForLine(@NotNull String content2, @NotNull TextRange textRange, int lineNumberInTextRange) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        String string = content2;
        int n = textRange.getStartOffset();
        int n2 = textRange.getEndOffset();
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String textRangeContent = string2;
        int startOffset = 0;
        for (n = 0; n < lineNumberInTextRange; ++n) {
            int it = n;
            boolean bl = false;
            if (!((startOffset = StringsKt.indexOf$default((CharSequence)textRangeContent, (char)'\n', (int)startOffset, (boolean)false, (int)4, null)) != -1)) {
                String string3 = "Failed requirement.";
                throw new IllegalArgumentException(string3.toString());
            }
            ++startOffset;
        }
        Object object = StringsKt.indexOf$default((CharSequence)textRangeContent, (char)'\n', (int)startOffset, (boolean)false, (int)4, null);
        int it = ((Number)object).intValue();
        boolean bl = false;
        Object object2 = it != -1 ? object : null;
        int endOffset = object2 != null ? ((Integer)object2).intValue() : textRangeContent.length();
        if (!(endOffset >= startOffset)) {
            object = "Failed requirement.";
            throw new IllegalArgumentException(object.toString());
        }
        return new TextRange(startOffset + textRange.getStartOffset(), endOffset + textRange.getStartOffset());
    }

    private static final List<CodeDisplaySnippet> getHighlightedSnippets(String content2, TextRange textRange, EditorHighlighter highlighter2, DiffStyle diffStyle) {
        List list;
        HighlighterIterator highlighterIterator = highlighter2.createIterator(textRange.getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator = highlighterIterator;
        List $this$getHighlightedSnippets_u24lambda_u244 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        while (!iterator.atEnd() && iterator.getStart() < textRange.getEndOffset()) {
            String text2;
            int startOffsetInContent = RangesKt.coerceAtLeast((int)iterator.getStart(), (int)textRange.getStartOffset());
            int endOffsetInContent = RangesKt.coerceAtMost((int)iterator.getEnd(), (int)textRange.getEndOffset());
            Intrinsics.checkNotNullExpressionValue((Object)content2.substring(startOffsetInContent, endOffsetInContent), (String)"substring(...)");
            TextAttributes baseAttributes = iterator.getTextAttributes();
            $this$getHighlightedSnippets_u24lambda_u244.add(new CodeDisplaySnippet(text2, diffStyle, baseAttributes));
            iterator.advance();
        }
        return CollectionsKt.build((List)list);
    }
}

