/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.suggestion.grouping;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.suggestion.AnchoredDiffChunk;
import com.android.studio.ml.suggestion.grouping.BoundaryType;
import com.android.studio.ml.suggestion.grouping.LineLevelChangeKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0004\u0014\u0015\u0016\u0017R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u0082\u0001\u0003\u0018\u0019\u001a\u00a8\u0006\u001b\u00c0\u0006\u0003"}, d2={"Lcom/android/studio/ml/suggestion/grouping/LineLevelChange;", "", "lineNumber", "", "getLineNumber", "()I", "newText", "", "getNewText", "()Ljava/lang/String;", "originalText", "getOriginalText", "signature", "Lcom/android/studio/ml/suggestion/grouping/LineLevelChange$Signature;", "getSignature", "()Lcom/android/studio/ml/suggestion/grouping/LineLevelChange$Signature;", "sourceChunk", "Lcom/android/studio/ml/suggestion/AnchoredDiffChunk;", "getSourceChunk", "()Lcom/android/studio/ml/suggestion/AnchoredDiffChunk;", "Addition", "Deletion", "Modification", "Signature", "Lcom/android/studio/ml/suggestion/grouping/LineLevelChange$Addition;", "Lcom/android/studio/ml/suggestion/grouping/LineLevelChange$Deletion;", "Lcom/android/studio/ml/suggestion/grouping/LineLevelChange$Modification;", "aiplugin.core.aicore"})
public interface LineLevelChange {
    @NotNull
    public AnchoredDiffChunk getSourceChunk();

    public int getLineNumber();

    @NotNull
    public String getOriginalText();

    @NotNull
    public String getNewText();

    @NotNull
    public Signature getSignature();

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0007H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/android/studio/ml/suggestion/grouping/LineLevelChange$Addition;", "Lcom/android/studio/ml/suggestion/grouping/LineLevelChange;", "sourceChunk", "Lcom/android/studio/ml/suggestion/AnchoredDiffChunk;", "lineNumber", "", "newText", "", "(Lcom/android/studio/ml/suggestion/AnchoredDiffChunk;ILjava/lang/String;)V", "getLineNumber", "()I", "getNewText", "()Ljava/lang/String;", "originalText", "getOriginalText", "signature", "Lcom/android/studio/ml/suggestion/grouping/LineLevelChange$Signature;", "getSignature", "()Lcom/android/studio/ml/suggestion/grouping/LineLevelChange$Signature;", "getSourceChunk", "()Lcom/android/studio/ml/suggestion/AnchoredDiffChunk;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "aiplugin.core.aicore"})
    @StabilityInferred(parameters=0)
    public static final class Addition
    implements LineLevelChange {
        @NotNull
        private final AnchoredDiffChunk sourceChunk;
        private final int lineNumber;
        @NotNull
        private final String newText;
        @NotNull
        private final String originalText;
        @NotNull
        private final Signature signature;
        public static final int $stable = 8;

        public Addition(@NotNull AnchoredDiffChunk sourceChunk, int lineNumber, @NotNull String newText) {
            Intrinsics.checkNotNullParameter((Object)sourceChunk, (String)"sourceChunk");
            Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
            this.sourceChunk = sourceChunk;
            this.lineNumber = lineNumber;
            this.newText = newText;
            this.originalText = "";
            this.signature = new Signature("", "", this.getNewText(), "");
        }

        @Override
        @NotNull
        public AnchoredDiffChunk getSourceChunk() {
            return this.sourceChunk;
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Override
        @NotNull
        public String getNewText() {
            return this.newText;
        }

        @Override
        @NotNull
        public String getOriginalText() {
            return this.originalText;
        }

        @Override
        @NotNull
        public Signature getSignature() {
            return this.signature;
        }

        @NotNull
        public final AnchoredDiffChunk component1() {
            return this.sourceChunk;
        }

        public final int component2() {
            return this.lineNumber;
        }

        @NotNull
        public final String component3() {
            return this.newText;
        }

        @NotNull
        public final Addition copy(@NotNull AnchoredDiffChunk sourceChunk, int lineNumber, @NotNull String newText) {
            Intrinsics.checkNotNullParameter((Object)sourceChunk, (String)"sourceChunk");
            Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
            return new Addition(sourceChunk, lineNumber, newText);
        }

        public static /* synthetic */ Addition copy$default(Addition addition, AnchoredDiffChunk anchoredDiffChunk, int n, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                anchoredDiffChunk = addition.sourceChunk;
            }
            if ((n2 & 2) != 0) {
                n = addition.lineNumber;
            }
            if ((n2 & 4) != 0) {
                string = addition.newText;
            }
            return addition.copy(anchoredDiffChunk, n, string);
        }

        @NotNull
        public String toString() {
            return "Addition(sourceChunk=" + this.sourceChunk + ", lineNumber=" + this.lineNumber + ", newText=" + this.newText + ")";
        }

        public int hashCode() {
            int result2 = this.sourceChunk.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.lineNumber);
            result2 = result2 * 31 + this.newText.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Addition)) {
                return false;
            }
            Addition addition = (Addition)other;
            if (!Intrinsics.areEqual((Object)this.sourceChunk, (Object)addition.sourceChunk)) {
                return false;
            }
            if (this.lineNumber != addition.lineNumber) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.newText, (Object)addition.newText);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0007H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/android/studio/ml/suggestion/grouping/LineLevelChange$Deletion;", "Lcom/android/studio/ml/suggestion/grouping/LineLevelChange;", "sourceChunk", "Lcom/android/studio/ml/suggestion/AnchoredDiffChunk;", "lineNumber", "", "originalText", "", "(Lcom/android/studio/ml/suggestion/AnchoredDiffChunk;ILjava/lang/String;)V", "getLineNumber", "()I", "newText", "getNewText", "()Ljava/lang/String;", "getOriginalText", "signature", "Lcom/android/studio/ml/suggestion/grouping/LineLevelChange$Signature;", "getSignature", "()Lcom/android/studio/ml/suggestion/grouping/LineLevelChange$Signature;", "getSourceChunk", "()Lcom/android/studio/ml/suggestion/AnchoredDiffChunk;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "aiplugin.core.aicore"})
    @StabilityInferred(parameters=0)
    public static final class Deletion
    implements LineLevelChange {
        @NotNull
        private final AnchoredDiffChunk sourceChunk;
        private final int lineNumber;
        @NotNull
        private final String originalText;
        @NotNull
        private final String newText;
        @NotNull
        private final Signature signature;
        public static final int $stable = 8;

        public Deletion(@NotNull AnchoredDiffChunk sourceChunk, int lineNumber, @NotNull String originalText) {
            Intrinsics.checkNotNullParameter((Object)sourceChunk, (String)"sourceChunk");
            Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
            this.sourceChunk = sourceChunk;
            this.lineNumber = lineNumber;
            this.originalText = originalText;
            this.newText = "";
            this.signature = new Signature("", this.getOriginalText(), "", "");
        }

        @Override
        @NotNull
        public AnchoredDiffChunk getSourceChunk() {
            return this.sourceChunk;
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Override
        @NotNull
        public String getOriginalText() {
            return this.originalText;
        }

        @Override
        @NotNull
        public String getNewText() {
            return this.newText;
        }

        @Override
        @NotNull
        public Signature getSignature() {
            return this.signature;
        }

        @NotNull
        public final AnchoredDiffChunk component1() {
            return this.sourceChunk;
        }

        public final int component2() {
            return this.lineNumber;
        }

        @NotNull
        public final String component3() {
            return this.originalText;
        }

        @NotNull
        public final Deletion copy(@NotNull AnchoredDiffChunk sourceChunk, int lineNumber, @NotNull String originalText) {
            Intrinsics.checkNotNullParameter((Object)sourceChunk, (String)"sourceChunk");
            Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
            return new Deletion(sourceChunk, lineNumber, originalText);
        }

        public static /* synthetic */ Deletion copy$default(Deletion deletion, AnchoredDiffChunk anchoredDiffChunk, int n, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                anchoredDiffChunk = deletion.sourceChunk;
            }
            if ((n2 & 2) != 0) {
                n = deletion.lineNumber;
            }
            if ((n2 & 4) != 0) {
                string = deletion.originalText;
            }
            return deletion.copy(anchoredDiffChunk, n, string);
        }

        @NotNull
        public String toString() {
            return "Deletion(sourceChunk=" + this.sourceChunk + ", lineNumber=" + this.lineNumber + ", originalText=" + this.originalText + ")";
        }

        public int hashCode() {
            int result2 = this.sourceChunk.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.lineNumber);
            result2 = result2 * 31 + this.originalText.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Deletion)) {
                return false;
            }
            Deletion deletion = (Deletion)other;
            if (!Intrinsics.areEqual((Object)this.sourceChunk, (Object)deletion.sourceChunk)) {
                return false;
            }
            if (this.lineNumber != deletion.lineNumber) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.originalText, (Object)deletion.originalText);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J\b\u0010\u001d\u001a\u00020\u0010H\u0002J1\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020\u0005H\u00d6\u0001J\t\u0010$\u001a\u00020\u0007H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u001b\u0010\u000f\u001a\u00020\u00108VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006%"}, d2={"Lcom/android/studio/ml/suggestion/grouping/LineLevelChange$Modification;", "Lcom/android/studio/ml/suggestion/grouping/LineLevelChange;", "sourceChunk", "Lcom/android/studio/ml/suggestion/AnchoredDiffChunk;", "lineNumber", "", "originalText", "", "newText", "(Lcom/android/studio/ml/suggestion/AnchoredDiffChunk;ILjava/lang/String;Ljava/lang/String;)V", "getLineNumber", "()I", "getNewText", "()Ljava/lang/String;", "getOriginalText", "signature", "Lcom/android/studio/ml/suggestion/grouping/LineLevelChange$Signature;", "getSignature", "()Lcom/android/studio/ml/suggestion/grouping/LineLevelChange$Signature;", "signature$delegate", "Lkotlin/Lazy;", "getSourceChunk", "()Lcom/android/studio/ml/suggestion/AnchoredDiffChunk;", "adjustAnchorForChangesWithinLine", "originalAnchor", "component1", "component2", "component3", "component4", "computeSignature", "copy", "equals", "", "other", "", "hashCode", "toString", "aiplugin.core.aicore"})
    @StabilityInferred(parameters=0)
    public static final class Modification
    implements LineLevelChange {
        @NotNull
        private final AnchoredDiffChunk sourceChunk;
        private final int lineNumber;
        @NotNull
        private final String originalText;
        @NotNull
        private final String newText;
        @NotNull
        private final Lazy signature$delegate;
        public static final int $stable = 8;

        public Modification(@NotNull AnchoredDiffChunk sourceChunk, int lineNumber, @NotNull String originalText, @NotNull String newText) {
            Intrinsics.checkNotNullParameter((Object)sourceChunk, (String)"sourceChunk");
            Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
            Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
            this.sourceChunk = sourceChunk;
            this.lineNumber = lineNumber;
            this.originalText = originalText;
            this.newText = newText;
            this.signature$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<Signature>(this){
                final /* synthetic */ Modification this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final Signature invoke() {
                    return Modification.access$computeSignature(this.this$0);
                }
            }));
        }

        @Override
        @NotNull
        public AnchoredDiffChunk getSourceChunk() {
            return this.sourceChunk;
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Override
        @NotNull
        public String getOriginalText() {
            return this.originalText;
        }

        @Override
        @NotNull
        public String getNewText() {
            return this.newText;
        }

        @Override
        @NotNull
        public Signature getSignature() {
            Lazy lazy = this.signature$delegate;
            return (Signature)lazy.getValue();
        }

        private final Signature computeSignature() {
            String commonPrefix = StringsKt.commonPrefixWith((CharSequence)this.getOriginalText(), (CharSequence)this.getNewText(), (boolean)false);
            int prefixLength = commonPrefix.length();
            String string = this.getOriginalText().substring(prefixLength);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String originalRemainder = string;
            String string2 = this.getNewText().substring(prefixLength);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String newRemainder = string2;
            String commonSuffix = StringsKt.commonSuffixWith((CharSequence)originalRemainder, (CharSequence)newRemainder, (boolean)false);
            String removed = StringsKt.removeSuffix((String)originalRemainder, (CharSequence)commonSuffix);
            String added = StringsKt.removeSuffix((String)newRemainder, (CharSequence)commonSuffix);
            return new Signature(commonPrefix, removed, added, commonSuffix);
        }

        @NotNull
        public final AnchoredDiffChunk adjustAnchorForChangesWithinLine(@NotNull AnchoredDiffChunk originalAnchor) {
            Intrinsics.checkNotNullParameter((Object)originalAnchor, (String)"originalAnchor");
            if (!Intrinsics.areEqual((Object)originalAnchor.getOriginalContentLines().get(this.getLineNumber()), (Object)this.getOriginalText())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!Intrinsics.areEqual((Object)originalAnchor.getNewContentLines().get(this.getLineNumber()), (Object)this.getNewText())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Signature displaySignature = this.getSignature().toDisplaySignature();
            return originalAnchor.getAdjustedAnchorInSingleLine(this.getLineNumber(), displaySignature.getCommonPrefix().length(), displaySignature.getRemoved().length(), this.getLineNumber(), displaySignature.getCommonPrefix().length(), displaySignature.getAdded().length());
        }

        @NotNull
        public final AnchoredDiffChunk component1() {
            return this.sourceChunk;
        }

        public final int component2() {
            return this.lineNumber;
        }

        @NotNull
        public final String component3() {
            return this.originalText;
        }

        @NotNull
        public final String component4() {
            return this.newText;
        }

        @NotNull
        public final Modification copy(@NotNull AnchoredDiffChunk sourceChunk, int lineNumber, @NotNull String originalText, @NotNull String newText) {
            Intrinsics.checkNotNullParameter((Object)sourceChunk, (String)"sourceChunk");
            Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
            Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
            return new Modification(sourceChunk, lineNumber, originalText, newText);
        }

        public static /* synthetic */ Modification copy$default(Modification modification, AnchoredDiffChunk anchoredDiffChunk, int n, String string, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                anchoredDiffChunk = modification.sourceChunk;
            }
            if ((n2 & 2) != 0) {
                n = modification.lineNumber;
            }
            if ((n2 & 4) != 0) {
                string = modification.originalText;
            }
            if ((n2 & 8) != 0) {
                string2 = modification.newText;
            }
            return modification.copy(anchoredDiffChunk, n, string, string2);
        }

        @NotNull
        public String toString() {
            return "Modification(sourceChunk=" + this.sourceChunk + ", lineNumber=" + this.lineNumber + ", originalText=" + this.originalText + ", newText=" + this.newText + ")";
        }

        public int hashCode() {
            int result2 = this.sourceChunk.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.lineNumber);
            result2 = result2 * 31 + this.originalText.hashCode();
            result2 = result2 * 31 + this.newText.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Modification)) {
                return false;
            }
            Modification modification = (Modification)other;
            if (!Intrinsics.areEqual((Object)this.sourceChunk, (Object)modification.sourceChunk)) {
                return false;
            }
            if (this.lineNumber != modification.lineNumber) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.originalText, (Object)modification.originalText)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.newText, (Object)modification.newText);
        }

        public static final /* synthetic */ Signature access$computeSignature(Modification $this) {
            return $this.computeSignature();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0087\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J1\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0012H\u00d6\u0001J\u0006\u0010\u0019\u001a\u00020\u0000J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/android/studio/ml/suggestion/grouping/LineLevelChange$Signature;", "", "commonPrefix", "", "removed", "added", "commonSuffix", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAdded", "()Ljava/lang/String;", "getCommonPrefix", "getCommonSuffix", "getRemoved", "component1", "component2", "component3", "component4", "computeChangedChunkPrefixStart", "", "computeChangedChunkSuffixEnd", "copy", "equals", "", "other", "hashCode", "toDisplaySignature", "toString", "aiplugin.core.aicore"})
    @StabilityInferred(parameters=1)
    public static final class Signature {
        @NotNull
        private final String commonPrefix;
        @NotNull
        private final String removed;
        @NotNull
        private final String added;
        @NotNull
        private final String commonSuffix;
        public static final int $stable;

        public Signature(@NotNull String commonPrefix, @NotNull String removed, @NotNull String added, @NotNull String commonSuffix) {
            Intrinsics.checkNotNullParameter((Object)commonPrefix, (String)"commonPrefix");
            Intrinsics.checkNotNullParameter((Object)removed, (String)"removed");
            Intrinsics.checkNotNullParameter((Object)added, (String)"added");
            Intrinsics.checkNotNullParameter((Object)commonSuffix, (String)"commonSuffix");
            this.commonPrefix = commonPrefix;
            this.removed = removed;
            this.added = added;
            this.commonSuffix = commonSuffix;
        }

        @NotNull
        public final String getCommonPrefix() {
            return this.commonPrefix;
        }

        @NotNull
        public final String getRemoved() {
            return this.removed;
        }

        @NotNull
        public final String getAdded() {
            return this.added;
        }

        @NotNull
        public final String getCommonSuffix() {
            return this.commonSuffix;
        }

        @NotNull
        public final Signature toDisplaySignature() {
            String addedCommonPrefix = StringsKt.drop((String)this.commonPrefix, (int)this.computeChangedChunkPrefixStart());
            String addedCommonSuffix = StringsKt.take((String)this.commonSuffix, (int)this.computeChangedChunkSuffixEnd());
            String displayPrefix = ((CharSequence)this.removed).length() == 0 || ((CharSequence)this.added).length() == 0 ? this.commonPrefix : StringsKt.removeSuffix((String)this.commonPrefix, (CharSequence)addedCommonPrefix);
            String displaySuffix = ((CharSequence)this.removed).length() == 0 || ((CharSequence)this.added).length() == 0 ? this.commonSuffix : StringsKt.removePrefix((String)this.commonSuffix, (CharSequence)addedCommonSuffix);
            String displayRemoved = ((CharSequence)this.removed).length() == 0 || ((CharSequence)this.added).length() == 0 ? this.removed : addedCommonPrefix + this.removed + addedCommonSuffix;
            String displayAdded = ((CharSequence)this.removed).length() == 0 || ((CharSequence)this.added).length() == 0 ? this.added : addedCommonPrefix + this.added + addedCommonSuffix;
            return new Signature(displayPrefix, displayRemoved, displayAdded, displaySuffix);
        }

        private final int computeChangedChunkSuffixEnd() {
            if (((CharSequence)this.removed).length() == 0 || ((CharSequence)this.added).length() == 0 || ((CharSequence)this.commonSuffix).length() == 0) {
                return 0;
            }
            if (LineLevelChangeKt.access$getBoundary(StringsKt.last((CharSequence)this.removed), StringsKt.first((CharSequence)this.commonSuffix)) == BoundaryType.CENTER_BOUNDARY) {
                return 0;
            }
            if (LineLevelChangeKt.access$getBoundary(StringsKt.last((CharSequence)this.added), StringsKt.first((CharSequence)this.commonSuffix)) == BoundaryType.CENTER_BOUNDARY) {
                return 0;
            }
            int n = this.commonSuffix.length() - 1;
            for (int i2 = 0; i2 < n; ++i2) {
                BoundaryType boundaryType = LineLevelChangeKt.access$getBoundary(this.commonSuffix.charAt(i2), this.commonSuffix.charAt(i2 + 1));
                if (boundaryType == null) continue;
                BoundaryType it = boundaryType;
                boolean bl = false;
                return i2 + it.getIndex();
            }
            return this.commonSuffix.length();
        }

        private final int computeChangedChunkPrefixStart() {
            if (((CharSequence)this.removed).length() == 0 || ((CharSequence)this.added).length() == 0 || ((CharSequence)this.commonPrefix).length() == 0) {
                return this.commonPrefix.length();
            }
            if (LineLevelChangeKt.access$getBoundary(StringsKt.last((CharSequence)this.commonPrefix), StringsKt.first((CharSequence)this.removed)) == BoundaryType.CENTER_BOUNDARY) {
                return this.commonPrefix.length();
            }
            if (LineLevelChangeKt.access$getBoundary(StringsKt.last((CharSequence)this.commonPrefix), StringsKt.first((CharSequence)this.added)) == BoundaryType.CENTER_BOUNDARY) {
                return this.commonPrefix.length();
            }
            for (int i2 = this.commonPrefix.length() - 2; -1 < i2; --i2) {
                BoundaryType boundaryType = LineLevelChangeKt.access$getBoundary(this.commonPrefix.charAt(i2), this.commonPrefix.charAt(i2 + 1));
                if (boundaryType == null) continue;
                BoundaryType it = boundaryType;
                boolean bl = false;
                return i2 + it.getIndex();
            }
            return 0;
        }

        @NotNull
        public final String component1() {
            return this.commonPrefix;
        }

        @NotNull
        public final String component2() {
            return this.removed;
        }

        @NotNull
        public final String component3() {
            return this.added;
        }

        @NotNull
        public final String component4() {
            return this.commonSuffix;
        }

        @NotNull
        public final Signature copy(@NotNull String commonPrefix, @NotNull String removed, @NotNull String added, @NotNull String commonSuffix) {
            Intrinsics.checkNotNullParameter((Object)commonPrefix, (String)"commonPrefix");
            Intrinsics.checkNotNullParameter((Object)removed, (String)"removed");
            Intrinsics.checkNotNullParameter((Object)added, (String)"added");
            Intrinsics.checkNotNullParameter((Object)commonSuffix, (String)"commonSuffix");
            return new Signature(commonPrefix, removed, added, commonSuffix);
        }

        public static /* synthetic */ Signature copy$default(Signature signature2, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = signature2.commonPrefix;
            }
            if ((n & 2) != 0) {
                string2 = signature2.removed;
            }
            if ((n & 4) != 0) {
                string3 = signature2.added;
            }
            if ((n & 8) != 0) {
                string4 = signature2.commonSuffix;
            }
            return signature2.copy(string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "Signature(commonPrefix=" + this.commonPrefix + ", removed=" + this.removed + ", added=" + this.added + ", commonSuffix=" + this.commonSuffix + ")";
        }

        public int hashCode() {
            int result2 = this.commonPrefix.hashCode();
            result2 = result2 * 31 + this.removed.hashCode();
            result2 = result2 * 31 + this.added.hashCode();
            result2 = result2 * 31 + this.commonSuffix.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Signature)) {
                return false;
            }
            Signature signature2 = (Signature)other;
            if (!Intrinsics.areEqual((Object)this.commonPrefix, (Object)signature2.commonPrefix)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.removed, (Object)signature2.removed)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.added, (Object)signature2.added)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.commonSuffix, (Object)signature2.commonSuffix);
        }
    }
}

