/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.templates.modelproviders;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.SmlBundle;
import com.android.studio.ml.templates.modelproviders.ModelProviderSettingsComponent;
import com.android.studio.ml.templates.modelproviders.data.DataValidator;
import com.android.studio.ml.templates.modelproviders.data.ModelDataStateManager;
import com.android.studio.ml.templates.modelproviders.data.ProviderDetails;
import com.android.studio.ml.templates.modelproviders.data.ValidationDetails;
import com.android.studio.ml.templates.modelproviders.data.ValidationError;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableWithId;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\r\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014H\u0016J\u000f\u0010\u0015\u001a\t\u0018\u00010\u0013\u00a2\u0006\u0002\b\u0016H\u0016J\r\u0010\u0017\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u000eH\u0016R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/studio/ml/templates/modelproviders/ModelProviderConfigurable;", "Lcom/intellij/openapi/options/ConfigurableWithId;", "Lcom/intellij/openapi/options/Configurable$VariableProjectAppLevel;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "disposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "settingsComponent", "Lcom/android/studio/ml/templates/modelproviders/ModelProviderSettingsComponent;", "apply", "", "createComponent", "Ljavax/swing/JComponent;", "disposeUIResources", "getDisplayName", "", "Lcom/intellij/openapi/util/NlsContexts$ConfigurableName;", "getHelpTopic", "Lorg/jetbrains/annotations/NonNls;", "getId", "isModified", "", "isProjectLevel", "reset", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nModelProviderConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelProviderConfigurable.kt\ncom/android/studio/ml/templates/modelproviders/ModelProviderConfigurable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,86:1\n1#2:87\n40#3,3:88\n40#3,3:91\n40#3,3:94\n*S KotlinDebug\n*F\n+ 1 ModelProviderConfigurable.kt\ncom/android/studio/ml/templates/modelproviders/ModelProviderConfigurable\n*L\n61#1:88,3\n73#1:91,3\n78#1:94,3\n*E\n"})
public final class ModelProviderConfigurable
implements ConfigurableWithId,
Configurable.VariableProjectAppLevel {
    @NotNull
    private final Project project;
    @Nullable
    private ModelProviderSettingsComponent settingsComponent;
    @NotNull
    private final Disposable disposable;
    public static final int $stable = 8;

    public ModelProviderConfigurable(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        Disposable disposable = Disposer.newDisposable((String)"ModelProviderConfigurable");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public JComponent createComponent() {
        ModelProviderSettingsComponent modelProviderSettingsComponent;
        ModelProviderSettingsComponent it = modelProviderSettingsComponent = new ModelProviderSettingsComponent(this.disposable, this.project);
        boolean bl = false;
        this.settingsComponent = it;
        return modelProviderSettingsComponent.getPanel();
    }

    public boolean isProjectLevel() {
        return false;
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.disposable);
        this.settingsComponent = null;
    }

    @NotNull
    public String getId() {
        return "templates.modelproviders.configurable";
    }

    @NotNull
    public String getDisplayName() {
        return SmlBundle.message("sml.studiobot.settings.modelProviders.display.name", new Object[0]);
    }

    public boolean isModified() {
        boolean $i$f$service = false;
        Class<ModelDataStateManager> serviceClass$iv = ModelDataStateManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        List<ProviderDetails> persistedState = ((ModelDataStateManager)((Object)object)).loadState();
        ModelProviderSettingsComponent modelProviderSettingsComponent = this.settingsComponent;
        List<ProviderDetails> uiState = modelProviderSettingsComponent != null ? modelProviderSettingsComponent.getState() : null;
        return !Intrinsics.areEqual(uiState, persistedState);
    }

    public void apply() {
        block3: {
            Object object = this.settingsComponent;
            if (object == null || (object = ((ModelProviderSettingsComponent)object).getState()) == null) break block3;
            Object it = object;
            boolean bl = false;
            ValidationDetails validationResult = DataValidator.INSTANCE.execute((List<ProviderDetails>)it);
            if (validationResult.getValidationError() != ValidationError.NoError) {
                ModelProviderSettingsComponent modelProviderSettingsComponent = this.settingsComponent;
                if (modelProviderSettingsComponent != null) {
                    modelProviderSettingsComponent.handleValidationErrors(validationResult);
                }
                throw new ConfigurationException(validationResult.getValidationError().getErrorMessage());
            }
            boolean $i$f$service = false;
            Class<ModelDataStateManager> serviceClass$iv = ModelDataStateManager.class;
            Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object2 == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((ModelDataStateManager)((Object)object2)).saveState((List<ProviderDetails>)it);
        }
    }

    public void reset() {
        block1: {
            boolean $i$f$service = false;
            Class<ModelDataStateManager> serviceClass$iv = ModelDataStateManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            List<ProviderDetails> persistedState = ((ModelDataStateManager)((Object)object)).loadState();
            ModelProviderSettingsComponent modelProviderSettingsComponent = this.settingsComponent;
            if (modelProviderSettingsComponent == null) break block1;
            modelProviderSettingsComponent.reset(persistedState);
        }
    }

    @Nullable
    public String getHelpTopic() {
        return "org.jetbrains.android.studio/gemini/use-a-local-llm";
    }
}

