/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.templates.modelproviders;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.templates.modelproviders.ModelProviderGroupPanel;
import com.android.studio.ml.templates.modelproviders.ProviderDetailsColumns;
import com.android.studio.ml.templates.modelproviders.data.ProviderDetails;
import com.android.studio.ml.templates.modelproviders.data.ValidationDetails;
import com.android.studio.ml.templates.modelproviders.providerinfo.ModelProviderInfoPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0012\u001a\u00020\u0013J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0014\u0010\u001a\u001a\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015J\u000e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/studio/ml/templates/modelproviders/ModelProviderSettingsComponent;", "", "disposable", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/project/Project;)V", "centralSplitter", "Lcom/intellij/openapi/ui/Splitter;", "linkTable", "Lcom/intellij/ui/table/TableView;", "Lcom/android/studio/ml/templates/modelproviders/data/ProviderDetails;", "mainPanel", "Ljavax/swing/JPanel;", "modelProviderInfoPanel", "Lcom/android/studio/ml/templates/modelproviders/providerinfo/ModelProviderInfoPanel;", "modelProviders", "Lcom/intellij/util/ui/ListTableModel;", "getPanel", "Ljavax/swing/JComponent;", "getState", "", "handleValidationErrors", "", "validationDetails", "Lcom/android/studio/ml/templates/modelproviders/data/ValidationDetails;", "reset", "uiState", "setRowFocus", "rowToSelect", "", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
public final class ModelProviderSettingsComponent {
    @NotNull
    private Splitter centralSplitter;
    @NotNull
    private TableView<ProviderDetails> linkTable;
    @NotNull
    private final JPanel mainPanel;
    @NotNull
    private final ListTableModel<ProviderDetails> modelProviders;
    @NotNull
    private ModelProviderInfoPanel modelProviderInfoPanel;
    public static final int $stable = 8;

    public ModelProviderSettingsComponent(@NotNull Disposable disposable, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.mainPanel = new JPanel(new BorderLayout());
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new ProviderDetailsColumns()};
        this.modelProviders = new ListTableModel(columnInfoArray);
        this.linkTable = new TableView(this.modelProviders);
        if (this.linkTable.getRowCount() > 0) {
            this.linkTable.setRowSelectionInterval(0, 0);
        }
        this.linkTable.setFillsViewportHeight(true);
        this.linkTable.setShowGrid(false);
        this.modelProviderInfoPanel = new ModelProviderInfoPanel(project2, disposable, this.linkTable, this.modelProviders);
        JPanel modelManagerPanel2 = new ModelProviderGroupPanel(this.linkTable, this.modelProviders, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ModelProviderSettingsComponent this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ModelProviderSettingsComponent.access$getModelProviderInfoPanel$p(this.this$0).requestFocusOnProviderName();
            }
        })).getPanel();
        DialogPanel modelInfoPanel = this.modelProviderInfoPanel.getPanel();
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)modelManagerPanel2, (int)20, (int)31);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        JScrollPane leftWrapper = jScrollPane;
        leftWrapper.setBorder((Border)JBUI.Borders.empty());
        JScrollPane jScrollPane2 = ScrollPaneFactory.createScrollPane((Component)((Component)modelInfoPanel), (int)20, (int)31);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane2, (String)"createScrollPane(...)");
        JScrollPane rightWrapper = jScrollPane2;
        rightWrapper.setBorder((Border)JBUI.Borders.empty());
        JPanel centerPanel = new JPanel(new BorderLayout());
        this.centralSplitter = new Splitter(false, 0.25f);
        this.centralSplitter.setFirstComponent((JComponent)leftWrapper);
        this.centralSplitter.setSecondComponent((JComponent)rightWrapper);
        centerPanel.add((Component)this.centralSplitter, "Center");
        this.mainPanel.add((Component)centerPanel, "Center");
        this.mainPanel.setPreferredSize(new Dimension(600, 600));
    }

    @NotNull
    public final JComponent getPanel() {
        return this.mainPanel;
    }

    @NotNull
    public final List<ProviderDetails> getState() {
        List list = this.modelProviders.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        return list;
    }

    public final void setRowFocus(int rowToSelect) {
        if (rowToSelect >= 0 && rowToSelect < this.linkTable.getRowCount()) {
            this.linkTable.setRowSelectionInterval(rowToSelect, rowToSelect);
        }
    }

    public final void handleValidationErrors(@NotNull ValidationDetails validationDetails) {
        Intrinsics.checkNotNullParameter((Object)validationDetails, (String)"validationDetails");
        this.setRowFocus(validationDetails.getProviderIndex());
        this.modelProviderInfoPanel.focusOnError(validationDetails);
    }

    public final void reset(@NotNull List<ProviderDetails> uiState) {
        Intrinsics.checkNotNullParameter(uiState, (String)"uiState");
        int previouslySelectedRow = this.linkTable.getSelectedRow();
        this.modelProviders.setItems(uiState);
        if (this.linkTable.getRowCount() > 0) {
            int rowToSelect = 0 <= previouslySelectedRow && previouslySelectedRow < this.modelProviders.getRowCount() ? previouslySelectedRow : 0;
            this.setRowFocus(rowToSelect);
        }
    }

    public static final /* synthetic */ ModelProviderInfoPanel access$getModelProviderInfoPanel$p(ModelProviderSettingsComponent $this) {
        return $this.modelProviderInfoPanel;
    }
}

