/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.util;

import com.android.studio.ml.ActiveModelProvider;
import com.android.studio.ml.CompletionModel;
import com.android.studio.ml.ModelProvider;
import com.android.tools.idea.studiobot.MimeType;
import com.android.tools.idea.studiobot.mimetype.MimeTypeUtilsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u000e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0005\u001a\n\u0010\b\u001a\u00020\t*\u00020\n\u001a\u0012\u0010\u000b\u001a\u00020\u0005*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"fileToUrl", "Ljava/net/URL;", "file", "Ljava/io/File;", "fileToUrlString", "", "urlToFile", "url", "isSupportedByAiPlugin", "", "Lcom/intellij/psi/PsiFile;", "projectRelativePath", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "aiplugin.core.aicore"})
public final class FileUtilsKt {
    @NotNull
    public static final String projectRelativePath(@NotNull VirtualFile $this$projectRelativePath, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)$this$projectRelativePath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        String string = $this$projectRelativePath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String path2 = string;
        String basePath = project2.getBasePath();
        if (basePath != null && StringsKt.startsWith$default((String)path2, (String)basePath, (boolean)false, (int)2, null)) {
            if (Intrinsics.areEqual((Object)path2, (Object)basePath)) {
                return path2;
            }
            char next = path2.charAt(basePath.length());
            int begin = switch (next) {
                case '/', '\\' -> basePath.length() + 1;
                default -> basePath.length();
            };
            String string2 = path2.substring(begin);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            return string2;
        }
        VirtualFile baseDir = ProjectUtil.guessProjectDir((Project)project2);
        if (baseDir != null) {
            String string3 = VfsUtilCore.getRelativePath((VirtualFile)$this$projectRelativePath, (VirtualFile)baseDir);
            if (string3 == null) {
                string3 = path2;
            }
            return string3;
        }
        return path2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSupportedByAiPlugin(@NotNull PsiFile $this$isSupportedByAiPlugin) {
        Intrinsics.checkNotNullParameter((Object)$this$isSupportedByAiPlugin, (String)"<this>");
        Project project2 = $this$isSupportedByAiPlugin.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        VirtualFile virtualFile2 = $this$isSupportedByAiPlugin.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        String mimeType = MimeTypeUtilsKt.forVirtualFile(MimeType.Companion, project2, virtualFile2);
        StateFlow<ModelProvider> modelProvider = ActiveModelProvider.Companion.getInstance().getModelProvider();
        if (mimeType == null) return false;
        ModelProvider modelProvider2 = (ModelProvider)modelProvider.getValue();
        Object object = modelProvider2;
        if (modelProvider2 == null) return false;
        CompletionModel completionModel = object.getCompletionModel();
        object = completionModel;
        if (completionModel == null) return false;
        if (!object.isSupportedLanguage-qru2Y28(mimeType)) return false;
        return true;
    }

    @NotNull
    public static final String fileToUrlString(@NotNull File file) {
        String url;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CharSequence charSequence = url = FileUtilsKt.fileToUrl(file).toExternalForm();
        Intrinsics.checkNotNull((Object)charSequence);
        if (!StringsKt.startsWith$default((String)charSequence, (String)"file:///", (boolean)false, (int)2, null)) {
            charSequence = url;
            Intrinsics.checkNotNull((Object)charSequence);
            charSequence = charSequence;
            Regex regex = new Regex("file:/");
            String string = "file:///";
            url = regex.replaceFirst(charSequence, string);
        }
        charSequence = url;
        Intrinsics.checkNotNull((Object)charSequence);
        return charSequence;
    }

    @NotNull
    public static final URL fileToUrl(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        URL uRL = file.toURI().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return uRL;
    }

    @NotNull
    public static final File urlToFile(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return FileUtilsKt.urlToFile(new URL(url));
    }

    @NotNull
    public static final File urlToFile(@NotNull URL url) {
        File file;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            file = new File(url.toURI());
        }
        catch (IllegalArgumentException e) {
            MalformedURLException ex = new MalformedURLException(e.getLocalizedMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (URISyntaxException uRISyntaxException) {
            file = new File(url.getPath());
        }
        return file;
    }
}

