/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.tools.read;

import com.android.tools.idea.studiobot.AiExcludeService;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.read.ReadFileArgs;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/google/aiplugin/agents/tools/read/ReadFileToolHandler;", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "localFileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "args", "Lcom/google/aiplugin/agents/tools/read/ReadFileArgs;", "<init>", "(Lcom/google/aiplugin/agents/tools/ToolContext;Lcom/intellij/openapi/vfs/VirtualFileSystem;Lcom/google/aiplugin/agents/tools/read/ReadFileArgs;)V", "getContext", "()Lcom/google/aiplugin/agents/tools/ToolContext;", "getArgs", "()Lcom/google/aiplugin/agents/tools/read/ReadFileArgs;", "readFileName", "", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "aiplugin.agents.agents-core"})
public final class ReadFileToolHandler
implements ToolHandler {
    @NotNull
    private final ToolContext context;
    @NotNull
    private final VirtualFileSystem localFileSystem;
    @NotNull
    private final ReadFileArgs args;
    @Nullable
    private String readFileName;

    public ReadFileToolHandler(@NotNull ToolContext context2, @NotNull VirtualFileSystem localFileSystem, @NotNull ReadFileArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)localFileSystem, (String)"localFileSystem");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.context = context2;
        this.localFileSystem = localFileSystem;
        this.args = args;
    }

    @NotNull
    public final ToolContext getContext() {
        return this.context;
    }

    @NotNull
    public final ReadFileArgs getArgs() {
        return this.args;
    }

    @Override
    @Nullable
    public Object handle(@NotNull Continuation<? super Response> $completion) {
        VirtualFile virtualFile2 = this.localFileSystem.refreshAndFindFileByPath(this.args.getAbsolutePath());
        if (virtualFile2 == null && (virtualFile2 = JarFileSystem.getInstance().refreshAndFindFileByPath(this.args.getAbsolutePath())) == null) {
            return new Response(null, "file not found", Response.ToolExecutionStatus.ERR_FILE_NOT_FOUND, 1, null);
        }
        VirtualFile file = virtualFile2;
        return ActionsKt.runReadAction(() -> ReadFileToolHandler.handle$lambda$1(this, file));
    }

    private static final Document handle$lambda$1$lambda$0(VirtualFile $file) {
        return FileDocumentManager.getInstance().getDocument($file);
    }

    private static final Response handle$lambda$1(ReadFileToolHandler this$0, VirtualFile $file) {
        AiExcludeService.ExclusionStatus exclusionStatus = AiExcludeService.Companion.getInstance(this$0.context.getProject()).getExclusionStatus($file);
        return switch (WhenMappings.$EnumSwitchMapping$0[exclusionStatus.ordinal()]) {
            case 1 -> {
                Document document = (Document)ActionsKt.runReadAction(() -> ReadFileToolHandler.handle$lambda$1$lambda$0($file));
                if (document == null) {
                    yield new Response(null, "could not get document", Response.ToolExecutionStatus.ERR_FILE_NOT_FOUND, 1, null);
                }
                this$0.readFileName = $file.getName();
                yield new Response(document.getText(), null, Response.ToolExecutionStatus.OK, 2, null);
            }
            case 2 -> new Response(null, "file not in project", Response.ToolExecutionStatus.ERR_FILE_NOT_IN_PROJECT, 1, null);
            case 3 -> new Response(null, "file blocked by aiexclude", Response.ToolExecutionStatus.ERR_FILE_BLOCKED_BY_AI_EXCLUDE, 1, null);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AiExcludeService.ExclusionStatus.values().length];
            try {
                nArray[AiExcludeService.ExclusionStatus.ALLOWED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AiExcludeService.ExclusionStatus.NOT_IN_PROJECT_OR_VCS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AiExcludeService.ExclusionStatus.EXCLUDED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

