/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.tools.search;

import com.android.tools.idea.studiobot.AiExcludeService;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.search.CodeDeclarationSummarizer;
import com.google.aiplugin.agents.tools.search.ListDeclarationsArgs;
import com.google.aiplugin.agents.tools.search.ListDeclarationsInDirectoryHandler;
import com.google.gson.Gson;
import com.intellij.lang.Language;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lcom/google/aiplugin/agents/tools/search/ListDeclarationsInDirectoryHandler;", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "fileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "args", "Lcom/google/aiplugin/agents/tools/search/ListDeclarationsArgs;", "maxResults", "", "<init>", "(Lcom/google/aiplugin/agents/tools/ToolContext;Lcom/intellij/openapi/vfs/VirtualFileSystem;Lcom/google/aiplugin/agents/tools/search/ListDeclarationsArgs;I)V", "getContext", "()Lcom/google/aiplugin/agents/tools/ToolContext;", "getArgs", "()Lcom/google/aiplugin/agents/tools/search/ListDeclarationsArgs;", "getMaxResults", "()I", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "aiplugin.agents.agents-core"})
@SourceDebugExtension(value={"SMAP\nListDeclarationsInDirectoryTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListDeclarationsInDirectoryTool.kt\ncom/google/aiplugin/agents/tools/search/ListDeclarationsInDirectoryHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,174:1\n4135#2,11:175\n774#3:186\n865#3,2:187\n25#4:189\n*S KotlinDebug\n*F\n+ 1 ListDeclarationsInDirectoryTool.kt\ncom/google/aiplugin/agents/tools/search/ListDeclarationsInDirectoryHandler\n*L\n131#1:175,11\n131#1:186\n131#1:187,2\n168#1:189\n*E\n"})
public final class ListDeclarationsInDirectoryHandler
implements ToolHandler {
    @NotNull
    private final ToolContext context;
    @NotNull
    private final VirtualFileSystem fileSystem;
    @NotNull
    private final ListDeclarationsArgs args;
    private final int maxResults;

    public ListDeclarationsInDirectoryHandler(@NotNull ToolContext context2, @NotNull VirtualFileSystem fileSystem, @NotNull ListDeclarationsArgs args, int maxResults) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.context = context2;
        this.fileSystem = fileSystem;
        this.args = args;
        this.maxResults = maxResults;
    }

    @NotNull
    public final ToolContext getContext() {
        return this.context;
    }

    @NotNull
    public final ListDeclarationsArgs getArgs() {
        return this.args;
    }

    public final int getMaxResults() {
        return this.maxResults;
    }

    @Override
    @Nullable
    public Object handle(@NotNull Continuation<? super Response> $completion) {
        return CoroutinesKt.readAction(() -> ListDeclarationsInDirectoryHandler.handle$lambda$1(this), $completion);
    }

    /*
     * WARNING - void declaration
     */
    private static final Response handle$lambda$1(ListDeclarationsInDirectoryHandler this$0) {
        Project project2 = this$0.context.getProject();
        try {
            int nFilesNotSummarized;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$filterIsInstanceTo$iv$iv;
            VirtualFile virtualFile2 = this$0.fileSystem.findFileByPath(this$0.args.getAbsolutePath());
            if (virtualFile2 == null) {
                return new Response(null, "directory not found", null, 5, null);
            }
            VirtualFile targetDir = virtualFile2;
            if (!GlobalSearchScope.allScope((Project)project2).contains(targetDir)) {
                return new Response(null, "directory not in project", null, 5, null);
            }
            if (!targetDir.exists()) {
                return new Response(null, "directory not found", null, 5, null);
            }
            if (!targetDir.isDirectory()) {
                return new Response(null, targetDir + " is not a directory", null, 5, null);
            }
            AiExcludeService aiExcludeService2 = AiExcludeService.Companion.getInstance(project2);
            if (aiExcludeService2.isFileExcluded(targetDir)) {
                return new Response(null, "directory blocked by aiexclude", null, 5, null);
            }
            PsiDirectory psiDirectory2 = PsiManager.getInstance((Project)project2).findDirectory(targetDir);
            if (psiDirectory2 == null) {
                return new Response(null, "Could not find PsiDirectory", null, 5, null);
            }
            PsiElement[] psiElementArray = psiDirectory2.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            Object $this$filterIsInstance$iv = psiElementArray;
            boolean $i$f$filterIsInstance = false;
            Object[] objectArray = $this$filterIsInstance$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PsiFile)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PsiFile it = (PsiFile)element$iv$iv;
                boolean bl = false;
                ProgressManager.checkCanceled();
                VirtualFile virtualFile3 = it.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getVirtualFile(...)");
                if (!(!aiExcludeService2.isFileExcluded(virtualFile3))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List files = (List)destination$iv$iv;
            int totalDeclarationsFound = 0;
            int nFilesSummarized = 0;
            List declarations = new ArrayList();
            for (PsiFile file : files) {
                ProgressManager.checkCanceled();
                Language language2 = file.getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"getLanguage(...)");
                List declarationsInFile = CollectionsKt.take((Iterable)CodeDeclarationSummarizer.Companion.getInstance(language2).getDeclarationSummaries(file), (int)Math.max(0, this$0.maxResults - totalDeclarationsFound));
                ++nFilesSummarized;
                if (declarationsInFile.isEmpty()) continue;
                String string = file.getVirtualFile().getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000)\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J(\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"com/google/aiplugin/agents/tools/search/ListDeclarationsInDirectoryHandler$handle$2$DeclarationsInFile", "", "filePath", "", "declarations", "", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getFilePath", "()Ljava/lang/String;", "getDeclarations", "()Ljava/util/List;", "component1", "component2", "copy", "(Ljava/lang/String;Ljava/util/List;)Lcom/google/aiplugin/agents/tools/search/ListDeclarationsInDirectoryHandler$handle$2$DeclarationsInFile;", "equals", "", "other", "hashCode", "", "toString", "aiplugin.agents.agents-core"})
                public final class DeclarationsInFile {
                    private final String filePath;
                    private final List<String> declarations;

                    public DeclarationsInFile(String filePath, List<String> declarations) {
                        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
                        Intrinsics.checkNotNullParameter(declarations, (String)"declarations");
                        this.filePath = filePath;
                        this.declarations = declarations;
                    }

                    public final String getFilePath() {
                        return this.filePath;
                    }

                    public final List<String> getDeclarations() {
                        return this.declarations;
                    }

                    public final String component1() {
                        return this.filePath;
                    }

                    public final List<String> component2() {
                        return this.declarations;
                    }

                    public final DeclarationsInFile copy(String filePath, List<String> declarations) {
                        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
                        Intrinsics.checkNotNullParameter(declarations, (String)"declarations");
                        return new DeclarationsInFile(filePath, declarations);
                    }

                    public static /* synthetic */ DeclarationsInFile copy$default(DeclarationsInFile declarationsInFile, String string, List list, int n, Object object) {
                        if ((n & 1) != 0) {
                            string = declarationsInFile.filePath;
                        }
                        if ((n & 2) != 0) {
                            list = declarationsInFile.declarations;
                        }
                        return declarationsInFile.copy(string, list);
                    }

                    public String toString() {
                        return "DeclarationsInFile(filePath=" + this.filePath + ", declarations=" + this.declarations + ")";
                    }

                    public int hashCode() {
                        int result2 = this.filePath.hashCode();
                        result2 = result2 * 31 + ((Object)this.declarations).hashCode();
                        return result2;
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (!(other instanceof DeclarationsInFile)) {
                            return false;
                        }
                        DeclarationsInFile declarationsInFile = (DeclarationsInFile)other;
                        if (!Intrinsics.areEqual((Object)this.filePath, (Object)declarationsInFile.filePath)) {
                            return false;
                        }
                        return Intrinsics.areEqual(this.declarations, declarationsInFile.declarations);
                    }
                }
                declarations.add(new DeclarationsInFile(string, declarationsInFile));
                if ((totalDeclarationsFound += declarationsInFile.size()) < this$0.maxResults) continue;
            }
            String truncationMessage = (nFilesNotSummarized = files.size() - nFilesSummarized) > 0 ? "\nLimit of " + this$0.maxResults + " results reached. Declarations not retrieved for " + nFilesNotSummarized + " more files" : "";
            return new Response(new Gson().toJson((Object)declarations) + truncationMessage, null, null, 6, null);
        }
        catch (Exception e) {
            ListDeclarationsInDirectoryHandler $this$thisLogger$iv = this$0;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ListDeclarationsInDirectoryHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)e);
            return new Response(null, "Error listing directory: " + e.getMessage(), null, 5, null);
        }
    }
}

