/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.tools.search;

import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.google.aiplugin.agents.tools.search.ListDeclarationsArgs;
import com.google.aiplugin.agents.tools.search.ListDeclarationsInDirectoryHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KParameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ToolDescription(summary="Returns a list of all public declared symbols in all the files in the given directory", description="This uses IntelliJ's PSI to identify named symbols. Note that this tool does not recurse into subdirectories.", examples={})
@ToolResult(description="A json document containing a list of symbols for each file in the directory.")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/google/aiplugin/agents/tools/search/ListDeclarationsInDirectoryTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/aiplugin/agents/tools/search/ListDeclarationsArgs;", "fileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFileSystem;)V", "maxResults", "", "name", "", "getName", "()Ljava/lang/String;", "getDisplayText", "args", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "aiplugin.agents.agents-core"})
public final class ListDeclarationsInDirectoryTool
implements Tool<ListDeclarationsArgs> {
    @NotNull
    private final VirtualFileSystem fileSystem;
    private final int maxResults;
    @NotNull
    private final String name;

    public ListDeclarationsInDirectoryTool(@NotNull VirtualFileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
        this.maxResults = 200;
        this.name = "list_definitions_in_directory";
    }

    public /* synthetic */ ListDeclarationsInDirectoryTool(VirtualFileSystem virtualFileSystem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
            virtualFileSystem = (VirtualFileSystem)localFileSystem;
        }
        this(virtualFileSystem);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDisplayText(@NotNull ListDeclarationsArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Searched for declarations";
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull ListDeclarationsArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new ListDeclarationsInDirectoryHandler(context2, this.fileSystem, args, this.maxResults);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tool.super.getDescription();
    }

    @Override
    @Nullable
    public String getStatusMessage() {
        return Tool.super.getStatusMessage();
    }

    @Override
    @Nullable
    public ToolHandler restoreHandler(@NotNull Project project2, @NotNull ListDeclarationsArgs args, @NotNull Response response2) {
        return Tool.super.restoreHandler(project2, args, response2);
    }

    @Override
    @NotNull
    public ToolDescription getToolDescription() {
        return Tool.super.getToolDescription();
    }

    @Override
    @Nullable
    public ToolResult getToolResult() {
        return Tool.super.getToolResult();
    }

    @Override
    @Nullable
    public Map<KParameter, ToolArgument> getToolArguments() {
        return Tool.super.getToolArguments();
    }

    public ListDeclarationsInDirectoryTool() {
        this(null, 1, null);
    }
}

