/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.tools.vcs;

import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.google.aiplugin.agents.tools.vcs.ListVcsRootsTool$Args$;
import com.google.gson.Gson;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KParameter;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ToolDescription(summary="Returns all VCS roots in the current project, along with their type (e.g., Git)", examples={})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u0011\u0012\u0013\u0014B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/google/aiplugin/agents/tools/vcs/ListVcsRootsTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/aiplugin/agents/tools/vcs/ListVcsRootsTool$Args;", "fileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFileSystem;)V", "name", "", "getName", "()Ljava/lang/String;", "getDisplayText", "args", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "Args", "Result", "VcsRootInfo", "Handler", "aiplugin.agents.agents-core"})
public final class ListVcsRootsTool
implements Tool<Args> {
    @NotNull
    private final VirtualFileSystem fileSystem;
    @NotNull
    private final String name;

    public ListVcsRootsTool(@NotNull VirtualFileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
        this.name = "list_vcs_roots";
    }

    public /* synthetic */ ListVcsRootsTool(VirtualFileSystem virtualFileSystem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
            virtualFileSystem = (VirtualFileSystem)localFileSystem;
        }
        this(virtualFileSystem);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDisplayText(@NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return !Intrinsics.areEqual((Object)args.getContextFile(), (Object)"<null>") ? "Finding VCS root for file" : "Finding VCS roots";
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new Handler(context2, this.fileSystem, args);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tool.super.getDescription();
    }

    @Override
    @Nullable
    public String getStatusMessage() {
        return Tool.super.getStatusMessage();
    }

    @Override
    @Nullable
    public ToolHandler restoreHandler(@NotNull Project project2, @NotNull Args args, @NotNull Response response2) {
        return Tool.super.restoreHandler(project2, args, response2);
    }

    @Override
    @NotNull
    public ToolDescription getToolDescription() {
        return Tool.super.getToolDescription();
    }

    @Override
    @Nullable
    public ToolResult getToolResult() {
        return Tool.super.getToolResult();
    }

    @Override
    @Nullable
    public Map<KParameter, ToolArgument> getToolArguments() {
        return Tool.super.getToolArguments();
    }

    public ListVcsRootsTool() {
        this(null, 1, null);
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB\u0011\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\b\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/google/aiplugin/agents/tools/vcs/ListVcsRootsTool$Args;", "", "contextFile", "", "<init>", "(Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getContextFile", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$aiplugin_agents_agents_core", "$serializer", "Companion", "aiplugin.agents.agents-core"})
    public static final class Args {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String contextFile;

        public Args(@ToolArgument(description="If provided, an absolute path of a file for which to find a VCS root. Omit to list all VCS roots in the project.") @NotNull String contextFile) {
            Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
            this.contextFile = contextFile;
        }

        public /* synthetic */ Args(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "<null>";
            }
            this(string);
        }

        @NotNull
        public final String getContextFile() {
            return this.contextFile;
        }

        @NotNull
        public final String component1() {
            return this.contextFile;
        }

        @NotNull
        public final Args copy(@ToolArgument(description="If provided, an absolute path of a file for which to find a VCS root. Omit to list all VCS roots in the project.") @NotNull String contextFile) {
            Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
            return new Args(contextFile);
        }

        public static /* synthetic */ Args copy$default(Args args, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = args.contextFile;
            }
            return args.copy(string);
        }

        @NotNull
        public String toString() {
            return "Args(contextFile=" + this.contextFile + ")";
        }

        public int hashCode() {
            return this.contextFile.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Args)) {
                return false;
            }
            Args args = (Args)other;
            return Intrinsics.areEqual((Object)this.contextFile, (Object)args.contextFile);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$aiplugin_agents_agents_core(Args self, CompositeEncoder output, SerialDescriptor serialDesc) {
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : !Intrinsics.areEqual((Object)self.contextFile, (Object)"<null>")) {
                output.encodeStringElement(serialDesc, 0, self.contextFile);
            }
        }

        public /* synthetic */ Args(int seen0, String contextFile, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)Args$$serializer.INSTANCE.getDescriptor());
            }
            this.contextFile = (seen0 & 1) == 0 ? "<null>" : contextFile;
        }

        public Args() {
            this(null, 1, null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/google/aiplugin/agents/tools/vcs/ListVcsRootsTool$Args$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/google/aiplugin/agents/tools/vcs/ListVcsRootsTool$Args;", "aiplugin.agents.agents-core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Args> serializer() {
                return (KSerializer)Args$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000bH\u0002J\u001b\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/google/aiplugin/agents/tools/vcs/ListVcsRootsTool$Handler;", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "fileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "args", "Lcom/google/aiplugin/agents/tools/vcs/ListVcsRootsTool$Args;", "<init>", "(Lcom/google/aiplugin/agents/tools/ToolContext;Lcom/intellij/openapi/vfs/VirtualFileSystem;Lcom/google/aiplugin/agents/tools/vcs/ListVcsRootsTool$Args;)V", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleWithContext", "contextFile", "", "handleWithoutContext", "createResponse", "vcsRoots", "", "Lcom/intellij/openapi/vcs/VcsRoot;", "([Lcom/intellij/openapi/vcs/VcsRoot;)Lcom/google/aiplugin/agents/Response;", "aiplugin.agents.agents-core"})
    @SourceDebugExtension(value={"SMAP\nListVcsRootsTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListVcsRootsTool.kt\ncom/google/aiplugin/agents/tools/vcs/ListVcsRootsTool$Handler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,107:1\n11158#2:108\n11493#2,3:109\n*S KotlinDebug\n*F\n+ 1 ListVcsRootsTool.kt\ncom/google/aiplugin/agents/tools/vcs/ListVcsRootsTool$Handler\n*L\n100#1:108\n100#1:109,3\n*E\n"})
    private static final class Handler
    implements ToolHandler {
        @NotNull
        private final ToolContext context;
        @NotNull
        private final VirtualFileSystem fileSystem;
        @NotNull
        private final Args args;

        public Handler(@NotNull ToolContext context2, @NotNull VirtualFileSystem fileSystem, @NotNull Args args) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.context = context2;
            this.fileSystem = fileSystem;
            this.args = args;
        }

        @Override
        @Nullable
        public Object handle(@NotNull Continuation<? super Response> $completion) {
            String contextFile = this.args.getContextFile();
            return !Intrinsics.areEqual((Object)contextFile, (Object)"<null>") ? this.handleWithContext(contextFile) : this.handleWithoutContext();
        }

        private final Response handleWithContext(String contextFile) {
            VirtualFile virtualFile2 = this.fileSystem.findFileByPath(contextFile);
            if (virtualFile2 == null) {
                return new Response(null, "context file not found", null, 5, null);
            }
            VirtualFile vFile = virtualFile2;
            VcsRoot vcsRoot = ProjectLevelVcsManager.getInstance((Project)this.context.getProject()).getVcsRootObjectFor(vFile);
            if (vcsRoot == null) {
                return new Response(null, "VCS root not found for context file", null, 5, null);
            }
            VcsRoot vcsRoot2 = vcsRoot;
            VcsRoot[] vcsRootArray = new VcsRoot[]{vcsRoot2};
            return this.createResponse(vcsRootArray);
        }

        private final Response handleWithoutContext() {
            VcsRoot[] vcsRootArray = ProjectLevelVcsManager.getInstance((Project)this.context.getProject()).getAllVcsRoots();
            Intrinsics.checkNotNullExpressionValue((Object)vcsRootArray, (String)"getAllVcsRoots(...)");
            VcsRoot[] allVcsRoots = vcsRootArray;
            return this.createResponse(allVcsRoots);
        }

        /*
         * WARNING - void declaration
         */
        private final Response createResponse(VcsRoot[] vcsRoots) {
            void $this$mapTo$iv$iv;
            VcsRoot[] $this$map$iv = vcsRoots;
            boolean $i$f$map = false;
            VcsRoot[] vcsRootArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void root;
                void item$iv$iv;
                void var11_10 = item$iv$iv = $this$mapTo$iv$iv[j];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = root.getPath().getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                Object object = root.getVcs();
                if (object == null || (object = object.getDisplayName()) == null) {
                    object = "<Unknown>";
                }
                collection.add(new VcsRootInfo(string, (String)object));
            }
            List vcsRootInfos = (List)destination$iv$iv;
            return new Response(new Gson().toJson((Object)new Result(vcsRootInfos)), null, null, 6, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/google/aiplugin/agents/tools/vcs/ListVcsRootsTool$Result;", "", "roots", "", "Lcom/google/aiplugin/agents/tools/vcs/ListVcsRootsTool$VcsRootInfo;", "<init>", "(Ljava/util/List;)V", "getRoots", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "aiplugin.agents.agents-core"})
    public static final class Result {
        @NotNull
        private final List<VcsRootInfo> roots;

        public Result(@NotNull List<VcsRootInfo> roots) {
            Intrinsics.checkNotNullParameter(roots, (String)"roots");
            this.roots = roots;
        }

        @NotNull
        public final List<VcsRootInfo> getRoots() {
            return this.roots;
        }

        @NotNull
        public final List<VcsRootInfo> component1() {
            return this.roots;
        }

        @NotNull
        public final Result copy(@NotNull List<VcsRootInfo> roots) {
            Intrinsics.checkNotNullParameter(roots, (String)"roots");
            return new Result(roots);
        }

        public static /* synthetic */ Result copy$default(Result result2, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = result2.roots;
            }
            return result2.copy(list);
        }

        @NotNull
        public String toString() {
            return "Result(roots=" + this.roots + ")";
        }

        public int hashCode() {
            return ((Object)this.roots).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result2 = (Result)other;
            return Intrinsics.areEqual(this.roots, result2.roots);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/google/aiplugin/agents/tools/vcs/ListVcsRootsTool$VcsRootInfo;", "", "vcsRoot", "", "vcsType", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getVcsRoot", "()Ljava/lang/String;", "getVcsType", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "aiplugin.agents.agents-core"})
    public static final class VcsRootInfo {
        @NotNull
        private final String vcsRoot;
        @NotNull
        private final String vcsType;

        public VcsRootInfo(@NotNull String vcsRoot, @NotNull String vcsType) {
            Intrinsics.checkNotNullParameter((Object)vcsRoot, (String)"vcsRoot");
            Intrinsics.checkNotNullParameter((Object)vcsType, (String)"vcsType");
            this.vcsRoot = vcsRoot;
            this.vcsType = vcsType;
        }

        @NotNull
        public final String getVcsRoot() {
            return this.vcsRoot;
        }

        @NotNull
        public final String getVcsType() {
            return this.vcsType;
        }

        @NotNull
        public final String component1() {
            return this.vcsRoot;
        }

        @NotNull
        public final String component2() {
            return this.vcsType;
        }

        @NotNull
        public final VcsRootInfo copy(@NotNull String vcsRoot, @NotNull String vcsType) {
            Intrinsics.checkNotNullParameter((Object)vcsRoot, (String)"vcsRoot");
            Intrinsics.checkNotNullParameter((Object)vcsType, (String)"vcsType");
            return new VcsRootInfo(vcsRoot, vcsType);
        }

        public static /* synthetic */ VcsRootInfo copy$default(VcsRootInfo vcsRootInfo, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = vcsRootInfo.vcsRoot;
            }
            if ((n & 2) != 0) {
                string2 = vcsRootInfo.vcsType;
            }
            return vcsRootInfo.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "VcsRootInfo(vcsRoot=" + this.vcsRoot + ", vcsType=" + this.vcsType + ")";
        }

        public int hashCode() {
            int result2 = this.vcsRoot.hashCode();
            result2 = result2 * 31 + this.vcsType.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VcsRootInfo)) {
                return false;
            }
            VcsRootInfo vcsRootInfo = (VcsRootInfo)other;
            if (!Intrinsics.areEqual((Object)this.vcsRoot, (Object)vcsRootInfo.vcsRoot)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.vcsType, (Object)vcsRootInfo.vcsType);
        }
    }
}

