/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.embedding;

import com.google.aiplugin.rag.embedding.EmbeddingData;
import com.google.aiplugin.rag.embedding.EmbeddingVector;
import com.google.aiplugin.rag.embedding.LocalVectorDBClient;
import com.google.aiplugin.rag.embedding.SqliteVectorDBClient;
import com.intellij.openapi.diagnostic.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0003H\u0016J\u0014\u0010\"\u001a\u00020 *\u00020#2\u0006\u0010$\u001a\u00020%H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006&"}, d2={"Lcom/google/aiplugin/rag/embedding/SqliteVectorDBClient;", "Lcom/google/aiplugin/rag/embedding/LocalVectorDBClient;", "dbFilePath", "", "<init>", "(Ljava/lang/String;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "embeddingDBUrl", "getEmbeddingDBUrl", "()Ljava/lang/String;", "embeddingDBConnection", "Ljava/sql/Connection;", "getEmbeddingDBConnection", "()Ljava/sql/Connection;", "setEmbeddingDBConnection", "(Ljava/sql/Connection;)V", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "search", "", "", "queryEmbedding", "Lcom/google/aiplugin/rag/embedding/EmbeddingVector;", "topK", "search-LG7R-eo", "([FI)Ljava/util/List;", "deleteAllUnindexed", "", "timeAfterUnindexed", "addEmbeddingData", "Ljava/sql/PreparedStatement;", "embeddingData", "Lcom/google/aiplugin/rag/embedding/EmbeddingData;", "aiplugin.rag.indexer"})
@SourceDebugExtension(value={"SMAP\nSqliteVectorDBClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqliteVectorDBClient.kt\ncom/google/aiplugin/rag/embedding/SqliteVectorDBClient\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,104:1\n25#2:105\n*S KotlinDebug\n*F\n+ 1 SqliteVectorDBClient.kt\ncom/google/aiplugin/rag/embedding/SqliteVectorDBClient\n*L\n33#1:105\n*E\n"})
public final class SqliteVectorDBClient
implements LocalVectorDBClient {
    @NotNull
    private final Logger logger;
    @NotNull
    private final String embeddingDBUrl;
    @Nullable
    private Connection embeddingDBConnection;
    @NotNull
    private final ReentrantLock lock;

    public SqliteVectorDBClient(@NotNull String dbFilePath) {
        Intrinsics.checkNotNullParameter((Object)dbFilePath, (String)"dbFilePath");
        SqliteVectorDBClient $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(SqliteVectorDBClient.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.embeddingDBUrl = "jdbc:sqlite:" + dbFilePath;
        this.lock = new ReentrantLock();
        try {
            Class.forName("org.sqlite.JDBC");
            this.getLogger().info("Loading org.sqlite.JDBC works. The index DB file path is " + dbFilePath + ".");
        }
        catch (ClassNotFoundException e) {
            this.getLogger().error((Throwable)e);
        }
        this.createStatement("\nCREATE TABLE IF NOT EXISTS gemini_embeddings (\nfile_id INTEGER PRIMARY KEY NOT NULL,\nembedding BLOB,\nunindexed_time TEXT\n);\n");
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    @NotNull
    public String getEmbeddingDBUrl() {
        return this.embeddingDBUrl;
    }

    @Override
    @Nullable
    public Connection getEmbeddingDBConnection() {
        return this.embeddingDBConnection;
    }

    @Override
    public void setEmbeddingDBConnection(@Nullable Connection connection) {
        this.embeddingDBConnection = connection;
    }

    @Override
    @NotNull
    public ReentrantLock getLock() {
        return this.lock;
    }

    @Override
    @NotNull
    public List<Integer> search-LG7R-eo(@NotNull float[] queryEmbedding, int topK) {
        List list;
        Intrinsics.checkNotNullParameter((Object)queryEmbedding, (String)"queryEmbedding");
        PriorityQueue queue = new PriorityQueue();
        this.prepareStatement("\nSELECT file_id, embedding\nFROM gemini_embeddings\nWHERE unindexed_time IS NULL\nAND embedding IS NOT NULL;\n", (arg_0, arg_1) -> SqliteVectorDBClient.search_LG7R_eo$lambda$0(queryEmbedding, queue, topK, arg_0, arg_1));
        List $this$search_LG7R_eo_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        while (!((Collection)queue).isEmpty()) {
            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000+\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"com/google/aiplugin/rag/embedding/SqliteVectorDBClient$search$IdWithSimilarity", "", "fileId", "", "similarityWithQuery", "", "<init>", "(IF)V", "getFileId", "()I", "getSimilarityWithQuery", "()F", "compareTo", "other", "(Lcom/google/aiplugin/rag/embedding/SqliteVectorDBClient$search$IdWithSimilarity;)I", "component1", "component2", "copy", "(IF)Lcom/google/aiplugin/rag/embedding/SqliteVectorDBClient$search$IdWithSimilarity;", "equals", "", "", "hashCode", "toString", "", "aiplugin.rag.indexer"})
            public final class IdWithSimilarity
            implements Comparable<IdWithSimilarity> {
                private final int fileId;
                private final float similarityWithQuery;

                public IdWithSimilarity(int fileId, float similarityWithQuery) {
                    this.fileId = fileId;
                    this.similarityWithQuery = similarityWithQuery;
                }

                public final int getFileId() {
                    return this.fileId;
                }

                public final float getSimilarityWithQuery() {
                    return this.similarityWithQuery;
                }

                public int compareTo(IdWithSimilarity other) {
                    Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                    return Float.compare(this.similarityWithQuery, other.similarityWithQuery);
                }

                public final int component1() {
                    return this.fileId;
                }

                public final float component2() {
                    return this.similarityWithQuery;
                }

                public final IdWithSimilarity copy(int fileId, float similarityWithQuery) {
                    return new IdWithSimilarity(fileId, similarityWithQuery);
                }

                public static /* synthetic */ IdWithSimilarity copy$default(IdWithSimilarity idWithSimilarity, int n, float f, int n2, Object object) {
                    if ((n2 & 1) != 0) {
                        n = idWithSimilarity.fileId;
                    }
                    if ((n2 & 2) != 0) {
                        f = idWithSimilarity.similarityWithQuery;
                    }
                    return idWithSimilarity.copy(n, f);
                }

                public String toString() {
                    return "IdWithSimilarity(fileId=" + this.fileId + ", similarityWithQuery=" + this.similarityWithQuery + ")";
                }

                public int hashCode() {
                    int result2 = Integer.hashCode(this.fileId);
                    result2 = result2 * 31 + Float.hashCode(this.similarityWithQuery);
                    return result2;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof IdWithSimilarity)) {
                        return false;
                    }
                    IdWithSimilarity idWithSimilarity = (IdWithSimilarity)other;
                    if (this.fileId != idWithSimilarity.fileId) {
                        return false;
                    }
                    return Float.compare(this.similarityWithQuery, idWithSimilarity.similarityWithQuery) == 0;
                }
            }
            $this$search_LG7R_eo_u24lambda_u241.add(((IdWithSimilarity)queue.remove()).getFileId());
        }
        return CollectionsKt.reversed((Iterable)CollectionsKt.build((List)list));
    }

    @Override
    public void deleteAllUnindexed(@NotNull String timeAfterUnindexed) {
        Intrinsics.checkNotNullParameter((Object)timeAfterUnindexed, (String)"timeAfterUnindexed");
        Object deleteAllUnindexedSql = Intrinsics.areEqual((Object)timeAfterUnindexed, (Object)"") ? "\n  DELETE FROM gemini_embeddings\n  WHERE unindexed_time is NOT NULL;\n" : "\n  DELETE FROM gemini_embeddings WHERE unindexed_time < datetime('now', '" + timeAfterUnindexed + "');\n";
        this.createStatement((String)deleteAllUnindexedSql);
    }

    @Override
    public void addEmbeddingData(@NotNull PreparedStatement $this$addEmbeddingData, @NotNull EmbeddingData embeddingData) {
        byte[] embeddingBytes;
        Intrinsics.checkNotNullParameter((Object)$this$addEmbeddingData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)embeddingData, (String)"embeddingData");
        $this$addEmbeddingData.setInt(1, embeddingData.getFileId());
        float[] fArray = embeddingData.getEmbedding-JirZnks();
        Object object = embeddingBytes = (Object)(fArray != null ? EmbeddingVector.toByteArray-impl(fArray) : null);
        if (embeddingBytes != null) {
            $this$addEmbeddingData.setBytes(2, embeddingBytes);
        } else {
            $this$addEmbeddingData.setNull(2, 2004);
        }
        $this$addEmbeddingData.addBatch();
    }

    @Override
    public void addOrUpdate(@NotNull List<EmbeddingData> embeddings) {
        LocalVectorDBClient.super.addOrUpdate(embeddings);
    }

    @Override
    public boolean contains(int fileId) {
        return LocalVectorDBClient.super.contains(fileId);
    }

    @Override
    public void unindex(int fileId) {
        LocalVectorDBClient.super.unindex(fileId);
    }

    @Override
    public boolean cancelUnindexing(int fileId) {
        return LocalVectorDBClient.super.cancelUnindexing(fileId);
    }

    @Override
    public void dispose() {
        LocalVectorDBClient.super.dispose();
    }

    @Override
    public int count() {
        return LocalVectorDBClient.super.count();
    }

    @Override
    @Nullable
    public <R> R connect(@NotNull Function1<? super Connection, ? extends R> run2) {
        return LocalVectorDBClient.super.connect(run2);
    }

    @Override
    @Nullable
    public Boolean createStatement(@NotNull String sql) {
        return LocalVectorDBClient.super.createStatement(sql);
    }

    @Override
    @Nullable
    public <R> R createStatement(@NotNull String sql, @NotNull Function2<? super Connection, ? super ResultSet, ? extends R> run2) {
        return LocalVectorDBClient.super.createStatement(sql, run2);
    }

    @Override
    @Nullable
    public <R> R prepareStatement(@NotNull String sql, @NotNull Function2<? super Connection, ? super PreparedStatement, ? extends R> run2) {
        return LocalVectorDBClient.super.prepareStatement(sql, run2);
    }

    private static final Unit search_LG7R_eo$lambda$0(float[] $queryEmbedding, PriorityQueue $queue, int $topK, Connection connection, PreparedStatement statement) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        ResultSet rs = statement.executeQuery();
        while (rs.next()) {
            byte[] embeddingBytes;
            int fileId = rs.getInt("file_id");
            if (rs.getBytes("embedding") == null) continue;
            float[] embedding = EmbeddingVector.Companion.fromByteArray-AjrUS1E(embeddingBytes);
            float similarity = EmbeddingVector.cos-h3pdXJg($queryEmbedding, embedding);
            $queue.add(new IdWithSimilarity(fileId, similarity));
            if ($queue.size() <= $topK) continue;
            $queue.remove();
        }
        return Unit.INSTANCE;
    }
}

