/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.analytics.firelog;

import com.google.cloud.tools.intellij.analytics.MetricsEnvironmentProviderBase;
import com.google.cloud.tools.intellij.analytics.firelog.ClearcutEventPayload;
import com.google.cloud.tools.intellij.analytics.firelog.MetricsResponse;
import com.google.cloud.tools.intellij.analytics.firelog.MetricsSender;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public abstract class FirelogHttpSenderBase
implements MetricsSender {
    private static final Logger logger = Logger.getInstance(FirelogHttpSenderBase.class);
    private static final String FIRELOG_API_KEY = "AIzaSyAHjSOddvsNOK2a8xLvqoX3j9frk0CfXn4";
    private static final String FIRELOG_COLLECTION_URL = "https://firebaselogging-pa.googleapis.com/v1/firelog/legacy/log?key=AIzaSyAHjSOddvsNOK2a8xLvqoX3j9frk0CfXn4";
    private HttpClient client;
    private static final Duration FIRELOG_REQUEST_TIMEOUT = Duration.ofSeconds(30L);

    public abstract MetricsEnvironmentProviderBase getMetricsEnvironmentProvider();

    public abstract String getUserAgent();

    @Override
    public String getId() {
        return "firelog";
    }

    @Override
    @RequiresBackgroundThread
    public Optional<Duration> sendPing(ClearcutEventPayload payload) {
        try {
            this.client = this.client == null ? HttpClient.newHttpClient() : this.client;
            HttpRequest request2 = HttpRequest.newBuilder().uri(URI.create(FIRELOG_COLLECTION_URL)).timeout(FIRELOG_REQUEST_TIMEOUT).setHeader("User-Agent", this.getUserAgent()).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(GSON.toJson((Object)payload))).build();
            HttpResponse<String> response2 = this.client.send(request2, HttpResponse.BodyHandlers.ofString());
            int statusCode = response2.statusCode();
            if (statusCode >= 300) {
                logger.warn("Non 200 status code for firelog request: " + statusCode);
                return Optional.empty();
            }
            return FirelogHttpSenderBase.extractNextRequestWaitDuration(response2);
        }
        catch (Exception e) {
            if (this.getMetricsEnvironmentProvider().getMetricsEnvironment() == MetricsEnvironmentProviderBase.MetricsEnvironment.DEV) {
                logger.warn("Failed to upload metrics.");
            }
            logger.warn("Exception during metrics service ping", (Throwable)e);
            return Optional.empty();
        }
    }

    private static Optional<Duration> extractNextRequestWaitDuration(@NotNull HttpResponse<String> response2) {
        try {
            MetricsResponse metricsResponse = (MetricsResponse)GSON.fromJson(response2.body(), MetricsResponse.class);
            if (metricsResponse == null) {
                logger.warn("Unable to extract nextRequestWaitMillis because response was empty.");
                return Optional.empty();
            }
            return Optional.of(Duration.ofMillis(Long.parseLong(metricsResponse.nextRequestWaitMillis)));
        }
        catch (RuntimeException e) {
            logger.warn("Unable to extract nextRequestWaitMillis.", (Throwable)e);
            return Optional.empty();
        }
    }

    @VisibleForTesting
    void setHttpClient(HttpClient client) {
        this.client = client;
    }
}

