/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.feedback;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleAnonymousFeedbackTask
extends Task.Backgroundable {
    private final Consumer<String> callback;
    private final Consumer<Exception> errorCallback;
    private final Throwable throwable;
    private final String errorDescription;
    private final FeedbackSender feedbackSender;

    GoogleAnonymousFeedbackTask(@Nullable Project project2, @NotNull String title, boolean canBeCancelled, @Nullable Throwable throwable, String errorDescription, Consumer<String> callback, Consumer<Exception> errorCallback, FeedbackSender feedbackSender) {
        super(project2, title, canBeCancelled);
        this.throwable = throwable;
        this.errorDescription = errorDescription;
        this.callback = callback;
        this.errorCallback = errorCallback;
        this.feedbackSender = feedbackSender;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        indicator.setIndeterminate(true);
        try {
            String token = this.feedbackSender.sendFeedback(this.throwable, this.errorDescription);
            this.callback.consume((Object)token);
        }
        catch (IOException | RuntimeException exception) {
            this.errorCallback.consume((Object)exception);
        }
    }

    public static interface FeedbackSender {
        public String sendFeedback(Throwable var1, String var2) throws IOException;
    }
}

