/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.login;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.services.oauth2.model.Userinfo;
import com.google.cloud.tools.intellij.login.GoogleLoginUtils;
import com.google.cloud.tools.intellij.login.IGoogleLoginCompletedCallback;
import com.google.cloud.tools.intellij.login.sdk.ExtendedCredential;
import java.awt.Image;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CredentialedUser {
    private String name = "";
    private Image image;
    private final String email;
    private final Credential credential;
    private final ExtendedCredential extendedCredential;
    private final boolean isActive;

    public CredentialedUser(@NotNull String email, boolean isActive, @NotNull ExtendedCredential extendedCredential) {
        this.email = email;
        this.credential = extendedCredential.getCredential();
        this.extendedCredential = extendedCredential;
        this.isActive = isActive;
        GoogleLoginUtils.getUserInfo(this.credential, userInfo -> this.initializeUserInfo((Userinfo)userInfo, null));
    }

    public String getEmail() {
        return this.email;
    }

    public Credential getCredential() {
        return this.credential;
    }

    @NotNull
    public ExtendedCredential getExtendedCredential() {
        return this.extendedCredential;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public String getName() {
        return this.name;
    }

    public Image getPicture() {
        return this.image;
    }

    private void initializeUserInfo(Userinfo userInfo, @Nullable IGoogleLoginCompletedCallback loginCompletedCallback) {
        if (userInfo == null) {
            this.name = null;
            this.image = null;
        } else {
            this.name = userInfo.getName();
            GoogleLoginUtils.provideUserPicture(userInfo, newImage -> {
                this.image = newImage;
                if (loginCompletedCallback != null) {
                    loginCompletedCallback.onLoginCompleted();
                }
            });
        }
    }
}

