/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.aiplugin.editor.prediction;

import com.google.tools.aiplugin.editor.prediction.Diff;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u0004\u0018\u00010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/DiffReader;", "", "reader", "Ljava/io/BufferedReader;", "<init>", "(Ljava/io/BufferedReader;)V", "getReader", "()Ljava/io/BufferedReader;", "diffHeader", "Lkotlin/text/Regex;", "lookAhead", "", "readDiff", "Lcom/google/tools/aiplugin/editor/prediction/Diff;", "aiplugin.editor.prediction"})
public final class DiffReader {
    @NotNull
    private final BufferedReader reader;
    @NotNull
    private final Regex diffHeader;
    @Nullable
    private String lookAhead;

    public DiffReader(@NotNull BufferedReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.reader = reader;
        this.diffHeader = new Regex("^--- .*$");
        this.lookAhead = this.reader.readLine();
    }

    @NotNull
    public final BufferedReader getReader() {
        return this.reader;
    }

    @Nullable
    public final Diff readDiff() {
        String string;
        while (this.lookAhead != null) {
            String string2 = this.lookAhead;
            Intrinsics.checkNotNull((Object)string2);
            if (this.diffHeader.matches((CharSequence)string2)) break;
            this.lookAhead = this.reader.readLine();
        }
        if (this.lookAhead == null) {
            return null;
        }
        List diffText = new ArrayList();
        do {
            String string3 = this.lookAhead;
            Intrinsics.checkNotNull((Object)string3);
            diffText.add(string3);
            this.lookAhead = this.reader.readLine();
            if (this.lookAhead == null) break;
            string = this.lookAhead;
            Intrinsics.checkNotNull((Object)string);
        } while (!this.diffHeader.matches((CharSequence)string));
        return Diff.Companion.parseDiff(CollectionsKt.joinToString$default((Iterable)diffText, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
    }
}

