/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.aiplugin.editor.prediction;

import com.google.tools.aiplugin.editor.prediction.Diff;
import com.google.tools.aiplugin.editor.prediction.DocumentChange;
import com.google.tools.aiplugin.editor.prediction.FileHeader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/DocumentChangeTracker;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "clock", "Lkotlinx/datetime/Clock;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lkotlinx/datetime/Clock;Lcom/intellij/openapi/Disposable;)V", "getClock", "()Lkotlinx/datetime/Clock;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "channel", "Lkotlinx/coroutines/channels/Channel;", "Lcom/google/tools/aiplugin/editor/prediction/DocumentChange;", "docs", "", "Ljava/nio/file/Path;", "", "getDocs", "()Ljava/util/Map;", "start", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "clear", "aiplugin.editor.prediction"})
public final class DocumentChangeTracker
implements DocumentListener {
    @NotNull
    private final Clock clock;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final Channel<DocumentChange> channel;
    @NotNull
    private final Map<Path, Long> docs;

    public DocumentChangeTracker(@NotNull Clock clock, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.clock = clock;
        this.disposable = disposable;
        this.channel = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        this.docs = new LinkedHashMap();
    }

    @NotNull
    public final Clock getClock() {
        return this.clock;
    }

    @NotNull
    public final Disposable getDisposable() {
        return this.disposable;
    }

    @NotNull
    public final Map<Path, Long> getDocs() {
        return this.docs;
    }

    @NotNull
    public final Channel<DocumentChange> start() {
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)this, this.disposable);
        return this.channel;
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        DocumentChange documentChange;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Document document = event.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document doc = document;
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(doc);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile virtualFile3 = virtualFile2;
        if (!virtualFile3.isInLocalFileSystem()) {
            return;
        }
        Path path2 = virtualFile3.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toNioPath(...)");
        Path path3 = path2;
        Instant now = this.clock.now();
        Long l2 = this.docs.get(path3);
        long l3 = event.getOldTimeStamp();
        if (l2 == null || l2 != l3) {
            FileHeader header = new FileHeader(((Object)path3).toString(), now, doc.getModificationStamp());
            String string = doc.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            documentChange = new DocumentChange.Create(header, string);
        } else {
            String afterChange;
            String string = doc.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = afterChange = string;
            int n = event.getOffset();
            int n2 = event.getOffset() + event.getNewFragment().length();
            CharSequence charSequence = event.getOldFragment();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getOldFragment(...)");
            CharSequence charSequence2 = charSequence;
            String beforeChange = ((Object)StringsKt.replaceRange((CharSequence)string2, (int)n, (int)n2, (CharSequence)charSequence2)).toString();
            FileHeader oldFile = new FileHeader(((Object)path3).toString(), now, event.getOldTimeStamp());
            FileHeader newFile = new FileHeader(((Object)path3).toString(), now, doc.getModificationStamp());
            Diff diff = Diff.Companion.calculateDiff(beforeChange, afterChange, oldFile, newFile);
            documentChange = new DocumentChange.Delta(diff);
        }
        DocumentChange change = documentChange;
        this.docs.put(path3, doc.getModificationStamp());
        this.channel.trySend-JP2dKIU((Object)change);
    }

    @RequiresEdt
    public final void clear() {
        this.docs.clear();
        this.channel.trySend-JP2dKIU((Object)DocumentChange.Clear.INSTANCE);
    }
}

