/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.aiplugin.editor.predictionservices.debug;

import com.android.studio.ml.suggestion.session.SuggestionControlSession;
import com.android.studio.ml.suggestion.session.SuggestionControlSessionManager;
import com.google.tools.aiplugin.editor.prediction.Diff;
import com.google.tools.aiplugin.editor.prediction.Prediction;
import com.google.tools.aiplugin.editor.predictionservices.Config;
import com.google.tools.aiplugin.editor.predictionservices.PredictionEvent;
import com.google.tools.aiplugin.editor.predictionservices.PredictionService;
import com.google.tools.aiplugin.editor.predictionservices.debug.DiffHistoryEntry;
import com.google.tools.aiplugin.editor.predictionservices.debug.InjectedDiffHistoryManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableSharedFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010*\u001a\u00020\u0019H\u0014J\b\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020\u0013H\u0002J\b\u0010/\u001a\u00020,H\u0002J\u0010\u00100\u001a\u00020,2\u0006\u00101\u001a\u000202H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010'\u001a\u0010\u0012\f\u0012\n )*\u0004\u0018\u00010&0&0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/debug/NextEditPredictionDebugDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "apply", "Ljavax/swing/JButton;", "getApply", "()Ljavax/swing/JButton;", "saveDiff", "getSaveDiff", "accept", "getAccept", "inject", "getInject", "lastPrediction", "Lcom/google/tools/aiplugin/editor/prediction/Prediction;", "getLastPrediction", "()Lcom/google/tools/aiplugin/editor/prediction/Prediction;", "setLastPrediction", "(Lcom/google/tools/aiplugin/editor/prediction/Prediction;)V", "root", "Ljavax/swing/JPanel;", "getRoot", "()Ljavax/swing/JPanel;", "config", "Lcom/google/tools/aiplugin/editor/predictionservices/Config;", "getConfig", "()Lcom/google/tools/aiplugin/editor/predictionservices/Config;", "setConfig", "(Lcom/google/tools/aiplugin/editor/predictionservices/Config;)V", "diffHistoryManager", "Lcom/google/tools/aiplugin/editor/predictionservices/debug/InjectedDiffHistoryManager;", "diffHistoryModel", "Ljavax/swing/DefaultComboBoxModel;", "Lcom/google/tools/aiplugin/editor/predictionservices/debug/DiffHistoryEntry;", "diffHistoryComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "kotlin.jvm.PlatformType", "createCenterPanel", "updateHistoryDropdown", "", "applyPrediction", "prediction", "acceptActiveControl", "injectPrediction", "text", "", "aiplugin.editor.prediction-services"})
@SourceDebugExtension(value={"SMAP\nNextEditPredictionDebugDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditPredictionDebugDialog.kt\ncom/google/tools/aiplugin/editor/predictionservices/debug/NextEditPredictionDebugDialog\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,304:1\n31#2,2:305\n31#2,2:309\n31#2,2:311\n25#3:307\n25#3:308\n*S KotlinDebug\n*F\n+ 1 NextEditPredictionDebugDialog.kt\ncom/google/tools/aiplugin/editor/predictionservices/debug/NextEditPredictionDebugDialog\n*L\n72#1:305,2\n84#1:309,2\n149#1:311,2\n275#1:307\n283#1:308\n*E\n"})
public final class NextEditPredictionDebugDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final JButton apply;
    @NotNull
    private final JButton saveDiff;
    @NotNull
    private final JButton accept;
    @NotNull
    private final JButton inject;
    @Nullable
    private Prediction lastPrediction;
    @NotNull
    private final JPanel root;
    @NotNull
    private Config config;
    @NotNull
    private final InjectedDiffHistoryManager diffHistoryManager;
    @NotNull
    private final DefaultComboBoxModel<DiffHistoryEntry> diffHistoryModel;
    @NotNull
    private final ComboBox<DiffHistoryEntry> diffHistoryComboBox;

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final JButton getApply() {
        return this.apply;
    }

    @NotNull
    public final JButton getSaveDiff() {
        return this.saveDiff;
    }

    @NotNull
    public final JButton getAccept() {
        return this.accept;
    }

    @NotNull
    public final JButton getInject() {
        return this.inject;
    }

    @Nullable
    public final Prediction getLastPrediction() {
        return this.lastPrediction;
    }

    public final void setLastPrediction(@Nullable Prediction prediction2) {
        this.lastPrediction = prediction2;
    }

    @NotNull
    public final JPanel getRoot() {
        return this.root;
    }

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    public final void setConfig(@NotNull Config config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"<set-?>");
        this.config = config2;
    }

    public NextEditPredictionDebugDialog(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2);
        this.apply = new JButton("Apply");
        this.saveDiff = new JButton("Save Diff");
        this.accept = new JButton("Accept via Editor");
        this.inject = new JButton("Inject Diff");
        this.root = new JPanel();
        this.diffHistoryModel = new DefaultComboBoxModel();
        this.diffHistoryComboBox = new ComboBox((ComboBoxModel)this.diffHistoryModel);
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<PredictionService> serviceClass$iv = PredictionService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        PredictionService service = (PredictionService)object;
        this.project = project2;
        this.config = service.getConfig();
        this.diffHistoryManager = InjectedDiffHistoryManager.Companion.getInstance(project2);
        this.setModal(false);
        this.setTitle("Next Edit Prediction Controller");
        this.setResizable(true);
        this.root.setMinimumSize(new Dimension(1000, 600));
        this.root.setLayout(new BorderLayout());
        JButton predictButton = new JButton("Predict");
        predictButton.addActionListener(arg_0 -> NextEditPredictionDebugDialog._init_$lambda$0(project2, arg_0));
        JPanel response2 = new JPanel();
        this.root.add((Component)response2, "Center");
        response2.setLayout(new BorderLayout());
        JTextArea textArea = new JTextArea();
        JBScrollPane scrollPane = new JBScrollPane((Component)textArea);
        response2.add((Component)scrollPane, "Center");
        textArea.setEditable(false);
        textArea.setBorder(IdeBorderFactory.createBorder());
        DefaultComboBoxModel<PredictionEvent> events = new DefaultComboBoxModel<PredictionEvent>();
        ComboBox combo = new ComboBox((ComboBoxModel)events);
        response2.add((Component)combo, "North");
        JPanel controls2 = new JPanel();
        response2.add((Component)controls2, "West");
        controls2.setLayout((LayoutManager)new VerticalFlowLayout());
        controls2.add(predictButton);
        this.apply.setEnabled(false);
        controls2.add(this.apply);
        this.apply.addActionListener(arg_0 -> NextEditPredictionDebugDialog._init_$lambda$2(events, this, textArea, arg_0));
        this.saveDiff.setEnabled(false);
        controls2.add(this.saveDiff);
        this.saveDiff.addActionListener(arg_0 -> NextEditPredictionDebugDialog._init_$lambda$4(this, arg_0));
        controls2.add(this.accept);
        this.accept.addActionListener(arg_0 -> NextEditPredictionDebugDialog._init_$lambda$5(this, arg_0));
        controls2.add((Component)new TitledSeparator("Config"));
        JBTextField delay = new JBTextField();
        JPanel delayPanel = new JPanel();
        delayPanel.setLayout(new BoxLayout(delayPanel, 2));
        delayPanel.add((Component)delay);
        delayPanel.add((Component)new JBLabel("ms"));
        controls2.add(delayPanel);
        delay.setText(String.valueOf(this.config.getAutoPredictDelay()));
        JCheckBox ignoreOutdated = new JCheckBox("Ignore outdated");
        ignoreOutdated.setSelected(this.config.getIgnoreOutdated());
        controls2.add(ignoreOutdated);
        JButton reconfigure = new JButton("Reconfigure");
        reconfigure.addActionListener(arg_0 -> NextEditPredictionDebugDialog._init_$lambda$6(delay, this, ignoreOutdated, project2, arg_0));
        controls2.add(reconfigure);
        JPanel injectPanel = new JPanel();
        injectPanel.setLayout(new BorderLayout());
        this.root.add((Component)injectPanel, "South");
        JPanel injectControls = new JPanel();
        injectControls.setLayout((LayoutManager)new VerticalFlowLayout());
        injectPanel.add((Component)injectControls, "West");
        JTextArea injectedDiffText = new JTextArea();
        injectControls.add(this.inject);
        this.inject.addActionListener(arg_0 -> NextEditPredictionDebugDialog._init_$lambda$7(this, injectedDiffText, arg_0));
        JButton clearButton = new JButton("Clear");
        injectControls.add(clearButton);
        clearButton.addActionListener(arg_0 -> NextEditPredictionDebugDialog._init_$lambda$8(injectedDiffText, this, arg_0));
        this.diffHistoryComboBox.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                DiffHistoryEntry diffHistoryEntry = value instanceof DiffHistoryEntry ? (DiffHistoryEntry)value : null;
                this.setText(diffHistoryEntry != null ? diffHistoryEntry.getReason() : null);
                return this;
            }
        });
        injectPanel.add((Component)this.diffHistoryComboBox, "North");
        this.updateHistoryDropdown();
        this.diffHistoryComboBox.addItemListener(arg_0 -> NextEditPredictionDebugDialog._init_$lambda$9(injectedDiffText, arg_0));
        injectPanel.add((Component)injectedDiffText, "Center");
        injectedDiffText.setBorder(IdeBorderFactory.createBorder());
        injectedDiffText.setRows(10);
        combo.addItemListener(arg_0 -> NextEditPredictionDebugDialog._init_$lambda$10(this, textArea, arg_0));
        BuildersKt.launch$default((CoroutineScope)service.getCs(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(service, events, null){
            int label;
            final /* synthetic */ PredictionService $service;
            final /* synthetic */ DefaultComboBoxModel<PredictionEvent> $events;
            {
                this.$service = $service;
                this.$events = $events;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$service.getEvents$aiplugin_editor_prediction_services().collect(new FlowCollector(){

                            public final Object emit(PredictionEvent event, Continuation<? super Unit> $completion) {
                                $events.addElement(event);
                                $events.setSelectedItem(event);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.init();
    }

    @NotNull
    protected JPanel createCenterPanel() {
        return this.root;
    }

    private final void updateHistoryDropdown() {
        List<DiffHistoryEntry> history2 = this.diffHistoryManager.getHistory();
        this.diffHistoryModel.removeAllElements();
        this.diffHistoryModel.addAll((Collection<DiffHistoryEntry>)history2);
        this.diffHistoryComboBox.setSelectedItem(null);
    }

    private final void applyPrediction(Prediction prediction2) {
        WriteCommandAction.runWriteCommandAction((Project)this.project, () -> NextEditPredictionDebugDialog.applyPrediction$lambda$11(prediction2));
    }

    private final void acceptActiveControl() {
        block1: {
            Object object = FileEditorManager.getInstance((Project)this.project).getSelectedEditor();
            TextEditor textEditor = object instanceof TextEditor ? (TextEditor)object : null;
            if (textEditor == null) {
                return;
            }
            TextEditor textEditor2 = textEditor;
            Editor editor = textEditor2.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            SuggestionControlSession suggestionControlSession = SuggestionControlSessionManager.Companion.getInstance(this.project, editor).getCurrentSession();
            if (suggestionControlSession == null || (object = suggestionControlSession.getActiveControl()) == null) break block1;
            object.accept();
        }
    }

    private final void injectPrediction(String text2) {
        String ex2;
        Diff diff;
        FileEditor fileEditor = FileEditorManager.getInstance((Project)this.project).getSelectedEditor();
        Object object = fileEditor;
        if (object == null || (object = object.getFile()) == null || (object = object.getPath()) == null) {
            return;
        }
        Object path2 = object;
        TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
        if (textEditor == null || (textEditor = textEditor.getEditor()) == null || (textEditor = textEditor.getDocument()) == null) {
            return;
        }
        TextEditor document = textEditor;
        try {
            diff = Diff.Companion.parseDiff(text2);
        }
        catch (Exception ex2) {
            NextEditPredictionDebugDialog $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(NextEditPredictionDebugDialog.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to parse injected diff", (Throwable)ex2);
            return;
        }
        Diff diff2 = diff;
        try {
            String string = document.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            ex2 = diff2.apply(string);
        }
        catch (Exception ex3) {
            NextEditPredictionDebugDialog $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(NextEditPredictionDebugDialog.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to apply injected diff", (Throwable)ex3);
            return;
        }
        String result2 = ex2;
        PredictionService predictionService = PredictionService.Companion.getInstance(this.project);
        BuildersKt.launch$default((CoroutineScope)predictionService.getCs(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(predictionService, (String)path2, (Document)document, diff2, result2, null){
            int label;
            final /* synthetic */ PredictionService $predictionService;
            final /* synthetic */ String $path;
            final /* synthetic */ Document $document;
            final /* synthetic */ Diff $diff;
            final /* synthetic */ String $result;
            {
                this.$predictionService = $predictionService;
                this.$path = $path;
                this.$document = $document;
                this.$diff = $diff;
                this.$result = $result;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        MutableSharedFlow<PredictionEvent> mutableSharedFlow = this.$predictionService.getEvents$aiplugin_editor_prediction_services();
                        Path path2 = Paths.get(this.$path, new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                        this.label = 1;
                        Object object3 = mutableSharedFlow.emit((Object)new PredictionEvent.Success(new Prediction("Manually injected prediction", path2, this.$document.getModificationStamp(), this.$diff, this.$result, Duration.Companion.getZERO-UwyO8pc(), null)), (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final void _init_$lambda$0(Project $project, ActionEvent it) {
        ComponentManager $this$service$iv = (ComponentManager)$project;
        boolean $i$f$service = false;
        Class<PredictionService> serviceClass$iv = PredictionService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((PredictionService)object).predict();
    }

    private static final void _init_$lambda$2(DefaultComboBoxModel $events, NextEditPredictionDebugDialog this$0, JTextArea $textArea, ActionEvent it) {
        block2: {
            Object object = $events.getSelectedItem();
            PredictionEvent.Success success = object instanceof PredictionEvent.Success ? (PredictionEvent.Success)object : null;
            if (success == null) break block2;
            PredictionEvent.Success it2 = success;
            boolean bl = false;
            try {
                this$0.applyPrediction(it2.getPrediction());
            }
            catch (Exception e) {
                $textArea.setText(e.getMessage());
            }
        }
    }

    private static final void _init_$lambda$4(NextEditPredictionDebugDialog this$0, ActionEvent it) {
        block0: {
            Prediction prediction2 = this$0.lastPrediction;
            if (prediction2 == null) break block0;
            Prediction it2 = prediction2;
            boolean bl = false;
            DiffHistoryEntry entry = new DiffHistoryEntry(it2.getReason(), it2.getDiff().toString());
            this$0.diffHistoryManager.add(entry);
            this$0.updateHistoryDropdown();
            this$0.root.requestFocusInWindow();
        }
    }

    private static final void _init_$lambda$5(NextEditPredictionDebugDialog this$0, ActionEvent it) {
        this$0.acceptActiveControl();
    }

    private static final void _init_$lambda$6(JBTextField $delay, NextEditPredictionDebugDialog this$0, JCheckBox $ignoreOutdated, Project $project, ActionEvent it) {
        String string = $delay.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        Long l2 = StringsKt.toLongOrNull((String)string);
        long ms = l2 != null ? l2 : 0L;
        $delay.setText(String.valueOf(ms));
        boolean bl = $ignoreOutdated.isSelected();
        this$0.config = new Config(ms, bl);
        ComponentManager $this$service$iv = (ComponentManager)$project;
        boolean $i$f$service = false;
        Class<PredictionService> serviceClass$iv = PredictionService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((PredictionService)object).updateConfig(this$0.config);
    }

    private static final void _init_$lambda$7(NextEditPredictionDebugDialog this$0, JTextArea $injectedDiffText, ActionEvent it) {
        String string = $injectedDiffText.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this$0.injectPrediction(string);
    }

    private static final void _init_$lambda$8(JTextArea $injectedDiffText, NextEditPredictionDebugDialog this$0, ActionEvent it) {
        $injectedDiffText.setText("");
        this$0.diffHistoryComboBox.setSelectedItem(null);
        this$0.root.requestFocusInWindow();
    }

    private static final void _init_$lambda$9(JTextArea $injectedDiffText, ItemEvent e) {
        if (e.getStateChange() == 1) {
            Object object = e.getItem();
            DiffHistoryEntry diffHistoryEntry = object instanceof DiffHistoryEntry ? (DiffHistoryEntry)object : null;
            if (diffHistoryEntry == null) {
                return;
            }
            DiffHistoryEntry selected = diffHistoryEntry;
            $injectedDiffText.setText(selected.getDiffText());
        }
    }

    private static final void _init_$lambda$10(NextEditPredictionDebugDialog this$0, JTextArea $textArea, ItemEvent e) {
        if (e.getStateChange() == 1) {
            Object object = e.getItem();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.google.tools.aiplugin.editor.predictionservices.PredictionEvent");
            PredictionEvent event = (PredictionEvent)object;
            this$0.apply.setEnabled(false);
            this$0.saveDiff.setEnabled(false);
            PredictionEvent predictionEvent = event;
            if (predictionEvent instanceof PredictionEvent.Success) {
                this$0.lastPrediction = ((PredictionEvent.Success)event).getPrediction();
                $textArea.setText(((PredictionEvent.Success)event).getPrediction().getDiff().toString());
                this$0.apply.setEnabled(true);
                this$0.saveDiff.setEnabled(true);
            } else if (predictionEvent instanceof PredictionEvent.Fail) {
                $textArea.setText(((PredictionEvent.Fail)event).getMessage());
            } else if (predictionEvent instanceof PredictionEvent.Initiated) {
                $textArea.setText("Predicting...");
            } else if (predictionEvent instanceof PredictionEvent.Forced) {
                $textArea.setText("Force predicting...");
            } else if (predictionEvent instanceof PredictionEvent.LlmRequest) {
                $textArea.setText(((PredictionEvent.LlmRequest)event).getPrompt());
            } else if (predictionEvent instanceof PredictionEvent.LlmResponse) {
                $textArea.setText(((PredictionEvent.LlmResponse)event).getResponse());
            } else if (predictionEvent instanceof PredictionEvent.Outdated) {
                $textArea.setText(((PredictionEvent.Outdated)event).getPrediction().getDiff().toString());
                this$0.apply.setEnabled(false);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private static final void applyPrediction$lambda$11(Prediction $prediction) {
        block1: {
            Document document;
            VirtualFile vf = LocalFileSystem.getInstance().findFileByNioFile($prediction.getPath());
            if (vf == null) break block1;
            Document document2 = document = FileDocumentManager.getInstance().getDocument(vf);
            if (document2 != null) {
                Diff diff = $prediction.getDiff();
                String string = document.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                document2.setText((CharSequence)diff.apply(string));
            }
        }
    }
}

