/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.aiplugin.editor.predictionservices.evals;

import com.android.studio.ml.bot.StudioBotFlags;
import com.android.studio.ml.experimental.GeminiModel;
import com.android.studio.ml.experimental.GeminiModels;
import com.google.common.collect.EvictingQueue;
import com.google.tools.aiplugin.editor.prediction.Diff;
import com.google.tools.aiplugin.editor.prediction.DiffReader;
import com.google.tools.aiplugin.editor.prediction.DocumentHistory;
import com.google.tools.aiplugin.editor.prediction.EditHistory;
import com.google.tools.aiplugin.editor.prediction.FileHeader;
import com.google.tools.aiplugin.editor.prediction.LineType;
import com.google.tools.aiplugin.editor.prediction.NextEditPredictor;
import com.google.tools.aiplugin.editor.prediction.Prediction;
import com.google.tools.aiplugin.editor.predictionservices.StudioPredictionModel;
import com.intellij.mock.MockApplication;
import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0003 !\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ\u0016\u0010\u001c\u001a\u00020\u00152\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/evals/Evals;", "", "geminiKey", "", "<init>", "(Ljava/lang/String;)V", "getGeminiKey", "()Ljava/lang/String;", "disposable", "Lcom/intellij/openapi/Disposable;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "application", "Lcom/intellij/mock/MockApplication;", "getApplication", "()Lcom/intellij/mock/MockApplication;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "evaluate", "", "model", "Lcom/android/studio/ml/experimental/GeminiModels;", "evalSource", "predictionLookahead", "", "runsPerEval", "printDebugReport", "cases", "", "Lcom/google/tools/aiplugin/editor/predictionservices/evals/Evals$Case;", "Companion", "Case", "Result", "aiplugin.editor.prediction-services"})
@SourceDebugExtension(value={"SMAP\nEvals.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Evals.kt\ncom/google/tools/aiplugin/editor/predictionservices/evals/Evals\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,238:1\n1#2:239\n1368#3:240\n1454#3,5:241\n774#3:246\n865#3,2:247\n774#3:249\n865#3,2:250\n1782#3,3:252\n1755#3,3:255\n1785#3:258\n1872#3,2:259\n1782#3,4:261\n1782#3,4:265\n1874#3:269\n1782#3,3:270\n1734#3,3:273\n1785#3:276\n1557#3:277\n1628#3,3:278\n1368#3:281\n1454#3,2:282\n774#3:284\n865#3,2:285\n1456#3,3:287\n1782#3,3:290\n1734#3,3:293\n1785#3:296\n*S KotlinDebug\n*F\n+ 1 Evals.kt\ncom/google/tools/aiplugin/editor/predictionservices/evals/Evals\n*L\n175#1:240\n175#1:241,5\n175#1:246\n175#1:247,2\n176#1:249\n176#1:250,2\n179#1:252,3\n180#1:255,3\n179#1:258\n205#1:259,2\n206#1:261,4\n207#1:265,4\n205#1:269\n215#1:270,3\n215#1:273,3\n215#1:276\n219#1:277\n219#1:278,3\n220#1:281\n220#1:282,2\n220#1:284\n220#1:285,2\n220#1:287,3\n225#1:290,3\n225#1:293,3\n225#1:296\n*E\n"})
public final class Evals {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String geminiKey;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final MockApplication application;
    @NotNull
    private final Project project;

    public Evals(@NotNull String geminiKey) {
        Intrinsics.checkNotNullParameter((Object)geminiKey, (String)"geminiKey");
        this.geminiKey = geminiKey;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
        this.application = new MockApplication(this.disposable);
        ApplicationManager.setApplication((Application)((Application)this.application), (Disposable)this.disposable);
        ExtensionsAreaImpl extensionsAreaImpl = this.application.getExtensionArea();
        Intrinsics.checkNotNullExpressionValue((Object)extensionsAreaImpl, (String)"getExtensionArea(...)");
        ExtensionsAreaImpl applicationArea = extensionsAreaImpl;
        applicationArea.registerExtensionPoint(StudioBotFlags.Companion.getEP_NAME().getName(), "com.android.studio.ml.bot.StudioBotFlags", ExtensionPoint.Kind.INTERFACE, false);
        this.project = (Project)new MockProject(null, this.disposable);
    }

    @NotNull
    public final String getGeminiKey() {
        return this.geminiKey;
    }

    @NotNull
    public final Disposable getDisposable() {
        return this.disposable;
    }

    @NotNull
    public final MockApplication getApplication() {
        return this.application;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void evaluate(@NotNull GeminiModels model2, @NotNull String evalSource, int predictionLookahead, int runsPerEval) {
        Intrinsics.checkNotNullParameter((Object)((Object)model2), (String)"model");
        Intrinsics.checkNotNullParameter((Object)evalSource, (String)"evalSource");
        Closeable closeable = new BufferedReader(new FileReader(evalSource));
        Throwable throwable = null;
        try {
            Diff diff;
            BufferedReader reader = (BufferedReader)closeable;
            boolean bl = false;
            DiffReader diffReader = new DiffReader(reader);
            EvictingQueue futureDiffs = EvictingQueue.create((int)predictionLookahead);
            GeminiModel model3 = new GeminiModel(model2, null, null, () -> Evals.evaluate$lambda$7$lambda$0(this), 6, null);
            NextEditPredictor predictor = new NextEditPredictor(new StudioPredictionModel(this.project, model3));
            Diff newFileDiff = null;
            Long newFileStamp = null;
            while (futureDiffs.size() < predictionLookahead && (diff = diffReader.readDiff()) != null) {
                FileHeader fileHeader = diff.getOldFile();
                Intrinsics.checkNotNull((Object)fileHeader);
                if (Intrinsics.areEqual((Object)fileHeader.getPath(), (Object)"null")) {
                    newFileDiff = diff;
                    FileHeader fileHeader2 = diff.getOldFile();
                    Intrinsics.checkNotNull((Object)fileHeader2);
                    Intrinsics.checkNotNull((Object)fileHeader2.getStamp());
                    continue;
                }
                futureDiffs.add((Object)diff);
            }
            List cases = new ArrayList();
            Diff diff2 = newFileDiff;
            Intrinsics.checkNotNull(diff2);
            FileHeader fileHeader = diff2.getNewFile();
            Intrinsics.checkNotNull((Object)fileHeader);
            FileHeader header = fileHeader;
            EditHistory editHistory = new EditHistory();
            Path path2 = Paths.get(header.getPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            String string = newFileDiff.apply("");
            Long l2 = header.getStamp();
            Intrinsics.checkNotNull((Object)l2);
            editHistory.reset(path2, string, l2);
            int editIndex = 0;
            System.out.println((Object)"Running Evals:");
            while (true) {
                Intrinsics.checkNotNull((Object)futureDiffs);
                if (!(!((Collection)futureDiffs).isEmpty())) break;
                Diff diff3 = (Diff)futureDiffs.remove();
                Intrinsics.checkNotNull((Object)diff3);
                editHistory.addDiff(diff3);
                if (diffReader.readDiff() != null) {
                    Diff it;
                    boolean bl2 = false;
                    futureDiffs.add((Object)it);
                }
                Case case_ = new Case(null, 1, null);
                cases.add(case_);
                for (int i2 = 0; i2 < runsPerEval; ++i2) {
                    Boolean bl3;
                    String runCounter = runsPerEval > 1 ? " - sample " + (i2 + 1) + "/" + runsPerEval : "";
                    System.out.print((Object)("  Prediction " + editIndex + runCounter + "..."));
                    try {
                        Object flattenedFuture;
                        Prediction prediction2 = (Prediction)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Prediction>, Object>(predictor, editHistory, null){
                            int label;
                            final /* synthetic */ NextEditPredictor $predictor;
                            final /* synthetic */ EditHistory $editHistory;
                            {
                                this.$predictor = $predictor;
                                this.$editHistory = $editHistory;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        DocumentHistory documentHistory = this.$editHistory.getHistory();
                                        Intrinsics.checkNotNull((Object)documentHistory);
                                        this.label = 1;
                                        Object object3 = this.$predictor.predict(documentHistory, (Continuation<? super Prediction>)((Continuation)this));
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Prediction> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)1, null);
                        try {
                            int n;
                            void $this$filterTo$iv$iv;
                            void $this$filterTo$iv$iv2;
                            void $this$filter$iv;
                            Object it;
                            Object element$iv$iv2;
                            void $this$flatMapTo$iv$iv;
                            Diff diff4 = prediction2.getDiff();
                            DocumentHistory documentHistory = editHistory.getHistory();
                            Intrinsics.checkNotNull((Object)documentHistory);
                            diff4.apply(documentHistory.getAfter());
                            Iterable $this$flatMap$iv = (Iterable)futureDiffs;
                            boolean $i$f$flatMap = false;
                            Iterable iterable = $this$flatMap$iv;
                            Iterable destination$iv$iv = new ArrayList();
                            boolean $i$f$flatMapTo = false;
                            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
                                it = (Diff)element$iv$iv2;
                                boolean bl4 = false;
                                Iterable list$iv$iv = ((Diff)it).flatten();
                                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                            }
                            $this$flatMap$iv = (List)destination$iv$iv;
                            boolean $i$f$filter = false;
                            $this$flatMapTo$iv$iv = $this$filter$iv;
                            destination$iv$iv = new ArrayList();
                            boolean $i$f$filterTo = false;
                            for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                                it = (Diff.SingleDiffChunk)element$iv$iv2;
                                boolean bl5 = false;
                                if (!(((Diff.SingleDiffChunk)it).getType() != LineType.CONTEXT)) continue;
                                destination$iv$iv.add(element$iv$iv2);
                            }
                            flattenedFuture = (List)destination$iv$iv;
                            Iterable $this$filter$iv2 = prediction2.getDiff().flatten();
                            boolean $i$f$filter2 = false;
                            destination$iv$iv = $this$filter$iv2;
                            Collection destination$iv$iv2 = new ArrayList();
                            boolean $i$f$filterTo2 = false;
                            element$iv$iv2 = $this$filterTo$iv$iv.iterator();
                            while (element$iv$iv2.hasNext()) {
                                Object element$iv$iv3 = element$iv$iv2.next();
                                Diff.SingleDiffChunk it2 = (Diff.SingleDiffChunk)element$iv$iv3;
                                boolean bl6 = false;
                                if (!(it2.getType() != LineType.CONTEXT)) continue;
                                destination$iv$iv2.add(element$iv$iv3);
                            }
                            List flattenedDiff = (List)destination$iv$iv2;
                            Iterable $this$count$iv = flattenedDiff;
                            boolean $i$f$count = false;
                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                n = 0;
                            } else {
                                int count$iv = 0;
                                for (Object element$iv : $this$count$iv) {
                                    boolean bl7;
                                    block23: {
                                        Diff.SingleDiffChunk candidate = (Diff.SingleDiffChunk)element$iv;
                                        boolean bl8 = false;
                                        Iterable $this$any$iv = (Iterable)flattenedFuture;
                                        boolean $i$f$any = false;
                                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                            bl7 = false;
                                        } else {
                                            for (Object element$iv2 : $this$any$iv) {
                                                Diff.SingleDiffChunk it3 = (Diff.SingleDiffChunk)element$iv2;
                                                boolean bl9 = false;
                                                if (!(!StringsKt.isBlank((CharSequence)it3.getContent()) && Intrinsics.areEqual((Object)it3.getContent(), (Object)candidate.getContent()))) continue;
                                                bl7 = true;
                                                break block23;
                                            }
                                            bl7 = false;
                                        }
                                    }
                                    if (!bl7 || ++count$iv >= 0) continue;
                                    CollectionsKt.throwCountOverflow();
                                }
                                n = count$iv;
                            }
                            int foundCount = n;
                            case_.getRuns().add(new Result(null, null, flattenedDiff.size(), foundCount));
                            System.out.println((Object)"done.");
                            flattenedFuture = Unit.INSTANCE;
                        }
                        catch (IllegalStateException e) {
                            System.out.println((Object)"failed to apply.");
                            flattenedFuture = case_.getRuns().add(new Result(null, e, 0, 0));
                        }
                        bl3 = flattenedFuture;
                        continue;
                    }
                    catch (Throwable t) {
                        System.out.println((Object)"model error.");
                        bl3 = case_.getRuns().add(new Result(t, null, 0, 0));
                    }
                }
                ++editIndex;
            }
            System.out.println((Object)"Finished Evals.");
            this.printDebugReport(cases);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void printDebugReport(List<Case> cases) {
        int n;
        int n2;
        Object object;
        Iterator $this$flatMapTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Object object2;
        int n3;
        if (cases.isEmpty() || cases.get(0).getRuns().isEmpty()) {
            System.out.println((Object)"No evals occurred.");
            return;
        }
        System.out.println((Object)("Edits evaluated: " + cases.size()));
        Iterable $this$forEachIndexed$iv = cases;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n4;
            int n5;
            Object element$iv3;
            int n6;
            Object element$iv22;
            int n7;
            void it;
            int n8;
            if ((n8 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Case case_ = (Case)item$iv;
            int i2 = n8;
            boolean bl = false;
            Iterable $this$count$iv = it.getRuns();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n7 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv22 : $this$count$iv) {
                    Result it2 = (Result)element$iv22;
                    boolean bl2 = false;
                    if (!(it2.getModelError() != null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n7 = count$iv;
            }
            int modelErrors = n7;
            Iterable $this$count$iv2 = it.getRuns();
            boolean $i$f$count22 = false;
            if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                n6 = 0;
            } else {
                int count$iv22 = 0;
                for (Object element$iv3 : $this$count$iv2) {
                    Result it3 = (Result)element$iv3;
                    boolean bl3 = false;
                    if (!(it3.getDiffApplicationError() != null) || ++count$iv22 >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n6 = count$iv22;
            }
            int diffErrors = n6;
            Iterable $i$f$count22 = it.getRuns();
            int count$iv22 = 0;
            element$iv22 = $i$f$count22.iterator();
            while (element$iv22.hasNext()) {
                element$iv3 = element$iv22.next();
                Result it3 = (Result)element$iv3;
                n5 = count$iv22;
                boolean bl4 = false;
                n4 = it3.getLinesAccepted();
                count$iv22 = n5 + n4;
            }
            int accepted = count$iv22;
            Object count$iv22 = it.getRuns();
            int element$iv22 = 0;
            element$iv3 = count$iv22.iterator();
            while (element$iv3.hasNext()) {
                void it4;
                Object e = element$iv3.next();
                Result bl4 = (Result)e;
                n5 = element$iv22;
                boolean bl5 = false;
                n4 = it4.getLinesPredicted();
                element$iv22 = n5 + n4;
            }
            int predicted = element$iv22;
            count$iv22 = "  Edit #" + i2 + " model errors: " + modelErrors + ", diff errors: " + diffErrors + ", acceptance rate: " + accepted + " / " + predicted;
            System.out.println(count$iv22);
        }
        Object $this$count$iv = cases;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n3 = 0;
        } else {
            int count$iv = 0;
            object2 = $this$count$iv.iterator();
            while (object2.hasNext()) {
                boolean bl;
                block28: {
                    Object element$iv = object2.next();
                    Case it = (Case)element$iv;
                    boolean bl6 = false;
                    Iterable $this$all$iv = it.getRuns();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv4 : $this$all$iv) {
                            Result it5 = (Result)element$iv4;
                            boolean bl7 = false;
                            if (it5.getModelError() == null && it5.getDiffApplicationError() == null) continue;
                            bl = false;
                            break block28;
                        }
                        bl = true;
                    }
                }
                if (!bl || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n3 = count$iv;
        }
        $this$count$iv = "Well-formed predictions: " + n3;
        System.out.println($this$count$iv);
        Iterable $this$map$iv = cases;
        boolean $i$f$map = false;
        object2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Case $i$f$all = (Case)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getRuns());
        }
        Object $this$flatMap$iv = (List)destination$iv$iv;
        int $i$f$flatMap = 0;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        Iterator bl6 = $this$flatMapTo$iv$iv.iterator();
        while (bl6.hasNext()) {
            void $this$filterTo$iv$iv;
            Object element$iv$iv = bl6.next();
            List it = (List)element$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = it;
            boolean $i$f$filter = false;
            Iterable bl7 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                Result it6 = (Result)element$iv$iv2;
                boolean bl8 = false;
                if (!(it6.getModelError() == null && it6.getDiffApplicationError() == null)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List successfulResults = (List)destination$iv$iv;
        $this$flatMap$iv = successfulResults;
        $i$f$flatMap = 0;
        $this$flatMapTo$iv$iv = $this$flatMap$iv.iterator();
        while ($this$flatMapTo$iv$iv.hasNext()) {
            void it;
            object = $this$flatMapTo$iv$iv.next();
            Result $i$f$flatMapTo2 = (Result)object;
            int n9 = $i$f$flatMap;
            boolean bl = false;
            n2 = it.getLinesAccepted();
            $i$f$flatMap = n9 + n2;
        }
        $this$flatMap$iv = successfulResults;
        int n10 = $i$f$flatMap;
        $i$f$flatMap = 0;
        $this$flatMapTo$iv$iv = $this$flatMap$iv.iterator();
        while ($this$flatMapTo$iv$iv.hasNext()) {
            object = $this$flatMapTo$iv$iv.next();
            Result it = (Result)object;
            n2 = $i$f$flatMap;
            boolean bl = false;
            int n11 = it.getLinesPredicted();
            $i$f$flatMap = n2 + n11;
        }
        n2 = $i$f$flatMap;
        $this$flatMap$iv = "Lines accepted: " + n10 + " / " + n2;
        System.out.println($this$flatMap$iv);
        Iterable $this$count$iv3 = cases;
        boolean $i$f$count2 = false;
        if ($this$count$iv3 instanceof Collection && ((Collection)$this$count$iv3).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv3) {
                boolean bl;
                block29: {
                    Case it = (Case)element$iv;
                    boolean bl9 = false;
                    Iterable $this$all$iv = it.getRuns();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv5 : $this$all$iv) {
                            Result it7 = (Result)element$iv5;
                            boolean bl10 = false;
                            if (it7.getModelError() == null && it7.getDiffApplicationError() != null) continue;
                            bl = false;
                            break block29;
                        }
                        bl = true;
                    }
                }
                if (!bl || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        String string = "Diff errors: " + n + " / " + cases.size() * cases.get(0).getRuns().size();
        System.out.println((Object)string);
    }

    private static final String evaluate$lambda$7$lambda$0(Evals this$0) {
        return this$0.geminiKey;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/evals/Evals$Case;", "", "runs", "", "Lcom/google/tools/aiplugin/editor/predictionservices/evals/Evals$Result;", "<init>", "(Ljava/util/List;)V", "getRuns", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "aiplugin.editor.prediction-services"})
    private static final class Case {
        @NotNull
        private final List<Result> runs;

        public Case(@NotNull List<Result> runs) {
            Intrinsics.checkNotNullParameter(runs, (String)"runs");
            this.runs = runs;
        }

        public /* synthetic */ Case(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = new ArrayList();
            }
            this(list);
        }

        @NotNull
        public final List<Result> getRuns() {
            return this.runs;
        }

        @NotNull
        public final List<Result> component1() {
            return this.runs;
        }

        @NotNull
        public final Case copy(@NotNull List<Result> runs) {
            Intrinsics.checkNotNullParameter(runs, (String)"runs");
            return new Case(runs);
        }

        public static /* synthetic */ Case copy$default(Case case_, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = case_.runs;
            }
            return case_.copy(list);
        }

        @NotNull
        public String toString() {
            return "Case(runs=" + this.runs + ")";
        }

        public int hashCode() {
            return ((Object)this.runs).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Case)) {
                return false;
            }
            Case case_ = (Case)other;
            return Intrinsics.areEqual(this.runs, case_.runs);
        }

        public Case() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/evals/Evals$Companion;", "", "<init>", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "aiplugin.editor.prediction-services"})
    @SourceDebugExtension(value={"SMAP\nEvals.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Evals.kt\ncom/google/tools/aiplugin/editor/predictionservices/evals/Evals$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,238:1\n1#2:239\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Object object;
            String path2;
            String geminiKey;
            int runsPerEval;
            int predictionLookahead;
            block15: {
                block14: {
                    Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                    predictionLookahead = 10;
                    runsPerEval = 1;
                    geminiKey = "";
                    String modelId = "GEMINI_2_5_FLASH_LITE";
                    path2 = "";
                    try {
                        int n = args.length;
                        for (int i2 = 0; i2 < n; ++i2) {
                            String[] stringArray;
                            if (StringsKt.startsWith$default((String)args[i2], (String)"--runs_per_eval", (boolean)false, (int)2, null)) {
                                stringArray = new String[]{"="};
                                runsPerEval = Integer.parseInt((String)StringsKt.split$default((CharSequence)args[i2], (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1));
                                continue;
                            }
                            if (StringsKt.startsWith$default((String)args[i2], (String)"--prediction_lookahead", (boolean)false, (int)2, null)) {
                                stringArray = new String[]{"="};
                                predictionLookahead = Integer.parseInt((String)StringsKt.split$default((CharSequence)args[i2], (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1));
                                continue;
                            }
                            if (StringsKt.startsWith$default((String)args[i2], (String)"--gemini_model_id", (boolean)false, (int)2, null)) {
                                stringArray = new String[]{"="};
                                modelId = (String)StringsKt.split$default((CharSequence)args[i2], (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
                                continue;
                            }
                            if (StringsKt.startsWith$default((String)args[i2], (String)"--gemini_key", (boolean)false, (int)2, null)) {
                                stringArray = new String[]{"="};
                                geminiKey = (String)StringsKt.split$default((CharSequence)args[i2], (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
                                continue;
                            }
                            path2 = args[i2];
                        }
                        if (StringsKt.isBlank((CharSequence)geminiKey)) {
                            throw new RuntimeException("No gemini key specified. Use '--gemini_key=<key>' option.");
                        }
                        if (!new File(path2).isFile()) {
                            if (StringsKt.isBlank((CharSequence)path2)) {
                                throw new RuntimeException("No valid path specified.");
                            }
                            throw new RuntimeException(path2 + " is not a valid file.");
                        }
                    }
                    catch (Throwable t) {
                        System.out.println(t);
                        String string = "Usage:\n  [options] path_to_evals_file\n\n  Options:\n  --runs_per_eval=<Int>:\n      Specifies the number of times to run each evaluation. Default is 1.\n  --prediction_lookahead=<Int>:\n      Specifies the number of edits in the future to inspect for matches. Default is 10.\n  --gemini_model_id=<String>:\n      Specify to chose a different model. Default is Gemini 2.5 Flash Lite.\n  --debug_print=<Boolean>:\n      Whether or not to print debugging information to TTY.\n  --gemini_key=<String>:\n      [REQUIRED] Specify the key for Gemini service.";
                        System.out.println((Object)string);
                        return;
                    }
                    object = System.getenv("NEP_MODEL_ID");
                    if (object == null) break block14;
                    String it = object;
                    boolean bl = false;
                    GeminiModels geminiModels2 = GeminiModels.valueOf(it);
                    object = geminiModels2;
                    if (geminiModels2 != null) break block15;
                }
                object = GeminiModels.GEMINI_2_5_FLASH_LITE;
            }
            Object model2 = object;
            new Evals(geminiKey).evaluate((GeminiModels)((Object)model2), path2, predictionLookahead, runsPerEval);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J5\u0010\u0014\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/evals/Evals$Result;", "", "modelError", "", "diffApplicationError", "linesPredicted", "", "linesAccepted", "<init>", "(Ljava/lang/Throwable;Ljava/lang/Throwable;II)V", "getModelError", "()Ljava/lang/Throwable;", "getDiffApplicationError", "getLinesPredicted", "()I", "getLinesAccepted", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "aiplugin.editor.prediction-services"})
    private static final class Result {
        @Nullable
        private final Throwable modelError;
        @Nullable
        private final Throwable diffApplicationError;
        private final int linesPredicted;
        private final int linesAccepted;

        public Result(@Nullable Throwable modelError, @Nullable Throwable diffApplicationError, int linesPredicted, int linesAccepted) {
            this.modelError = modelError;
            this.diffApplicationError = diffApplicationError;
            this.linesPredicted = linesPredicted;
            this.linesAccepted = linesAccepted;
        }

        @Nullable
        public final Throwable getModelError() {
            return this.modelError;
        }

        @Nullable
        public final Throwable getDiffApplicationError() {
            return this.diffApplicationError;
        }

        public final int getLinesPredicted() {
            return this.linesPredicted;
        }

        public final int getLinesAccepted() {
            return this.linesAccepted;
        }

        @Nullable
        public final Throwable component1() {
            return this.modelError;
        }

        @Nullable
        public final Throwable component2() {
            return this.diffApplicationError;
        }

        public final int component3() {
            return this.linesPredicted;
        }

        public final int component4() {
            return this.linesAccepted;
        }

        @NotNull
        public final Result copy(@Nullable Throwable modelError, @Nullable Throwable diffApplicationError, int linesPredicted, int linesAccepted) {
            return new Result(modelError, diffApplicationError, linesPredicted, linesAccepted);
        }

        public static /* synthetic */ Result copy$default(Result result2, Throwable throwable, Throwable throwable2, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                throwable = result2.modelError;
            }
            if ((n3 & 2) != 0) {
                throwable2 = result2.diffApplicationError;
            }
            if ((n3 & 4) != 0) {
                n = result2.linesPredicted;
            }
            if ((n3 & 8) != 0) {
                n2 = result2.linesAccepted;
            }
            return result2.copy(throwable, throwable2, n, n2);
        }

        @NotNull
        public String toString() {
            return "Result(modelError=" + this.modelError + ", diffApplicationError=" + this.diffApplicationError + ", linesPredicted=" + this.linesPredicted + ", linesAccepted=" + this.linesAccepted + ")";
        }

        public int hashCode() {
            int result2 = this.modelError == null ? 0 : this.modelError.hashCode();
            result2 = result2 * 31 + (this.diffApplicationError == null ? 0 : this.diffApplicationError.hashCode());
            result2 = result2 * 31 + Integer.hashCode(this.linesPredicted);
            result2 = result2 * 31 + Integer.hashCode(this.linesAccepted);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result2 = (Result)other;
            if (!Intrinsics.areEqual((Object)this.modelError, (Object)result2.modelError)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.diffApplicationError, (Object)result2.diffApplicationError)) {
                return false;
            }
            if (this.linesPredicted != result2.linesPredicted) {
                return false;
            }
            return this.linesAccepted == result2.linesAccepted;
        }
    }
}

