/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.action;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.TerminalReference;
import com.android.studio.ml.TerminalService;
import com.android.studio.ml.bot.StudioBotFlags;
import com.android.studio.ml.bot.ui.compose.timeline.AttachmentKt;
import com.android.studio.ml.bot.ui.compose.timeline.context.ContextDrawerPersister;
import com.google.tools.intellij.aiplugin.SmlIjBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.JBTerminalWidget;
import com.jediterm.terminal.ui.TerminalPanel;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/google/tools/intellij/aiplugin/action/AddToContextAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getSource", "Lcom/google/tools/intellij/aiplugin/action/AddToContextAction$Source;", "event", "update", "Source", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
public final class AddToContextAction
extends DumbAwareAction {
    public static final int $stable = 8;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        Project project2 = e.getProject();
        presentation2.setEnabledAndVisible(false);
        if (project2 == null || !StudioBotFlags.Companion.getInstance().isContextAttachmentEnabled()) {
            return;
        }
        Source source = this.getSource(e);
        if (source == Source.FILE) {
            return;
        }
        if (source == Source.TERMINAL && StudioBotFlags.Companion.getInstance().isTerminalSelectionEnabled()) {
            TerminalService.TerminalInfo terminalInfo = TerminalService.Companion.getInstance(project2).getActiveTerminal();
            if (terminalInfo == null) {
                return;
            }
            TerminalService.TerminalInfo activeTerminal = terminalInfo;
            if (activeTerminal.getSelectedText() == null) {
                Object[] objectArray = new Object[]{"Gemini: ", "Current Terminal"};
                presentation2.setText(SmlIjBundle.message("aiplugin.actions.addToContext.text", objectArray));
                presentation2.setEnabledAndVisible(true);
                return;
            }
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project2 = e.getProject();
            if (project2 == null) {
                return;
            }
            Project project3 = project2;
            Source source = this.getSource(e);
            if (source == Source.FILE || source != Source.TERMINAL) break block3;
            TerminalService.TerminalInfo terminalInfo = TerminalService.Companion.getInstance(project3).getActiveTerminal();
            if (terminalInfo != null) {
                TerminalService.TerminalInfo terminal = terminalInfo;
                boolean bl = false;
                if (terminal.getSelectedText() == null) {
                    ContextDrawerPersister.Companion.getInstance().addAttachments(CollectionsKt.listOf((Object)AttachmentKt.toContextDrawerAttachment(new TerminalReference(terminal.getId(), true))));
                }
            }
        }
    }

    private final Source getSource(AnActionEvent event) {
        VirtualFile file = (VirtualFile)event.getDataContext().getData(CommonDataKeys.VIRTUAL_FILE);
        Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
        Component comp = (Component)event.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        return editor != null && file != null ? Source.FILE : (comp instanceof TerminalPanel || comp instanceof JBTerminalWidget || editor != null ? Source.TERMINAL : Source.OTHER);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/google/tools/intellij/aiplugin/action/AddToContextAction$Source;", "", "(Ljava/lang/String;I)V", "FILE", "TERMINAL", "OTHER", "aiplugin.ij-platform"})
    public static final class Source
    extends Enum<Source> {
        public static final /* enum */ Source FILE = new Source();
        public static final /* enum */ Source TERMINAL = new Source();
        public static final /* enum */ Source OTHER = new Source();
        private static final /* synthetic */ Source[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Source[] values() {
            return (Source[])$VALUES.clone();
        }

        public static Source valueOf(String value) {
            return Enum.valueOf(Source.class, value);
        }

        @NotNull
        public static EnumEntries<Source> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sourceArray = new Source[]{Source.FILE, Source.TERMINAL, Source.OTHER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

