/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.analytics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.AdvertiserNotificationEvent;
import com.android.studio.ml.AiExcludeEvent;
import com.android.studio.ml.ChatBotEvent;
import com.android.studio.ml.ChatSessionEvent;
import com.android.studio.ml.CompletionEvent;
import com.android.studio.ml.ConfigurationEvent;
import com.android.studio.ml.GeminiAdvertiserEvent;
import com.android.studio.ml.GeolocationEvent;
import com.android.studio.ml.MetricsReporter;
import com.android.studio.ml.ModelProviderEvent;
import com.android.studio.ml.PromptLibraryEvent;
import com.android.studio.ml.ReleaseNotesUrlClickedEvent;
import com.android.studio.ml.SmlConversation;
import com.android.studio.ml.StudioTestScenarioEvent;
import com.android.studio.ml.TransformEvent;
import com.android.studio.ml.bot.MessageFeedbackModel;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpHeaders;
import com.google.api.services.cloudcode_pa.v1internal.model.ServerProcessingDetails;
import com.google.tools.intellij.aiplugin.CitationBlockingException;
import com.google.tools.intellij.aiplugin.analytics.ChatMetadata;
import com.google.tools.intellij.aiplugin.analytics.TrackingEvent;
import com.google.tools.intellij.aiplugin.analytics.UsageTrackerService;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u00012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020.H\u0002J\u000e\u0010/\u001a\u0004\u0018\u000100*\u000201H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/google/tools/intellij/aiplugin/analytics/AiPluginMetricsReporter;", "Lcom/android/studio/ml/MetricsReporter;", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "logAdvertiserNotificationEvent", "", "event", "Lcom/android/studio/ml/AdvertiserNotificationEvent;", "logAiExcludeEvent", "Lcom/android/studio/ml/AiExcludeEvent;", "logChatBotEvent", "Lcom/android/studio/ml/ChatBotEvent;", "logChatSessionEvent", "Lcom/android/studio/ml/ChatSessionEvent;", "logCompletionEvent", "Lcom/android/studio/ml/CompletionEvent;", "logConfigurationEvent", "Lcom/android/studio/ml/ConfigurationEvent;", "logGeminiAdvertiserEvent", "Lcom/android/studio/ml/GeminiAdvertiserEvent;", "logGeolocationEvent", "Lcom/android/studio/ml/GeolocationEvent;", "logModelProviderEvent", "Lcom/android/studio/ml/ModelProviderEvent;", "logNextEditEvent", "Lcom/google/tools/intellij/aiplugin/analytics/AiPluginMetricsReporter$NextEditEvent;", "logPromptLibraryEvent", "Lcom/android/studio/ml/PromptLibraryEvent;", "logReleaseNotesEvent", "Lcom/android/studio/ml/ReleaseNotesUrlClickedEvent;", "logTestScenarioEvent", "Lcom/android/studio/ml/StudioTestScenarioEvent;", "logTransformEvent", "Lcom/android/studio/ml/TransformEvent;", "processBotResponse", "Lcom/android/studio/ml/ChatBotEvent$BotResponse;", "processBotResponseChunk", "Lcom/android/studio/ml/ChatBotEvent$BotResponseChunk;", "processBotResponseError", "Lcom/android/studio/ml/ChatBotEvent$BotResponseError;", "processFolderContextEvent", "Lcom/android/studio/ml/ChatBotEvent$FolderContextEvent;", "processQueryBoxEvent", "Lcom/android/studio/ml/ChatBotEvent$QueryBoxEvent;", "processUserFeedback", "Lcom/android/studio/ml/ChatBotEvent$UserFeedback;", "asTrackingValueOrNull", "", "Lcom/android/studio/ml/bot/MessageFeedbackModel$Rating;", "NextEditEvent", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAiPluginMetricsReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiPluginMetricsReporter.kt\ncom/google/tools/intellij/aiplugin/analytics/AiPluginMetricsReporter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,209:1\n25#2:210\n*S KotlinDebug\n*F\n+ 1 AiPluginMetricsReporter.kt\ncom/google/tools/intellij/aiplugin/analytics/AiPluginMetricsReporter\n*L\n31#1:210\n*E\n"})
public final class AiPluginMetricsReporter
implements MetricsReporter {
    @NotNull
    public static final AiPluginMetricsReporter INSTANCE;
    @NotNull
    private static final Logger logger;
    public static final int $stable;

    private AiPluginMetricsReporter() {
    }

    @Override
    public void logCompletionEvent(@NotNull CompletionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        logger.debug("completion event: " + event);
    }

    @Override
    public void logTransformEvent(@NotNull TransformEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        logger.debug("transform event: " + event);
    }

    @Override
    public void logChatBotEvent(@NotNull ChatBotEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ChatBotEvent chatBotEvent = event;
        if (chatBotEvent instanceof ChatBotEvent.BotResponse) {
            this.processBotResponse((ChatBotEvent.BotResponse)event);
        } else if (chatBotEvent instanceof ChatBotEvent.BotResponseChunk) {
            this.processBotResponseChunk((ChatBotEvent.BotResponseChunk)event);
        } else if (chatBotEvent instanceof ChatBotEvent.BotResponseError) {
            this.processBotResponseError((ChatBotEvent.BotResponseError)event);
        } else if (chatBotEvent instanceof ChatBotEvent.UserFeedback) {
            this.processUserFeedback((ChatBotEvent.UserFeedback)event);
        } else if (chatBotEvent instanceof ChatBotEvent.QueryBoxEvent) {
            this.processQueryBoxEvent((ChatBotEvent.QueryBoxEvent)event);
        } else if (chatBotEvent instanceof ChatBotEvent.FolderContextEvent) {
            this.processFolderContextEvent((ChatBotEvent.FolderContextEvent)event);
        } else if ((((((chatBotEvent instanceof ChatBotEvent.ActionInvoked ? true : chatBotEvent instanceof ChatBotEvent.ActionResult) ? true : chatBotEvent instanceof ChatBotEvent.BotInvoked) ? true : chatBotEvent instanceof ChatBotEvent.ContextDrawerEvent) ? true : chatBotEvent instanceof ChatBotEvent.DependencySuggestion) ? true : chatBotEvent instanceof ChatBotEvent.ParseResult) ? true : chatBotEvent instanceof ChatBotEvent.SlashAction) {
            // empty if block
        }
    }

    private final void processBotResponseError(ChatBotEvent.BotResponseError event) {
        Throwable t = event.getThrowable();
        if (t instanceof CitationBlockingException) {
            return;
        }
        GoogleJsonResponseException googleJsonResponseException = t instanceof GoogleJsonResponseException ? (GoogleJsonResponseException)t : null;
        String traceId = googleJsonResponseException != null && (googleJsonResponseException = googleJsonResponseException.getHeaders()) != null ? TrackingEvent.Companion.getTraceId((HttpHeaders)googleJsonResponseException) : null;
        logger.warn("chat response error: " + event);
        UsageTrackerService.Companion.getInstance().trackConversationOfferedFailure(traceId, t);
    }

    private final void processBotResponse(ChatBotEvent.BotResponse event) {
        Object object = event.getMetadata().getBackendSpecificData();
        ChatMetadata chatMetadata = object instanceof ChatMetadata ? (ChatMetadata)object : null;
        if (chatMetadata == null) {
            return;
        }
        ChatMetadata chatMetadata2 = chatMetadata;
        if (chatMetadata2.isStreamingChat()) {
            UsageTrackerService.Companion.getInstance().trackConversationOfferedPartialEnd-HG0u8IE(chatMetadata2, event.getLatency-UwyO8pc());
        }
        UsageTrackerService.Companion.getInstance().trackConversationOffered-UREId80(chatMetadata2, event.getLatency-UwyO8pc(), chatMetadata2.isStreamingChat() ? Duration.box-impl((long)event.getTimeToFirstToken-UwyO8pc()) : null, event.getMode());
    }

    private final void processBotResponseChunk(ChatBotEvent.BotResponseChunk event) {
        String string;
        SmlConversation.ResponseChunk responseChunk;
        Object object = event.getMetadata().getBackendSpecificData();
        ChatMetadata chatMetadata = object instanceof ChatMetadata ? (ChatMetadata)object : null;
        if (chatMetadata == null) {
            return;
        }
        ChatMetadata chatMetadata2 = chatMetadata;
        if (!chatMetadata2.isStreamingChat()) {
            return;
        }
        if (event.isFirstChunk()) {
            UsageTrackerService.Companion.getInstance().trackConversationOfferedPartialStart-HG0u8IE(chatMetadata2.getTraceId(), event.getLatency-UwyO8pc());
        }
        if (((responseChunk = event.getChunk()) instanceof SmlConversation.TextChunk ? event.getChunk().getText() : (string = responseChunk instanceof SmlConversation.CodeChunk ? event.getChunk().getText() : "")) == null) {
            string = "";
        }
        String text2 = string;
        UsageTrackerService.Companion.getInstance().trackConversationOfferedPartialChunk(chatMetadata2.getTraceId(), text2);
    }

    private final void processUserFeedback(ChatBotEvent.UserFeedback event) {
        Object object = event.getMetadata().getBackendSpecificData();
        ChatMetadata chatMetadata = object instanceof ChatMetadata ? (ChatMetadata)object : null;
        if (chatMetadata == null) {
            return;
        }
        ChatMetadata chatMetadata2 = chatMetadata;
        String feedbackValue = this.asTrackingValueOrNull(event.getFeedbackState());
        if (feedbackValue != null) {
            UsageTrackerService.Companion.getInstance().trackFeedbackValue(feedbackValue, chatMetadata2);
        }
    }

    private final void processQueryBoxEvent(ChatBotEvent.QueryBoxEvent event) {
        logger.debug("QueryBox event: " + event);
        UsageTrackerService.Companion.getInstance().trackQueryBoxEvent(event);
    }

    private final void processFolderContextEvent(ChatBotEvent.FolderContextEvent event) {
        logger.debug("FolderContext event: " + event);
        UsageTrackerService.Companion.getInstance().trackFolderContextEvent(event);
    }

    private final String asTrackingValueOrNull(MessageFeedbackModel.Rating $this$asTrackingValueOrNull) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$asTrackingValueOrNull.ordinal()]) {
            case 1 -> "cloudcode.aipp.conversation.thumbsup";
            case 2 -> "cloudcode.aipp.conversation.thumbsdown";
            case 3 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public void logConfigurationEvent(@NotNull ConfigurationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        logger.debug("configuration event: " + event);
    }

    @Override
    public void logAiExcludeEvent(@NotNull AiExcludeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        logger.debug("aiexclude event: " + event);
    }

    @Override
    public void logGeolocationEvent(@NotNull GeolocationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        logger.debug("geolocation event: " + event);
    }

    @Override
    public void logTestScenarioEvent(@NotNull StudioTestScenarioEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        logger.debug("test scenario event: " + event);
    }

    @Override
    public void logPromptLibraryEvent(@NotNull PromptLibraryEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        logger.debug("prompt library event: " + event);
        PromptLibraryEvent promptLibraryEvent = event;
        if (promptLibraryEvent instanceof PromptLibraryEvent.PromptLibraryUpdate) {
            UsageTrackerService.Companion.getInstance().trackCustomSlashCommandsUpdated((PromptLibraryEvent.PromptLibraryUpdate)event);
        } else if (promptLibraryEvent instanceof PromptLibraryEvent.PromptLibraryInvoke) {
            UsageTrackerService.Companion.getInstance().trackPromptForChatInvoked(((PromptLibraryEvent.PromptLibraryInvoke)event).getVariableCount());
        }
    }

    @Override
    public void logModelProviderEvent(@NotNull ModelProviderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        logger.debug("model provider event: " + event);
    }

    @Override
    public void logReleaseNotesEvent(@NotNull ReleaseNotesUrlClickedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        UsageTrackerService.Companion.getInstance().trackReleaseNotesOpen(event.getSource());
    }

    @Override
    public void logGeminiAdvertiserEvent(@NotNull GeminiAdvertiserEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        logger.debug("gemini advertiser event: " + event);
    }

    @Override
    public void logAdvertiserNotificationEvent(@NotNull AdvertiserNotificationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        logger.debug("advertiser notification event: " + event);
    }

    @Override
    public void logChatSessionEvent(@NotNull ChatSessionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        logger.debug("chat session event: " + event);
        UsageTrackerService.Companion.getInstance().trackChatSessionEvent(event);
    }

    public final void logNextEditEvent(@NotNull NextEditEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        logger.debug("next edit event: " + event);
        UsageTrackerService.Companion.getInstance().trackNextEditEvent(event);
    }

    static {
        AiPluginMetricsReporter $this$thisLogger$iv = INSTANCE = new AiPluginMetricsReporter();
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(AiPluginMetricsReporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        AiPluginMetricsReporter.logger = logger;
        $stable = 8;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001:\u0001*BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\rH\u00c6\u0003J_\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0010\u00a8\u0006+"}, d2={"Lcom/google/tools/intellij/aiplugin/analytics/AiPluginMetricsReporter$NextEditEvent;", "", "key", "Lcom/google/tools/intellij/aiplugin/analytics/AiPluginMetricsReporter$NextEditEvent$Key;", "projectId", "", "completionIndex", "completionMethod", "language", "ideSessionIndex", "httpHeaders", "Lcom/google/api/client/http/HttpHeaders;", "processingDetails", "Lcom/google/api/services/cloudcode_pa/v1internal/model/ServerProcessingDetails;", "(Lcom/google/tools/intellij/aiplugin/analytics/AiPluginMetricsReporter$NextEditEvent$Key;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/google/api/client/http/HttpHeaders;Lcom/google/api/services/cloudcode_pa/v1internal/model/ServerProcessingDetails;)V", "getCompletionIndex", "()Ljava/lang/String;", "getCompletionMethod", "getHttpHeaders", "()Lcom/google/api/client/http/HttpHeaders;", "getIdeSessionIndex", "getKey", "()Lcom/google/tools/intellij/aiplugin/analytics/AiPluginMetricsReporter$NextEditEvent$Key;", "getLanguage", "getProcessingDetails", "()Lcom/google/api/services/cloudcode_pa/v1internal/model/ServerProcessingDetails;", "getProjectId", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "", "toString", "Key", "aiplugin.ij-platform"})
    @StabilityInferred(parameters=0)
    public static final class NextEditEvent {
        @NotNull
        private final Key key;
        @Nullable
        private final String projectId;
        @NotNull
        private final String completionIndex;
        @NotNull
        private final String completionMethod;
        @NotNull
        private final String language;
        @NotNull
        private final String ideSessionIndex;
        @Nullable
        private final HttpHeaders httpHeaders;
        @Nullable
        private final ServerProcessingDetails processingDetails;
        public static final int $stable = 8;

        public NextEditEvent(@NotNull Key key, @Nullable String projectId, @NotNull String completionIndex, @NotNull String completionMethod, @NotNull String language2, @NotNull String ideSessionIndex, @Nullable HttpHeaders httpHeaders, @Nullable ServerProcessingDetails processingDetails) {
            Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
            Intrinsics.checkNotNullParameter((Object)completionIndex, (String)"completionIndex");
            Intrinsics.checkNotNullParameter((Object)completionMethod, (String)"completionMethod");
            Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
            Intrinsics.checkNotNullParameter((Object)ideSessionIndex, (String)"ideSessionIndex");
            this.key = key;
            this.projectId = projectId;
            this.completionIndex = completionIndex;
            this.completionMethod = completionMethod;
            this.language = language2;
            this.ideSessionIndex = ideSessionIndex;
            this.httpHeaders = httpHeaders;
            this.processingDetails = processingDetails;
        }

        @NotNull
        public final Key getKey() {
            return this.key;
        }

        @Nullable
        public final String getProjectId() {
            return this.projectId;
        }

        @NotNull
        public final String getCompletionIndex() {
            return this.completionIndex;
        }

        @NotNull
        public final String getCompletionMethod() {
            return this.completionMethod;
        }

        @NotNull
        public final String getLanguage() {
            return this.language;
        }

        @NotNull
        public final String getIdeSessionIndex() {
            return this.ideSessionIndex;
        }

        @Nullable
        public final HttpHeaders getHttpHeaders() {
            return this.httpHeaders;
        }

        @Nullable
        public final ServerProcessingDetails getProcessingDetails() {
            return this.processingDetails;
        }

        @NotNull
        public final Key component1() {
            return this.key;
        }

        @Nullable
        public final String component2() {
            return this.projectId;
        }

        @NotNull
        public final String component3() {
            return this.completionIndex;
        }

        @NotNull
        public final String component4() {
            return this.completionMethod;
        }

        @NotNull
        public final String component5() {
            return this.language;
        }

        @NotNull
        public final String component6() {
            return this.ideSessionIndex;
        }

        @Nullable
        public final HttpHeaders component7() {
            return this.httpHeaders;
        }

        @Nullable
        public final ServerProcessingDetails component8() {
            return this.processingDetails;
        }

        @NotNull
        public final NextEditEvent copy(@NotNull Key key, @Nullable String projectId, @NotNull String completionIndex, @NotNull String completionMethod, @NotNull String language2, @NotNull String ideSessionIndex, @Nullable HttpHeaders httpHeaders, @Nullable ServerProcessingDetails processingDetails) {
            Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
            Intrinsics.checkNotNullParameter((Object)completionIndex, (String)"completionIndex");
            Intrinsics.checkNotNullParameter((Object)completionMethod, (String)"completionMethod");
            Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
            Intrinsics.checkNotNullParameter((Object)ideSessionIndex, (String)"ideSessionIndex");
            return new NextEditEvent(key, projectId, completionIndex, completionMethod, language2, ideSessionIndex, httpHeaders, processingDetails);
        }

        public static /* synthetic */ NextEditEvent copy$default(NextEditEvent nextEditEvent, Key key, String string, String string2, String string3, String string4, String string5, HttpHeaders httpHeaders, ServerProcessingDetails serverProcessingDetails, int n, Object object) {
            if ((n & 1) != 0) {
                key = nextEditEvent.key;
            }
            if ((n & 2) != 0) {
                string = nextEditEvent.projectId;
            }
            if ((n & 4) != 0) {
                string2 = nextEditEvent.completionIndex;
            }
            if ((n & 8) != 0) {
                string3 = nextEditEvent.completionMethod;
            }
            if ((n & 0x10) != 0) {
                string4 = nextEditEvent.language;
            }
            if ((n & 0x20) != 0) {
                string5 = nextEditEvent.ideSessionIndex;
            }
            if ((n & 0x40) != 0) {
                httpHeaders = nextEditEvent.httpHeaders;
            }
            if ((n & 0x80) != 0) {
                serverProcessingDetails = nextEditEvent.processingDetails;
            }
            return nextEditEvent.copy(key, string, string2, string3, string4, string5, httpHeaders, serverProcessingDetails);
        }

        @NotNull
        public String toString() {
            return "NextEditEvent(key=" + this.key + ", projectId=" + this.projectId + ", completionIndex=" + this.completionIndex + ", completionMethod=" + this.completionMethod + ", language=" + this.language + ", ideSessionIndex=" + this.ideSessionIndex + ", httpHeaders=" + this.httpHeaders + ", processingDetails=" + this.processingDetails + ")";
        }

        public int hashCode() {
            int result2 = this.key.hashCode();
            result2 = result2 * 31 + (this.projectId == null ? 0 : this.projectId.hashCode());
            result2 = result2 * 31 + this.completionIndex.hashCode();
            result2 = result2 * 31 + this.completionMethod.hashCode();
            result2 = result2 * 31 + this.language.hashCode();
            result2 = result2 * 31 + this.ideSessionIndex.hashCode();
            result2 = result2 * 31 + (this.httpHeaders == null ? 0 : this.httpHeaders.hashCode());
            result2 = result2 * 31 + (this.processingDetails == null ? 0 : this.processingDetails.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NextEditEvent)) {
                return false;
            }
            NextEditEvent nextEditEvent = (NextEditEvent)other;
            if (this.key != nextEditEvent.key) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.projectId, (Object)nextEditEvent.projectId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.completionIndex, (Object)nextEditEvent.completionIndex)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.completionMethod, (Object)nextEditEvent.completionMethod)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.language, (Object)nextEditEvent.language)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.ideSessionIndex, (Object)nextEditEvent.ideSessionIndex)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.httpHeaders, (Object)nextEditEvent.httpHeaders)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.processingDetails, (Object)nextEditEvent.processingDetails);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/google/tools/intellij/aiplugin/analytics/AiPluginMetricsReporter$NextEditEvent$Key;", "", "(Ljava/lang/String;I)V", "SESSION_OFFERED", "SESSION_REJECTED", "SESSION_IGNORED", "SESSION_STARTED", "SESSION_COMPLETED", "SUGGESTION_DISPLAYED", "SUGGESTION_ACCEPTED", "SUGGESTION_IGNORED", "SUGGESTION_REJECTED", "aiplugin.ij-platform"})
        public static final class Key
        extends Enum<Key> {
            public static final /* enum */ Key SESSION_OFFERED = new Key();
            public static final /* enum */ Key SESSION_REJECTED = new Key();
            public static final /* enum */ Key SESSION_IGNORED = new Key();
            public static final /* enum */ Key SESSION_STARTED = new Key();
            public static final /* enum */ Key SESSION_COMPLETED = new Key();
            public static final /* enum */ Key SUGGESTION_DISPLAYED = new Key();
            public static final /* enum */ Key SUGGESTION_ACCEPTED = new Key();
            public static final /* enum */ Key SUGGESTION_IGNORED = new Key();
            public static final /* enum */ Key SUGGESTION_REJECTED = new Key();
            private static final /* synthetic */ Key[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Key[] values() {
                return (Key[])$VALUES.clone();
            }

            public static Key valueOf(String value) {
                return Enum.valueOf(Key.class, value);
            }

            @NotNull
            public static EnumEntries<Key> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = keyArray = new Key[]{Key.SESSION_OFFERED, Key.SESSION_REJECTED, Key.SESSION_IGNORED, Key.SESSION_STARTED, Key.SESSION_COMPLETED, Key.SUGGESTION_DISPLAYED, Key.SUGGESTION_ACCEPTED, Key.SUGGESTION_IGNORED, Key.SUGGESTION_REJECTED};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MessageFeedbackModel.Rating.values().length];
            try {
                nArray[MessageFeedbackModel.Rating.Upvoted.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageFeedbackModel.Rating.Downvoted.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageFeedbackModel.Rating.NotSet.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

