/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.feedback;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.cloud.tools.intellij.experimentation.ExperimentFlag;
import com.google.cloud.tools.intellij.experimentation.FlagType;
import com.google.cloud.tools.intellij.feedback.FeedbackServiceBase;
import com.google.common.annotations.VisibleForTesting;
import com.google.tools.intellij.aiplugin.SmlIjBundle;
import com.google.tools.intellij.aiplugin.experimentation.ExperimentationFlagsService;
import com.google.tools.intellij.aiplugin.feedback.FeedbackDialog;
import com.google.tools.intellij.aiplugin.notification.AiPluginNotificationService;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ApplicationKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u0012\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/google/tools/intellij/aiplugin/feedback/AiPluginFeedbackService;", "Lcom/google/cloud/tools/intellij/feedback/FeedbackServiceBase;", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "feedbackBlockEnabled", "", "getAttachmentDisplayText", "", "logFile", "Ljava/io/File;", "displayLines", "", "bigFileLimit", "", "getAttachments", "", "Lcom/intellij/openapi/diagnostic/Attachment;", "getLogAttachment", "filename", "showFeedbackDialog", "", "prefixTag", "Companion", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAiPluginFeedbackService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiPluginFeedbackService.kt\ncom/google/tools/intellij/aiplugin/feedback/AiPluginFeedbackService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,113:1\n25#2:114\n40#3,3:115\n*S KotlinDebug\n*F\n+ 1 AiPluginFeedbackService.kt\ncom/google/tools/intellij/aiplugin/feedback/AiPluginFeedbackService\n*L\n31#1:114\n60#1:115,3\n*E\n"})
public final class AiPluginFeedbackService
extends FeedbackServiceBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    public static final int $stable = 8;
    @NotNull
    private static final String IDEA_LOG_FILE_NAME = "idea.log";
    private static final int BIG_FILE_THRESHOLD_LINES = 10000;
    @NotNull
    private static final ExperimentFlag<Boolean> enableFeedbackBlockFlag = new ExperimentFlag<Boolean>("GCAFeedbackBlock__enable_feedback_block", false, FlagType.BOOLEAN.INSTANCE);

    public AiPluginFeedbackService() {
        AiPluginFeedbackService $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(AiPluginFeedbackService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    public final void showFeedbackDialog(@Nullable String prefixTag) {
        if (this.feedbackBlockEnabled()) {
            AiPluginNotificationService.notifyWarning$default(AiPluginNotificationService.Companion.getInstance(), SmlIjBundle.message("aiplugin.feedback.block.title", new Object[0]), SmlIjBundle.message("aiplugin.feedback.block.message", new Object[0]), null, 4, null);
        } else {
            ApplicationKt.getApplication().invokeAndWait(() -> AiPluginFeedbackService.showFeedbackDialog$lambda$0(prefixTag, this), ModalityState.defaultModalityState());
        }
    }

    public static /* synthetic */ void showFeedbackDialog$default(AiPluginFeedbackService aiPluginFeedbackService, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        aiPluginFeedbackService.showFeedbackDialog(string);
    }

    public final boolean feedbackBlockEnabled() {
        boolean $i$f$service = false;
        Class<ExperimentationFlagsService> serviceClass$iv = ExperimentationFlagsService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((ExperimentationFlagsService)object).getValue(enableFeedbackBlockFlag);
    }

    private final List<Attachment> getAttachments() {
        Object[] objectArray = new Attachment[]{this.getLogAttachment(IDEA_LOG_FILE_NAME), this.getLogAttachment("gemini-backend.log"), this.getLogAttachment("gemini-backend.1.log")};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private final Attachment getLogAttachment(String filename) {
        Attachment attachment;
        String[] stringArray = new String[]{filename};
        Path logPath = Paths.get(PathManager.getLogPath(), stringArray);
        this.logger.info("Retrieving " + filename + " from: " + logPath);
        File logFile = logPath.toFile();
        if (logFile.exists()) {
            Attachment attachment2;
            String string = logFile.toString();
            Intrinsics.checkNotNull((Object)logFile);
            Attachment $this$getLogAttachment_u24lambda_u241 = attachment2 = new Attachment(string, logFile, AiPluginFeedbackService.getAttachmentDisplayText$default(this, logFile, 0, 0L, 6, null));
            boolean bl = false;
            $this$getLogAttachment_u24lambda_u241.setIncluded(true);
            attachment = attachment2;
        } else {
            this.logger.info(filename + " was not found");
            attachment = null;
        }
        return attachment;
    }

    @VisibleForTesting
    @NotNull
    public final String getAttachmentDisplayText(@NotNull File logFile, int displayLines, long bigFileLimit) {
        Intrinsics.checkNotNullParameter((Object)logFile, (String)"logFile");
        if (Files.size(logFile.toPath()) > bigFileLimit) {
            ReversedLinesFileReader reader = ((ReversedLinesFileReader.Builder)((ReversedLinesFileReader.Builder)ReversedLinesFileReader.builder().setFile(logFile)).setCharset(Charsets.UTF_8)).get();
            List result2 = reader.readLines(displayLines);
            result2.add("[Only the last " + displayLines + " lines will be sent]");
            Intrinsics.checkNotNull((Object)result2);
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)result2), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }
        return FilesKt.readText$default((File)logFile, null, (int)1, null);
    }

    public static /* synthetic */ String getAttachmentDisplayText$default(AiPluginFeedbackService aiPluginFeedbackService, File file, int n, long l2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 10000;
        }
        if ((n2 & 4) != 0) {
            l2 = 0x500000L;
        }
        return aiPluginFeedbackService.getAttachmentDisplayText(file, n, l2);
    }

    private static final void showFeedbackDialog$lambda$0(String $prefixTag, AiPluginFeedbackService this$0) {
        String string = SmlIjBundle.message("aiplugin.feedback.dialog.description.placeholder", new Object[0]);
        String string2 = $prefixTag;
        if (string2 == null) {
            string2 = SmlIjBundle.message("aiplugin.feedback.dialog.description.prefix", new Object[0]);
        }
        new FeedbackDialog(null, string, string2, (Function1)new Function1<Continuation<? super List<? extends Attachment>>, Object>(this$0, null){
            int label;
            final /* synthetic */ AiPluginFeedbackService this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return AiPluginFeedbackService.access$getAttachments(this.this$0);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super List<Attachment>> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, SmlIjBundle.message("aiplugin.feedback.dialog.title", new Object[0]), 1, null).show();
    }

    public static final /* synthetic */ List access$getAttachments(AiPluginFeedbackService $this) {
        return $this.getAttachments();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/google/tools/intellij/aiplugin/feedback/AiPluginFeedbackService$Companion;", "", "()V", "BIG_FILE_THRESHOLD_LINES", "", "IDEA_LOG_FILE_NAME", "", "enableFeedbackBlockFlag", "Lcom/google/cloud/tools/intellij/experimentation/ExperimentFlag;", "", "getEnableFeedbackBlockFlag", "()Lcom/google/cloud/tools/intellij/experimentation/ExperimentFlag;", "getInstance", "Lcom/google/tools/intellij/aiplugin/feedback/AiPluginFeedbackService;", "aiplugin.ij-platform"})
    @SourceDebugExtension(value={"SMAP\nAiPluginFeedbackService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiPluginFeedbackService.kt\ncom/google/tools/intellij/aiplugin/feedback/AiPluginFeedbackService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,113:1\n40#2,3:114\n*S KotlinDebug\n*F\n+ 1 AiPluginFeedbackService.kt\ncom/google/tools/intellij/aiplugin/feedback/AiPluginFeedbackService$Companion\n*L\n104#1:114,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AiPluginFeedbackService getInstance() {
            boolean $i$f$service = false;
            Class<AiPluginFeedbackService> serviceClass$iv = AiPluginFeedbackService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (AiPluginFeedbackService)object;
        }

        @NotNull
        public final ExperimentFlag<Boolean> getEnableFeedbackBlockFlag() {
            return enableFeedbackBlockFlag;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

