/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.hats;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.cloud.tools.intellij.analytics.firelog.HatsResponse;
import com.google.tools.intellij.aiplugin.SmlIjBundle;
import com.google.tools.intellij.aiplugin.analytics.UsageTrackerService;
import com.google.tools.intellij.aiplugin.hats.AiPluginBasePartialHatsStepPanel;
import com.google.tools.intellij.aiplugin.hats.HatsActivationManager;
import com.google.tools.intellij.aiplugin.hats.HatsMetricsKt;
import com.google.tools.intellij.aiplugin.hats.PartialHatsDialog;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextArea;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/google/tools/intellij/aiplugin/hats/AbstractFreeformTextHatsPanel;", "Lcom/google/tools/intellij/aiplugin/hats/AiPluginBasePartialHatsStepPanel;", "title", "", "textChangedTrackEvent", "step", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)V", "charCountLabel", "Lcom/intellij/ui/components/JBLabel;", "getCharCountLabel", "()Lcom/intellij/ui/components/JBLabel;", "hatsQuestionNumber", "getHatsQuestionNumber", "()I", "textArea", "Lcom/intellij/ui/components/JBTextArea;", "getTextArea", "()Lcom/intellij/ui/components/JBTextArea;", "textFilled", "", "createComponents", "", "isOptional", "submit", "Companion", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
public abstract class AbstractFreeformTextHatsPanel
extends AiPluginBasePartialHatsStepPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String title;
    @NotNull
    private final String textChangedTrackEvent;
    @NotNull
    private final JBTextArea textArea;
    @NotNull
    private final JBLabel charCountLabel;
    private boolean textFilled;
    public static final int $stable = 8;
    private static final int MAX_INPUT_LENGTH = 500;
    private static final int WARNING_INPUT_LENGTH = 450;
    @NotNull
    private static final Color WARNING_TEXT_ORANGE = new Color(232, 113, 10);

    public AbstractFreeformTextHatsPanel(@NotNull String title, @NotNull String textChangedTrackEvent, @Nullable Integer step) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)textChangedTrackEvent, (String)"textChangedTrackEvent");
        super(step);
        this.title = title;
        this.textChangedTrackEvent = textChangedTrackEvent;
        this.textArea = new JBTextArea(8, 50);
        this.charCountLabel = new JBLabel();
        this.createComponents();
    }

    public /* synthetic */ AbstractFreeformTextHatsPanel(String string, String string2, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        this(string, string2, n);
    }

    @NotNull
    public final JBTextArea getTextArea() {
        return this.textArea;
    }

    @NotNull
    public final JBLabel getCharCountLabel() {
        return this.charCountLabel;
    }

    public abstract int getHatsQuestionNumber();

    private final void createComponents() {
        this.setLayout((LayoutManager)new MigLayout("fillx"));
        this.addStepCountLabel();
        JBLabel csatTitleLabel = new JBLabel(this.title);
        csatTitleLabel.setFont((Font)PartialHatsDialog.Companion.getSECTION_HEADER_FONT$aiplugin_ij_platform());
        this.add((Component)csatTitleLabel, "gapbottom 30px, wrap");
        this.textArea.getEmptyText().setText(SmlIjBundle.message("hats.dialog.text.add.comments", new Object[0]));
        this.textArea.setLineWrap(true);
        this.add((Component)new JBScrollPane((Component)this.textArea), "growx, wrap");
        this.add((Component)this.charCountLabel, "gapbefore push, wrap");
        this.addHatsDisclaimer();
        Document document = this.textArea.getDocument();
        document.addDocumentListener((DocumentListener)new DocumentAdapter(this){
            final /* synthetic */ AbstractFreeformTextHatsPanel this$0;
            {
                this.this$0 = $receiver;
            }

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int docLength = e.getDocument().getLength();
                if (docLength > 500) {
                    Object[] objectArray = new Object[]{docLength - 500};
                    this.this$0.getCharCountLabel().setText(SmlIjBundle.message("hats.dialog.response.character.count.message.over", objectArray));
                    this.this$0.getCharCountLabel().setForeground((Color)JBColor.RED);
                } else {
                    Object[] objectArray = new Object[]{500 - docLength};
                    this.this$0.getCharCountLabel().setText(SmlIjBundle.message("hats.dialog.response.character.count.message.remaining", objectArray));
                    if (docLength > 450) {
                        this.this$0.getCharCountLabel().setForeground(AbstractFreeformTextHatsPanel.access$getWARNING_TEXT_ORANGE$cp());
                    } else {
                        this.this$0.getCharCountLabel().setForeground(JBColor.foreground());
                    }
                }
            }
        });
        document.addDocumentListener((DocumentListener)new DocumentAdapter(this){
            final /* synthetic */ AbstractFreeformTextHatsPanel this$0;
            {
                this.this$0 = $receiver;
            }

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!AbstractFreeformTextHatsPanel.access$getTextFilled$p(this.this$0)) {
                    HatsMetricsKt.sendHatsTrackEvent(AbstractFreeformTextHatsPanel.access$getTextChangedTrackEvent$p(this.this$0));
                    AbstractFreeformTextHatsPanel.access$setTextFilled$p(this.this$0, true);
                }
            }
        });
    }

    @Override
    public boolean isOptional() {
        return true;
    }

    @Override
    public void submit() {
        String string = this.textArea.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String freeFormResponseText = StringsKt.take((String)string, (int)500);
        if (StringsKt.isBlank((CharSequence)freeFormResponseText)) {
            return;
        }
        HatsResponse freeFormResponse = new HatsResponse(null, CollectionsKt.listOf((Object)new HatsResponse.OpenTextResponse(this.getHatsQuestionNumber(), freeFormResponseText)), HatsResponse.HatsResponseType.PARTIAL_RESPONSE, "Gemini Code Assist", HatsActivationManager.Companion.getInstance().getCurrentHatsSurveyInstanceId());
        UsageTrackerService.Companion.getInstance().sendHatsPing(freeFormResponse, HatsMetricsKt.getExtraHatsMetadata());
    }

    public static final /* synthetic */ Color access$getWARNING_TEXT_ORANGE$cp() {
        return WARNING_TEXT_ORANGE;
    }

    public static final /* synthetic */ boolean access$getTextFilled$p(AbstractFreeformTextHatsPanel $this) {
        return $this.textFilled;
    }

    public static final /* synthetic */ String access$getTextChangedTrackEvent$p(AbstractFreeformTextHatsPanel $this) {
        return $this.textChangedTrackEvent;
    }

    public static final /* synthetic */ void access$setTextFilled$p(AbstractFreeformTextHatsPanel $this, boolean bl) {
        $this.textFilled = bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/google/tools/intellij/aiplugin/hats/AbstractFreeformTextHatsPanel$Companion;", "", "()V", "MAX_INPUT_LENGTH", "", "WARNING_INPUT_LENGTH", "WARNING_TEXT_ORANGE", "Ljava/awt/Color;", "aiplugin.ij-platform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

