/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.logs;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.RollingFileHandler;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Handler;
import java.util.logging.Logger;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ3\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2!\u0010\u0010\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\t0\u0011H\u0002J\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/google/tools/intellij/aiplugin/logs/GeminiBackendLogger;", "", "()V", "defaultLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "debug", "", "msg", "", "t", "", "info", "logMessage", "logFunction", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "warn", "Companion", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGeminiBackendLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeminiBackendLogger.kt\ncom/google/tools/intellij/aiplugin/logs/GeminiBackendLogger\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,72:1\n25#2:73\n*S KotlinDebug\n*F\n+ 1 GeminiBackendLogger.kt\ncom/google/tools/intellij/aiplugin/logs/GeminiBackendLogger\n*L\n29#1:73\n*E\n"})
public final class GeminiBackendLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final com.intellij.openapi.diagnostic.Logger defaultLogger;
    private final Logger logger;
    public static final int $stable = 8;
    @NotNull
    public static final String BACKEND_LOG_FILE_NAME = "gemini-backend.log";
    @NotNull
    public static final String BACKEND_LOG_ROLLING_FILE_NAME = "gemini-backend.1.log";
    public static final long BACKEND_LOG_MAX_FILE_SIZE = 0x500000L;
    @NotNull
    private static final GeminiBackendLogger INSTANCE = new GeminiBackendLogger();

    private GeminiBackendLogger() {
        GeminiBackendLogger $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance(GeminiBackendLogger.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.defaultLogger = logger;
        this.logger = Logger.getLogger(BACKEND_LOG_FILE_NAME);
        Handler[] handlerArray = this.logger.getHandlers();
        Intrinsics.checkNotNullExpressionValue((Object)handlerArray, (String)"getHandlers(...)");
        for (Handler handler : handlerArray) {
            this.logger.removeHandler(handler);
        }
        String[] stringArray = new String[]{BACKEND_LOG_FILE_NAME};
        Path path2 = Paths.get(PathManager.getLogPath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        this.logger.addHandler((Handler)new RollingFileHandler(path2, 0x500000L, 1, true, null, 16, null));
        this.logger.setUseParentHandlers(false);
    }

    public final void info(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.logMessage(msg, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ GeminiBackendLogger this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GeminiBackendLogger.access$getLogger$p(this.this$0).info(it);
            }
        }));
    }

    public final void warn(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.logMessage(msg, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ GeminiBackendLogger this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GeminiBackendLogger.access$getLogger$p(this.this$0).warning(it);
            }
        }));
    }

    public final void warn(@NotNull String msg, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.logMessage(msg + "\n" + ExceptionsKt.stackTraceToString((Throwable)t), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ GeminiBackendLogger this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GeminiBackendLogger.access$getLogger$p(this.this$0).warning(it);
            }
        }));
    }

    public final void debug(@NotNull String msg, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.logMessage(msg + "\n" + ExceptionsKt.stackTraceToString((Throwable)t), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ GeminiBackendLogger this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GeminiBackendLogger.access$getLogger$p(this.this$0).fine(it);
            }
        }));
    }

    private final void logMessage(String msg, Function1<? super String, Unit> logFunction) {
        try {
            logFunction.invoke((Object)msg);
        }
        catch (Throwable t) {
            this.defaultLogger.info("Error when logging to gemini-backend.log: " + t);
        }
    }

    public static final /* synthetic */ Logger access$getLogger$p(GeminiBackendLogger $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/google/tools/intellij/aiplugin/logs/GeminiBackendLogger$Companion;", "", "()V", "BACKEND_LOG_FILE_NAME", "", "BACKEND_LOG_MAX_FILE_SIZE", "", "BACKEND_LOG_ROLLING_FILE_NAME", "INSTANCE", "Lcom/google/tools/intellij/aiplugin/logs/GeminiBackendLogger;", "getINSTANCE", "()Lcom/google/tools/intellij/aiplugin/logs/GeminiBackendLogger;", "aiplugin.core.aicore"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GeminiBackendLogger getINSTANCE() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

