/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.recitation;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.tools.intellij.aiplugin.recitation.RecitationTrackingService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/google/tools/intellij/aiplugin/recitation/RecitationBulkFileListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "()V", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "aiplugin.ij-platform"})
@StabilityInferred(parameters=1)
public final class RecitationBulkFileListener
implements BulkFileListener {
    public static final int $stable;

    public void after(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        for (VFileEvent vFileEvent : events) {
            VirtualFile file;
            if (vFileEvent.getFile() == null) continue;
            List projects = CollectionsKt.filterNotNull((Iterable)ProjectLocator.Companion.getInstance().getProjectsForFile(file));
            for (Project project2 : projects) {
                if (vFileEvent instanceof VFileMoveEvent) {
                    RecitationTrackingService recitationTrackingService = RecitationTrackingService.Companion.getInstance(project2);
                    String string = ((VFileMoveEvent)vFileEvent).getOldPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOldPath(...)");
                    String string2 = ((VFileMoveEvent)vFileEvent).getNewPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNewPath(...)");
                    recitationTrackingService.renameFile(string, string2);
                    continue;
                }
                if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !((VFilePropertyChangeEvent)vFileEvent).isRename()) continue;
                RecitationTrackingService recitationTrackingService = RecitationTrackingService.Companion.getInstance(project2);
                String string = ((VFilePropertyChangeEvent)vFileEvent).getOldPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOldPath(...)");
                String string3 = ((VFilePropertyChangeEvent)vFileEvent).getNewPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getNewPath(...)");
                recitationTrackingService.renameFile(string, string3);
            }
        }
    }
}

