/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.recitation;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.studiobot.Citation;
import com.google.tools.intellij.aiplugin.SmlIjBundle;
import com.google.tools.intellij.aiplugin.recitation.RecitationGutterService;
import com.google.tools.intellij.aiplugin.recitation.RecitationTrackingService;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0002H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/google/tools/intellij/aiplugin/recitation/RecitationExternalAnnotator;", "Lcom/intellij/lang/annotation/ExternalAnnotator;", "Lcom/google/tools/intellij/aiplugin/recitation/RecitationExternalAnnotator$CollectedInformation;", "Lcom/google/tools/intellij/aiplugin/recitation/RecitationTrackingService$DetectedCitations;", "()V", "apply", "", "file", "Lcom/intellij/psi/PsiFile;", "detectedCitations", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "collectInformation", "editor", "Lcom/intellij/openapi/editor/Editor;", "hasErrors", "", "createIntentionAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "citation", "Lcom/google/tools/intellij/aiplugin/recitation/RecitationTrackingService$CitationInstance;", "url", "", "doAnnotate", "collectedInformation", "CollectedInformation", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRecitationExternalAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecitationExternalAnnotator.kt\ncom/google/tools/intellij/aiplugin/recitation/RecitationExternalAnnotator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,155:1\n4135#2,11:156\n1863#3:167\n1864#3:171\n774#3:172\n865#3,2:173\n1863#3,2:175\n40#4,3:168\n*S KotlinDebug\n*F\n+ 1 RecitationExternalAnnotator.kt\ncom/google/tools/intellij/aiplugin/recitation/RecitationExternalAnnotator\n*L\n84#1:156,11\n84#1:167\n84#1:171\n90#1:172\n90#1:173,2\n91#1:175,2\n85#1:168,3\n*E\n"})
public final class RecitationExternalAnnotator
extends ExternalAnnotator<CollectedInformation, RecitationTrackingService.DetectedCitations> {
    public static final int $stable = 8;

    @Nullable
    public CollectedInformation collectInformation(@NotNull PsiFile file, @NotNull Editor editor, boolean hasErrors) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Project project2 = editor.getProject();
        if (project2 == null) {
            return null;
        }
        Project project3 = project2;
        if (project3.isDisposed()) {
            return null;
        }
        Object object = editor.getVirtualFile();
        if (object == null || (object = object.getPath()) == null) {
            return null;
        }
        Object filePath = object;
        long l2 = editor.getDocument().getModificationStamp();
        CharSequence charSequence = editor.getDocument().getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        return new CollectedInformation((String)filePath, l2, charSequence, project3);
    }

    @NotNull
    public RecitationTrackingService.DetectedCitations doAnnotate(@NotNull CollectedInformation collectedInformation) {
        Intrinsics.checkNotNullParameter((Object)collectedInformation, (String)"collectedInformation");
        return RecitationTrackingService.Companion.getInstance(collectedInformation.getProject()).detectCitations(collectedInformation.getFilePath(), collectedInformation.getDocumentModificationStamp(), collectedInformation.getDocumentText());
    }

    /*
     * WARNING - void declaration
     */
    public void apply(@NotNull PsiFile file, @NotNull RecitationTrackingService.DetectedCitations detectedCitations, @NotNull AnnotationHolder holder) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable $this$forEach$iv;
        Iterator $this$filterIsInstanceTo$iv$iv;
        FileEditor[] editors;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)detectedCitations, (String)"detectedCitations");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Project project2 = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        boolean updated = RecitationTrackingService.Companion.getInstance(project2).updateCitations(detectedCitations);
        if (!updated) {
            return;
        }
        VirtualFile virtualFile2 = file.getVirtualFile();
        if (virtualFile2 == null) {
            return;
        }
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)file.getProject()).getAllEditors(virtualFile2);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
        Object $this$filterIsInstance$iv = editors = fileEditorArray;
        boolean $i$f$filterIsInstance = false;
        FileEditor[] fileEditorArray2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TextEditor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextEditor it = (TextEditor)element$iv;
            boolean bl = false;
            boolean $i$f$service = false;
            Class<RecitationGutterService> serviceClass$iv = RecitationGutterService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            RecitationGutterService recitationGutterService = (RecitationGutterService)object;
            Editor editor = it.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            recitationGutterService.render(editor);
        }
        $this$forEach$iv = detectedCitations.getCitations();
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RecitationTrackingService.CitationInstance it = (RecitationTrackingService.CitationInstance)element$iv$iv;
            boolean bl = false;
            if (!(it.getCitation() instanceof Citation.Web)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String[] stringArray;
            RecitationTrackingService.CitationInstance it = (RecitationTrackingService.CitationInstance)element$iv;
            boolean bl = false;
            Citation citation = it.getCitation();
            Intrinsics.checkNotNull((Object)citation, (String)"null cannot be cast to non-null type com.android.tools.idea.studiobot.Citation.Web");
            Citation.Web citation2 = (Citation.Web)citation;
            TextRange range = it.getRangeInDocument();
            String uri = citation2.getUrl();
            String string = citation2.getLicense();
            if (string == null) {
                string = "unknown";
            }
            String license = "license " + string;
            String message = SmlIjBundle.INSTANCE.getMessage("ai.plugin.settings.recitation.warning", new Object[0]);
            String htmlMessage = StringsKt.trimIndent((String)("\n          <p>" + message + "</p>\n          <p><a href=\"" + uri + "\">" + uri + "</a></p>\n          <p>" + license + "</p>\n        "));
            try {
                stringArray = new String[]{message, uri, license};
                stringArray = holder.newAnnotation(HighlightSeverity.WARNING, CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])stringArray), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).range(range).tooltip(htmlMessage);
            }
            catch (Exception e) {
                continue;
            }
            String[] stringArray2 = stringArray;
            Intrinsics.checkNotNull((Object)stringArray2);
            String[] annotation = stringArray2;
            IntentionAction action = this.createIntentionAction(it, citation2.getUrl());
            annotation.withFix(action).create();
        }
    }

    private final IntentionAction createIntentionAction(RecitationTrackingService.CitationInstance citation, String url) {
        return new IntentionAction(url, citation){
            final /* synthetic */ String $url;
            final /* synthetic */ RecitationTrackingService.CitationInstance $citation;
            {
                this.$url = $url;
                this.$citation = $citation;
            }

            public boolean startInWriteAction() {
                return true;
            }

            public String getText() {
                String string = this.$url;
                if (string == null) {
                    string = "";
                }
                return "Ignore Citation Warning: " + string;
            }

            public String getFamilyName() {
                return "RECITATION_CHECKING_ACTION_FAMILY_NAME";
            }

            public boolean isAvailable(Project project2, Editor editor, PsiFile file) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                return true;
            }

            public void invoke(Project project2, Editor editor, PsiFile file) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                    RecitationTrackingService.Companion.getInstance(project2).removeCitation(this.$citation);
                    PsiFile psiFile2 = file;
                    if (psiFile2 == null) break block0;
                    PsiFile it = psiFile2;
                    boolean bl = false;
                    DaemonCodeAnalyzer.getInstance((Project)project2).restart(it);
                }
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/google/tools/intellij/aiplugin/recitation/RecitationExternalAnnotator$CollectedInformation;", "", "filePath", "", "documentModificationStamp", "", "documentText", "", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/lang/String;JLjava/lang/CharSequence;Lcom/intellij/openapi/project/Project;)V", "getDocumentModificationStamp", "()J", "getDocumentText", "()Ljava/lang/CharSequence;", "getFilePath", "()Ljava/lang/String;", "getProject", "()Lcom/intellij/openapi/project/Project;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "aiplugin.ij-platform"})
    @StabilityInferred(parameters=0)
    public static final class CollectedInformation {
        @NotNull
        private final String filePath;
        private final long documentModificationStamp;
        @NotNull
        private final CharSequence documentText;
        @NotNull
        private final Project project;
        public static final int $stable = 8;

        public CollectedInformation(@NotNull String filePath, long documentModificationStamp, @NotNull CharSequence documentText, @NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)documentText, (String)"documentText");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.filePath = filePath;
            this.documentModificationStamp = documentModificationStamp;
            this.documentText = documentText;
            this.project = project2;
        }

        @NotNull
        public final String getFilePath() {
            return this.filePath;
        }

        public final long getDocumentModificationStamp() {
            return this.documentModificationStamp;
        }

        @NotNull
        public final CharSequence getDocumentText() {
            return this.documentText;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final String component1() {
            return this.filePath;
        }

        public final long component2() {
            return this.documentModificationStamp;
        }

        @NotNull
        public final CharSequence component3() {
            return this.documentText;
        }

        @NotNull
        public final Project component4() {
            return this.project;
        }

        @NotNull
        public final CollectedInformation copy(@NotNull String filePath, long documentModificationStamp, @NotNull CharSequence documentText, @NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)documentText, (String)"documentText");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return new CollectedInformation(filePath, documentModificationStamp, documentText, project2);
        }

        public static /* synthetic */ CollectedInformation copy$default(CollectedInformation collectedInformation, String string, long l2, CharSequence charSequence, Project project2, int n, Object object) {
            if ((n & 1) != 0) {
                string = collectedInformation.filePath;
            }
            if ((n & 2) != 0) {
                l2 = collectedInformation.documentModificationStamp;
            }
            if ((n & 4) != 0) {
                charSequence = collectedInformation.documentText;
            }
            if ((n & 8) != 0) {
                project2 = collectedInformation.project;
            }
            return collectedInformation.copy(string, l2, charSequence, project2);
        }

        @NotNull
        public String toString() {
            return "CollectedInformation(filePath=" + this.filePath + ", documentModificationStamp=" + this.documentModificationStamp + ", documentText=" + this.documentText + ", project=" + this.project + ")";
        }

        public int hashCode() {
            int result2 = this.filePath.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.documentModificationStamp);
            result2 = result2 * 31 + this.documentText.hashCode();
            result2 = result2 * 31 + this.project.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CollectedInformation)) {
                return false;
            }
            CollectedInformation collectedInformation = (CollectedInformation)other;
            if (!Intrinsics.areEqual((Object)this.filePath, (Object)collectedInformation.filePath)) {
                return false;
            }
            if (this.documentModificationStamp != collectedInformation.documentModificationStamp) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.documentText, (Object)collectedInformation.documentText)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.project, (Object)collectedInformation.project);
        }
    }
}

