/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.util;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.bot.diff.actions.AcceptAllChangesAction;
import com.google.tools.intellij.aiplugin.SmlIjBundle;
import com.google.tools.intellij.aiplugin.util.AiPluginCodeIntegrationService;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B<\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012%\b\u0002\u0010\u0005\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0005\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/google/tools/intellij/aiplugin/util/CreateFileFromDiffAction;", "Lcom/android/studio/ml/bot/diff/actions/AcceptAllChangesAction;", "filePath", "", "fileContent", "onCompletion", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "e", "", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "actionPerformed", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDiffUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffUtils.kt\ncom/google/tools/intellij/aiplugin/util/CreateFileFromDiffAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,226:1\n25#2:227\n40#3,3:228\n13402#4,2:231\n*S KotlinDebug\n*F\n+ 1 DiffUtils.kt\ncom/google/tools/intellij/aiplugin/util/CreateFileFromDiffAction\n*L\n187#1:227\n205#1:228,3\n209#1:231,2\n*E\n"})
public final class CreateFileFromDiffAction
extends AcceptAllChangesAction {
    @NotNull
    private final String filePath;
    @NotNull
    private final String fileContent;
    @NotNull
    private final Function1<Throwable, Unit> onCompletion;
    @NotNull
    private final Logger logger;
    public static final int $stable = 8;

    public CreateFileFromDiffAction(@NotNull String filePath, @NotNull String fileContent, @NotNull Function1<? super Throwable, Unit> onCompletion) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        Intrinsics.checkNotNullParameter(onCompletion, (String)"onCompletion");
        super(null, 1, null);
        this.filePath = filePath;
        this.fileContent = fileContent;
        this.onCompletion = onCompletion;
        CreateFileFromDiffAction $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(CreateFileFromDiffAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    public /* synthetic */ CreateFileFromDiffAction(String string, String string2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        this(string, string2, (Function1<? super Throwable, Unit>)function1);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
        e.getPresentation().setText(SmlIjBundle.message("aiplugin.actions.createNewFile.text", new Object[0]));
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        WriteCommandAction.Builder builder = WriteCommandAction.writeCommandAction((Project)project3);
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)PathUtil.getFileName((String)this.filePath), (String)"getFileName(...)");
        builder.withName(SmlIjBundle.message("aiplugin.actions.undo.createNewFile.text", objectArray)).run(() -> CreateFileFromDiffAction.actionPerformed$lambda$1(this, project3, e));
    }

    private static final void actionPerformed$lambda$1(CreateFileFromDiffAction this$0, Project $project, AnActionEvent $e) {
        try {
            this$0.logger.info("Executing undoable write action on " + Thread.currentThread().getName() + " for " + this$0.filePath);
            boolean $i$f$service = false;
            Class<AiPluginCodeIntegrationService> serviceClass$iv = AiPluginCodeIntegrationService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            VirtualFile newVirtualFile = ((AiPluginCodeIntegrationService)object).ensureFileWithContent$aiplugin_ij_platform($project, this$0.filePath, this$0.fileContent);
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)$project);
            VirtualFile[] virtualFileArray = (VirtualFile[])$e.getData(PlatformCoreDataKeys.VIRTUAL_FILE_ARRAY);
            if (virtualFileArray != null) {
                VirtualFile[] $this$forEach$iv = virtualFileArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int j = 0; j < n; ++j) {
                    VirtualFile element$iv;
                    VirtualFile fileToClose = element$iv = $this$forEach$iv[j];
                    boolean bl = false;
                    if (!fileEditorManager.isFileOpen(fileToClose)) continue;
                    fileEditorManager.closeFile(fileToClose);
                }
            }
            fileEditorManager.openFile(newVirtualFile, true);
            this$0.logger.info("File opened successfully in editor: " + newVirtualFile.getPath());
            this$0.onCompletion.invoke(null);
        }
        catch (Exception ex) {
            this$0.logger.error("Error during file creation/opening for " + this$0.filePath + ": " + ex.getMessage(), (Throwable)ex);
            this$0.onCompletion.invoke((Object)ex);
        }
    }
}

